/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.blob;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.LookAheadIterator;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.BLOB;
import net.yacy.kelondro.blob.Heap;
import net.yacy.kelondro.blob.HeapModifier;
import net.yacy.kelondro.blob.HeapWriter;
import net.yacy.kelondro.rwi.Reference;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.rwi.ReferenceFactory;
import net.yacy.kelondro.rwi.ReferenceIterator;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.kelondro.util.MergeIterator;
import net.yacy.kelondro.util.NamePrefixThreadFactory;

public class ArrayStack
implements BLOB {
    private static final long maxFileSize = Integer.MAX_VALUE;
    public static final long oneMonth = 2628000000L;
    private int keylength;
    private ByteOrder ordering;
    private final File heapLocation;
    private long fileAgeLimit;
    private long fileSizeLimit;
    private long repositoryAgeMax;
    private long repositorySizeMax;
    private List<blobItem> blobs;
    private final String prefix;
    private final int buffersize;
    private final boolean trimall;
    private final ExecutorService executor;
    private static final GenericFormatter my_SHORT_MILSEC_FORMATTER = new GenericFormatter(GenericFormatter.newShortMilsecFormat(), 1L);
    private static final ExecutorService DELETE_EXECUTOR = Executors.newCachedThreadPool(new NamePrefixThreadFactory(ArrayStack.class.getSimpleName() + ".DELETE_EXECUTOR"));

    public ArrayStack(File heapLocation, String prefix, ByteOrder ordering, int keylength, int buffersize, boolean trimall, boolean deleteonfail) throws IOException {
        Date d;
        this.keylength = keylength;
        this.prefix = prefix;
        this.ordering = ordering;
        this.buffersize = buffersize;
        this.heapLocation = heapLocation;
        this.fileAgeLimit = 2628000000L;
        this.fileSizeLimit = Integer.MAX_VALUE;
        this.repositoryAgeMax = Long.MAX_VALUE;
        this.repositorySizeMax = Long.MAX_VALUE;
        this.trimall = trimall;
        this.executor = new ThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors(), 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamePrefixThreadFactory(this.prefix));
        if (heapLocation.exists()) {
            if (!heapLocation.isDirectory()) {
                throw new IOException("the BLOBArray directory " + heapLocation.toString() + " does not exist (is blocked by a file with same name)");
            }
        } else if (!heapLocation.mkdirs()) {
            throw new IOException("the BLOBArray directory " + heapLocation.toString() + " does not exist (can not be created)");
        }
        String[] files = heapLocation.list();
        HashSet<String> fh = new HashSet<String>();
        for (String file : files) {
            fh.add(file);
        }
        boolean deletions = false;
        for (String string : files) {
            String s;
            if (string.endsWith(".tmp") || string.endsWith(".prt")) {
                FileUtils.deletedelete(new File(heapLocation, string));
                deletions = true;
            }
            if (!string.endsWith(".idx") && !string.endsWith(".gap") || fh.contains(s = string.substring(0, string.length() - 17))) continue;
            FileUtils.deletedelete(new File(heapLocation, string));
            deletions = true;
        }
        if (deletions) {
            files = heapLocation.list();
        }
        deletions = false;
        for (String file : files) {
            if (file.length() < 19 || !file.endsWith(".blob")) continue;
            File f = new File(heapLocation, file);
            if (f.length() == 0L) {
                f.delete();
                deletions = true;
                continue;
            }
            try {
                d = GenericFormatter.SHORT_SECOND_FORMATTER.parse(file.substring(0, 14), 0).getTime();
                f.renameTo(this.newBLOB(d));
                deletions = true;
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (deletions) {
            files = heapLocation.list();
        }
        TreeMap<Long, blobItem> treeMap = new TreeMap<Long, blobItem>();
        long maxtime = 0L;
        for (String file : files) {
            if (file.length() < 22 || file.charAt(this.prefix.length()) != '.' || !file.endsWith(".blob")) continue;
            try {
                d = my_SHORT_MILSEC_FORMATTER.parse(file.substring(this.prefix.length() + 1, this.prefix.length() + 18), 0).getTime();
                long time = d.getTime();
                if (time <= maxtime) continue;
                maxtime = time;
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        for (String file : files) {
            if (file.length() < 22 || file.charAt(this.prefix.length()) != '.' || !file.endsWith(".blob")) continue;
            try {
                d = my_SHORT_MILSEC_FORMATTER.parse(file.substring(this.prefix.length() + 1, this.prefix.length() + 18), 0).getTime();
                File f = new File(heapLocation, file);
                long time = d.getTime();
                try {
                    HeapModifier oneBlob;
                    if (time == maxtime && !trimall) {
                        oneBlob = new Heap(f, keylength, ordering, buffersize);
                    } else {
                        oneBlob = new HeapModifier(f, keylength, ordering);
                        oneBlob.optimize();
                    }
                    treeMap.put(time, new blobItem(d, f, oneBlob));
                }
                catch (IOException e) {
                    if (deleteonfail) {
                        ConcurrentLog.warn("KELONDRO", "ArrayStack: cannot read file " + f.getName() + ", deleting it (smart fail; alternative would be: crash; required user action would be same as deletion)");
                        f.delete();
                        continue;
                    }
                    throw new IOException(e.getMessage(), e);
                }
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        this.blobs = new CopyOnWriteArrayList<blobItem>();
        for (blobItem bi : treeMap.values()) {
            this.blobs.add(bi);
        }
    }

    @Override
    public long mem() {
        long m = 0L;
        if (this.blobs != null) {
            for (blobItem b : this.blobs) {
                m += b.blob.mem();
            }
        }
        return m;
    }

    @Override
    public void optimize() {
        throw new UnsupportedOperationException();
    }

    public synchronized void mountBLOB(File location, boolean full) throws IOException {
        HeapModifier oneBlob;
        Date d;
        try {
            d = my_SHORT_MILSEC_FORMATTER.parse(location.getName().substring(this.prefix.length() + 1, this.prefix.length() + 18), 0).getTime();
        }
        catch (ParseException e) {
            throw new IOException("date parse problem with file " + location.toString() + ": " + e.getMessage());
        }
        if (full && this.buffersize > 0 && !this.trimall) {
            oneBlob = new Heap(location, this.keylength, this.ordering, this.buffersize);
        } else {
            oneBlob = new HeapModifier(location, this.keylength, this.ordering);
            oneBlob.optimize();
        }
        this.blobs.add(new blobItem(d, location, oneBlob));
    }

    private synchronized void unmountBLOB(File location, boolean writeIDX) {
        for (int i = 0; i < this.blobs.size(); ++i) {
            blobItem b = this.blobs.get(i);
            if (!b.location.getAbsolutePath().equals(location.getAbsolutePath())) continue;
            this.blobs.remove(i);
            b.blob.close(writeIDX);
            b.blob = null;
            b.location = null;
            return;
        }
        ConcurrentLog.severe("KELONDRO", "BLOBArray: file " + String.valueOf(location) + " cannot be unmounted. The file " + (location.exists() ? "exists." : "does not exist."));
    }

    private File unmount(int idx2) {
        blobItem b = this.blobs.remove(idx2);
        b.blob.close(false);
        b.blob = null;
        File f = b.location;
        b.location = null;
        return f;
    }

    public synchronized File[] unmountBestMatch(float maxq, long maxResultSize) {
        if (this.blobs.size() < 2) {
            return null;
        }
        float min = Float.MAX_VALUE;
        File[] bestMatch = new File[2];
        maxResultSize >>= 1;
        int loopcount = 0;
        block0: for (int i = 0; i < this.blobs.size() - 1; ++i) {
            for (int j = i + 1; j < this.blobs.size(); ++j) {
                long r;
                ++loopcount;
                File lf = this.blobs.get((int)i).location;
                File rf = this.blobs.get((int)j).location;
                long m = this.blobs.get((int)i).blob.mem();
                long l = 1L + (lf.length() >> 1);
                if (l + (r = 1L + (rf.length() >> 1)) > maxResultSize || !MemoryControl.request(m += this.blobs.get((int)j).blob.mem(), true)) continue;
                float q = Math.max((float)l, (float)r) / Math.min((float)l, (float)r);
                if (q < min) {
                    min = q;
                    bestMatch[0] = lf;
                    bestMatch[1] = rf;
                }
                if (loopcount > 1000 && min <= maxq && min != Float.MAX_VALUE) break block0;
            }
        }
        if (min > maxq) {
            return null;
        }
        this.unmountBLOB(bestMatch[1], false);
        this.unmountBLOB(bestMatch[0], false);
        return bestMatch;
    }

    public synchronized File unmountOldest() {
        if (this.blobs.isEmpty()) {
            return null;
        }
        if (System.currentTimeMillis() - this.blobs.get((int)0).creation.getTime() < this.fileAgeLimit) {
            return null;
        }
        File f = this.blobs.get((int)0).location;
        this.unmountBLOB(f, false);
        return f;
    }

    public synchronized File[] unmountSmallest(long maxResultSize) {
        if (this.blobs.size() < 2) {
            return null;
        }
        File f0 = this.smallestBLOB(null, maxResultSize);
        if (f0 == null) {
            return null;
        }
        File f1 = this.smallestBLOB(f0, maxResultSize - f0.length());
        if (f1 == null) {
            return null;
        }
        this.unmountBLOB(f0, false);
        this.unmountBLOB(f1, false);
        return new File[]{f0, f1};
    }

    private synchronized File smallestBLOB(File excluding, long maxsize) {
        if (this.blobs.isEmpty()) {
            return null;
        }
        File bestFile = null;
        long smallest = Long.MAX_VALUE;
        File f = null;
        for (int i = 0; i < this.blobs.size(); ++i) {
            f = this.blobs.get((int)i).location;
            if (excluding != null && f.getAbsolutePath().equals(excluding.getAbsolutePath())) continue;
            if (f.length() < smallest) {
                smallest = f.length();
                bestFile = f;
            }
            if (i > 70 && smallest <= maxsize && smallest != Long.MAX_VALUE) break;
        }
        if (smallest > maxsize) {
            return null;
        }
        return bestFile;
    }

    public synchronized File unmountOldestBLOB(boolean smallestFromFirst2) {
        if (this.blobs.isEmpty()) {
            return null;
        }
        int idx2 = 0;
        if (smallestFromFirst2 && this.blobs.get((int)1).location.length() < this.blobs.get((int)0).location.length()) {
            idx2 = 1;
        }
        return this.unmount(idx2);
    }

    public synchronized int entries() {
        return this.blobs == null ? 0 : this.blobs.size();
    }

    public synchronized File newBLOB(Date creation) {
        return new File(this.heapLocation, this.prefix + "." + my_SHORT_MILSEC_FORMATTER.format(creation) + ".blob");
    }

    @Override
    public String name() {
        return this.heapLocation.getName();
    }

    public void setMaxAge(long maxAge) {
        this.repositoryAgeMax = maxAge;
        this.fileAgeLimit = Math.min(2628000000L, maxAge / 10L);
    }

    public void setMaxSize(long maxSize) {
        this.repositorySizeMax = maxSize;
        this.fileSizeLimit = Math.min(Integer.MAX_VALUE, maxSize / 100L);
        this.executeLimits();
    }

    private void executeLimits() {
        blobItem oldestBLOB;
        if (this.blobs.isEmpty()) {
            return;
        }
        while (!this.blobs.isEmpty() && System.currentTimeMillis() - this.blobs.get((int)0).creation.getTime() - this.fileAgeLimit > this.repositoryAgeMax) {
            oldestBLOB = this.blobs.remove(0);
            oldestBLOB.blob.close(false);
            oldestBLOB.blob = null;
            FileUtils.deletedelete(oldestBLOB.location);
        }
        while (!this.blobs.isEmpty() && this.length() > this.repositorySizeMax) {
            oldestBLOB = this.blobs.remove(0);
            oldestBLOB.blob.close(false);
            FileUtils.deletedelete(oldestBLOB.location);
        }
    }

    @Override
    public synchronized long length() {
        long s = 0L;
        for (int i = 0; i < this.blobs.size(); ++i) {
            s += this.blobs.get((int)i).location.length();
        }
        return s;
    }

    @Override
    public ByteOrder ordering() {
        return this.ordering;
    }

    @Override
    public int keylength() {
        return this.keylength;
    }

    @Override
    public synchronized void clear() throws IOException {
        for (blobItem bi : this.blobs) {
            bi.blob.clear();
            bi.blob.close(false);
            HeapWriter.delete(bi.location);
        }
        this.blobs.clear();
    }

    @Override
    public synchronized int size() {
        int s = 0;
        for (blobItem bi : this.blobs) {
            s += bi.blob.size();
        }
        return s;
    }

    @Override
    public synchronized boolean isEmpty() {
        for (blobItem bi : this.blobs) {
            if (bi.blob.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public synchronized int[] sizes() {
        if (this.blobs == null) {
            return new int[0];
        }
        int[] s = new int[this.blobs.size()];
        int c = 0;
        for (blobItem bi : this.blobs) {
            s[c++] = bi.blob.size();
        }
        return s;
    }

    @Override
    public synchronized CloneableIterator<byte[]> keys(boolean up, boolean rotating) throws IOException {
        assert (!rotating);
        ArrayList c = new ArrayList(this.blobs.size());
        Iterator<blobItem> i = this.blobs.iterator();
        while (i.hasNext()) {
            c.add(i.next().blob.keys(up, rotating));
        }
        return MergeIterator.cascade(c, this.ordering, MergeIterator.simpleMerge, up);
    }

    @Override
    public synchronized CloneableIterator<byte[]> keys(boolean up, byte[] firstKey) throws IOException {
        ArrayList c = new ArrayList(this.blobs.size());
        Iterator<blobItem> i = this.blobs.iterator();
        while (i.hasNext()) {
            c.add(i.next().blob.keys(up, firstKey));
        }
        return MergeIterator.cascade(c, this.ordering, MergeIterator.simpleMerge, up);
    }

    @Override
    public synchronized boolean containsKey(byte[] key) {
        blobItem bi = this.keeperOf(key);
        return bi != null;
    }

    private blobItem keeperOf(final byte[] key) {
        int i;
        if (this.blobs.isEmpty()) {
            return null;
        }
        if (this.blobs.size() == 1) {
            blobItem bi = this.blobs.get(0);
            if (bi.blob.containsKey(key)) {
                return bi;
            }
            return null;
        }
        int bs1 = this.blobs.size() - 1;
        blobItem bi = this.blobs.get(bs1);
        if (bi.blob.containsKey(key)) {
            return bi;
        }
        if (this.blobs.size() == 2) {
            bi = this.blobs.get(0);
            if (bi.blob.containsKey(key)) {
                return bi;
            }
            return null;
        }
        ExecutorCompletionService<blobItem> cs = new ExecutorCompletionService<blobItem>(this.executor);
        int accepted = 0;
        for (i = 0; i < bs1; ++i) {
            final blobItem b = this.blobs.get(i);
            try {
                cs.submit(new Callable<blobItem>(){
                    final /* synthetic */ ArrayStack this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public blobItem call() {
                        if (b.blob.containsKey(key)) {
                            return b;
                        }
                        return null;
                    }
                });
                ++accepted;
                continue;
            }
            catch (RejectedExecutionException e) {
                if (!b.blob.containsKey(key)) continue;
                return b;
            }
        }
        try {
            for (i = 0; i < accepted; ++i) {
                blobItem index2;
                Future f = cs.take();
                if (f == null || (index2 = (blobItem)f.get()) == null) continue;
                return index2;
            }
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            ConcurrentLog.severe("KELONDRO", "ArrayStack", e);
            throw new RuntimeException(e.getCause());
        }
        return null;
    }

    @Override
    public byte[] get(byte[] key) throws IOException, SpaceExceededException {
        if (this.blobs == null || this.blobs.isEmpty()) {
            return null;
        }
        if (this.blobs.size() == 1) {
            blobItem bi = this.blobs.get(0);
            return bi.blob.get(key);
        }
        blobItem bi = this.keeperOf(key);
        return bi == null ? null : bi.blob.get(key);
    }

    @Override
    public byte[] get(Object key) {
        if (!(key instanceof byte[])) {
            return null;
        }
        try {
            return this.get((byte[])key);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
        }
        return null;
    }

    public Iterable<byte[]> getAll(byte[] key) throws IOException {
        return new BlobValues(key);
    }

    @Override
    public synchronized long length(byte[] key) throws IOException {
        for (blobItem bi : this.blobs) {
            long l = bi.blob.length(key);
            if (l < 0L) continue;
            return l;
        }
        return -1L;
    }

    public Iterable<Long> lengthAll(byte[] key) throws IOException {
        return new BlobLengths(key);
    }

    public synchronized long lengthAdd(byte[] key) throws IOException {
        long l = 0L;
        for (blobItem bi : this.blobs) {
            l += bi.blob.length(key);
        }
        return l;
    }

    @Override
    public synchronized void insert(byte[] key, byte[] b) throws IOException {
        blobItem bi;
        blobItem blobItem2 = bi = this.blobs.isEmpty() ? null : this.blobs.get(this.blobs.size() - 1);
        if (bi == null || System.currentTimeMillis() - bi.creation.getTime() > this.fileAgeLimit || bi.location.length() > this.fileSizeLimit && this.fileSizeLimit >= 0L) {
            bi = new blobItem(this.buffersize);
            this.blobs.add(bi);
        }
        assert (bi.blob instanceof Heap);
        bi.blob.insert(key, b);
        this.executeLimits();
    }

    @Override
    public synchronized int replace(byte[] key, BLOB.Rewriter rewriter) throws IOException, SpaceExceededException {
        int d = 0;
        for (blobItem bi : this.blobs) {
            d += bi.blob.replace(key, rewriter);
        }
        return d;
    }

    @Override
    public synchronized int reduce(byte[] key, BLOB.Reducer reduce) throws IOException, SpaceExceededException {
        int d = 0;
        for (blobItem bi : this.blobs) {
            d += bi.blob.reduce(key, reduce);
        }
        return d;
    }

    @Override
    public synchronized void delete(final byte[] key) throws IOException {
        long m = this.mem();
        if (!this.blobs.isEmpty()) {
            if (this.blobs.size() == 1) {
                blobItem bi = this.blobs.get(0);
                bi.blob.delete(key);
            } else {
                FutureTask[] t = (FutureTask[])Array.newInstance(FutureTask.class, this.blobs.size() - 1);
                int i = 0;
                for (blobItem bi : this.blobs) {
                    if (i < t.length) {
                        final blobItem bi0 = bi;
                        t[i] = new FutureTask<Boolean>(new Callable<Boolean>(){
                            final /* synthetic */ ArrayStack this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public Boolean call() {
                                try {
                                    bi0.blob.delete(key);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                return true;
                            }
                        });
                        DELETE_EXECUTOR.execute(t[i]);
                    } else {
                        try {
                            bi.blob.delete(key);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
                for (FutureTask s : t) {
                    try {
                        s.get();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
            }
        }
        assert (this.mem() <= m) : "m = " + m + ", mem() = " + this.mem();
    }

    public static void shutdownDeleteService() {
        DELETE_EXECUTOR.shutdown();
        long timeout = 1L;
        try {
            boolean terminated = DELETE_EXECUTOR.awaitTermination(1L, TimeUnit.SECONDS);
            if (!terminated) {
                ConcurrentLog.warn("KELONDRO", "ArrayStack: Delete executor service could not terminated within 1 second");
            }
        }
        catch (InterruptedException e) {
            ConcurrentLog.warn("KELONDRO", "ArrayStack: Interrupted before termination of the delete executor service");
        }
    }

    @Override
    public synchronized void close(boolean writeIDX) {
        for (blobItem bi : this.blobs) {
            bi.blob.close(writeIDX);
        }
        this.blobs.clear();
        this.blobs = null;
        this.executor.shutdown();
    }

    public File mergeMount(File f1, File f2, ReferenceFactory<? extends Reference> factory, File newFile, int writeBuffer) {
        if (f2 == null) {
            ConcurrentLog.info("KELONDRO", "BLOBArray: rewrite of " + f1.getName());
            File resultFile = ArrayStack.rewriteWorker(factory, this.keylength, this.ordering, f1, newFile, writeBuffer);
            if (resultFile == null) {
                ConcurrentLog.warn("KELONDRO", "BLOBArray: rewrite of file " + String.valueOf(f1) + " returned null. newFile = " + String.valueOf(newFile));
                return null;
            }
            try {
                this.mountBLOB(resultFile, false);
            }
            catch (IOException e) {
                ConcurrentLog.warn("KELONDRO", "BLOBArray: rewrite of file " + String.valueOf(f1) + " successfull, but read failed. resultFile = " + String.valueOf(resultFile));
                return null;
            }
            ConcurrentLog.info("KELONDRO", "BLOBArray: rewrite of " + f1.getName() + " into " + String.valueOf(resultFile));
            return resultFile;
        }
        ConcurrentLog.info("KELONDRO", "BLOBArray: merging " + f1.getName() + " with " + f2.getName());
        File resultFile = ArrayStack.mergeWorker(factory, this.keylength, this.ordering, f1, f2, newFile, writeBuffer);
        if (resultFile == null) {
            ConcurrentLog.warn("KELONDRO", "BLOBArray: merge of files " + String.valueOf(f1) + ", " + String.valueOf(f2) + " returned null. newFile = " + String.valueOf(newFile));
            return null;
        }
        try {
            this.mountBLOB(resultFile, false);
        }
        catch (IOException e) {
            ConcurrentLog.warn("KELONDRO", "BLOBArray: merge of files " + String.valueOf(f1) + ", " + String.valueOf(f2) + " successfull, but read failed. resultFile = " + String.valueOf(resultFile));
            return null;
        }
        ConcurrentLog.info("KELONDRO", "BLOBArray: merged " + f1.getName() + " with " + f2.getName() + " into " + String.valueOf(resultFile));
        return resultFile;
    }

    /*
     * Exception decompiling
     */
    private static <ReferenceType extends Reference> File mergeWorker(ReferenceFactory<ReferenceType> factory, int keylength, ByteOrder order, File f1, File f2, File newFile, int writeBuffer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static <ReferenceType extends Reference> File rewriteWorker(ReferenceFactory<ReferenceType> factory, int keylength, ByteOrder order, File f, File newFile, int writeBuffer) {
        ReferenceIterator<ReferenceType> i = null;
        try {
            i = new ReferenceIterator<ReferenceType>(f, factory);
        }
        catch (IOException e) {
            ConcurrentLog.severe("KELONDRO", "ArrayStack: cannot rewrite because input file cannot be read, f = " + f.toString() + ": " + e.getMessage(), e);
            return null;
        }
        if (!i.hasNext()) {
            FileUtils.deletedelete(f);
            return null;
        }
        assert (i.hasNext());
        File tmpFile = new File(newFile.getParentFile(), newFile.getName() + ".prt");
        try {
            HeapWriter writer = new HeapWriter(tmpFile, newFile, keylength, order, writeBuffer);
            ArrayStack.rewrite(i, order, writer);
            writer.close(true);
            i.close();
        }
        catch (IOException e) {
            ConcurrentLog.severe("KELONDRO", "ArrayStack: cannot writing or close writing rewrite, newFile = " + newFile.toString() + ", tmpFile = " + tmpFile.toString() + ": " + e.getMessage(), e);
            FileUtils.deletedelete(tmpFile);
            FileUtils.deletedelete(newFile);
            return null;
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.severe("KELONDRO", "ArrayStack: cannot rewrite because of memory failure: " + e.getMessage(), e);
            FileUtils.deletedelete(tmpFile);
            FileUtils.deletedelete(newFile);
            return null;
        }
        FileUtils.deletedelete(f);
        return newFile;
    }

    private static <ReferenceType extends Reference> void merge(CloneableIterator<ReferenceContainer<ReferenceType>> i1, CloneableIterator<ReferenceContainer<ReferenceType>> i2, ByteOrder ordering, HeapWriter writer) throws IOException, SpaceExceededException {
        byte[] c2lh;
        byte[] c1lh;
        int s;
        ReferenceContainer c2;
        ReferenceContainer c1;
        block30: {
            block31: {
                assert (i1.hasNext());
                assert (i2.hasNext());
                c1 = (ReferenceContainer)i1.next();
                c2 = (ReferenceContainer)i2.next();
                while (true) {
                    assert (c1 != null);
                    assert (c2 != null);
                    int e = ordering.compare(c1.getTermHash(), c2.getTermHash());
                    if (e < 0) {
                        s = c1.shrinkReferences();
                        if (s > 0) {
                            ConcurrentLog.info("KELONDRO", "ArrayStack: shrinking index for " + ASCII.String(c1.getTermHash()) + " by " + s + " to " + c1.size() + " entries");
                        }
                        writer.add(c1.getTermHash(), c1.exportCollection());
                        if (i1.hasNext()) {
                            c1lh = c1.getTermHash();
                            c1 = (ReferenceContainer)i1.next();
                            assert (ordering.compare(c1.getTermHash(), c1lh) > 0);
                            continue;
                        }
                        c1 = null;
                        break block30;
                    }
                    if (e > 0) {
                        s = c2.shrinkReferences();
                        if (s > 0) {
                            ConcurrentLog.info("KELONDRO", "ArrayStack: shrinking index for " + ASCII.String(c2.getTermHash()) + " by " + s + " to " + c2.size() + " entries");
                        }
                        writer.add(c2.getTermHash(), c2.exportCollection());
                        if (i2.hasNext()) {
                            c2lh = c2.getTermHash();
                            c2 = (ReferenceContainer)i2.next();
                            assert (ordering.compare(c2.getTermHash(), c2lh) > 0);
                            continue;
                        }
                        c2 = null;
                        break block30;
                    }
                    assert (e == 0);
                    s = (c1 = c1.merge(c2)).shrinkReferences();
                    if (s > 0) {
                        ConcurrentLog.info("KELONDRO", "ArrayStack: shrinking index for " + ASCII.String(c1.getTermHash()) + " by " + s + " to " + c1.size() + " entries");
                    }
                    writer.add(c1.getTermHash(), c1.exportCollection());
                    c1lh = c1.getTermHash();
                    c2lh = c2.getTermHash();
                    if (!i1.hasNext() || !i2.hasNext()) break block31;
                    c1 = (ReferenceContainer)i1.next();
                    assert (ordering.compare(c1.getTermHash(), c1lh) > 0);
                    c2 = (ReferenceContainer)i2.next();
                    if (!$assertionsDisabled && ordering.compare(c2.getTermHash(), c2lh) <= 0) break;
                }
                throw new AssertionError();
            }
            c1 = null;
            c2 = null;
            if (i1.hasNext()) {
                c1 = (ReferenceContainer)i1.next();
                assert (ordering.compare(c1.getTermHash(), c1lh) > 0);
            }
            if (i2.hasNext()) {
                c2 = (ReferenceContainer)i2.next();
                assert (ordering.compare(c2.getTermHash(), c2lh) > 0);
            }
        }
        assert (!i1.hasNext() || !i2.hasNext());
        assert (c1 == null || c2 == null);
        while (c1 != null) {
            s = c1.shrinkReferences();
            if (s > 0) {
                ConcurrentLog.info("KELONDRO", "ArrayStack: shrinking index for " + ASCII.String(c1.getTermHash()) + " by " + s + " to " + c1.size() + " entries");
            }
            writer.add(c1.getTermHash(), c1.exportCollection());
            if (i1.hasNext()) {
                c1lh = c1.getTermHash();
                c1 = (ReferenceContainer)i1.next();
                assert (ordering.compare(c1.getTermHash(), c1lh) > 0);
                continue;
            }
            c1 = null;
        }
        while (c2 != null) {
            s = c2.shrinkReferences();
            if (s > 0) {
                ConcurrentLog.info("KELONDRO", "ArrayStack: shrinking index for " + ASCII.String(c2.getTermHash()) + " by " + s + " to " + c2.size() + " entries");
            }
            writer.add(c2.getTermHash(), c2.exportCollection());
            if (i2.hasNext()) {
                c2lh = c2.getTermHash();
                c2 = (ReferenceContainer)i2.next();
                assert (ordering.compare(c2.getTermHash(), c2lh) > 0);
                continue;
            }
            c2 = null;
        }
    }

    private static <ReferenceType extends Reference> void rewrite(CloneableIterator<ReferenceContainer<ReferenceType>> i, ByteOrder ordering, HeapWriter writer) throws IOException, SpaceExceededException {
        block4: {
            byte[] clh;
            assert (i.hasNext());
            ReferenceContainer c = (ReferenceContainer)i.next();
            while (true) {
                assert (c != null);
                int s = c.shrinkReferences();
                if (s > 0) {
                    ConcurrentLog.info("KELONDRO", "ArrayStack: shrinking index for " + ASCII.String(c.getTermHash()) + " by " + s + " to " + c.size() + " entries");
                }
                writer.add(c.getTermHash(), c.exportCollection());
                if (!i.hasNext()) break block4;
                clh = c.getTermHash();
                c = (ReferenceContainer)i.next();
                assert (ordering.compare(c.getTermHash(), clh) > 0);
            }
        }
    }

    public static void main(String[] args) {
        File f = new File("/Users/admin/blobarraytest");
        try {
            ArrayStack heap = new ArrayStack(f, "test", NaturalOrder.naturalOrder, 12, 524288, false, true);
            heap.insert("aaaaaaaaaaaa".getBytes(), "eins zwei drei".getBytes());
            heap.insert("aaaaaaaaaaab".getBytes(), "vier fuenf sechs".getBytes());
            heap.insert("aaaaaaaaaaac".getBytes(), "sieben acht neun".getBytes());
            heap.insert("aaaaaaaaaaad".getBytes(), "zehn elf zwoelf".getBytes());
            CloneableIterator<byte[]> i = heap.keys(true, false);
            while (i.hasNext()) {
                System.out.println("key_b: " + UTF8.String((byte[])i.next()));
            }
            heap.delete("aaaaaaaaaaab".getBytes());
            heap.delete("aaaaaaaaaaac".getBytes());
            heap.insert("aaaaaaaaaaaX".getBytes(), "WXYZ".getBytes());
            heap.close(true);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
    }

    private class blobItem {
        Date creation;
        File location;
        BLOB blob;

        public blobItem(Date creation, File location, BLOB blob) {
            assert (blob != null);
            this.creation = creation;
            this.location = location;
            this.blob = blob;
        }

        public blobItem(int buffer) throws IOException {
            this.creation = new Date();
            this.location = ArrayStack.this.newBLOB(this.creation);
            this.blob = buffer == 0 ? new HeapModifier(this.location, ArrayStack.this.keylength, ArrayStack.this.ordering) : new Heap(this.location, ArrayStack.this.keylength, ArrayStack.this.ordering, buffer);
        }
    }

    private class BlobValues
    extends LookAheadIterator<byte[]> {
        private final Iterator<blobItem> bii;
        private final byte[] key;

        public BlobValues(byte[] key) {
            this.bii = ArrayStack.this.blobs.iterator();
            this.key = key;
        }

        @Override
        protected byte[] next0() {
            while (this.bii.hasNext()) {
                BLOB b = this.bii.next().blob;
                if (b == null) continue;
                try {
                    byte[] n = b.get(this.key);
                    if (n == null) continue;
                    return n;
                }
                catch (IOException e) {
                    ConcurrentLog.severe("KELONDRO", "ArrayStack: BlobValues - IOException: " + e.getMessage(), e);
                    return null;
                }
                catch (SpaceExceededException e) {
                    ConcurrentLog.severe("KELONDRO", "ArrayStack: BlobValues - RowSpaceExceededException: " + e.getMessage(), e);
                    break;
                }
            }
            return null;
        }
    }

    private class BlobLengths
    extends LookAheadIterator<Long> {
        private final Iterator<blobItem> bii;
        private final byte[] key;

        public BlobLengths(byte[] key) {
            this.bii = ArrayStack.this.blobs.iterator();
            this.key = key;
        }

        @Override
        protected Long next0() {
            while (this.bii.hasNext()) {
                BLOB b = this.bii.next().blob;
                if (b == null) continue;
                try {
                    long l = b.length(this.key);
                    if (l < 0L) continue;
                    return l;
                }
                catch (IOException e) {
                    ConcurrentLog.severe("KELONDRO", "ArrayStack", e);
                    return null;
                }
            }
            return null;
        }
    }
}

