/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.http.servlets;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.yacy.cora.federate.solr.connector.EmbeddedSolrConnector;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.search.Switchboard;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.UpdateRequestHandler;
import org.apache.solr.handler.admin.LukeRequestHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.QueryResponseWriterUtil;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.servlet.ResponseUtils;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.servlet.cache.Method;

public class SolrServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        EmbeddedSolrConnector connector;
        if (!Domains.isIntranet(request.getRemoteAddr())) {
            ((HttpServletResponse)response).sendError(403, "SolrServlet use not granted for IP " + request.getRemoteAddr());
        }
        HttpServletRequest hrequest = (HttpServletRequest)request;
        Method reqMethod = Method.getMethod((String)hrequest.getMethod());
        String requestURI = hrequest.getRequestURI();
        MultiMapSolrParams mmsp = SolrRequestParsers.parseQueryString((String)hrequest.getQueryString());
        boolean defaultConnector = requestURI.startsWith("/solr/webgraph") ? false : requestURI.startsWith("/solr/collection1") || mmsp.get("core", "collection1").equals("collection1");
        mmsp.getMap().remove("core");
        Switchboard sb = Switchboard.getSwitchboard();
        EmbeddedSolrConnector embeddedSolrConnector = connector = defaultConnector ? sb.index.fulltext().getDefaultEmbeddedConnector() : sb.index.fulltext().getEmbeddedConnector("webgraph");
        if (connector == null) {
            throw new ServletException("no core");
        }
        SolrQueryResponse solrRsp = new SolrQueryResponse();
        SolrQueryRequest solrReq = null;
        try {
            solrReq = SolrRequestParsers.DEFAULT.parse(connector.getCore(), hrequest.getServletPath(), hrequest);
            solrReq.getContext().put("webapp", hrequest.getContextPath());
            Object handler = "/solr/collection1/update".equals(hrequest.getServletPath()) || "/solr/webgraph/update".equals(hrequest.getServletPath()) ? new UpdateRequestHandler() : new LukeRequestHandler();
            handler.init(new NamedList());
            SolrRequestInfo.setRequestInfo((SolrRequestInfo)new SolrRequestInfo(solrReq, solrRsp));
            connector.getCore().execute((SolrRequestHandler)handler, solrReq, solrRsp);
            Iterator headers = solrRsp.httpHeaders();
            while (headers.hasNext()) {
                Map.Entry entry2 = (Map.Entry)headers.next();
                ((HttpServletResponse)response).addHeader((String)entry2.getKey(), (String)entry2.getValue());
            }
            QueryResponseWriter responseWriter = connector.getCore().getQueryResponseWriter(solrReq);
            this.writeResponse(solrReq, solrRsp, (HttpServletResponse)response, responseWriter, reqMethod);
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
        }
        finally {
            if (solrReq != null) {
                solrReq.close();
            }
            SolrRequestInfo.clearRequestInfo();
        }
    }

    private void writeResponse(SolrQueryRequest solrReq, SolrQueryResponse solrRsp, HttpServletResponse response, QueryResponseWriter responseWriter, Method reqMethod) throws IOException {
        try {
            String ct;
            Object invalidStates = solrReq.getContext().get("_stateVer_");
            if (invalidStates != null) {
                solrRsp.add("_stateVer_", invalidStates);
            }
            if (null != (ct = responseWriter.getContentType(solrReq, solrRsp))) {
                response.setContentType(ct);
            }
            if (solrRsp.getException() != null) {
                SimpleOrderedMap info = new SimpleOrderedMap();
                int code = ResponseUtils.getErrorInfo((Throwable)solrRsp.getException(), (NamedList)info, null);
                solrRsp.add("error", (Object)info);
                response.setStatus(code);
            }
            if (Method.HEAD != reqMethod) {
                ServletOutputStream out = response.getOutputStream();
                QueryResponseWriterUtil.writeQueryResponse((OutputStream)out, (QueryResponseWriter)responseWriter, (SolrQueryRequest)solrReq, (SolrQueryResponse)solrRsp, (String)ct);
            }
        }
        catch (EOFException e) {
            ConcurrentLog.info("SolrServlet", "Unable to write response, client closed connection or we are shutting down", e);
        }
    }
}

