/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.api.bookmarks.posts;

import java.util.Date;
import java.util.Iterator;
import net.yacy.cora.date.ISO8601Formatter;
import net.yacy.cora.order.Digest;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.data.BookmarksDB;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class all {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard switchboard = (Switchboard)env;
        boolean isAdmin = switchboard.verifyAuthentication(header);
        serverObjects prop = new serverObjects();
        Iterator<String> it = post != null && post.containsKey("tag") ? switchboard.bookmarksDB.getBookmarksIterator(post.get("tag"), isAdmin) : switchboard.bookmarksDB.getBookmarksIterator(isAdmin);
        boolean extendedXML = post != null && post.containsKey("extendedXML");
        int count = 0;
        while (it.hasNext()) {
            BookmarksDB.Bookmark bookmark = switchboard.bookmarksDB.getBookmark(it.next());
            if (bookmark == null) continue;
            prop.putXML("posts_" + count + "_url", bookmark.getUrl());
            prop.putXML("posts_" + count + "_title", bookmark.getTitle());
            prop.putXML("posts_" + count + "_description", bookmark.getDescription());
            prop.putXML("posts_" + count + "_md5", Digest.encodeMD5Hex(bookmark.getUrl()));
            Date date = new Date(bookmark.getTimeStamp());
            prop.putXML("posts_" + count + "_time", ISO8601Formatter.FORMATTER.format(date));
            prop.putXML("posts_" + count + "_tags", bookmark.getTagsString().replaceAll(",", " "));
            prop.put("posts_" + count + "_isExtended", extendedXML ? "1" : "0");
            if (extendedXML) {
                prop.put("posts_" + count + "_isExtended_private", Boolean.toString(!bookmark.getPublic()));
            }
            ++count;
        }
        prop.put("posts", count);
        return prop;
    }
}

