/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Date;
import java.util.Set;
import net.yacy.cora.protocol.ConnectionInfo;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.Memory;
import net.yacy.kelondro.io.ByteCount;
import net.yacy.kelondro.util.Formatter;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.kelondro.util.OS;
import net.yacy.kelondro.workflow.WorkflowProcessor;
import net.yacy.peers.PeerActions;
import net.yacy.peers.operation.yacyBuildProperties;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class Status {
    private static final String SEEDSERVER = "seedServer";
    private static final String PEERSTATUS = "peerStatus";

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        String peerStatus;
        boolean adminaccess;
        serverObjects prop = new serverObjects();
        Switchboard sb = (Switchboard)env;
        prop.put("forwardToConfigBasic", 0L);
        if (!(post != null && post.containsKey("noforward") || sb.getConfig("server.servlets.called", "").indexOf("ConfigBasic.html", 0) >= 0)) {
            prop.put("forwardToConfigBasic", 1L);
        }
        if (post != null) {
            post.remove("noforward");
        }
        if (post != null && !post.isEmpty()) {
            if (sb.adminAuthenticated(header) < 2) {
                prop.authenticationRequired();
                return prop;
            }
            boolean redirect = false;
            if (post.containsKey("login")) {
                prop.put("LOCATION", "Status.html");
                return prop;
            }
            if (post.containsKey("pauseCrawlJob")) {
                String jobType = post.get("jobType");
                if ("localCrawl".equals(jobType)) {
                    sb.pauseCrawlJob("50_localcrawl", "user demand on Status.html");
                } else if ("remoteTriggeredCrawl".equals(jobType)) {
                    sb.pauseCrawlJob("62_remotetriggeredcrawl", "user demand on Status.html");
                }
                redirect = true;
            } else if (post.containsKey("continueCrawlJob")) {
                String jobType = post.get("jobType");
                if ("localCrawl".equals(jobType)) {
                    sb.continueCrawlJob("50_localcrawl");
                } else if ("remoteTriggeredCrawl".equals(jobType)) {
                    sb.continueCrawlJob("62_remotetriggeredcrawl");
                }
                redirect = true;
            } else if (post.containsKey("ResetTraffic")) {
                ByteCount.resetCount();
                redirect = true;
            } else if (post.containsKey("popup")) {
                boolean trigger_enabled = post.getBoolean("popup");
                sb.setConfig("browserPopUpTrigger", trigger_enabled);
                redirect = true;
            } else if (post.containsKey("tray")) {
                boolean trigger_enabled = post.getBoolean("tray");
                sb.setConfig("tray.icon.enabled", trigger_enabled);
                redirect = true;
            }
            if (redirect) {
                prop.put("LOCATION", "Status.html");
                return prop;
            }
        }
        boolean bl = adminaccess = sb.adminAuthenticated(header) >= 2;
        if (adminaccess) {
            prop.put("showPrivateTable", "1");
            prop.put("privateStatusTable", "Status_p.inc");
        } else {
            prop.put("showPrivateTable", "0");
            prop.put("privateStatusTable", "");
        }
        String currpw = sb.getConfig("adminAccountBase64MD5", "");
        String dfltpw = "MD5:8cffbc0d66567a0987a4aba1ec46d63c";
        prop.put("protection", currpw.equals(dfltpw) ? "0" : "1");
        if (sb.getConfigBool("adminAccountForLocalhost", false)) {
            prop.put("unrestrictedLocalAccess", 1L);
            if (sb.getConfig("server.servlets.called", "").indexOf("ConfigAccounts_p.html", 0) < 0) {
                prop.put("warningUnrestrictedLocalAccess", true);
            }
        }
        if (adminaccess) {
            String minFree;
            if (!sb.observer.getDiskAvailable()) {
                minFree = Formatter.bytesToString(sb.observer.getMinFreeDiskSteadystate());
                prop.put("warningDiskSpaceLow", "1");
                prop.put("warningDiskSpaceLow_minSpace", minFree);
            }
            if (!sb.observer.getMemoryAvailable()) {
                minFree = Formatter.bytesToString(sb.observer.getMinFreeMemory() * 1024L * 1024L);
                prop.put("warningMemoryLow", "1");
                prop.put("warningMemoryLow_minSpace", minFree);
            }
        }
        String versionstring = yacyBuildProperties.getReleaseStub();
        prop.put("versionpp", versionstring);
        prop.put("java.version", System.getProperty("java.version"));
        if (adminaccess && sb.getThread("50_localcrawl").getJobCount() == 0) {
            prop.put("hintCrawlStart", "1");
        }
        if (adminaccess && sb.getThread("50_localcrawl").getJobCount() > 500) {
            prop.put("hintCrawlMonitor", "1");
        }
        if (adminaccess && "intranet|webportal|allip".indexOf(env.getConfig("network.unit.name", "unspecified")) >= 0) {
            prop.put("hintSupport", "1");
        }
        if (adminaccess && sb.crawlJobIsPaused("50_localcrawl")) {
            prop.put("warningCrawlPaused", "1");
        }
        String extendedPortString = sb.getConfig("port", "8090");
        int pos = extendedPortString.indexOf(58, 0);
        prop.put("port", extendedPortString);
        if (pos != -1) {
            prop.put("extPortFormat", "1");
            prop.putHTML("extPortFormat_extPort", extendedPortString);
        } else {
            prop.put("extPortFormat", "0");
        }
        Set<String> ips = Domains.myPublicIPs();
        prop.put("host", ips.toString());
        prop.put("sslSupport", sb.getConfig("keyStore", "").isEmpty() || !sb.getConfigBool("server.https", false) ? 0L : 1L);
        if (sb.getConfigBool("server.https", false)) {
            prop.put("sslSupport_sslPort", sb.getHttpServer().getSslPort());
        }
        if (sb.getConfigBool("remoteProxyUse", false)) {
            prop.put("remoteProxy", "1");
            prop.putXML("remoteProxy_host", sb.getConfig("remoteProxyHost", "<unknown>"));
            prop.putXML("remoteProxy_port", sb.getConfig("remoteProxyPort", "<unknown>"));
        } else {
            prop.put("remoteProxy", "0");
        }
        prop.put("info_isTransparentProxy", sb.getConfigBool("isTransparentProxy", false) ? "0" : "1");
        prop.put("info_proxyURL", sb.getConfigBool("proxyURL", false) ? "0" : "1");
        String thisHash = "";
        String thisName = sb.peers.mySeed().getName();
        if (sb.peers.mySeed() == null) {
            thisHash = "not assigned";
            prop.put("peerAddress", "0");
            prop.put("peerStatistics", "0");
        } else {
            long uptime = 60000L * sb.peers.mySeed().getLong("Uptime", 0L);
            prop.put("peerStatistics", "1");
            prop.put("peerStatistics_uptime", PeerActions.formatInterval(uptime));
            thisHash = sb.peers.mySeed().hash;
            Set<String> myIps = sb.peers.mySeed().getIPs();
            if (myIps.size() == 0) {
                prop.put("peerAddress", "0");
                prop.put("warningGoOnline", "1");
            } else {
                prop.put("peerAddress", "1");
                prop.put("peerAddress_address", sb.peers.mySeed().getPublicAddress(myIps.iterator().next()));
                prop.putXML("peerAddress_peername", sb.peers.mySeed().getName().toLowerCase());
            }
        }
        String string = peerStatus = sb.peers.mySeed() == null ? "virgin" : sb.peers.mySeed().get("PeerType", "virgin");
        if ("virgin".equals(peerStatus) && "freeworld".equals(sb.getConfig("network.unit.name", "")) && !"privatepeer".equals(sb.getConfig("cluster.mode", ""))) {
            prop.put(PEERSTATUS, "0");
            prop.put("urgentStatusVirgin", "1");
        } else if ("junior".equals(peerStatus) && "freeworld".equals(sb.getConfig("network.unit.name", "")) && !"privatepeer".equals(sb.getConfig("cluster.mode", ""))) {
            prop.put(PEERSTATUS, "1");
            prop.put("warningStatusJunior", "1");
        } else if ("senior".equals(peerStatus)) {
            prop.put(PEERSTATUS, "2");
            prop.put("hintStatusSenior", "1");
        } else if ("principal".equals(peerStatus)) {
            prop.put(PEERSTATUS, "3");
            prop.put("hintStatusPrincipal", "1");
            prop.putHTML("hintStatusPrincipal_seedURL", sb.peers.mySeed().get("seedURL", "?"));
        }
        prop.putHTML("peerName", thisName);
        prop.put("hash", thisHash);
        String seedUploadMethod = sb.getConfig("seedUploadMethod", "");
        if (!"none".equalsIgnoreCase(seedUploadMethod) || "".equals(seedUploadMethod) && (sb.getConfig("seedFTPPassword", "").length() > 0 || sb.getConfig("seedFilePath", "").length() > 0)) {
            if ("".equals(seedUploadMethod)) {
                if (sb.getConfig("seedFTPPassword", "").length() > 0) {
                    sb.setConfig("seedUploadMethod", "Ftp");
                }
                if (sb.getConfig("seedFilePath", "").length() > 0) {
                    sb.setConfig("seedUploadMethod", "File");
                }
            }
            if ("ftp".equalsIgnoreCase(seedUploadMethod)) {
                prop.put(SEEDSERVER, "1");
                prop.putHTML("seedServer_seedServer", sb.getConfig("seedFTPServer", ""));
            } else if ("scp".equalsIgnoreCase(seedUploadMethod)) {
                prop.put(SEEDSERVER, "1");
                prop.putHTML("seedServer_seedServer", sb.getConfig("seedScpServer", ""));
            } else if ("file".equalsIgnoreCase(seedUploadMethod)) {
                prop.put(SEEDSERVER, "2");
                prop.putHTML("seedServer_seedFile", sb.getConfig("seedFilePath", ""));
            }
            prop.put("seedServer_lastUpload", PeerActions.formatInterval(System.currentTimeMillis() - sb.peers.lastSeedUpload_timeStamp));
        } else {
            prop.put(SEEDSERVER, "0");
        }
        if (sb.peers != null && sb.peers.sizeConnected() > 0) {
            prop.put("otherPeers", "1");
            prop.putNum("otherPeers_num", sb.peers.sizeConnected());
        } else {
            prop.put("otherPeers", "0");
        }
        if (!sb.getConfigBool("browserPopUpTrigger", false)) {
            prop.put("popup", "0");
        } else {
            prop.put("popup", "1");
        }
        if (!OS.isWindows) {
            prop.put("tray", "2");
        } else if (!sb.getConfigBool("tray.icon.enabled", false)) {
            prop.put("tray", "0");
        } else {
            prop.put("tray", "1");
        }
        prop.put("usedMemory", Formatter.bytesToString(MemoryControl.used()));
        prop.put("maxMemory", Formatter.bytesToString(MemoryControl.maxMemory()));
        prop.put("usedDisk", Formatter.bytesToString(sb.observer.getSizeOfDataPath(true)));
        prop.put("freeDisk", Formatter.bytesToString(sb.observer.getUsableSpace()));
        prop.put("processors", WorkflowProcessor.availableCPU);
        prop.put("load", Memory.getSystemLoadAverage());
        ThreadMXBean threadbean = ManagementFactory.getThreadMXBean();
        prop.put("processesCurrentInclDaemon", threadbean.getThreadCount());
        prop.put("processesCurrentOnlyDaemon", threadbean.getDaemonThreadCount());
        prop.put("processesTotal", threadbean.getTotalStartedThreadCount());
        prop.put("processesPeak", threadbean.getPeakThreadCount());
        prop.put("trafficProxy", Formatter.bytesToString(ByteCount.getAccountCount("PROXY")));
        prop.put("trafficCrawler", Formatter.bytesToString(ByteCount.getAccountCount("CRAWLER")));
        prop.putNum("connectionsActive", ConnectionInfo.getServerCount());
        prop.putNum("connectionsMax", ConnectionInfo.getServerMaxcount());
        int loaderJobCount = sb.crawlQueues.activeWorkerEntries().size();
        int loaderMaxCount = sb.getConfigInt("crawler.MaxActiveThreads", 10);
        int loaderPercent = loaderMaxCount == 0 ? 0 : loaderJobCount * 100 / loaderMaxCount;
        prop.putNum("loaderQueueSize", loaderJobCount);
        prop.putNum("loaderQueueMax", loaderMaxCount);
        prop.put("loaderQueuePercent", loaderPercent > 100 ? 100L : (long)loaderPercent);
        prop.putNum("localCrawlQueueSize", sb.getThread("50_localcrawl").getJobCount());
        prop.put("localCrawlPaused", sb.crawlJobIsPaused("50_localcrawl") ? "1" : "0");
        prop.putNum("remoteTriggeredCrawlQueueSize", sb.getThread("62_remotetriggeredcrawl") != null ? (long)sb.getThread("62_remotetriggeredcrawl").getJobCount() : 0L);
        prop.put("remoteTriggeredCrawlPaused", sb.crawlJobIsPaused("62_remotetriggeredcrawl") ? "1" : "0");
        prop.putNum("stackCrawlQueueSize", sb.crawlStacker.size());
        prop.put("date", new Date().toString());
        return prop;
    }
}

