/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.util.Iterator;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.kelondro.workflow.WorkflowProcessor;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class PerformanceConcurrency_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch sb) {
        WorkflowProcessor<?> p;
        serverObjects prop = new serverObjects();
        long blocktime_total = 0L;
        long exectime_total = 0L;
        long passontime_total = 0L;
        Iterator<WorkflowProcessor<?>> threads = WorkflowProcessor.processes();
        while (threads.hasNext()) {
            p = threads.next();
            blocktime_total += p.getBlockTime();
            exectime_total += p.getExecTime();
            passontime_total += p.getPassOnTime();
        }
        if (blocktime_total == 0L) {
            blocktime_total = 1L;
        }
        if (exectime_total == 0L) {
            exectime_total = 1L;
        }
        if (passontime_total == 0L) {
            passontime_total = 1L;
        }
        threads = WorkflowProcessor.processes();
        int c = 0;
        while (threads.hasNext()) {
            p = threads.next();
            long cycles = p.getExecCount();
            if (cycles == 0L) {
                cycles = 1L;
            }
            prop.put("table_" + c + "_threadname", p.getName());
            prop.putHTML("table_" + c + "_longdescr", p.getDescription());
            prop.put("table_" + c + "_queuesize", p.getQueueSize());
            prop.put("table_" + c + "_queuesizemax", p.getMaxQueueSize());
            prop.put("table_" + c + "_concurrency", p.getMaxConcurrency());
            prop.put("table_" + c + "_executors", p.getExecutors());
            prop.putHTML("table_" + c + "_childs", p.getChilds());
            long blocktime = p.getBlockTime();
            long exectime = p.getExecTime();
            long passontime = p.getPassOnTime();
            prop.putNum("table_" + c + "_blockreadtime", blocktime / cycles);
            prop.putNum("table_" + c + "_blockreadpercent", 100L * blocktime / blocktime_total);
            prop.putNum("table_" + c + "_exectime", exectime / cycles);
            prop.putNum("table_" + c + "_execpercent", 100L * exectime / exectime_total);
            prop.putNum("table_" + c + "_blockwritetime", passontime / cycles);
            prop.putNum("table_" + c + "_blockwritepercent", 100L * passontime / passontime_total);
            prop.putNum("table_" + c + "_totalcycles", p.getExecCount());
            boolean problem = false;
            boolean warning = false;
            if (p.getQueueSize() == p.getMaxQueueSize()) {
                problem = true;
            }
            if (p.getQueueSize() > p.getMaxQueueSize() * 8 / 10) {
                warning = true;
            }
            if (100L * blocktime / blocktime_total > 80L) {
                warning = true;
            }
            if (100L * exectime / exectime_total > 80L) {
                warning = true;
            }
            if (100L * passontime / passontime_total > 80L) {
                warning = true;
            }
            prop.put("table_" + c + "_class", !warning && !problem ? 0L : (!problem ? 1L : 2L));
            ++c;
        }
        prop.put("table", c);
        return prop;
    }
}

