/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.util.CommonPattern;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.VocabularyScraper;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class xlsParser
extends AbstractParser
implements Parser {
    public xlsParser() {
        super("Microsoft Excel Parser");
        this.SUPPORTED_EXTENSIONS.add("xls");
        this.SUPPORTED_EXTENSIONS.add("xla");
        this.SUPPORTED_MIME_TYPES.add("application/msexcel");
        this.SUPPORTED_MIME_TYPES.add("application/excel");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.ms-excel");
        this.SUPPORTED_MIME_TYPES.add("application/x-excel");
        this.SUPPORTED_MIME_TYPES.add("application/x-msexcel");
        this.SUPPORTED_MIME_TYPES.add("application/x-ms-excel");
        this.SUPPORTED_MIME_TYPES.add("application/x-dos_ms_excel");
        this.SUPPORTED_MIME_TYPES.add("application/xls");
    }

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        try {
            String keywords;
            POIFSFileSystem poifs = new POIFSFileSystem(source);
            ExcelExtractor exceldoc = new ExcelExtractor(poifs);
            exceldoc.setIncludeSheetNames(false);
            SummaryInformation sumInfo = exceldoc.getSummaryInformation();
            String title = sumInfo.getTitle();
            if (title == null || title.isEmpty()) {
                title = MultiProtocolURL.unescape(location.getFileName());
            }
            String subject = sumInfo.getSubject();
            ArrayList<String> descriptions = new ArrayList<String>();
            if (subject != null && !subject.isEmpty()) {
                descriptions.add(subject);
            }
            String[] keywlist = (keywords = sumInfo.getKeywords()) != null && !keywords.isEmpty() ? CommonPattern.COMMA.split(keywords) : null;
            Document[] retdocs = new Document[]{new Document(location, mimeType, StandardCharsets.UTF_8.name(), this, null, keywlist, xlsParser.singleList(title), sumInfo.getAuthor(), exceldoc.getDocSummaryInformation().getCompany(), null, descriptions, 0.0, 0.0, exceldoc.getText(), null, null, null, false, sumInfo.getLastSaveDateTime())};
            exceldoc.close();
            return retdocs;
        }
        catch (IOException ex1) {
            throw new Parser.Failure(ex1.getMessage(), location);
        }
    }
}

