/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.content.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.yacy.cora.util.ConcurrentLog;

public class DatabaseConnection {
    private Connection connection;

    public DatabaseConnection(String dbType, String host, int port, String dbname, String user, String pw) throws SQLException {
        String dbDriverStr = null;
        String dbConnStr = null;
        if (dbType.equalsIgnoreCase("mysql")) {
            dbDriverStr = "com.mysql.jdbc.Driver";
            dbConnStr = "jdbc:mysql://" + host + ":" + port + "/" + dbname;
        } else if (dbType.equalsIgnoreCase("pgsql")) {
            dbDriverStr = "org.postgresql.Driver";
            dbConnStr = "jdbc:postgresql://" + host + ":" + port + "/" + dbname;
        } else {
            throw new IllegalArgumentException();
        }
        try {
            Class.forName(dbDriverStr).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new SQLException("Unable to load the jdbc driver: " + e.getMessage());
        }
        try {
            this.connection = DriverManager.getConnection(dbConnStr, user, pw);
        }
        catch (Exception e) {
            throw new SQLException("Unable to establish a database connection: " + e.getMessage());
        }
    }

    public void setAutoCommit(boolean b) {
        try {
            this.connection.setAutoCommit(b);
        }
        catch (SQLException e) {
            ConcurrentLog.logException(e);
        }
    }

    public int count(String tablename) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery("select count(*) from " + tablename);
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public synchronized void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public Statement statement() throws SQLException {
        return this.connection.createStatement();
    }
}

