/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.kelondro.io.CharBuffer;
import org.json.JSONException;
import org.json.JSONObject;

public class VocabularyScraper {
    private final JSONObject scraperDefinition;
    private Map<String, String> classVocabulary;
    private final Map<DigestURL, ConcurrentHashMap<String, String>> vocMap;

    public VocabularyScraper() {
        this.classVocabulary = null;
        this.scraperDefinition = new JSONObject();
        this.vocMap = new ConcurrentHashMap<DigestURL, ConcurrentHashMap<String, String>>();
    }

    public VocabularyScraper(JSONObject init) {
        this.scraperDefinition = init == null ? new JSONObject() : init;
        this.vocMap = new ConcurrentHashMap<DigestURL, ConcurrentHashMap<String, String>>();
        if (this.scraperDefinition.length() == 0) {
            this.classVocabulary = null;
        } else {
            this.classVocabulary = new ConcurrentHashMap<String, String>();
            for (String voc : this.scraperDefinition.keySet()) {
                try {
                    JSONObject props = this.scraperDefinition.getJSONObject(voc);
                    String classtype = props.getString("class");
                    this.classVocabulary.put(classtype, voc);
                }
                catch (JSONException jSONException) {}
            }
            if (this.classVocabulary.size() == 0) {
                this.classVocabulary = null;
            }
        }
    }

    public VocabularyScraper(String init) throws JSONException {
        this(new JSONObject(init));
    }

    public String toString() {
        return this.scraperDefinition.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(DigestURL root, String className, CharBuffer content) {
        if (this.classVocabulary == null) {
            return;
        }
        String voc = this.classVocabulary.get(className);
        if (voc == null) {
            return;
        }
        ConcurrentHashMap<String, String> vocmap = this.vocMap.get(root);
        if (vocmap == null) {
            VocabularyScraper vocabularyScraper = this;
            synchronized (vocabularyScraper) {
                vocmap = new ConcurrentHashMap();
                this.vocMap.put(root, vocmap);
            }
        }
        if (!vocmap.containsKey(voc)) {
            vocmap.put(voc, content.toString());
        }
    }

    public Map<String, String> removeVocMap(DigestURL root) {
        return this.vocMap.remove(root);
    }
}

