/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.storage;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import net.yacy.cora.storage.SizeLimitedMap;

public class SizeLimitedSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -1674392695322189500L;
    private transient SizeLimitedMap<E, Object> map;
    private static final Object OBJECT = new Object();

    public SizeLimitedSet(int sizeLimit) {
        this.map = new SizeLimitedMap(sizeLimit);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, OBJECT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == OBJECT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public boolean isLimitExceeded() {
        return this.map.isLimitExceeded();
    }

    public Object clone() {
        try {
            SizeLimitedSet n = (SizeLimitedSet)super.clone();
            n.map = (SizeLimitedMap)this.map.clone();
            return n;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

