/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.sorting;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.yacy.cora.sorting.AbstractScoreMap;
import net.yacy.cora.sorting.ScoreMap;
import net.yacy.cora.util.StringBuilderComparator;

public class OrderedScoreMap<E>
extends AbstractScoreMap<E>
implements ScoreMap<E> {
    protected final Map<E, AtomicInteger> map;

    public OrderedScoreMap(Comparator<? super E> comparator) {
        this.map = comparator == null ? new HashMap<E, AtomicInteger>() : new TreeMap<E, AtomicInteger>(comparator);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
    }

    @Override
    public int shrinkToMaxSize(int maxsize) {
        if (this.map.size() <= maxsize) {
            return 0;
        }
        int deletedNb = 0;
        int minScore = this.getMinScore();
        while (this.map.size() > maxsize) {
            deletedNb += this.shrinkToMinScore(++minScore);
        }
        return deletedNb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int shrinkToMinScore(int minScore) {
        int deletedNb = 0;
        Map<E, AtomicInteger> map = this.map;
        synchronized (map) {
            Iterator<Map.Entry<E, AtomicInteger>> i = this.map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<E, AtomicInteger> entry2 = i.next();
                if (entry2.getValue().intValue() >= minScore) continue;
                i.remove();
                ++deletedNb;
            }
        }
        return deletedNb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Map<E, AtomicInteger> map = this.map;
        synchronized (map) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sizeSmaller(int size) {
        if (this.map.size() < size) {
            return true;
        }
        Map<E, AtomicInteger> map = this.map;
        synchronized (map) {
            return this.map.size() < size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        if (this.map.isEmpty()) {
            return true;
        }
        Map<E, AtomicInteger> map = this.map;
        synchronized (map) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inc(E obj) {
        if (obj == null) {
            return;
        }
        AtomicInteger score = this.map.get(obj);
        if (score != null) {
            score.incrementAndGet();
            return;
        }
        Map<E, AtomicInteger> map = this.map;
        synchronized (map) {
            score = this.map.get(obj);
            if (score == null) {
                this.map.put(obj, new AtomicInteger(1));
                return;
            }
        }
        score.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dec(E obj) {
        AtomicInteger score;
        if (obj == null) {
            return;
        }
        Map<E, AtomicInteger> map = this.map;
        synchronized (map) {
            score = this.map.get(obj);
            if (score == null) {
                this.map.put(obj, new AtomicInteger(-1));
                return;
            }
        }
        score.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(E obj, int newScore) {
        AtomicInteger score;
        if (obj == null) {
            return;
        }
        Map<E, AtomicInteger> map = this.map;
        synchronized (map) {
            score = this.map.get(obj);
            if (score == null) {
                this.map.put(obj, new AtomicInteger(newScore));
                return;
            }
        }
        score.getAndSet(newScore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inc(E obj, int incrementScore) {
        AtomicInteger score;
        if (obj == null) {
            return;
        }
        Map<E, AtomicInteger> map = this.map;
        synchronized (map) {
            score = this.map.get(obj);
            if (score == null) {
                this.map.put(obj, new AtomicInteger(incrementScore));
                return;
            }
        }
        score.addAndGet(incrementScore);
    }

    @Override
    public void dec(E obj, int incrementScore) {
        this.inc(obj, -incrementScore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(E obj) {
        AtomicInteger score;
        if (obj == null) {
            return 0;
        }
        Map<E, AtomicInteger> map = this.map;
        synchronized (map) {
            score = this.map.remove(obj);
            if (score == null) {
                return 0;
            }
        }
        return score.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(E obj) {
        Map<E, AtomicInteger> map = this.map;
        synchronized (map) {
            return this.map.containsKey(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int get(E obj) {
        AtomicInteger score;
        if (obj == null) {
            return 0;
        }
        Map<E, AtomicInteger> map = this.map;
        synchronized (map) {
            score = this.map.get(obj);
        }
        if (score == null) {
            return 0;
        }
        return score.intValue();
    }

    public SortedMap<E, AtomicInteger> tailMap(E obj) {
        if (this.map instanceof TreeMap) {
            return ((TreeMap)this.map).tailMap(obj);
        }
        throw new UnsupportedOperationException("map must have comparator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMinScore() {
        if (this.map.isEmpty()) {
            return -1;
        }
        int minScore = Integer.MAX_VALUE;
        Map<E, AtomicInteger> map = this.map;
        synchronized (map) {
            for (Map.Entry<E, AtomicInteger> entry2 : this.map.entrySet()) {
                if (entry2.getValue().intValue() >= minScore) continue;
                minScore = entry2.getValue().intValue();
            }
        }
        return minScore;
    }

    public int getMaxScore() {
        if (this.map.isEmpty()) {
            return -1;
        }
        int maxScore = Integer.MIN_VALUE;
        for (Map.Entry<E, AtomicInteger> entry2 : this.map.entrySet()) {
            if (entry2.getValue().intValue() <= maxScore) continue;
            maxScore = entry2.getValue().intValue();
        }
        return maxScore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> keys(boolean up) {
        Map<E, AtomicInteger> map = this.map;
        synchronized (map) {
            TreeMap<Integer, Set> m = new TreeMap<Integer, Set>();
            for (Map.Entry<E, AtomicInteger> entry2 : this.map.entrySet()) {
                Set s = (Set)m.get(entry2.getValue().intValue());
                if (s == null) {
                    s = this.map instanceof TreeMap ? new TreeSet(((TreeMap)this.map).comparator()) : new HashSet();
                    s.add(entry2.getKey());
                    m.put(((AtomicInteger)entry2.getValue()).intValue(), s);
                    continue;
                }
                s.add(entry2.getKey());
            }
            ArrayList l = new ArrayList(this.map.size());
            for (Set f : m.values()) {
                for (Object e : f) {
                    l.add(e);
                }
            }
            if (up) {
                return l.iterator();
            }
            ArrayList r = new ArrayList(l.size());
            for (int i = l.size() - 1; i >= 0; --i) {
                r.add(l.get(i));
            }
            return r.iterator();
        }
    }

    public static void main(String[] args) {
        OrderedScoreMap<StringBuilder> w = new OrderedScoreMap<StringBuilder>(StringBuilderComparator.CASE_INSENSITIVE_ORDER);
        Random r = new Random();
        for (int i = 0; i < 10000; ++i) {
            w.inc(new StringBuilder("a" + (char)(97 + r.nextInt(26))));
        }
        for (StringBuilder s : w) {
            System.out.println(String.valueOf(s) + ":" + w.get(s));
        }
        System.out.println("--");
        w.shrinkToMaxSize(10);
        for (StringBuilder s : w) {
            System.out.println(String.valueOf(s) + ":" + w.get(s));
        }
    }
}

