/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.geo;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.yacy.cora.document.WordCache;
import net.yacy.cora.geo.GeoLocation;
import net.yacy.cora.geo.Locations;
import net.yacy.cora.geo.OverarchingLocation;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;

public class GeonamesLocation
implements Locations {
    private static final ConcurrentLog log = new ConcurrentLog(GeonamesLocation.class.getName());
    private final Map<Integer, GeoLocation> id2loc;
    private final TreeMap<String, List<Integer>> name2ids;
    private final File file;

    public GeonamesLocation(File file, WordCache dymLib, long minPopulation) {
        BufferedReader reader;
        this.file = file;
        this.id2loc = new HashMap<Integer, GeoLocation>();
        this.name2ids = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        if (file == null || !file.exists()) {
            return;
        }
        try {
            ZipFile zf = new ZipFile(file);
            Object entryName = file.getName();
            entryName = ((String)entryName).substring(0, ((String)entryName).length() - 3) + "txt";
            ZipEntry ze = zf.getEntry((String)entryName);
            InputStream is = zf.getInputStream(ze);
            reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            zf.close();
        }
        catch (IOException e) {
            log.warn(e);
            return;
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                String[] fields = CommonPattern.TAB.split(line);
                long population = Long.parseLong(fields[14]);
                if (minPopulation > 0L && population < minPopulation) continue;
                Integer geonameid = Integer.valueOf(fields[0]);
                HashSet<String> locnames = new HashSet<String>();
                locnames.add(fields[1]);
                locnames.add(fields[2]);
                for (String s : CommonPattern.COMMA.split(fields[3])) {
                    locnames.add(s);
                }
                GeoLocation c = new GeoLocation(Float.parseFloat(fields[4]), Float.parseFloat(fields[5]), fields[1]);
                c.setPopulation((int)Long.parseLong(fields[14]));
                this.id2loc.put(geonameid, c);
                for (String name : locnames) {
                    if (dymLib != null && dymLib.contains(new StringBuilder(name)) || name.length() < OverarchingLocation.MINIMUM_NAME_LENGTH) continue;
                    List<Integer> locs = this.name2ids.get(name);
                    if (locs == null) {
                        locs = new ArrayList<Integer>(1);
                    }
                    locs.add(geonameid);
                    this.name2ids.put(name, locs);
                }
            }
        }
        catch (IOException e) {
            log.warn(e);
        }
    }

    @Override
    public int size() {
        return this.id2loc.size();
    }

    @Override
    public boolean isEmpty() {
        return this.id2loc.isEmpty();
    }

    private boolean caseIncensitiveStartsWith(String s0, String s1) {
        int l1 = s1.length();
        if (s0.length() < l1) {
            return false;
        }
        return s0.substring(0, l1).equalsIgnoreCase(s1);
    }

    @Override
    public TreeSet<GeoLocation> find(String anyname, boolean locationexact) {
        HashSet<Integer> r = new HashSet<Integer>();
        if (locationexact) {
            List<Integer> c = this.name2ids.get(anyname);
            if (c != null) {
                r.addAll(c);
            }
        } else {
            SortedMap<String, List<Integer>> cities = this.name2ids.tailMap(anyname);
            for (Map.Entry<String, List<Integer>> entry2 : cities.entrySet()) {
                if (!this.caseIncensitiveStartsWith(entry2.getKey(), anyname)) break;
                r.addAll((Collection)entry2.getValue());
            }
        }
        TreeSet<GeoLocation> a = new TreeSet<GeoLocation>();
        for (Integer n : r) {
            GeoLocation w = this.id2loc.get(n);
            if (w == null) continue;
            a.add(w);
        }
        return a;
    }

    @Override
    public Set<String> locationNames() {
        HashSet<String> locations = new HashSet<String>();
        locations.addAll(this.name2ids.keySet());
        return locations;
    }

    @Override
    public Set<String> recommend(String s) {
        HashSet<String> a = new HashSet<String>();
        if (s.isEmpty()) {
            return a;
        }
        SortedMap<String, List<Integer>> tail = this.name2ids.tailMap(s);
        for (String name : tail.keySet()) {
            if (!this.caseIncensitiveStartsWith(name, s)) break;
            a.add(name);
        }
        return a;
    }

    @Override
    public Set<StringBuilder> recommend(StringBuilder s) {
        HashSet<StringBuilder> a = new HashSet<StringBuilder>();
        if (s.length() == 0) {
            return a;
        }
        String sString = s.toString();
        SortedMap<String, List<Integer>> tail = this.name2ids.tailMap(sString);
        for (String name : tail.keySet()) {
            if (!this.caseIncensitiveStartsWith(name, sString)) break;
            a.add(new StringBuilder(name));
        }
        return a;
    }

    @Override
    public String nickname() {
        return this.file.getName();
    }

    @Override
    public int hashCode() {
        return this.nickname().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Locations)) {
            return false;
        }
        return this.nickname().equals(((Locations)other).nickname());
    }
}

