/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.ai.llama3.Tensor;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.yacy.ai.llama3.Model.GGMLType;
import net.yacy.ai.llama3.Tensor.FloatTensor;

public final class F16FloatTensor
extends FloatTensor {
    final int size;
    final ByteBuffer buffer;

    public F16FloatTensor(int size, ByteBuffer buffer) {
        if (buffer.remaining() < size * 2) {
            throw new IllegalArgumentException("Buffer too small");
        }
        this.size = size;
        this.buffer = buffer.duplicate().order(ByteOrder.nativeOrder());
    }

    public F16FloatTensor(float[] values) {
        this.size = values.length;
        this.buffer = ByteBuffer.allocateDirect(this.size * 2).order(ByteOrder.nativeOrder());
        for (int i = 0; i < this.size; ++i) {
            this.setFloat(i, values[i]);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public GGMLType type() {
        return GGMLType.F16;
    }

    @Override
    public final void setFloat(int index2, float value) {
        assert (0 <= index2 && index2 < this.size);
        short hBits = F16FloatTensor.floatToFloat16(value);
        this.buffer.putShort(index2 * 2, hBits);
    }

    @Override
    public final float getFloat(int index2) {
        assert (0 <= index2 && index2 < this.size);
        return F16FloatTensor.float16ToFloat(this.buffer.getShort(index2 * 2));
    }
}

