/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrClassLoader;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.handler.SolrConfigHandler;
import org.apache.solr.pkg.PackageListeningClassLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.rest.RestManager;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.SchemaManager;
import org.apache.solr.schema.ZkIndexSchemaReader;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaHandler
extends RequestHandlerBase
implements SolrCoreAware,
PermissionNameProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean isImmutableConfigSet = false;
    private SolrRequestHandler managedResourceRequestHandler;
    private static final Map<String, String> level2 = new HashMap<String, String>();
    private static final Set<String> subPaths;

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        block6: {
            RequestHandlerUtils.setWt(req, "json");
            String httpMethod = (String)req.getContext().get("httpMethod");
            if ("POST".equals(httpMethod)) {
                if (this.isImmutableConfigSet) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet is immutable");
                }
                if (req.getContentStreams() == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "no stream");
                }
                try {
                    List<Map<String, Object>> errs = new SchemaManager(req).performOperations();
                    if (!errs.isEmpty()) {
                        throw new ApiBag.ExceptionWithErrObject(SolrException.ErrorCode.BAD_REQUEST, "error processing commands", errs);
                    }
                    break block6;
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error reading input String " + e.getMessage(), (Throwable)e);
                }
            }
            this.handleGET(req, rsp);
        }
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
        switch (ctx.getHttpMethod()) {
            case "GET": {
                return PermissionNameProvider.Name.SCHEMA_READ_PERM;
            }
            case "PUT": 
            case "DELETE": 
            case "POST": {
                return PermissionNameProvider.Name.SCHEMA_EDIT_PERM;
            }
        }
        return null;
    }

    private void handleGET(SolrQueryRequest req, SolrQueryResponse rsp) {
        try {
            String path;
            switch (path = (String)req.getContext().get("path")) {
                case "/schema": {
                    rsp.add("schema", req.getSchema().getNamedPropertyValues());
                    break;
                }
                case "/schema/version": {
                    rsp.add("version", Float.valueOf(req.getSchema().getVersion()));
                    break;
                }
                case "/schema/uniquekey": {
                    rsp.add("uniqueKey", req.getSchema().getUniqueKeyField().getName());
                    break;
                }
                case "/schema/similarity": {
                    rsp.add("similarity", req.getSchema().getSimilarityFactory().getNamedPropertyValues());
                    break;
                }
                case "/schema/name": {
                    String schemaName = req.getSchema().getSchemaName();
                    if (null == schemaName) {
                        String message = "Schema has no name";
                        throw new SolrException(SolrException.ErrorCode.NOT_FOUND, message);
                    }
                    rsp.add("name", schemaName);
                    break;
                }
                case "/schema/zkversion": {
                    int refreshIfBelowVersion = req.getParams().getInt("refreshIfBelowVersion");
                    int zkVersion = -1;
                    IndexSchema schema = req.getSchema();
                    if (schema instanceof ManagedIndexSchema) {
                        ManagedIndexSchema managed = (ManagedIndexSchema)schema;
                        zkVersion = managed.getSchemaZkVersion();
                        if (refreshIfBelowVersion != -1 && zkVersion < refreshIfBelowVersion) {
                            log.info("REFRESHING SCHEMA (refreshIfBelowVersion={}, currentVersion={}) before returning version!", (Object)refreshIfBelowVersion, (Object)zkVersion);
                            ZkSolrResourceLoader zkSolrResourceLoader = (ZkSolrResourceLoader)req.getCore().getResourceLoader();
                            ZkIndexSchemaReader zkIndexSchemaReader = zkSolrResourceLoader.getZkIndexSchemaReader();
                            managed = zkIndexSchemaReader.refreshSchemaFromZk(refreshIfBelowVersion);
                            zkVersion = managed.getSchemaZkVersion();
                        }
                    }
                    rsp.add("zkversion", zkVersion);
                    break;
                }
                default: {
                    List parts = StrUtils.splitSmart((String)path, (char)'/', (boolean)true);
                    if (parts.size() > 1 && level2.containsKey(parts.get(1))) {
                        String realName = (String)parts.get(1);
                        String fieldName = IndexSchema.nameMapping.get(realName);
                        String pathParam = level2.get(realName);
                        if (parts.size() > 2) {
                            req.setParams(SolrParams.wrapDefaults((SolrParams)new MapSolrParams(Collections.singletonMap(pathParam, (String)parts.get(2))), (SolrParams)req.getParams()));
                        }
                        Map<String, Object> propertyValues = req.getSchema().getNamedPropertyValues(realName, req.getParams());
                        Object o = propertyValues.get(fieldName);
                        if (parts.size() > 2) {
                            String name = (String)parts.get(2);
                            if (o instanceof List) {
                                List list = (List)o;
                                for (Object obj : list) {
                                    SimpleOrderedMap simpleOrderedMap;
                                    if (!(obj instanceof SimpleOrderedMap) || !name.equals((simpleOrderedMap = (SimpleOrderedMap)obj).get("name"))) continue;
                                    rsp.add(fieldName.substring(0, realName.length() - 1), simpleOrderedMap);
                                    this.insertPackageInfo(rsp.getValues(), req);
                                    return;
                                }
                            }
                            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No such path " + path);
                        }
                        rsp.add(fieldName, o);
                        this.insertPackageInfo(rsp.getValues(), req);
                        return;
                    }
                    throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No such path " + path);
                }
            }
        }
        catch (Exception e) {
            rsp.setException(e);
        }
    }

    private void insertPackageInfo(Object o, SolrQueryRequest req) {
        if (!req.getParams().getBool("meta", false)) {
            return;
        }
        if (o instanceof List) {
            List l = (List)o;
            for (Object o1 : l) {
                if (!(o1 instanceof NamedList) && !(o1 instanceof List)) continue;
                this.insertPackageInfo(o1, req);
            }
        } else if (o instanceof NamedList) {
            NamedList nl = (NamedList)o;
            nl.forEach((n, v) -> {
                if (v instanceof NamedList || v instanceof List) {
                    this.insertPackageInfo(v, req);
                }
            });
            Object v2 = nl.get("class");
            if (v2 instanceof String) {
                String klas = (String)v2;
                PluginInfo.ClassName parsedClassName = new PluginInfo.ClassName(klas);
                if (parsedClassName.pkg != null) {
                    MapWriter mw;
                    SolrClassLoader solrClassLoader = req.getCore().getLatestSchema().getSolrClassLoader();
                    MapWriter mapWriter = mw = solrClassLoader instanceof PackageListeningClassLoader ? ((PackageListeningClassLoader)solrClassLoader).getPackageVersion(parsedClassName) : null;
                    if (mw != null) {
                        nl.add("_packageinfo_", (Object)mw);
                    }
                }
            }
        }
    }

    @Override
    public SolrRequestHandler getSubHandler(String subPath) {
        List parts = StrUtils.splitSmart((String)subPath, (char)'/', (boolean)true);
        String prefix = (String)parts.get(0);
        if (subPaths.contains(prefix)) {
            return this;
        }
        if (this.managedResourceRequestHandler != null) {
            return this.managedResourceRequestHandler;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return "CRUD operations over the Solr schema";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public void inform(SolrCore core) {
        this.isImmutableConfigSet = SolrConfigHandler.getImmutable(core);
        this.managedResourceRequestHandler = new ManagedResourceRequestHandler(core.getRestManager());
    }

    @Override
    public Collection<Api> getApis() {
        return ApiBag.wrapRequestHandlers(this, "core.SchemaRead", "core.SchemaRead.fields", "core.SchemaRead.copyFields", "core.SchemaEdit", "core.SchemaRead.dynamicFields_fieldTypes");
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    static {
        level2.put(IndexSchema.SchemaProps.Handler.FIELD_TYPES.nameLower, null);
        level2.put(IndexSchema.SchemaProps.Handler.FIELDS.nameLower, "fl");
        level2.put(IndexSchema.SchemaProps.Handler.DYNAMIC_FIELDS.nameLower, "fl");
        level2.put(IndexSchema.SchemaProps.Handler.COPY_FIELDS.nameLower, null);
        subPaths = new HashSet<String>(Set.of("version", "uniquekey", "name", "similarity", "defaultsearchfield", "solrqueryparser", "zkversion"));
        subPaths.addAll(level2.keySet());
    }

    private class ManagedResourceRequestHandler
    extends RequestHandlerBase
    implements PermissionNameProvider {
        private final RestManager restManager;

        private ManagedResourceRequestHandler(RestManager restManager) {
            this.restManager = restManager;
        }

        @Override
        public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) {
            RestManager.ManagedEndpoint me = new RestManager.ManagedEndpoint(this.restManager);
            me.doInit(req, rsp);
            me.delegateRequestToManagedResource();
        }

        @Override
        public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
            return SchemaHandler.this.getPermissionName(ctx);
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }
    }
}

