var RENCODE={DEFAULT_FLOAT_BITS:32,MAX_INT_LENGTH:64,CHR_LIST:59,CHR_DICT:60,CHR_INT:61,CHR_INT1:62,CHR_INT2:63,CHR_INT4:64,CHR_INT8:65,CHR_FLOAT32:66,CHR_FLOAT64:44,CHR_TRUE:67,CHR_FALSE:68,CHR_NONE:69,CHR_TERM:127,INT_POS_FIXED_START:0,INT_POS_FIXED_COUNT:44,DICT_FIXED_START:102,DICT_FIXED_COUNT:25,INT_NEG_FIXED_START:70,INT_NEG_FIXED_COUNT:32,STR_FIXED_START:128,STR_FIXED_COUNT:64,LIST_FIXED_START:192,LIST_FIXED_COUNT:64,COLON_CHARCODE:":".charCodeAt(0),SLASH_CHARCODE:"/".charCodeAt(0)};function utf8ByteArrayToString(bytes){for(var out=[],pos=0,c=0;pos<bytes.length;){var u,c2,c3,c1=bytes[pos++];c1<128?out[c++]=String.fromCharCode(c1):191<c1&&c1<224?(c2=bytes[pos++],out[c++]=String.fromCharCode((31&c1)<<6|63&c2)):239<c1&&c1<365?(u=((7&c1)<<18|(63&(c2=bytes[pos++]))<<12|(63&(c3=bytes[pos++]))<<6|63&bytes[pos++])-65536,out[c++]=String.fromCharCode(55296+(u>>10)),out[c++]=String.fromCharCode(56320+(1023&u))):(c2=bytes[pos++],c3=bytes[pos++],out[c++]=String.fromCharCode((15&c1)<<12|(63&c2)<<6|63&c3))}return out.join("")}function stringToUtf8ByteArray(str){for(var out=[],p=0,i=0;i<str.length;i++){var c=str.charCodeAt(i);c<128?out[p++]=c:(c<2048?out[p++]=c>>6|192:(55296==(64512&c)&&i+1<str.length&&56320==(64512&str.charCodeAt(i+1))?(c=65536+((1023&c)<<10)+(1023&str.charCodeAt(++i)),out[p++]=c>>18|240,out[p++]=c>>12&63|128):out[p++]=c>>12|224,out[p++]=c>>6&63|128),out[p++]=63&c|128)}return out}function rencode_string(str){var bytes=stringToUtf8ByteArray(str),len=bytes.length;if(len<RENCODE.STR_FIXED_COUNT){(u8a=new Uint8Array(len+1))[0]=RENCODE.STR_FIXED_START+len;for(var i=0;i<len;++i)u8a[i+1]=bytes[i]}else{for(var len_str=len.toString(),len_len=len_str.length,u8a=new Uint8Array(len_len+1+len),i=0;i<len_len;++i)u8a[i]=len_str.charCodeAt(i);u8a[len_len]=":".charCodeAt(0);for(i=0;i<len_str;++i)u8a[len_len+1+i]=bytes[i]}return u8a}function rencode_int(i){var i8a,u8a=null;if(0<=i&&i<RENCODE.INT_POS_FIXED_COUNT)u8a=new Uint8Array([RENCODE.INT_POS_FIXED_START+i]);else if(-RENCODE.INT_NEG_FIXED_COUNT<=i&&i<0)u8a=new Uint8Array(new Int8Array([RENCODE.INT_NEG_FIXED_START-1-i]).buffer);else if(-128<=i&&i<128)u8a=new Uint8Array(new Int8Array([RENCODE.CHR_INT1,i]).buffer);else if(-32768<=i&&i<32768)u8a=new Uint8Array(new Int8Array([RENCODE.CHR_INT2,Math.floor(i/256)%256,i%256]).buffer);else if(-2147483648<=i&&i<2147483648)(i8a=new Int8Array(5))[0]=RENCODE.CHR_INT4,i8a[1]=Math.floor(i/256/256/256),i8a[2]=Math.floor(i/256/256)%256,i8a[3]=Math.floor(i/256)%256,i8a[4]=i%256,u8a=new Uint8Array(i8a.buffer);else if(-0x8000000000000000<=i&&i<0x8000000000000000){(i8a=new Int8Array(9))[0]=RENCODE.CHR_INT8;for(var j=0;j<8;++j)i8a[8-j]=i%256,i=Math.floor(i/256);u8a=new Uint8Array(i8a.buffer)}else{var str=i.toString();if(str.length>=RENCODE.MAX_INT_LENGTH)throw"number too big: "+i;var str_len=str.length;(u8a=new Uint8Array(str_len+2))[0]=RENCODE.CHR_INT;for(j=0;j<str_len;++j)u8a[1+j]=str[j];u8a[str_len+1]=RENCODE.CHR_TERM}return u8a}function rencode_merge_arrays(rlist){for(var len=0,i=0;i<rlist.length;++i)len+=rlist[i].length;for(var u8a=new Uint8Array(len),index=0,i=0;i<rlist.length;++i)u8a.set(rlist[i],index),index+=rlist[i].length;return u8a}function rencode_uint8(a){for(var len=a.length,len_str=len.toString(),len_len=len_str.length,u8a=new Uint8Array(len_len+1+len),i=0;i<len_len;++i)u8a[i]=len_str.charCodeAt(i);return u8a[len_len]="/".charCodeAt(0),u8a.set(a,len_len+1),u8a}function rencode_list(l){var list_len=l.length,rlist=[];if(list_len<RENCODE.LIST_FIXED_COUNT){rlist.push(new Uint8Array([RENCODE.LIST_FIXED_START+list_len]));for(var i=0;i<list_len;++i)rlist.push(rencode(l[i]))}else{rlist.push(new Uint8Array([RENCODE.CHR_LIST]));for(i=0;i<list_len;++i)rlist.push(rencode(l[i]));rlist.push(new Uint8Array([RENCODE.CHR_TERM]))}return rencode_merge_arrays(rlist)}function rencode_dict(dict){var dict_len=Object.keys(dict).length,rlist=[];if(dict_len<RENCODE.DICT_FIXED_COUNT)for(var key in rlist.push(new Uint8Array([RENCODE.DICT_FIXED_START+dict_len])),dict){var value=dict[key];rlist.push(rencode(key)),rlist.push(rencode(value))}else{for(var key in rlist.push(new Uint8Array([RENCODE.CHR_DICT])),dict){value=dict[key];rlist.push(rencode(key)),rlist.push(rencode(value))}rlist.push(new Uint8Array([RENCODE.CHR_TERM]))}return rencode_merge_arrays(rlist)}function rencode_bool(v){return v?new Uint8Array([RENCODE.CHR_TRUE]):new Uint8Array([RENCODE.CHR_FALSE])}function rencode_none(){return new Uint8Array([RENCODE.CHR_NONE])}function rencode(obj){if(null==obj)return rencode_none();var type=typeof obj;if("object"==type)return(void 0===obj.length?rencode_dict:obj.constructor===Uint8Array?rencode_uint8:rencode_list)(obj);switch(type){case"string":return rencode_string(obj);case"number":return rencode_int(obj);case"list":return rencode_list(obj);case"dictionary":return rencode_dict(obj);case"boolean":return rencode_bool(obj?1:0);default:throw"invalid object type in source: "+type}}function rdecode_string(dec){for(var len=0;dec.buf[dec.pos+len]!=RENCODE.COLON_CHARCODE&&dec.buf[dec.pos+len]!=RENCODE.SLASH_CHARCODE;)len++;var str_len_str=String.fromCharCode.apply(null,dec.buf.subarray(dec.pos,dec.pos+len)),str_len=parseInt(str_len_str);if(isNaN(str_len))throw"invalid string length: '"+str_len_str+"'";var str_len_str=dec.buf[dec.pos+len]==RENCODE.SLASH_CHARCODE,bytes=(dec.pos+=len+1,dec.buf.subarray(dec.pos,dec.pos+str_len));return dec.pos+=str_len,str_len_str?new Uint8Array(bytes):0==str_len?"":utf8ByteArrayToString(bytes)}function Uint8ToString(u8a){if("string"==typeof u8a)return u8a;for(var c=[],i=0;i<u8a.length;i+=32768)c.push(String.fromCharCode.apply(null,u8a.subarray(i,i+32768)));return c.join("")}function rdecode_list(dec){dec.pos++;for(var list=[];dec.buf[dec.pos]!=RENCODE.CHR_TERM;)list.push(_rdecode(dec));return dec.pos++,list}function rdecode_dict(dec){dec.pos++;for(var dict={};dec.buf[dec.pos]!=RENCODE.CHR_TERM;){var key=_rdecode(dec),value=_rdecode(dec);dict[key]=value}return dec.pos++,dict}function rdecode_int(dec){dec.pos++;for(var len=0;dec.buf[dec.pos+len]!=RENCODE.CHR_TERM;)len++;var int_str=String.fromCharCode.apply(null,dec.buf.subarray(dec.pos,dec.pos+len)),i=(dec.pos+=len+1,parseInt(int_str));if(isNaN(i))throw"invalid int: '"+int_str+"'";return i}function rdecode_intb(dec){var b=dec.buf[dec.pos+1]<<24>>24;return dec.pos+=2,b}function rdecode_inth(dec){var slice=dec.buf.slice(dec.pos+1,dec.pos+3),slice=new DataView(slice.buffer).getInt16(0);return dec.pos+=3,slice}function rdecode_intl(dec){var slice=dec.buf.slice(dec.pos+1,dec.pos+5),slice=new DataView(slice.buffer).getInt32(0);return dec.pos+=5,slice}function rdecode_intq(dec){var slice=dec.buf.slice(dec.pos+1,dec.pos+9),slice=new DataView(slice.buffer).getBigInt64(0);return dec.pos+=9,Number.isSafeInteger(slice),parseInt(slice)}function rdecode_true(dec){return dec.pos++,!0}function rdecode_false(dec){return dec.pos++,!1}function rdecode_none(dec){return dec.pos++,null}Number.isSafeInteger=Number.isSafeInteger||function(value){return Number.isInteger(value)&&Math.abs(value)<=Number.MAX_SAFE_INTEGER};for(var decode_func=new Map,i=0;i<10;i++){var charcode=i.toString().charCodeAt(0);decode_func[charcode]=rdecode_string}function make_fixed_length_string_decoder(len){return function(dec){dec.pos++;var u8a=dec.buf.subarray(dec.pos,dec.pos+len);return dec.pos+=len,utf8ByteArrayToString(u8a)}}decode_func[RENCODE.CHR_LIST]=rdecode_list,decode_func[RENCODE.CHR_DICT]=rdecode_dict,decode_func[RENCODE.CHR_INT]=rdecode_int,decode_func[RENCODE.CHR_INT1]=rdecode_intb,decode_func[RENCODE.CHR_INT2]=rdecode_inth,decode_func[RENCODE.CHR_INT4]=rdecode_intl,decode_func[RENCODE.CHR_INT8]=rdecode_intq,decode_func[RENCODE.CHR_TRUE]=rdecode_true,decode_func[RENCODE.CHR_FALSE]=rdecode_false,decode_func[RENCODE.CHR_NONE]=rdecode_none;for(i=0;i<RENCODE.STR_FIXED_COUNT;i++)decode_func[RENCODE.STR_FIXED_START+i]=make_fixed_length_string_decoder(i);function make_fixed_length_list_decoder(len){return function(dec){dec.pos++;for(var list=[],i=0;i<len;i++)list.push(_rdecode(dec));return list}}for(i=0;i<RENCODE.LIST_FIXED_COUNT;i++)decode_func[RENCODE.LIST_FIXED_START+i]=make_fixed_length_list_decoder(i);function make_fixed_length_dict_decoder(len){return function(dec){dec.pos++;for(var dict={},i=0;i<len;i++){var key=_rdecode(dec),value=_rdecode(dec);dict[key]=value}return dict}}for(i=0;i<RENCODE.DICT_FIXED_COUNT;i++)decode_func[RENCODE.DICT_FIXED_START+i]=make_fixed_length_dict_decoder(i);function make_int_fixed_decoder(i){return function(dec){return dec.pos++,i}}for(i=0;i<RENCODE.INT_POS_FIXED_COUNT;i++)decode_func[RENCODE.INT_POS_FIXED_START+i]=make_int_fixed_decoder(i);for(i=0;i<RENCODE.INT_NEG_FIXED_COUNT;i++)decode_func[RENCODE.INT_NEG_FIXED_START+i]=make_int_fixed_decoder(-1-i);class DecodeBuffer{constructor(u8a){this.buf=u8a,this.pos=0}}function _rdecode(dec){if(dec.pos>=dec.buf.length)throw"reached end of buffer";var typecode=dec.buf[dec.pos],decode=decode_func[typecode];if(null==decode)throw"no decoder for typecode "+typecode+" at position "+dec.pos;return decode(dec)}function rdecode(buf){var type=typeof buf;if("string"==type){for(var u8a=new Uint8Array(buf.length),i=0,j=buf.length;i<j;++i)u8a[i]=buf.charCodeAt(i);return _rdecode(new DecodeBuffer(u8a))}if("object"==type&&buf.constructor===Uint8Array)return _rdecode(new DecodeBuffer(buf));throw"cannot decode "+type}function rencode_selftest(){function test_value(input,output){var u8a_output=new Uint8Array(output),enc=rencode(input);if(enc.length!=u8a_output.length)throw"failed to encode '"+input+"', expected length "+u8a_output.length+" bytes but got "+enc.length;for(var i=0,j=enc.length;i<j;++i)if(enc[i]!=u8a_output[i])throw"failed to encode '"+input+"', expected '"+u8a_output+"' but got '"+enc+"', error at position "+i+": "+enc[i]+" vs "+u8a_output[i];output=rdecode(enc);if(output!=input)throw"failed to decode '"+enc+"', expected '"+input+"' but got '"+output+"'"}try{return test_value(!0,[67]),test_value(!1,[68]),test_value(-10,[79]),test_value(-29,[98]),test_value(1,[1]),test_value(40,[40]),test_value("foobarbaz",[137,102,111,111,98,97,114,98,97,122]),test_value(100,[62,100]),test_value(-100,[62,156]),test_value(7483648,[64,0,114,49,0]),test_value(-7483648,[64,255,141,207,0]),test_value(0x721f494c589c0000,[65,114,31,73,76,88,156,0,0]),test_value(-0x721f494c589c0000,[65,141,224,182,179,167,100,0,0]),test_value(27123,[63,105,243]),test_value(-27123,[63,150,13]),test_value("\0",[129,0]),test_value("fööbar",[136,102,195,182,195,182,98,97,114]),!0}catch(e){return console.log("rencode failed its self test",e),!1}}