/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 2016-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */
#ifndef __WINE_ICU_H
#define __WINE_ICU_H

#define U_MAX_VERSION_LENGTH 4

typedef uint8_t UBiDiLevel;
typedef int8_t UBool;
typedef uint16_t UChar;
typedef int32_t UChar32;
typedef double UDate;

typedef enum UErrorCode
{
    U_USING_FALLBACK_WARNING = -128,
    U_ERROR_WARNING_START = -128,
    U_USING_DEFAULT_WARNING = -127,
    U_SAFECLONE_ALLOCATED_WARNING = -126,
    U_STATE_OLD_WARNING = -125,
    U_STRING_NOT_TERMINATED_WARNING = -124,
    U_SORT_KEY_TOO_SHORT_WARNING = -123,
    U_AMBIGUOUS_ALIAS_WARNING = -122,
    U_DIFFERENT_UCA_VERSION = -121,
    U_PLUGIN_CHANGED_LEVEL_WARNING = -120,
    U_ZERO_ERROR = 0,
    U_ILLEGAL_ARGUMENT_ERROR = 1,
    U_MISSING_RESOURCE_ERROR = 2,
    U_INVALID_FORMAT_ERROR = 3,
    U_FILE_ACCESS_ERROR = 4,
    U_INTERNAL_PROGRAM_ERROR = 5,
    U_MESSAGE_PARSE_ERROR = 6,
    U_MEMORY_ALLOCATION_ERROR = 7,
    U_INDEX_OUTOFBOUNDS_ERROR = 8,
    U_PARSE_ERROR = 9,
    U_INVALID_CHAR_FOUND = 10,
    U_TRUNCATED_CHAR_FOUND = 11,
    U_ILLEGAL_CHAR_FOUND = 12,
    U_INVALID_TABLE_FORMAT = 13,
    U_INVALID_TABLE_FILE = 14,
    U_BUFFER_OVERFLOW_ERROR = 15,
    U_UNSUPPORTED_ERROR = 16,
    U_RESOURCE_TYPE_MISMATCH = 17,
    U_ILLEGAL_ESCAPE_SEQUENCE = 18,
    U_UNSUPPORTED_ESCAPE_SEQUENCE = 19,
    U_NO_SPACE_AVAILABLE = 20,
    U_CE_NOT_FOUND_ERROR = 21,
    U_PRIMARY_TOO_LONG_ERROR = 22,
    U_STATE_TOO_OLD_ERROR = 23,
    U_TOO_MANY_ALIASES_ERROR = 24,
    U_ENUM_OUT_OF_SYNC_ERROR = 25,
    U_INVARIANT_CONVERSION_ERROR = 26,
    U_INVALID_STATE_ERROR = 27,
    U_COLLATOR_VERSION_MISMATCH = 28,
    U_USELESS_COLLATOR_ERROR = 29,
    U_NO_WRITE_PERMISSION = 30,
    U_BAD_VARIABLE_DEFINITION = 0x10000,
    U_PARSE_ERROR_START = 0x10000,
    U_MALFORMED_RULE,
    U_MALFORMED_SET,
    U_MALFORMED_SYMBOL_REFERENCE,
    U_MALFORMED_UNICODE_ESCAPE,
    U_MALFORMED_VARIABLE_DEFINITION,
    U_MALFORMED_VARIABLE_REFERENCE,
    U_MISMATCHED_SEGMENT_DELIMITERS,
    U_MISPLACED_ANCHOR_START,
    U_MISPLACED_CURSOR_OFFSET,
    U_MISPLACED_QUANTIFIER,
    U_MISSING_OPERATOR,
    U_MISSING_SEGMENT_CLOSE,
    U_MULTIPLE_ANTE_CONTEXTS,
    U_MULTIPLE_CURSORS,
    U_MULTIPLE_POST_CONTEXTS,
    U_TRAILING_BACKSLASH,
    U_UNDEFINED_SEGMENT_REFERENCE,
    U_UNDEFINED_VARIABLE,
    U_UNQUOTED_SPECIAL,
    U_UNTERMINATED_QUOTE,
    U_RULE_MASK_ERROR,
    U_MISPLACED_COMPOUND_FILTER,
    U_MULTIPLE_COMPOUND_FILTERS,
    U_INVALID_RBT_SYNTAX,
    U_INVALID_PROPERTY_PATTERN,
    U_MALFORMED_PRAGMA,
    U_UNCLOSED_SEGMENT,
    U_ILLEGAL_CHAR_IN_SEGMENT,
    U_VARIABLE_RANGE_EXHAUSTED,
    U_VARIABLE_RANGE_OVERLAP,
    U_ILLEGAL_CHARACTER,
    U_INTERNAL_TRANSLITERATOR_ERROR,
    U_INVALID_ID,
    U_INVALID_FUNCTION,
    U_UNEXPECTED_TOKEN = 0x10100,
    U_FMT_PARSE_ERROR_START = 0x10100,
    U_MULTIPLE_DECIMAL_SEPARATORS,
    U_MULTIPLE_DECIMAL_SEPERATORS = U_MULTIPLE_DECIMAL_SEPARATORS,
    U_MULTIPLE_EXPONENTIAL_SYMBOLS,
    U_MALFORMED_EXPONENTIAL_PATTERN,
    U_MULTIPLE_PERCENT_SYMBOLS,
    U_MULTIPLE_PERMILL_SYMBOLS,
    U_MULTIPLE_PAD_SPECIFIERS,
    U_PATTERN_SYNTAX_ERROR,
    U_ILLEGAL_PAD_POSITION,
    U_UNMATCHED_BRACES,
    U_UNSUPPORTED_PROPERTY,
    U_UNSUPPORTED_ATTRIBUTE,
    U_ARGUMENT_TYPE_MISMATCH,
    U_DUPLICATE_KEYWORD,
    U_UNDEFINED_KEYWORD,
    U_DEFAULT_KEYWORD_MISSING,
    U_DECIMAL_NUMBER_SYNTAX_ERROR,
    U_FORMAT_INEXACT_ERROR,
    U_NUMBER_ARG_OUTOFBOUNDS_ERROR,
    U_NUMBER_SKELETON_SYNTAX_ERROR,
    U_BRK_INTERNAL_ERROR = 0x10200,
    U_BRK_ERROR_START = 0x10200,
    U_BRK_HEX_DIGITS_EXPECTED,
    U_BRK_SEMICOLON_EXPECTED,
    U_BRK_RULE_SYNTAX,
    U_BRK_UNCLOSED_SET,
    U_BRK_ASSIGN_ERROR,
    U_BRK_VARIABLE_REDFINITION,
    U_BRK_MISMATCHED_PAREN,
    U_BRK_NEW_LINE_IN_QUOTED_STRING,
    U_BRK_UNDEFINED_VARIABLE,
    U_BRK_INIT_ERROR,
    U_BRK_RULE_EMPTY_SET,
    U_BRK_UNRECOGNIZED_OPTION,
    U_BRK_MALFORMED_RULE_TAG,
    U_REGEX_INTERNAL_ERROR = 0x10300,
    U_REGEX_ERROR_START = 0x10300,
    U_REGEX_RULE_SYNTAX,
    U_REGEX_INVALID_STATE,
    U_REGEX_BAD_ESCAPE_SEQUENCE,
    U_REGEX_PROPERTY_SYNTAX,
    U_REGEX_UNIMPLEMENTED,
    U_REGEX_MISMATCHED_PAREN,
    U_REGEX_NUMBER_TOO_BIG,
    U_REGEX_BAD_INTERVAL,
    U_REGEX_MAX_LT_MIN,
    U_REGEX_INVALID_BACK_REF,
    U_REGEX_INVALID_FLAG,
    U_REGEX_LOOK_BEHIND_LIMIT,
    U_REGEX_SET_CONTAINS_STRING,
    U_REGEX_MISSING_CLOSE_BRACKET = U_REGEX_SET_CONTAINS_STRING + 2,
    U_REGEX_INVALID_RANGE,
    U_REGEX_STACK_OVERFLOW,
    U_REGEX_TIME_OUT,
    U_REGEX_STOPPED_BY_CALLER,
    U_REGEX_PATTERN_TOO_BIG,
    U_REGEX_INVALID_CAPTURE_GROUP_NAME,
    U_IDNA_PROHIBITED_ERROR = 0x10400,
    U_IDNA_ERROR_START = 0x10400,
    U_IDNA_UNASSIGNED_ERROR,
    U_IDNA_CHECK_BIDI_ERROR,
    U_IDNA_STD3_ASCII_RULES_ERROR,
    U_IDNA_ACE_PREFIX_ERROR,
    U_IDNA_VERIFICATION_ERROR,
    U_IDNA_LABEL_TOO_LONG_ERROR,
    U_IDNA_ZERO_LENGTH_LABEL_ERROR,
    U_IDNA_DOMAIN_NAME_TOO_LONG_ERROR,
    U_STRINGPREP_PROHIBITED_ERROR = U_IDNA_PROHIBITED_ERROR,
    U_STRINGPREP_UNASSIGNED_ERROR = U_IDNA_UNASSIGNED_ERROR,
    U_STRINGPREP_CHECK_BIDI_ERROR = U_IDNA_CHECK_BIDI_ERROR,
    U_PLUGIN_ERROR_START = 0x10500,
    U_PLUGIN_TOO_HIGH = 0x10500,
    U_PLUGIN_DIDNT_SET_LEVEL,
} UErrorCode;

enum
{
    U_PARSE_CONTEXT_LEN = 16
};

typedef enum UDateTimeScale
{
    UDTS_JAVA_TIME = 0,
    UDTS_UNIX_TIME,
    UDTS_ICU4C_TIME,
    UDTS_WINDOWS_FILE_TIME,
    UDTS_DOTNET_DATE_TIME,
    UDTS_MAC_OLD_TIME,
    UDTS_MAC_TIME,
    UDTS_EXCEL_TIME,
    UDTS_DB2_TIME,
    UDTS_UNIX_MICROSECONDS_TIME,
} UDateTimeScale;

typedef enum UTimeScaleValue
{
    UTSV_UNITS_VALUE = 0,
    UTSV_EPOCH_OFFSET_VALUE = 1,
    UTSV_FROM_MIN_VALUE = 2,
    UTSV_FROM_MAX_VALUE = 3,
    UTSV_TO_MIN_VALUE = 4,
    UTSV_TO_MAX_VALUE = 5,
} UTimeScaleValue;

typedef enum UTransDirection
{
    UTRANS_FORWARD,
    UTRANS_REVERSE
} UTransDirection;

typedef enum URestrictionLevel
{
    USPOOF_ASCII = 0x10000000,
    USPOOF_SINGLE_SCRIPT_RESTRICTIVE = 0x20000000,
    USPOOF_HIGHLY_RESTRICTIVE = 0x30000000,
    USPOOF_MODERATELY_RESTRICTIVE = 0x40000000,
    USPOOF_MINIMALLY_RESTRICTIVE = 0x50000000,
    USPOOF_UNRESTRICTIVE = 0x60000000,
    USPOOF_RESTRICTION_LEVEL_MASK = 0x7F000000,
} URestrictionLevel;

typedef enum
{
    USEARCH_OVERLAP = 0,
    USEARCH_ELEMENT_COMPARISON = 2,
} USearchAttribute;

typedef enum
{
    USEARCH_DEFAULT = -1,
    USEARCH_OFF,
    USEARCH_ON,
    USEARCH_STANDARD_ELEMENT_COMPARISON,
    USEARCH_PATTERN_BASE_WEIGHT_IS_WILDCARD,
    USEARCH_ANY_BASE_WEIGHT_IS_WILDCARD,
} USearchAttributeValue;

typedef enum URelativeDateTimeUnit
{
    UDAT_REL_UNIT_YEAR,
    UDAT_REL_UNIT_QUARTER,
    UDAT_REL_UNIT_MONTH,
    UDAT_REL_UNIT_WEEK,
    UDAT_REL_UNIT_DAY,
    UDAT_REL_UNIT_HOUR,
    UDAT_REL_UNIT_MINUTE,
    UDAT_REL_UNIT_SECOND,
    UDAT_REL_UNIT_SUNDAY,
    UDAT_REL_UNIT_MONDAY,
    UDAT_REL_UNIT_TUESDAY,
    UDAT_REL_UNIT_WEDNESDAY,
    UDAT_REL_UNIT_THURSDAY,
    UDAT_REL_UNIT_FRIDAY,
    UDAT_REL_UNIT_SATURDAY,
} URelativeDateTimeUnit;

typedef enum URegionType
{
    URGN_UNKNOWN,
    URGN_TERRITORY,
    URGN_WORLD,
    URGN_CONTINENT,
    URGN_SUBCONTINENT,
    URGN_GROUPING,
    URGN_DEPRECATED,
} URegionType;

typedef enum
{
    UNORM2_COMPOSE,
    UNORM2_DECOMPOSE,
    UNORM2_FCD,
    UNORM2_COMPOSE_CONTIGUOUS
} UNormalization2Mode;

typedef enum UNormalizationCheckResult
{
    UNORM_NO,
    UNORM_YES,
    UNORM_MAYBE
} UNormalizationCheckResult;

typedef enum
{
    ULOC_LAYOUT_LTR = 0,
    ULOC_LAYOUT_RTL = 1,
    ULOC_LAYOUT_TTB = 2,
    ULOC_LAYOUT_BTT = 3,
    ULOC_LAYOUT_UNKNOWN
} ULayoutType;

typedef enum
{
    ULOC_ACCEPT_FAILED = 0,
    ULOC_ACCEPT_VALID = 1,
    ULOC_ACCEPT_FALLBACK = 2
} UAcceptResult;

struct UConverter;
typedef struct UConverter UConverter;

typedef struct
{
    uint16_t size;
    UBool flush;
    UConverter *converter;
    const UChar *source;
    const UChar *sourceLimit;
    char *target;
    const char *targetLimit;
    int32_t *offsets;
} UConverterFromUnicodeArgs;

typedef struct
{
    uint16_t size;
    UBool flush;
    UConverter *converter;
    const char *source;
    const char *sourceLimit;
    UChar *target;
    const UChar *targetLimit;
    int32_t *offsets;
} UConverterToUnicodeArgs;

typedef struct UTransPosition
{
    int32_t contextStart;
    int32_t contextLimit;
    int32_t start;
    int32_t limit;
} UTransPosition;

typedef void *UReplaceable;

typedef struct UReplaceableCallbacks
{
    int32_t (*length)(const UReplaceable *rep);
    UChar (*charAt)(const UReplaceable *rep, int32_t offset);
    UChar32 (*char32At)(const UReplaceable *rep, int32_t offset);
    void (*replace)(UReplaceable *rep, int32_t start, int32_t limit, const UChar *text,
                    int32_t textLength);
    void (*extract)(UReplaceable *rep, int32_t start, int32_t limit, UChar *dst);
    void (*copy)(UReplaceable *rep, int32_t start, int32_t limit, int32_t dest);
} UReplaceableCallbacks;

typedef struct UParseError
{
    int32_t line;
    int32_t offset;
    UChar preContext[U_PARSE_CONTEXT_LEN];
    UChar postContext[U_PARSE_CONTEXT_LEN];
} UParseError;

typedef enum UDisplayContextType {
    UDISPCTX_TYPE_DIALECT_HANDLING = 0,
    UDISPCTX_TYPE_CAPITALIZATION = 1,
    UDISPCTX_TYPE_DISPLAY_LENGTH = 2,
    UDISPCTX_TYPE_SUBSTITUTE_HANDLING = 3
} UDisplayContextType;

typedef enum UDisplayContext
{
    UDISPCTX_STANDARD_NAMES = (UDISPCTX_TYPE_DIALECT_HANDLING << 8) + 0,
    UDISPCTX_DIALECT_NAMES = (UDISPCTX_TYPE_DIALECT_HANDLING << 8) + 1,
    UDISPCTX_CAPITALIZATION_NONE = (UDISPCTX_TYPE_CAPITALIZATION << 8) + 0,
    UDISPCTX_CAPITALIZATION_FOR_MIDDLE_OF_SENTENCE = (UDISPCTX_TYPE_CAPITALIZATION << 8) + 1,
    UDISPCTX_CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE = (UDISPCTX_TYPE_CAPITALIZATION << 8) + 2,
    UDISPCTX_CAPITALIZATION_FOR_UI_LIST_OR_MENU = (UDISPCTX_TYPE_CAPITALIZATION << 8) + 3,
    UDISPCTX_CAPITALIZATION_FOR_STANDALONE = (UDISPCTX_TYPE_CAPITALIZATION << 8) + 4,
    UDISPCTX_LENGTH_FULL = (UDISPCTX_TYPE_DISPLAY_LENGTH << 8) + 0,
    UDISPCTX_LENGTH_SHORT = (UDISPCTX_TYPE_DISPLAY_LENGTH << 8) + 1,
    UDISPCTX_SUBSTITUTE = (UDISPCTX_TYPE_SUBSTITUTE_HANDLING << 8) + 0,
    UDISPCTX_NO_SUBSTITUTE = (UDISPCTX_TYPE_SUBSTITUTE_HANDLING << 8) + 1
} UDisplayContext;

typedef enum UDateRelativeDateTimeFormatterStyle
{
    UDAT_STYLE_LONG,
    UDAT_STYLE_SHORT,
    UDAT_STYLE_NARROW,
} UDateRelativeDateTimeFormatterStyle;

typedef enum UPluralType
{
    UPLURAL_TYPE_CARDINAL,
    UPLURAL_TYPE_ORDINAL,
} UPluralType;

typedef enum UNumberFormatTextAttribute
{
    UNUM_POSITIVE_PREFIX,
    UNUM_POSITIVE_SUFFIX,
    UNUM_NEGATIVE_PREFIX,
    UNUM_NEGATIVE_SUFFIX,
    UNUM_PADDING_CHARACTER,
    UNUM_CURRENCY_CODE,
    UNUM_DEFAULT_RULESET,
    UNUM_PUBLIC_RULESETS
} UNumberFormatTextAttribute;

typedef enum UNumberFormatSymbol
{
    UNUM_DECIMAL_SEPARATOR_SYMBOL = 0,
    UNUM_GROUPING_SEPARATOR_SYMBOL = 1,
    UNUM_PATTERN_SEPARATOR_SYMBOL = 2,
    UNUM_PERCENT_SYMBOL = 3,
    UNUM_ZERO_DIGIT_SYMBOL = 4,
    UNUM_DIGIT_SYMBOL = 5,
    UNUM_MINUS_SIGN_SYMBOL = 6,
    UNUM_PLUS_SIGN_SYMBOL = 7,
    UNUM_CURRENCY_SYMBOL = 8,
    UNUM_INTL_CURRENCY_SYMBOL = 9,
    UNUM_MONETARY_SEPARATOR_SYMBOL = 10,
    UNUM_EXPONENTIAL_SYMBOL = 11,
    UNUM_PERMILL_SYMBOL = 12,
    UNUM_PAD_ESCAPE_SYMBOL = 13,
    UNUM_INFINITY_SYMBOL = 14,
    UNUM_NAN_SYMBOL = 15,
    UNUM_SIGNIFICANT_DIGIT_SYMBOL = 16,
    UNUM_MONETARY_GROUPING_SEPARATOR_SYMBOL = 17,
    UNUM_ONE_DIGIT_SYMBOL = 18,
    UNUM_TWO_DIGIT_SYMBOL = 19,
    UNUM_THREE_DIGIT_SYMBOL = 20,
    UNUM_FOUR_DIGIT_SYMBOL = 21,
    UNUM_FIVE_DIGIT_SYMBOL = 22,
    UNUM_SIX_DIGIT_SYMBOL = 23,
    UNUM_SEVEN_DIGIT_SYMBOL = 24,
    UNUM_EIGHT_DIGIT_SYMBOL = 25,
    UNUM_NINE_DIGIT_SYMBOL = 26,
    UNUM_EXPONENT_MULTIPLICATION_SYMBOL = 27,
} UNumberFormatSymbol;

typedef enum UNumberFormatAttributeValue
{
    UNUM_FORMAT_ATTRIBUTE_VALUE_HIDDEN
} UNumberFormatAttributeValue;

typedef enum UNumberFormatAttribute
{
    UNUM_PARSE_INT_ONLY,
    UNUM_GROUPING_USED,
    UNUM_DECIMAL_ALWAYS_SHOWN,
    UNUM_MAX_INTEGER_DIGITS,
    UNUM_MIN_INTEGER_DIGITS,
    UNUM_INTEGER_DIGITS,
    UNUM_MAX_FRACTION_DIGITS,
    UNUM_MIN_FRACTION_DIGITS,
    UNUM_FRACTION_DIGITS,
    UNUM_MULTIPLIER,
    UNUM_GROUPING_SIZE,
    UNUM_ROUNDING_MODE,
    UNUM_ROUNDING_INCREMENT,
    UNUM_FORMAT_WIDTH,
    UNUM_PADDING_POSITION,
    UNUM_SECONDARY_GROUPING_SIZE,
    UNUM_SIGNIFICANT_DIGITS_USED,
    UNUM_MIN_SIGNIFICANT_DIGITS,
    UNUM_MAX_SIGNIFICANT_DIGITS,
    UNUM_LENIENT_PARSE,
    UNUM_PARSE_ALL_INPUT = 20,
    UNUM_SCALE = 21,
    UNUM_MINIMUM_GROUPING_DIGITS = 22,
    UNUM_CURRENCY_USAGE = 23,
    UNUM_FORMAT_FAIL_IF_MORE_THAN_MAX_DIGITS = 0x1000,
    UNUM_PARSE_NO_EXPONENT = 0x1001,
    UNUM_PARSE_DECIMAL_MARK_REQUIRED = 0x1002,
    UNUM_PARSE_CASE_SENSITIVE = 0x1003,
    UNUM_SIGN_ALWAYS_SHOWN = 0x1004,
} UNumberFormatAttribute;

typedef enum UStringPrepProfileType
{
    USPREP_RFC3491_NAMEPREP,
    USPREP_RFC3530_NFS4_CS_PREP,
    USPREP_RFC3530_NFS4_CS_PREP_CI,
    USPREP_RFC3530_NFS4_CIS_PREP,
    USPREP_RFC3530_NFS4_MIXED_PREP_PREFIX,
    USPREP_RFC3530_NFS4_MIXED_PREP_SUFFIX,
    USPREP_RFC3722_ISCSI,
    USPREP_RFC3920_NODEPREP,
    USPREP_RFC3920_RESOURCEPREP,
    USPREP_RFC4011_MIB,
    USPREP_RFC4013_SASLPREP,
    USPREP_RFC4505_TRACE,
    USPREP_RFC4518_LDAP,
    USPREP_RFC4518_LDAP_CI
} UStringPrepProfileType;

typedef enum USetSpanCondition
{
    USET_SPAN_NOT_CONTAINED = 0,
    USET_SPAN_CONTAINED = 1,
    USET_SPAN_SIMPLE = 2,
} USetSpanCondition;

typedef enum UNumberFormatStyle
{
    UNUM_PATTERN_DECIMAL = 0,
    UNUM_DECIMAL = 1,
    UNUM_CURRENCY = 2,
    UNUM_PERCENT = 3,
    UNUM_SCIENTIFIC = 4,
    UNUM_SPELLOUT = 5,
    UNUM_ORDINAL = 6,
    UNUM_DURATION = 7,
    UNUM_NUMBERING_SYSTEM = 8,
    UNUM_PATTERN_RULEBASED = 9,
    UNUM_CURRENCY_ISO = 10,
    UNUM_CURRENCY_PLURAL = 11,
    UNUM_CURRENCY_ACCOUNTING = 12,
    UNUM_CASH_CURRENCY = 13,
    UNUM_DECIMAL_COMPACT_SHORT = 14,
    UNUM_DECIMAL_COMPACT_LONG = 15,
    UNUM_CURRENCY_STANDARD = 16,
    UNUM_DEFAULT = UNUM_DECIMAL,
    UNUM_IGNORE = UNUM_PATTERN_DECIMAL
} UNumberFormatStyle;

typedef enum
{
    ULOC_ACTUAL_LOCALE = 0,
    ULOC_VALID_LOCALE = 1,
} ULocDataLocaleType;

typedef enum UProperty
{
    UCHAR_ALPHABETIC = 0,
    UCHAR_BINARY_START = UCHAR_ALPHABETIC,
    UCHAR_ASCII_HEX_DIGIT = 1,
    UCHAR_BIDI_CONTROL = 2,
    UCHAR_BIDI_MIRRORED = 3,
    UCHAR_DASH = 4,
    UCHAR_DEFAULT_IGNORABLE_CODE_POINT = 5,
    UCHAR_DEPRECATED = 6,
    UCHAR_DIACRITIC = 7,
    UCHAR_EXTENDER = 8,
    UCHAR_FULL_COMPOSITION_EXCLUSION = 9,
    UCHAR_GRAPHEME_BASE = 10,
    UCHAR_GRAPHEME_EXTEND = 11,
    UCHAR_GRAPHEME_LINK = 12,
    UCHAR_HEX_DIGIT = 13,
    UCHAR_HYPHEN = 14,
    UCHAR_ID_CONTINUE = 15,
    UCHAR_ID_START = 16,
    UCHAR_IDEOGRAPHIC = 17,
    UCHAR_IDS_BINARY_OPERATOR = 18,
    UCHAR_IDS_TRINARY_OPERATOR = 19,
    UCHAR_JOIN_CONTROL = 20,
    UCHAR_LOGICAL_ORDER_EXCEPTION = 21,
    UCHAR_LOWERCASE = 22,
    UCHAR_MATH = 23,
    UCHAR_NONCHARACTER_CODE_POINT = 24,
    UCHAR_QUOTATION_MARK = 25,
    UCHAR_RADICAL = 26,
    UCHAR_SOFT_DOTTED = 27,
    UCHAR_TERMINAL_PUNCTUATION = 28,
    UCHAR_UNIFIED_IDEOGRAPH = 29,
    UCHAR_UPPERCASE = 30,
    UCHAR_WHITE_SPACE = 31,
    UCHAR_XID_CONTINUE = 32,
    UCHAR_XID_START = 33,
    UCHAR_CASE_SENSITIVE = 34,
    UCHAR_S_TERM = 35,
    UCHAR_VARIATION_SELECTOR = 36,
    UCHAR_NFD_INERT = 37,
    UCHAR_NFKD_INERT = 38,
    UCHAR_NFC_INERT = 39,
    UCHAR_NFKC_INERT = 40,
    UCHAR_SEGMENT_STARTER = 41,
    UCHAR_PATTERN_SYNTAX = 42,
    UCHAR_PATTERN_WHITE_SPACE = 43,
    UCHAR_POSIX_ALNUM = 44,
    UCHAR_POSIX_BLANK = 45,
    UCHAR_POSIX_GRAPH = 46,
    UCHAR_POSIX_PRINT = 47,
    UCHAR_POSIX_XDIGIT = 48,
    UCHAR_CASED = 49,
    UCHAR_CASE_IGNORABLE = 50,
    UCHAR_CHANGES_WHEN_LOWERCASED = 51,
    UCHAR_CHANGES_WHEN_UPPERCASED = 52,
    UCHAR_CHANGES_WHEN_TITLECASED = 53,
    UCHAR_CHANGES_WHEN_CASEFOLDED = 54,
    UCHAR_CHANGES_WHEN_CASEMAPPED = 55,
    UCHAR_CHANGES_WHEN_NFKC_CASEFOLDED = 56,
    UCHAR_EMOJI = 57,
    UCHAR_EMOJI_PRESENTATION = 58,
    UCHAR_EMOJI_MODIFIER = 59,
    UCHAR_EMOJI_MODIFIER_BASE = 60,
    UCHAR_EMOJI_COMPONENT = 61,
    UCHAR_REGIONAL_INDICATOR = 62,
    UCHAR_PREPENDED_CONCATENATION_MARK = 63,
    UCHAR_EXTENDED_PICTOGRAPHIC = 64,
    UCHAR_BIDI_CLASS = 0x1000,
    UCHAR_INT_START = UCHAR_BIDI_CLASS,
    UCHAR_BLOCK = 0x1001,
    UCHAR_CANONICAL_COMBINING_CLASS = 0x1002,
    UCHAR_DECOMPOSITION_TYPE = 0x1003,
    UCHAR_EAST_ASIAN_WIDTH = 0x1004,
    UCHAR_GENERAL_CATEGORY = 0x1005,
    UCHAR_JOINING_GROUP = 0x1006,
    UCHAR_JOINING_TYPE = 0x1007,
    UCHAR_LINE_BREAK = 0x1008,
    UCHAR_NUMERIC_TYPE = 0x1009,
    UCHAR_SCRIPT = 0x100A,
    UCHAR_HANGUL_SYLLABLE_TYPE = 0x100B,
    UCHAR_NFD_QUICK_CHECK = 0x100C,
    UCHAR_NFKD_QUICK_CHECK = 0x100D,
    UCHAR_NFC_QUICK_CHECK = 0x100E,
    UCHAR_NFKC_QUICK_CHECK = 0x100F,
    UCHAR_LEAD_CANONICAL_COMBINING_CLASS = 0x1010,
    UCHAR_TRAIL_CANONICAL_COMBINING_CLASS = 0x1011,
    UCHAR_GRAPHEME_CLUSTER_BREAK = 0x1012,
    UCHAR_SENTENCE_BREAK = 0x1013,
    UCHAR_WORD_BREAK = 0x1014,
    UCHAR_BIDI_PAIRED_BRACKET_TYPE = 0x1015,
    UCHAR_INDIC_POSITIONAL_CATEGORY = 0x1016,
    UCHAR_INDIC_SYLLABIC_CATEGORY = 0x1017,
    UCHAR_VERTICAL_ORIENTATION = 0x1018,
    UCHAR_GENERAL_CATEGORY_MASK = 0x2000,
    UCHAR_MASK_START = UCHAR_GENERAL_CATEGORY_MASK,
    UCHAR_NUMERIC_VALUE = 0x3000,
    UCHAR_DOUBLE_START = UCHAR_NUMERIC_VALUE,
    UCHAR_AGE = 0x4000,
    UCHAR_STRING_START = UCHAR_AGE,
    UCHAR_BIDI_MIRRORING_GLYPH = 0x4001,
    UCHAR_CASE_FOLDING = 0x4002,
    UCHAR_LOWERCASE_MAPPING = 0x4004,
    UCHAR_NAME = 0x4005,
    UCHAR_SIMPLE_CASE_FOLDING = 0x4006,
    UCHAR_SIMPLE_LOWERCASE_MAPPING = 0x4007,
    UCHAR_SIMPLE_TITLECASE_MAPPING = 0x4008,
    UCHAR_SIMPLE_UPPERCASE_MAPPING = 0x4009,
    UCHAR_TITLECASE_MAPPING = 0x400A,
    UCHAR_UPPERCASE_MAPPING = 0x400C,
    UCHAR_BIDI_PAIRED_BRACKET = 0x400D,
    UCHAR_SCRIPT_EXTENSIONS = 0x7000,
    UCHAR_OTHER_PROPERTY_START = UCHAR_SCRIPT_EXTENSIONS,
    UCHAR_INVALID_CODE = -1
} UProperty;

typedef enum UScriptCode
{
    USCRIPT_INVALID_CODE = -1,
    USCRIPT_COMMON = 0,
    USCRIPT_INHERITED = 1,
    USCRIPT_ARABIC = 2,
    USCRIPT_ARMENIAN = 3,
    USCRIPT_BENGALI = 4,
    USCRIPT_BOPOMOFO = 5,
    USCRIPT_CHEROKEE = 6,
    USCRIPT_COPTIC = 7,
    USCRIPT_CYRILLIC = 8,
    USCRIPT_DESERET = 9,
    USCRIPT_DEVANAGARI = 10,
    USCRIPT_ETHIOPIC = 11,
    USCRIPT_GEORGIAN = 12,
    USCRIPT_GOTHIC = 13,
    USCRIPT_GREEK = 14,
    USCRIPT_GUJARATI = 15,
    USCRIPT_GURMUKHI = 16,
    USCRIPT_HAN = 17,
    USCRIPT_HANGUL = 18,
    USCRIPT_HEBREW = 19,
    USCRIPT_HIRAGANA = 20,
    USCRIPT_KANNADA = 21,
    USCRIPT_KATAKANA = 22,
    USCRIPT_KHMER = 23,
    USCRIPT_LAO = 24,
    USCRIPT_LATIN = 25,
    USCRIPT_MALAYALAM = 26,
    USCRIPT_MONGOLIAN = 27,
    USCRIPT_MYANMAR = 28,
    USCRIPT_OGHAM = 29,
    USCRIPT_OLD_ITALIC = 30,
    USCRIPT_ORIYA = 31,
    USCRIPT_RUNIC = 32,
    USCRIPT_SINHALA = 33,
    USCRIPT_SYRIAC = 34,
    USCRIPT_TAMIL = 35,
    USCRIPT_TELUGU = 36,
    USCRIPT_THAANA = 37,
    USCRIPT_THAI = 38,
    USCRIPT_TIBETAN = 39,
    USCRIPT_CANADIAN_ABORIGINAL = 40,
    USCRIPT_UCAS = USCRIPT_CANADIAN_ABORIGINAL,
    USCRIPT_YI = 41,
    USCRIPT_TAGALOG = 42,
    USCRIPT_HANUNOO = 43,
    USCRIPT_BUHID = 44,
    USCRIPT_TAGBANWA = 45,
    USCRIPT_BRAILLE = 46,
    USCRIPT_CYPRIOT = 47,
    USCRIPT_LIMBU = 48,
    USCRIPT_LINEAR_B = 49,
    USCRIPT_OSMANYA = 50,
    USCRIPT_SHAVIAN = 51,
    USCRIPT_TAI_LE = 52,
    USCRIPT_UGARITIC = 53,
    USCRIPT_KATAKANA_OR_HIRAGANA = 54,
    USCRIPT_BUGINESE = 55,
    USCRIPT_GLAGOLITIC = 56,
    USCRIPT_KHAROSHTHI = 57,
    USCRIPT_SYLOTI_NAGRI = 58,
    USCRIPT_NEW_TAI_LUE = 59,
    USCRIPT_TIFINAGH = 60,
    USCRIPT_OLD_PERSIAN = 61,
    USCRIPT_BALINESE = 62,
    USCRIPT_BATAK = 63,
    USCRIPT_BLISSYMBOLS = 64,
    USCRIPT_BRAHMI = 65,
    USCRIPT_CHAM = 66,
    USCRIPT_CIRTH = 67,
    USCRIPT_OLD_CHURCH_SLAVONIC_CYRILLIC = 68,
    USCRIPT_DEMOTIC_EGYPTIAN = 69,
    USCRIPT_HIERATIC_EGYPTIAN = 70,
    USCRIPT_EGYPTIAN_HIEROGLYPHS = 71,
    USCRIPT_KHUTSURI = 72,
    USCRIPT_SIMPLIFIED_HAN = 73,
    USCRIPT_TRADITIONAL_HAN = 74,
    USCRIPT_PAHAWH_HMONG = 75,
    USCRIPT_OLD_HUNGARIAN = 76,
    USCRIPT_HARAPPAN_INDUS = 77,
    USCRIPT_JAVANESE = 78,
    USCRIPT_KAYAH_LI = 79,
    USCRIPT_LATIN_FRAKTUR = 80,
    USCRIPT_LATIN_GAELIC = 81,
    USCRIPT_LEPCHA = 82,
    USCRIPT_LINEAR_A = 83,
    USCRIPT_MANDAIC = 84,
    USCRIPT_MANDAEAN = USCRIPT_MANDAIC,
    USCRIPT_MAYAN_HIEROGLYPHS = 85,
    USCRIPT_MEROITIC_HIEROGLYPHS = 86,
    USCRIPT_MEROITIC = USCRIPT_MEROITIC_HIEROGLYPHS,
    USCRIPT_NKO = 87,
    USCRIPT_ORKHON = 88,
    USCRIPT_OLD_PERMIC = 89,
    USCRIPT_PHAGS_PA = 90,
    USCRIPT_PHOENICIAN = 91,
    USCRIPT_MIAO = 92,
    USCRIPT_PHONETIC_POLLARD = USCRIPT_MIAO,
    USCRIPT_RONGORONGO = 93,
    USCRIPT_SARATI = 94,
    USCRIPT_ESTRANGELO_SYRIAC = 95,
    USCRIPT_WESTERN_SYRIAC = 96,
    USCRIPT_EASTERN_SYRIAC = 97,
    USCRIPT_TENGWAR = 98,
    USCRIPT_VAI = 99,
    USCRIPT_VISIBLE_SPEECH = 100,
    USCRIPT_CUNEIFORM = 101,
    USCRIPT_UNWRITTEN_LANGUAGES = 102,
    USCRIPT_UNKNOWN = 103,
    USCRIPT_CARIAN = 104,
    USCRIPT_JAPANESE = 105,
    USCRIPT_LANNA = 106,
    USCRIPT_LYCIAN = 107,
    USCRIPT_LYDIAN = 108,
    USCRIPT_OL_CHIKI = 109,
    USCRIPT_REJANG = 110,
    USCRIPT_SAURASHTRA = 111,
    USCRIPT_SIGN_WRITING = 112,
    USCRIPT_SUNDANESE = 113,
    USCRIPT_MOON = 114,
    USCRIPT_MEITEI_MAYEK = 115,
    USCRIPT_IMPERIAL_ARAMAIC = 116,
    USCRIPT_AVESTAN = 117,
    USCRIPT_CHAKMA = 118,
    USCRIPT_KOREAN = 119,
    USCRIPT_KAITHI = 120,
    USCRIPT_MANICHAEAN = 121,
    USCRIPT_INSCRIPTIONAL_PAHLAVI = 122,
    USCRIPT_PSALTER_PAHLAVI = 123,
    USCRIPT_BOOK_PAHLAVI = 124,
    USCRIPT_INSCRIPTIONAL_PARTHIAN = 125,
    USCRIPT_SAMARITAN = 126,
    USCRIPT_TAI_VIET = 127,
    USCRIPT_MATHEMATICAL_NOTATION = 128,
    USCRIPT_SYMBOLS = 129,
    USCRIPT_BAMUM = 130,
    USCRIPT_LISU = 131,
    USCRIPT_NAKHI_GEBA = 132,
    USCRIPT_OLD_SOUTH_ARABIAN = 133,
    USCRIPT_BASSA_VAH = 134,
    USCRIPT_DUPLOYAN = 135,
    USCRIPT_ELBASAN = 136,
    USCRIPT_GRANTHA = 137,
    USCRIPT_KPELLE = 138,
    USCRIPT_LOMA = 139,
    USCRIPT_MENDE = 140,
    USCRIPT_MEROITIC_CURSIVE = 141,
    USCRIPT_OLD_NORTH_ARABIAN = 142,
    USCRIPT_NABATAEAN = 143,
    USCRIPT_PALMYRENE = 144,
    USCRIPT_KHUDAWADI = 145,
    USCRIPT_SINDHI = USCRIPT_KHUDAWADI,
    USCRIPT_WARANG_CITI = 146,
    USCRIPT_AFAKA = 147,
    USCRIPT_JURCHEN = 148,
    USCRIPT_MRO = 149,
    USCRIPT_NUSHU = 150,
    USCRIPT_SHARADA = 151,
    USCRIPT_SORA_SOMPENG = 152,
    USCRIPT_TAKRI = 153,
    USCRIPT_TANGUT = 154,
    USCRIPT_WOLEAI = 155,
    USCRIPT_ANATOLIAN_HIEROGLYPHS = 156,
    USCRIPT_KHOJKI = 157,
    USCRIPT_TIRHUTA = 158,
    USCRIPT_CAUCASIAN_ALBANIAN = 159,
    USCRIPT_MAHAJANI = 160,
    USCRIPT_AHOM = 161,
    USCRIPT_HATRAN = 162,
    USCRIPT_MODI = 163,
    USCRIPT_MULTANI = 164,
    USCRIPT_PAU_CIN_HAU = 165,
    USCRIPT_SIDDHAM = 166,
    USCRIPT_ADLAM = 167,
    USCRIPT_BHAIKSUKI = 168,
    USCRIPT_MARCHEN = 169,
    USCRIPT_NEWA = 170,
    USCRIPT_OSAGE = 171,
    USCRIPT_HAN_WITH_BOPOMOFO = 172,
    USCRIPT_JAMO = 173,
    USCRIPT_SYMBOLS_EMOJI = 174,
    USCRIPT_MASARAM_GONDI = 175,
    USCRIPT_SOYOMBO = 176,
    USCRIPT_ZANABAZAR_SQUARE = 177,
    USCRIPT_DOGRA = 178,
    USCRIPT_GUNJALA_GONDI = 179,
    USCRIPT_MAKASAR = 180,
    USCRIPT_MEDEFAIDRIN = 181,
    USCRIPT_HANIFI_ROHINGYA = 182,
    USCRIPT_SOGDIAN = 183,
    USCRIPT_OLD_SOGDIAN = 184,
    USCRIPT_ELYMAIC = 185,
    USCRIPT_NYIAKENG_PUACHUE_HMONG = 186,
    USCRIPT_NANDINAGARI = 187,
    USCRIPT_WANCHO = 188,
    USCRIPT_CHORASMIAN = 189,
    USCRIPT_DIVES_AKURU = 190,
    USCRIPT_KHITAN_SMALL_SCRIPT = 191,
    USCRIPT_YEZIDI = 192,
} UScriptCode;

typedef enum UMeasurementSystem
{
    UMS_SI,
    UMS_US,
    UMS_UK,
} UMeasurementSystem;

typedef enum ULocaleDataExemplarSetType
{
    ULOCDATA_ES_STANDARD = 0,
    ULOCDATA_ES_AUXILIARY = 1,
    ULOCDATA_ES_INDEX = 2,
    ULOCDATA_ES_PUNCTUATION = 3,
} ULocaleDataExemplarSetType;

typedef enum ULocaleDataDelimiterType
{
    ULOCDATA_QUOTATION_START = 0,
    ULOCDATA_QUOTATION_END = 1,
    ULOCDATA_ALT_QUOTATION_START = 2,
    ULOCDATA_ALT_QUOTATION_END = 3,
} ULocaleDataDelimiterType;

typedef enum UGender
{
    UGENDER_MALE,
    UGENDER_FEMALE,
    UGENDER_OTHER
} UGender;

typedef enum UFormattableType
{
    UFMT_DATE = 0,
    UFMT_DOUBLE,
    UFMT_LONG,
    UFMT_STRING,
    UFMT_ARRAY,
    UFMT_INT64,
    UFMT_OBJECT,
} UFormattableType;

typedef enum UScriptUsage
{
    USCRIPT_USAGE_NOT_ENCODED,
    USCRIPT_USAGE_UNKNOWN,
    USCRIPT_USAGE_EXCLUDED,
    USCRIPT_USAGE_LIMITED_USE,
    USCRIPT_USAGE_ASPIRATIONAL,
    USCRIPT_USAGE_RECOMMENDED
} UScriptUsage;

typedef enum
{
    URES_NONE = -1,
    URES_STRING = 0,
    URES_BINARY = 1,
    URES_TABLE = 2,
    URES_ALIAS = 3,
    URES_INT = 7,
    URES_ARRAY = 8,
    URES_INT_VECTOR = 14,
} UResType;

typedef enum
{
    ULDN_STANDARD_NAMES = 0,
    ULDN_DIALECT_NAMES
} UDialectHandling;

typedef enum UCurrencyUsage
{
    UCURR_USAGE_STANDARD = 0,
    UCURR_USAGE_CASH = 1,
} UCurrencyUsage;

typedef enum UCurrNameStyle
{
    UCURR_SYMBOL_NAME,
    UCURR_LONG_NAME,
    UCURR_NARROW_SYMBOL_NAME
} UCurrNameStyle;

typedef enum UConverterUnicodeSet {
    UCNV_ROUNDTRIP_SET,
    UCNV_ROUNDTRIP_AND_FALLBACK_SET,
} UConverterUnicodeSet;

typedef enum UDateTimePatternField
{
    UDATPG_ERA_FIELD,
    UDATPG_YEAR_FIELD,
    UDATPG_QUARTER_FIELD,
    UDATPG_MONTH_FIELD,
    UDATPG_WEEK_OF_YEAR_FIELD,
    UDATPG_WEEK_OF_MONTH_FIELD,
    UDATPG_WEEKDAY_FIELD,
    UDATPG_DAY_OF_YEAR_FIELD,
    UDATPG_DAY_OF_WEEK_IN_MONTH_FIELD,
    UDATPG_DAY_FIELD,
    UDATPG_DAYPERIOD_FIELD,
    UDATPG_HOUR_FIELD,
    UDATPG_MINUTE_FIELD,
    UDATPG_SECOND_FIELD,
    UDATPG_FRACTIONAL_SECOND_FIELD,
    UDATPG_ZONE_FIELD,
    UDATPG_FIELD_COUNT
} UDateTimePatternField;

typedef enum UDateTimePatternMatchOptions
{
    UDATPG_MATCH_NO_OPTIONS = 0,
    UDATPG_MATCH_HOUR_FIELD_LENGTH = 1 << UDATPG_HOUR_FIELD,
    UDATPG_MATCH_ALL_FIELDS_LENGTH = (1 << UDATPG_FIELD_COUNT) - 1
} UDateTimePatternMatchOptions;

typedef enum
{
    UCNV_UNSUPPORTED_CONVERTER = -1,
    UCNV_SBCS = 0,
    UCNV_DBCS = 1,
    UCNV_MBCS = 2,
    UCNV_LATIN_1 = 3,
    UCNV_UTF8 = 4,
    UCNV_UTF16_BigEndian = 5,
    UCNV_UTF16_LittleEndian = 6,
    UCNV_UTF32_BigEndian = 7,
    UCNV_UTF32_LittleEndian = 8,
    UCNV_EBCDIC_STATEFUL = 9,
    UCNV_ISO_2022 = 10,
    UCNV_LMBCS_1 = 11,
    UCNV_LMBCS_2,
    UCNV_LMBCS_3,
    UCNV_LMBCS_4,
    UCNV_LMBCS_5,
    UCNV_LMBCS_6,
    UCNV_LMBCS_8,
    UCNV_LMBCS_11,
    UCNV_LMBCS_16,
    UCNV_LMBCS_17,
    UCNV_LMBCS_18,
    UCNV_LMBCS_19,
    UCNV_LMBCS_LAST = UCNV_LMBCS_19,
    UCNV_HZ,
    UCNV_SCSU,
    UCNV_ISCII,
    UCNV_US_ASCII,
    UCNV_UTF7,
    UCNV_BOCU1,
    UCNV_UTF16,
    UCNV_UTF32,
    UCNV_CESU8,
    UCNV_IMAP_MAILBOX,
    UCNV_COMPOUND_TEXT,
    UCNV_NUMBER_OF_SUPPORTED_CONVERTER_TYPES
} UConverterType;

typedef enum
{
    UCNV_UNASSIGNED = 0,
    UCNV_ILLEGAL = 1,
    UCNV_IRREGULAR = 2,
    UCNV_RESET = 3,
    UCNV_CLOSE = 4,
    UCNV_CLONE = 5
} UConverterCallbackReason;

typedef enum UDateTimePGDisplayWidth
{
    UDATPG_WIDE,
    UDATPG_ABBREVIATED,
    UDATPG_NARROW
} UDateTimePGDisplayWidth;

typedef enum UDateTimePatternConflict
{
    UDATPG_NO_CONFLICT,
    UDATPG_BASE_CONFLICT,
    UDATPG_CONFLICT,
} UDateTimePatternConflict;

typedef enum UCalendarDateFields
{
    UCAL_ERA,
    UCAL_YEAR,
    UCAL_MONTH,
    UCAL_WEEK_OF_YEAR,
    UCAL_WEEK_OF_MONTH,
    UCAL_DATE,
    UCAL_DAY_OF_YEAR,
    UCAL_DAY_OF_WEEK,
    UCAL_DAY_OF_WEEK_IN_MONTH,
    UCAL_AM_PM,
    UCAL_HOUR,
    UCAL_HOUR_OF_DAY,
    UCAL_MINUTE,
    UCAL_SECOND,
    UCAL_MILLISECOND,
    UCAL_ZONE_OFFSET,
    UCAL_DST_OFFSET,
    UCAL_YEAR_WOY,
    UCAL_DOW_LOCAL,
    UCAL_EXTENDED_YEAR,
    UCAL_JULIAN_DAY,
    UCAL_MILLISECONDS_IN_DAY,
    UCAL_IS_LEAP_MONTH,
    UCAL_FIELD_COUNT,
    UCAL_DAY_OF_MONTH = UCAL_DATE
} UCalendarDateFields;

typedef enum UDateFormatField
{
    UDAT_ERA_FIELD = 0,
    UDAT_YEAR_FIELD = 1,
    UDAT_MONTH_FIELD = 2,
    UDAT_DATE_FIELD = 3,
    UDAT_HOUR_OF_DAY1_FIELD = 4,
    UDAT_HOUR_OF_DAY0_FIELD = 5,
    UDAT_MINUTE_FIELD = 6,
    UDAT_SECOND_FIELD = 7,
    UDAT_FRACTIONAL_SECOND_FIELD = 8,
    UDAT_DAY_OF_WEEK_FIELD = 9,
    UDAT_DAY_OF_YEAR_FIELD = 10,
    UDAT_DAY_OF_WEEK_IN_MONTH_FIELD = 11,
    UDAT_WEEK_OF_YEAR_FIELD = 12,
    UDAT_WEEK_OF_MONTH_FIELD = 13,
    UDAT_AM_PM_FIELD = 14,
    UDAT_HOUR1_FIELD = 15,
    UDAT_HOUR0_FIELD = 16,
    UDAT_TIMEZONE_FIELD = 17,
    UDAT_YEAR_WOY_FIELD = 18,
    UDAT_DOW_LOCAL_FIELD = 19,
    UDAT_EXTENDED_YEAR_FIELD = 20,
    UDAT_JULIAN_DAY_FIELD = 21,
    UDAT_MILLISECONDS_IN_DAY_FIELD = 22,
    UDAT_TIMEZONE_RFC_FIELD = 23,
    UDAT_TIMEZONE_GENERIC_FIELD = 24,
    UDAT_STANDALONE_DAY_FIELD = 25,
    UDAT_STANDALONE_MONTH_FIELD = 26,
    UDAT_QUARTER_FIELD = 27,
    UDAT_STANDALONE_QUARTER_FIELD = 28,
    UDAT_TIMEZONE_SPECIAL_FIELD = 29,
    UDAT_YEAR_NAME_FIELD = 30,
    UDAT_TIMEZONE_LOCALIZED_GMT_OFFSET_FIELD = 31,
    UDAT_TIMEZONE_ISO_FIELD = 32,
    UDAT_TIMEZONE_ISO_LOCAL_FIELD = 33,
    UDAT_AM_PM_MIDNIGHT_NOON_FIELD = 35,
    UDAT_FLEXIBLE_DAY_PERIOD_FIELD = 36,
} UDateFormatField;

typedef enum UDateFormatSymbolType
{
    UDAT_ERAS,
    UDAT_MONTHS,
    UDAT_SHORT_MONTHS,
    UDAT_WEEKDAYS,
    UDAT_SHORT_WEEKDAYS,
    UDAT_AM_PMS,
    UDAT_LOCALIZED_CHARS,
    UDAT_ERA_NAMES,
    UDAT_NARROW_MONTHS,
    UDAT_NARROW_WEEKDAYS,
    UDAT_STANDALONE_MONTHS,
    UDAT_STANDALONE_SHORT_MONTHS,
    UDAT_STANDALONE_NARROW_MONTHS,
    UDAT_STANDALONE_WEEKDAYS,
    UDAT_STANDALONE_SHORT_WEEKDAYS,
    UDAT_STANDALONE_NARROW_WEEKDAYS,
    UDAT_QUARTERS,
    UDAT_SHORT_QUARTERS,
    UDAT_STANDALONE_QUARTERS,
    UDAT_STANDALONE_SHORT_QUARTERS,
    UDAT_SHORTER_WEEKDAYS,
    UDAT_STANDALONE_SHORTER_WEEKDAYS,
    UDAT_CYCLIC_YEARS_WIDE,
    UDAT_CYCLIC_YEARS_ABBREVIATED,
    UDAT_CYCLIC_YEARS_NARROW,
    UDAT_ZODIAC_NAMES_WIDE,
    UDAT_ZODIAC_NAMES_ABBREVIATED,
    UDAT_ZODIAC_NAMES_NARROW
} UDateFormatSymbolType;

typedef enum UDateFormatBooleanAttribute
{
    UDAT_PARSE_ALLOW_WHITESPACE = 0,
    UDAT_PARSE_ALLOW_NUMERIC = 1,
    UDAT_PARSE_PARTIAL_LITERAL_MATCH = 2,
    UDAT_PARSE_MULTIPLE_PATTERNS_FOR_MATCH = 3,
    UDAT_BOOLEAN_ATTRIBUTE_COUNT = 4
} UDateFormatBooleanAttribute;

typedef enum UDateFormatStyle
{
    UDAT_FULL,
    UDAT_LONG,
    UDAT_MEDIUM,
    UDAT_SHORT,
    UDAT_DEFAULT = UDAT_MEDIUM,
    UDAT_RELATIVE = (1 << 7),
    UDAT_FULL_RELATIVE = UDAT_FULL | UDAT_RELATIVE,
    UDAT_LONG_RELATIVE = UDAT_LONG | UDAT_RELATIVE,
    UDAT_MEDIUM_RELATIVE = UDAT_MEDIUM | UDAT_RELATIVE,
    UDAT_SHORT_RELATIVE = UDAT_SHORT | UDAT_RELATIVE,
    UDAT_NONE = -1,
    UDAT_PATTERN = -2,
} UDateFormatStyle;

typedef enum
{
    UCNV_UNKNOWN = -1,
    UCNV_IBM = 0
} UConverterPlatform;

typedef enum
{
    UCOL_EQUAL = 0,
    UCOL_GREATER = 1,
    UCOL_LESS = -1
} UCollationResult;

typedef enum UBreakIteratorType
{
    UBRK_CHARACTER = 0,
    UBRK_WORD = 1,
    UBRK_LINE = 2,
    UBRK_SENTENCE = 3,
} UBreakIteratorType;

typedef enum UBlockCode
{
    UBLOCK_NO_BLOCK = 0,
    UBLOCK_BASIC_LATIN = 1,
    UBLOCK_LATIN_1_SUPPLEMENT = 2,
    UBLOCK_LATIN_EXTENDED_A = 3,
    UBLOCK_LATIN_EXTENDED_B = 4,
    UBLOCK_IPA_EXTENSIONS = 5,
    UBLOCK_SPACING_MODIFIER_LETTERS = 6,
    UBLOCK_COMBINING_DIACRITICAL_MARKS = 7,
    UBLOCK_GREEK = 8,
    UBLOCK_CYRILLIC = 9,
    UBLOCK_ARMENIAN = 10,
    UBLOCK_HEBREW = 11,
    UBLOCK_ARABIC = 12,
    UBLOCK_SYRIAC = 13,
    UBLOCK_THAANA = 14,
    UBLOCK_DEVANAGARI = 15,
    UBLOCK_BENGALI = 16,
    UBLOCK_GURMUKHI = 17,
    UBLOCK_GUJARATI = 18,
    UBLOCK_ORIYA = 19,
    UBLOCK_TAMIL = 20,
    UBLOCK_TELUGU = 21,
    UBLOCK_KANNADA = 22,
    UBLOCK_MALAYALAM = 23,
    UBLOCK_SINHALA = 24,
    UBLOCK_THAI = 25,
    UBLOCK_LAO = 26,
    UBLOCK_TIBETAN = 27,
    UBLOCK_MYANMAR = 28,
    UBLOCK_GEORGIAN = 29,
    UBLOCK_HANGUL_JAMO = 30,
    UBLOCK_ETHIOPIC = 31,
    UBLOCK_CHEROKEE = 32,
    UBLOCK_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS = 33,
    UBLOCK_OGHAM = 34,
    UBLOCK_RUNIC = 35,
    UBLOCK_KHMER = 36,
    UBLOCK_MONGOLIAN = 37,
    UBLOCK_LATIN_EXTENDED_ADDITIONAL = 38,
    UBLOCK_GREEK_EXTENDED = 39,
    UBLOCK_GENERAL_PUNCTUATION = 40,
    UBLOCK_SUPERSCRIPTS_AND_SUBSCRIPTS = 41,
    UBLOCK_CURRENCY_SYMBOLS = 42,
    UBLOCK_COMBINING_MARKS_FOR_SYMBOLS = 43,
    UBLOCK_LETTERLIKE_SYMBOLS = 44,
    UBLOCK_NUMBER_FORMS = 45,
    UBLOCK_ARROWS = 46,
    UBLOCK_MATHEMATICAL_OPERATORS = 47,
    UBLOCK_MISCELLANEOUS_TECHNICAL = 48,
    UBLOCK_CONTROL_PICTURES = 49,
    UBLOCK_OPTICAL_CHARACTER_RECOGNITION = 50,
    UBLOCK_ENCLOSED_ALPHANUMERICS = 51,
    UBLOCK_BOX_DRAWING = 52,
    UBLOCK_BLOCK_ELEMENTS = 53,
    UBLOCK_GEOMETRIC_SHAPES = 54,
    UBLOCK_MISCELLANEOUS_SYMBOLS = 55,
    UBLOCK_DINGBATS = 56,
    UBLOCK_BRAILLE_PATTERNS = 57,
    UBLOCK_CJK_RADICALS_SUPPLEMENT = 58,
    UBLOCK_KANGXI_RADICALS = 59,
    UBLOCK_IDEOGRAPHIC_DESCRIPTION_CHARACTERS = 60,
    UBLOCK_CJK_SYMBOLS_AND_PUNCTUATION = 61,
    UBLOCK_HIRAGANA = 62,
    UBLOCK_KATAKANA = 63,
    UBLOCK_BOPOMOFO = 64,
    UBLOCK_HANGUL_COMPATIBILITY_JAMO = 65,
    UBLOCK_KANBUN = 66,
    UBLOCK_BOPOMOFO_EXTENDED = 67,
    UBLOCK_ENCLOSED_CJK_LETTERS_AND_MONTHS = 68,
    UBLOCK_CJK_COMPATIBILITY = 69,
    UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A = 70,
    UBLOCK_CJK_UNIFIED_IDEOGRAPHS = 71,
    UBLOCK_YI_SYLLABLES = 72,
    UBLOCK_YI_RADICALS = 73,
    UBLOCK_HANGUL_SYLLABLES = 74,
    UBLOCK_HIGH_SURROGATES = 75,
    UBLOCK_HIGH_PRIVATE_USE_SURROGATES = 76,
    UBLOCK_LOW_SURROGATES = 77,
    UBLOCK_PRIVATE_USE_AREA = 78,
    UBLOCK_PRIVATE_USE = UBLOCK_PRIVATE_USE_AREA,
    UBLOCK_CJK_COMPATIBILITY_IDEOGRAPHS = 79,
    UBLOCK_ALPHABETIC_PRESENTATION_FORMS = 80,
    UBLOCK_ARABIC_PRESENTATION_FORMS_A = 81,
    UBLOCK_COMBINING_HALF_MARKS = 82,
    UBLOCK_CJK_COMPATIBILITY_FORMS = 83,
    UBLOCK_SMALL_FORM_VARIANTS = 84,
    UBLOCK_ARABIC_PRESENTATION_FORMS_B = 85,
    UBLOCK_SPECIALS = 86,
    UBLOCK_HALFWIDTH_AND_FULLWIDTH_FORMS = 87,
    UBLOCK_OLD_ITALIC = 88,
    UBLOCK_GOTHIC = 89,
    UBLOCK_DESERET = 90,
    UBLOCK_BYZANTINE_MUSICAL_SYMBOLS = 91,
    UBLOCK_MUSICAL_SYMBOLS = 92,
    UBLOCK_MATHEMATICAL_ALPHANUMERIC_SYMBOLS = 93,
    UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B = 94,
    UBLOCK_CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT = 95,
    UBLOCK_TAGS = 96,
    UBLOCK_CYRILLIC_SUPPLEMENT = 97,
    UBLOCK_CYRILLIC_SUPPLEMENTARY = UBLOCK_CYRILLIC_SUPPLEMENT,
    UBLOCK_TAGALOG = 98,
    UBLOCK_HANUNOO = 99,
    UBLOCK_BUHID = 100,
    UBLOCK_TAGBANWA = 101,
    UBLOCK_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A = 102,
    UBLOCK_SUPPLEMENTAL_ARROWS_A = 103,
    UBLOCK_SUPPLEMENTAL_ARROWS_B = 104,
    UBLOCK_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B = 105,
    UBLOCK_SUPPLEMENTAL_MATHEMATICAL_OPERATORS = 106,
    UBLOCK_KATAKANA_PHONETIC_EXTENSIONS = 107,
    UBLOCK_VARIATION_SELECTORS = 108,
    UBLOCK_SUPPLEMENTARY_PRIVATE_USE_AREA_A = 109,
    UBLOCK_SUPPLEMENTARY_PRIVATE_USE_AREA_B = 110,
    UBLOCK_LIMBU = 111,
    UBLOCK_TAI_LE = 112,
    UBLOCK_KHMER_SYMBOLS = 113,
    UBLOCK_PHONETIC_EXTENSIONS = 114,
    UBLOCK_MISCELLANEOUS_SYMBOLS_AND_ARROWS = 115,
    UBLOCK_YIJING_HEXAGRAM_SYMBOLS = 116,
    UBLOCK_LINEAR_B_SYLLABARY = 117,
    UBLOCK_LINEAR_B_IDEOGRAMS = 118,
    UBLOCK_AEGEAN_NUMBERS = 119,
    UBLOCK_UGARITIC = 120,
    UBLOCK_SHAVIAN = 121,
    UBLOCK_OSMANYA = 122,
    UBLOCK_CYPRIOT_SYLLABARY = 123,
    UBLOCK_TAI_XUAN_JING_SYMBOLS = 124,
    UBLOCK_VARIATION_SELECTORS_SUPPLEMENT = 125,
    UBLOCK_ANCIENT_GREEK_MUSICAL_NOTATION = 126,
    UBLOCK_ANCIENT_GREEK_NUMBERS = 127,
    UBLOCK_ARABIC_SUPPLEMENT = 128,
    UBLOCK_BUGINESE = 129,
    UBLOCK_CJK_STROKES = 130,
    UBLOCK_COMBINING_DIACRITICAL_MARKS_SUPPLEMENT = 131,
    UBLOCK_COPTIC = 132,
    UBLOCK_ETHIOPIC_EXTENDED = 133,
    UBLOCK_ETHIOPIC_SUPPLEMENT = 134,
    UBLOCK_GEORGIAN_SUPPLEMENT = 135,
    UBLOCK_GLAGOLITIC = 136,
    UBLOCK_KHAROSHTHI = 137,
    UBLOCK_MODIFIER_TONE_LETTERS = 138,
    UBLOCK_NEW_TAI_LUE = 139,
    UBLOCK_OLD_PERSIAN = 140,
    UBLOCK_PHONETIC_EXTENSIONS_SUPPLEMENT = 141,
    UBLOCK_SUPPLEMENTAL_PUNCTUATION = 142,
    UBLOCK_SYLOTI_NAGRI = 143,
    UBLOCK_TIFINAGH = 144,
    UBLOCK_VERTICAL_FORMS = 145,
    UBLOCK_NKO = 146,
    UBLOCK_BALINESE = 147,
    UBLOCK_LATIN_EXTENDED_C = 148,
    UBLOCK_LATIN_EXTENDED_D = 149,
    UBLOCK_PHAGS_PA = 150,
    UBLOCK_PHOENICIAN = 151,
    UBLOCK_CUNEIFORM = 152,
    UBLOCK_CUNEIFORM_NUMBERS_AND_PUNCTUATION = 153,
    UBLOCK_COUNTING_ROD_NUMERALS = 154,
    UBLOCK_SUNDANESE = 155,
    UBLOCK_LEPCHA = 156,
    UBLOCK_OL_CHIKI = 157,
    UBLOCK_CYRILLIC_EXTENDED_A = 158,
    UBLOCK_VAI = 159,
    UBLOCK_CYRILLIC_EXTENDED_B = 160,
    UBLOCK_SAURASHTRA = 161,
    UBLOCK_KAYAH_LI = 162,
    UBLOCK_REJANG = 163,
    UBLOCK_CHAM = 164,
    UBLOCK_ANCIENT_SYMBOLS = 165,
    UBLOCK_PHAISTOS_DISC = 166,
    UBLOCK_LYCIAN = 167,
    UBLOCK_CARIAN = 168,
    UBLOCK_LYDIAN = 169,
    UBLOCK_MAHJONG_TILES = 170,
    UBLOCK_DOMINO_TILES = 171,
    UBLOCK_SAMARITAN = 172,
    UBLOCK_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED = 173,
    UBLOCK_TAI_THAM = 174,
    UBLOCK_VEDIC_EXTENSIONS = 175,
    UBLOCK_LISU = 176,
    UBLOCK_BAMUM = 177,
    UBLOCK_COMMON_INDIC_NUMBER_FORMS = 178,
    UBLOCK_DEVANAGARI_EXTENDED = 179,
    UBLOCK_HANGUL_JAMO_EXTENDED_A = 180,
    UBLOCK_JAVANESE = 181,
    UBLOCK_MYANMAR_EXTENDED_A = 182,
    UBLOCK_TAI_VIET = 183,
    UBLOCK_MEETEI_MAYEK = 184,
    UBLOCK_HANGUL_JAMO_EXTENDED_B = 185,
    UBLOCK_IMPERIAL_ARAMAIC = 186,
    UBLOCK_OLD_SOUTH_ARABIAN = 187,
    UBLOCK_AVESTAN = 188,
    UBLOCK_INSCRIPTIONAL_PARTHIAN = 189,
    UBLOCK_INSCRIPTIONAL_PAHLAVI = 190,
    UBLOCK_OLD_TURKIC = 191,
    UBLOCK_RUMI_NUMERAL_SYMBOLS = 192,
    UBLOCK_KAITHI = 193,
    UBLOCK_EGYPTIAN_HIEROGLYPHS = 194,
    UBLOCK_ENCLOSED_ALPHANUMERIC_SUPPLEMENT = 195,
    UBLOCK_ENCLOSED_IDEOGRAPHIC_SUPPLEMENT = 196,
    UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C = 197,
    UBLOCK_MANDAIC = 198,
    UBLOCK_BATAK = 199,
    UBLOCK_ETHIOPIC_EXTENDED_A = 200,
    UBLOCK_BRAHMI = 201,
    UBLOCK_BAMUM_SUPPLEMENT = 202,
    UBLOCK_KANA_SUPPLEMENT = 203,
    UBLOCK_PLAYING_CARDS = 204,
    UBLOCK_MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS = 205,
    UBLOCK_EMOTICONS = 206,
    UBLOCK_TRANSPORT_AND_MAP_SYMBOLS = 207,
    UBLOCK_ALCHEMICAL_SYMBOLS = 208,
    UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D = 209,
    UBLOCK_ARABIC_EXTENDED_A = 210,
    UBLOCK_ARABIC_MATHEMATICAL_ALPHABETIC_SYMBOLS = 211,
    UBLOCK_CHAKMA = 212,
    UBLOCK_MEETEI_MAYEK_EXTENSIONS = 213,
    UBLOCK_MEROITIC_CURSIVE = 214,
    UBLOCK_MEROITIC_HIEROGLYPHS = 215,
    UBLOCK_MIAO = 216,
    UBLOCK_SHARADA = 217,
    UBLOCK_SORA_SOMPENG = 218,
    UBLOCK_SUNDANESE_SUPPLEMENT = 219,
    UBLOCK_TAKRI = 220,
    UBLOCK_BASSA_VAH = 221,
    UBLOCK_CAUCASIAN_ALBANIAN = 222,
    UBLOCK_COPTIC_EPACT_NUMBERS = 223,
    UBLOCK_COMBINING_DIACRITICAL_MARKS_EXTENDED = 224,
    UBLOCK_DUPLOYAN = 225,
    UBLOCK_ELBASAN = 226,
    UBLOCK_GEOMETRIC_SHAPES_EXTENDED = 227,
    UBLOCK_GRANTHA = 228,
    UBLOCK_KHOJKI = 229,
    UBLOCK_KHUDAWADI = 230,
    UBLOCK_LATIN_EXTENDED_E = 231,
    UBLOCK_LINEAR_A = 232,
    UBLOCK_MAHAJANI = 233,
    UBLOCK_MANICHAEAN = 234,
    UBLOCK_MENDE_KIKAKUI = 235,
    UBLOCK_MODI = 236,
    UBLOCK_MRO = 237,
    UBLOCK_MYANMAR_EXTENDED_B = 238,
    UBLOCK_NABATAEAN = 239,
    UBLOCK_OLD_NORTH_ARABIAN = 240,
    UBLOCK_OLD_PERMIC = 241,
    UBLOCK_ORNAMENTAL_DINGBATS = 242,
    UBLOCK_PAHAWH_HMONG = 243,
    UBLOCK_PALMYRENE = 244,
    UBLOCK_PAU_CIN_HAU = 245,
    UBLOCK_PSALTER_PAHLAVI = 246,
    UBLOCK_SHORTHAND_FORMAT_CONTROLS = 247,
    UBLOCK_SIDDHAM = 248,
    UBLOCK_SINHALA_ARCHAIC_NUMBERS = 249,
    UBLOCK_SUPPLEMENTAL_ARROWS_C = 250,
    UBLOCK_TIRHUTA = 251,
    UBLOCK_WARANG_CITI = 252,
    UBLOCK_AHOM = 253,
    UBLOCK_ANATOLIAN_HIEROGLYPHS = 254,
    UBLOCK_CHEROKEE_SUPPLEMENT = 255,
    UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E = 256,
    UBLOCK_EARLY_DYNASTIC_CUNEIFORM = 257,
    UBLOCK_HATRAN = 258,
    UBLOCK_MULTANI = 259,
    UBLOCK_OLD_HUNGARIAN = 260,
    UBLOCK_SUPPLEMENTAL_SYMBOLS_AND_PICTOGRAPHS = 261,
    UBLOCK_SUTTON_SIGNWRITING = 262,
    UBLOCK_ADLAM = 263,
    UBLOCK_BHAIKSUKI = 264,
    UBLOCK_CYRILLIC_EXTENDED_C = 265,
    UBLOCK_GLAGOLITIC_SUPPLEMENT = 266,
    UBLOCK_IDEOGRAPHIC_SYMBOLS_AND_PUNCTUATION = 267,
    UBLOCK_MARCHEN = 268,
    UBLOCK_MONGOLIAN_SUPPLEMENT = 269,
    UBLOCK_NEWA = 270,
    UBLOCK_OSAGE = 271,
    UBLOCK_TANGUT = 272,
    UBLOCK_TANGUT_COMPONENTS = 273,
    UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_F = 274,
    UBLOCK_KANA_EXTENDED_A = 275,
    UBLOCK_MASARAM_GONDI = 276,
    UBLOCK_NUSHU = 277,
    UBLOCK_SOYOMBO = 278,
    UBLOCK_SYRIAC_SUPPLEMENT = 279,
    UBLOCK_ZANABAZAR_SQUARE = 280,
    UBLOCK_CHESS_SYMBOLS = 281,
    UBLOCK_DOGRA = 282,
    UBLOCK_GEORGIAN_EXTENDED = 283,
    UBLOCK_GUNJALA_GONDI = 284,
    UBLOCK_HANIFI_ROHINGYA = 285,
    UBLOCK_INDIC_SIYAQ_NUMBERS = 286,
    UBLOCK_MAKASAR = 287,
    UBLOCK_MAYAN_NUMERALS = 288,
    UBLOCK_MEDEFAIDRIN = 289,
    UBLOCK_OLD_SOGDIAN = 290,
    UBLOCK_SOGDIAN = 291,
    UBLOCK_EGYPTIAN_HIEROGLYPH_FORMAT_CONTROLS = 292,
    UBLOCK_ELYMAIC = 293,
    UBLOCK_NANDINAGARI = 294,
    UBLOCK_NYIAKENG_PUACHUE_HMONG = 295,
    UBLOCK_OTTOMAN_SIYAQ_NUMBERS = 296,
    UBLOCK_SMALL_KANA_EXTENSION = 297,
    UBLOCK_SYMBOLS_AND_PICTOGRAPHS_EXTENDED_A = 298,
    UBLOCK_TAMIL_SUPPLEMENT = 299,
    UBLOCK_WANCHO = 300,
    UBLOCK_CHORASMIAN = 301,
    UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_G = 302,
    UBLOCK_DIVES_AKURU = 303,
    UBLOCK_KHITAN_SMALL_SCRIPT = 304,
    UBLOCK_LISU_SUPPLEMENT = 305,
    UBLOCK_SYMBOLS_FOR_LEGACY_COMPUTING = 306,
    UBLOCK_TANGUT_SUPPLEMENT = 307,
    UBLOCK_YEZIDI = 308,
    UBLOCK_INVALID_CODE = -1
} UBlockCode;

typedef enum
{
    UBIDI_LOGICAL = 0,
    UBIDI_VISUAL
} UBiDiOrder;

typedef enum
{
    UBIDI_MIRRORING_OFF = 0,
    UBIDI_MIRRORING_ON
} UBiDiMirroring;

typedef enum UBiDiReorderingMode
{
    UBIDI_REORDER_DEFAULT = 0,
    UBIDI_REORDER_NUMBERS_SPECIAL,
    UBIDI_REORDER_GROUP_NUMBERS_WITH_R,
    UBIDI_REORDER_RUNS_ONLY,
    UBIDI_REORDER_INVERSE_NUMBERS_AS_L,
    UBIDI_REORDER_INVERSE_LIKE_DIRECT,
    UBIDI_REORDER_INVERSE_FOR_NUMBERS_SPECIAL,
} UBiDiReorderingMode;

typedef enum UCharDirection
{
    U_LEFT_TO_RIGHT = 0,
    U_RIGHT_TO_LEFT = 1,
    U_EUROPEAN_NUMBER = 2,
    U_EUROPEAN_NUMBER_SEPARATOR = 3,
    U_EUROPEAN_NUMBER_TERMINATOR = 4,
    U_ARABIC_NUMBER = 5,
    U_COMMON_NUMBER_SEPARATOR = 6,
    U_BLOCK_SEPARATOR = 7,
    U_SEGMENT_SEPARATOR = 8,
    U_WHITE_SPACE_NEUTRAL = 9,
    U_OTHER_NEUTRAL = 10,
    U_LEFT_TO_RIGHT_EMBEDDING = 11,
    U_LEFT_TO_RIGHT_OVERRIDE = 12,
    U_RIGHT_TO_LEFT_ARABIC = 13,
    U_RIGHT_TO_LEFT_EMBEDDING = 14,
    U_RIGHT_TO_LEFT_OVERRIDE = 15,
    U_POP_DIRECTIONAL_FORMAT = 16,
    U_DIR_NON_SPACING_MARK = 17,
    U_BOUNDARY_NEUTRAL = 18,
    U_FIRST_STRONG_ISOLATE = 19,
    U_LEFT_TO_RIGHT_ISOLATE = 20,
    U_RIGHT_TO_LEFT_ISOLATE = 21,
    U_POP_DIRECTIONAL_ISOLATE = 22,
} UCharDirection;

typedef enum
{
    UCOL_DEFAULT = -1,
    UCOL_PRIMARY = 0,
    UCOL_SECONDARY = 1,
    UCOL_TERTIARY = 2,
    UCOL_DEFAULT_STRENGTH = UCOL_TERTIARY,
    UCOL_CE_STRENGTH_LIMIT,
    UCOL_QUATERNARY = 3,
    UCOL_IDENTICAL = 15,
    UCOL_STRENGTH_LIMIT,
    UCOL_OFF = 16,
    UCOL_ON = 17,
    UCOL_SHIFTED = 20,
    UCOL_NON_IGNORABLE = 21,
    UCOL_LOWER_FIRST = 24,
    UCOL_UPPER_FIRST = 25,
} UColAttributeValue;

typedef enum
{
    UCOL_FRENCH_COLLATION,
    UCOL_ALTERNATE_HANDLING,
    UCOL_CASE_FIRST,
    UCOL_CASE_LEVEL,
    UCOL_NORMALIZATION_MODE,
    UCOL_DECOMPOSITION_MODE = UCOL_NORMALIZATION_MODE,
    UCOL_STRENGTH,
    UCOL_NUMERIC_COLLATION = UCOL_STRENGTH + 2,
    UCOL_ATTRIBUTE_COUNT
} UColAttribute;

typedef enum
{
    UCOL_REORDER_CODE_DEFAULT = -1,
    UCOL_REORDER_CODE_NONE = USCRIPT_UNKNOWN,
    UCOL_REORDER_CODE_OTHERS = USCRIPT_UNKNOWN,
    UCOL_REORDER_CODE_SPACE = 0x1000,
    UCOL_REORDER_CODE_FIRST = UCOL_REORDER_CODE_SPACE,
    UCOL_REORDER_CODE_PUNCTUATION = 0x1001,
    UCOL_REORDER_CODE_SYMBOL = 0x1002,
    UCOL_REORDER_CODE_CURRENCY = 0x1003,
    UCOL_REORDER_CODE_DIGIT = 0x1004,
} UColReorderCode;

typedef enum
{
    UCOL_TAILORING_ONLY,
    UCOL_FULL_RULES
} UColRuleOption;

typedef enum UBiDiDirection
{
    UBIDI_LTR,
    UBIDI_RTL,
    UBIDI_MIXED,
    UBIDI_NEUTRAL
} UBiDiDirection;

typedef enum
{
    UCOL_BOUND_LOWER = 0,
    UCOL_BOUND_UPPER = 1,
    UCOL_BOUND_UPPER_LONG = 2,
} UColBoundMode;

typedef enum UCalendarAttribute
{
    UCAL_LENIENT,
    UCAL_FIRST_DAY_OF_WEEK,
    UCAL_MINIMAL_DAYS_IN_FIRST_WEEK,
    UCAL_REPEATED_WALL_TIME,
    UCAL_SKIPPED_WALL_TIME
} UCalendarAttribute;

typedef enum UPropertyNameChoice
{
    U_SHORT_PROPERTY_NAME,
    U_LONG_PROPERTY_NAME,
} UPropertyNameChoice;

typedef struct UFieldPosition
{
    int32_t field;
    int32_t beginIndex;
    int32_t endIndex;
} UFieldPosition;

typedef enum USystemTimeZoneType
{
    UCAL_ZONE_TYPE_ANY,
    UCAL_ZONE_TYPE_CANONICAL,
    UCAL_ZONE_TYPE_CANONICAL_LOCATION
} USystemTimeZoneType;

typedef enum UCalendarType
{
    UCAL_TRADITIONAL,
    UCAL_DEFAULT = UCAL_TRADITIONAL,
    UCAL_GREGORIAN
} UCalendarType;

typedef enum UCalendarDaysOfWeek
{
    UCAL_SUNDAY = 1,
    UCAL_MONDAY,
    UCAL_TUESDAY,
    UCAL_WEDNESDAY,
    UCAL_THURSDAY,
    UCAL_FRIDAY,
    UCAL_SATURDAY
} UCalendarDaysOfWeek;

typedef enum UTimeZoneTransitionType
{
    UCAL_TZ_TRANSITION_NEXT,
    UCAL_TZ_TRANSITION_NEXT_INCLUSIVE,
    UCAL_TZ_TRANSITION_PREVIOUS,
    UCAL_TZ_TRANSITION_PREVIOUS_INCLUSIVE
} UTimeZoneTransitionType;

typedef enum UCharCategory
{
    U_UNASSIGNED = 0,
    U_GENERAL_OTHER_TYPES = 0,
    U_UPPERCASE_LETTER = 1,
    U_LOWERCASE_LETTER = 2,
    U_TITLECASE_LETTER = 3,
    U_MODIFIER_LETTER = 4,
    U_OTHER_LETTER = 5,
    U_NON_SPACING_MARK = 6,
    U_ENCLOSING_MARK = 7,
    U_COMBINING_SPACING_MARK = 8,
    U_DECIMAL_DIGIT_NUMBER = 9,
    U_LETTER_NUMBER = 10,
    U_OTHER_NUMBER = 11,
    U_SPACE_SEPARATOR = 12,
    U_LINE_SEPARATOR = 13,
    U_PARAGRAPH_SEPARATOR = 14,
    U_CONTROL_CHAR = 15,
    U_FORMAT_CHAR = 16,
    U_PRIVATE_USE_CHAR = 17,
    U_SURROGATE = 18,
    U_DASH_PUNCTUATION = 19,
    U_START_PUNCTUATION = 20,
    U_END_PUNCTUATION = 21,
    U_CONNECTOR_PUNCTUATION = 22,
    U_OTHER_PUNCTUATION = 23,
    U_MATH_SYMBOL = 24,
    U_CURRENCY_SYMBOL = 25,
    U_MODIFIER_SYMBOL = 26,
    U_OTHER_SYMBOL = 27,
    U_INITIAL_PUNCTUATION = 28,
    U_FINAL_PUNCTUATION = 29,
    U_CHAR_CATEGORY_COUNT
} UCharCategory;

typedef enum UCharNameChoice
{
    U_UNICODE_CHAR_NAME,
    U_EXTENDED_CHAR_NAME = U_UNICODE_CHAR_NAME + 2,
    U_CHAR_NAME_ALIAS,
} UCharNameChoice;

typedef enum UCalendarDisplayNameType
{
    UCAL_STANDARD,
    UCAL_SHORT_STANDARD,
    UCAL_DST,
    UCAL_SHORT_DST
} UCalendarDisplayNameType;

typedef enum UCalendarLimitType
{
    UCAL_MINIMUM,
    UCAL_MAXIMUM,
    UCAL_GREATEST_MINIMUM,
    UCAL_LEAST_MAXIMUM,
    UCAL_ACTUAL_MINIMUM,
    UCAL_ACTUAL_MAXIMUM
} UCalendarLimitType;

typedef enum UCalendarWeekdayType
{
    UCAL_WEEKDAY,
    UCAL_WEEKEND,
    UCAL_WEEKEND_ONSET,
    UCAL_WEEKEND_CEASE
} UCalendarWeekdayType;

enum
{
    USET_SERIALIZED_STATIC_ARRAY_CAPACITY = 8
};

typedef struct USerializedSet
{
    const uint16_t *array;
    int32_t bmpLength;
    int32_t length;
    uint16_t staticArray[USET_SERIALIZED_STATIC_ARRAY_CAPACITY];
} USerializedSet;

typedef struct UIDNAInfo
{
    int16_t size;
    UBool isTransitionalDifferent;
    UBool reservedB3;
    uint32_t errors;
    int32_t reservedI2;
    int32_t reservedI3;
} UIDNAInfo;

struct UBiDi;
struct UBiDiTransform;
struct UBreakIterator;
struct UCaseMap;
struct UCharIterator;
struct UCharsetDetector;
struct UCharsetMatch;
struct UCollationElements;
struct UCollator;
struct UConverter;
struct UConverterSelector;
struct UDateIntervalFormat;
struct UEnumeration;
struct UFieldPositionIterator;
struct UFormattedNumber;
struct UGenderInfo;
struct UIDNA;
struct UListFormatter;
struct ULocaleData;
struct ULocaleDisplayNames;
struct UNormalizer2;
struct UNumberFormatter;
struct UNumberingSystem;
struct UPluralRules;
struct URegion;
struct URegularExpression;
struct URelativeDateTimeFormatter;
struct UResourceBundle;
struct UResourceBundle;
struct USpoofChecker;
struct USpoofCheckResult;
struct UStringPrepProfile;
struct UStringSearch;
struct UText;

typedef const void *UCurrRegistryKey;
typedef struct UBiDi UBiDi;
typedef struct UBiDiTransform UBiDiTransform;
typedef struct UBreakIterator UBreakIterator;
typedef struct UCaseMap UCaseMap;
typedef struct UCharIterator UCharIterator;
typedef struct UCharsetDetector UCharsetDetector;
typedef struct UCharsetMatch UCharsetMatch;
typedef struct UCollationElements UCollationElements;
typedef struct UCollator UCollator;
typedef struct UConverter UConverter;
typedef struct UConverterSelector UConverterSelector;
typedef struct UDateIntervalFormat UDateIntervalFormat;
typedef struct UEnumeration UEnumeration;
typedef struct UFieldPositionIterator UFieldPositionIterator;
typedef struct UFormattedNumber UFormattedNumber;
typedef struct UGenderInfo UGenderInfo;
typedef struct UIDNA UIDNA;
typedef struct UListFormatter UListFormatter;
typedef struct ULocaleData ULocaleData;
typedef struct ULocaleDisplayNames ULocaleDisplayNames;
typedef struct UNormalizer2 UNormalizer2;
typedef struct UNumberFormatter UNumberFormatter;
typedef struct UNumberingSystem UNumberingSystem;
typedef struct UPluralRules UPluralRules;
typedef struct URegion URegion;
typedef struct URegularExpression URegularExpression;
typedef struct URelativeDateTimeFormatter URelativeDateTimeFormatter;
typedef struct UResourceBundle UResourceBundle;
typedef struct USet USet;
typedef struct USpoofChecker USpoofChecker;
typedef struct USpoofCheckResult USpoofCheckResult;
typedef struct UStringPrepProfile UStringPrepProfile;
typedef struct UStringSearch UStringSearch;
typedef struct UText UText;
typedef UColAttributeValue UCollationStrength;
typedef uint8_t UVersionInfo[U_MAX_VERSION_LENGTH];
typedef UResourceBundle *u_nl_catd;
typedef void *UCalendar;
typedef void *UDateFormat;
typedef void *UDateTimePatternGenerator;
typedef void *UFormattable;
typedef void *UMessageFormat;
typedef void *UNumberFormat;
typedef void *UReplaceable;
typedef void *UTransliterator;

typedef UBool __cdecl URegexMatchCallback(const void *context, int32_t steps);
typedef UBool __cdecl URegexFindProgressCallback(const void *context, int64_t matchIndex);
typedef void __cdecl UTraceEntry(const void *context, int32_t fnNumber);
typedef void __cdecl UTraceExit(const void *context, int32_t fnNumber, const char *fmt,
                                va_list args);
typedef void __cdecl UTraceData(const void *context, int32_t fnNumber, int32_t level,
                                const char *fmt, va_list args);
typedef void (__cdecl *UConverterToUCallback)(const void *context, UConverterToUnicodeArgs *args,
                                             const char *codeUnits, int32_t length,
                                             UConverterCallbackReason reason,
                                             UErrorCode *pErrorCode);
typedef void (__cdecl *UConverterFromUCallback)(const void *context, UConverterFromUnicodeArgs *args,
                                               const UChar *codeUnits, int32_t length,
                                               UChar32 codePoint, UConverterCallbackReason reason,
                                               UErrorCode *pErrorCode);
typedef UCharDirection __cdecl UBiDiClassCallback(const void *context, UChar32 c);
typedef UChar (__cdecl *UNESCAPE_CHAR_AT)(int32_t offset, void *context);
typedef void *__cdecl UMemAllocFn(const void *context, size_t size);
typedef void *__cdecl UMemReallocFn(const void *context, void *mem, size_t size);
typedef void __cdecl UMemFreeFn(const void *context, void *mem);
typedef UBool __cdecl UCharEnumTypeRange(const void *context, UChar32 start, UChar32 limit,
                                         UCharCategory type);
typedef UBool __cdecl UEnumCharNamesFn(void *context, UChar32 code, UCharNameChoice nameChoice,
                                       const char *name, int32_t length);

void __cdecl UCNV_FROM_U_CALLBACK_ESCAPE(const void *context, UConverterFromUnicodeArgs *fromArgs, const UChar *codeUnits, int32_t length, UChar32 codePoint, UConverterCallbackReason reason, UErrorCode *err);
void __cdecl UCNV_FROM_U_CALLBACK_SKIP(const void *context, UConverterFromUnicodeArgs *fromUArgs, const UChar *codeUnits, int32_t length, UChar32 codePoint, UConverterCallbackReason reason, UErrorCode *err);
void __cdecl UCNV_FROM_U_CALLBACK_STOP(const void *context, UConverterFromUnicodeArgs *fromUArgs, const UChar *codeUnits, int32_t length, UChar32 codePoint, UConverterCallbackReason reason, UErrorCode *err);
void __cdecl UCNV_FROM_U_CALLBACK_SUBSTITUTE(const void *context, UConverterFromUnicodeArgs *fromArgs, const UChar *codeUnits, int32_t length, UChar32 codePoint, UConverterCallbackReason reason, UErrorCode *err);
void __cdecl UCNV_TO_U_CALLBACK_ESCAPE(const void *context, UConverterToUnicodeArgs *toArgs, const char *codeUnits, int32_t length, UConverterCallbackReason reason, UErrorCode *err);
void __cdecl UCNV_TO_U_CALLBACK_SKIP(const void *context, UConverterToUnicodeArgs *toArgs, const char *codeUnits, int32_t length, UConverterCallbackReason reason, UErrorCode *err);
void __cdecl UCNV_TO_U_CALLBACK_STOP(const void *context, UConverterToUnicodeArgs *toUArgs, const char *codePoints, int32_t length, UConverterCallbackReason reason, UErrorCode *err);
void __cdecl UCNV_TO_U_CALLBACK_SUBSTITUTE(const void *context, UConverterToUnicodeArgs *toArgs, const char *codeUnits, int32_t length, UConverterCallbackReason reason, UErrorCode *err);
void __cdecl u_UCharsToChars(const UChar *us, char *cs, int32_t length);
char * __cdecl u_austrcpy(char *s1, const UChar *ucs2);
char * __cdecl u_austrncpy(char *s1, const UChar *ucs2, int32_t n);
void __cdecl u_catclose(u_nl_catd catd);
const UChar * __cdecl u_catgets(u_nl_catd catd, int32_t set_num, int32_t msg_num, const UChar *s, int32_t *len, UErrorCode *ec);
u_nl_catd __cdecl u_catopen(const char *name, const char *locale, UErrorCode *ec);
void __cdecl u_charAge(UChar32 c, UVersionInfo versionArray);
int32_t __cdecl u_charDigitValue(UChar32 c);
UCharDirection __cdecl u_charDirection(UChar32 c);
UChar32 __cdecl u_charFromName(UCharNameChoice nameChoice, const char *name, UErrorCode *pErrorCode);
UChar32 __cdecl u_charMirror(UChar32 c);
int32_t __cdecl u_charName(UChar32 code, UCharNameChoice nameChoice, char *buffer, int32_t bufferLength, UErrorCode *pErrorCode);
int8_t __cdecl u_charType(UChar32 c);
void __cdecl u_charsToUChars(const char *cs, UChar *us, int32_t length);
void __cdecl u_cleanup(void);
int32_t __cdecl u_countChar32(const UChar *s, int32_t length);
int32_t __cdecl u_digit(UChar32 ch, int8_t radix);
void __cdecl u_enumCharNames(UChar32 start, UChar32 limit, UEnumCharNamesFn *fn, void *context, UCharNameChoice nameChoice, UErrorCode *pErrorCode);
void __cdecl u_enumCharTypes(UCharEnumTypeRange *enumRange, const void *context);
const char * __cdecl u_errorName(UErrorCode code);
UChar32 __cdecl u_foldCase(UChar32 c, uint32_t options);
UChar32 __cdecl u_forDigit(int32_t digit, int8_t radix);
int32_t __cdecl u_formatMessage(const char *locale, const UChar *pattern, int32_t patternLength, UChar *result, int32_t resultLength, UErrorCode *status, ...);
int32_t __cdecl u_formatMessageWithError(const char *locale, const UChar *pattern, int32_t patternLength, UChar *result, int32_t resultLength, UParseError *parseError, UErrorCode *status, ...);
UChar32 __cdecl u_getBidiPairedBracket(UChar32 c);
uint8_t __cdecl u_getCombiningClass(UChar32 c);
void __cdecl u_getDataVersion(UVersionInfo dataVersionFillin, UErrorCode *status);
int32_t __cdecl u_getFC_NFKC_Closure(UChar32 c, UChar *dest, int32_t destCapacity, UErrorCode *pErrorCode);
int32_t __cdecl u_getIntPropertyMaxValue(UProperty which);
int32_t __cdecl u_getIntPropertyMinValue(UProperty arg0);
int32_t __cdecl u_getIntPropertyValue(UChar32 c, UProperty which);
double __cdecl u_getNumericValue(UChar32 c);
UProperty __cdecl u_getPropertyEnum(const char *alias);
const char * __cdecl u_getPropertyName(UProperty property, UPropertyNameChoice nameChoice);
int32_t __cdecl u_getPropertyValueEnum(UProperty property, const char *alias);
const char * __cdecl u_getPropertyValueName(UProperty property, int32_t value, UPropertyNameChoice nameChoice);
void __cdecl u_getUnicodeVersion(UVersionInfo versionArray);
void __cdecl u_getVersion(UVersionInfo versionArray);
UBool __cdecl u_hasBinaryProperty(UChar32 c, UProperty which);
void __cdecl u_init(UErrorCode *status);
UBool __cdecl u_isIDIgnorable(UChar32 c);
UBool __cdecl u_isIDPart(UChar32 c);
UBool __cdecl u_isIDStart(UChar32 c);
UBool __cdecl u_isISOControl(UChar32 c);
UBool __cdecl u_isJavaIDPart(UChar32 c);
UBool __cdecl u_isJavaIDStart(UChar32 c);
UBool __cdecl u_isJavaSpaceChar(UChar32 c);
UBool __cdecl u_isMirrored(UChar32 c);
UBool __cdecl u_isUAlphabetic(UChar32 c);
UBool __cdecl u_isULowercase(UChar32 c);
UBool __cdecl u_isUUppercase(UChar32 c);
UBool __cdecl u_isUWhiteSpace(UChar32 c);
UBool __cdecl u_isWhitespace(UChar32 c);
UBool __cdecl u_isalnum(UChar32 c);
UBool __cdecl u_isalpha(UChar32 c);
UBool __cdecl u_isbase(UChar32 c);
UBool __cdecl u_isblank(UChar32 c);
UBool __cdecl u_iscntrl(UChar32 c);
UBool __cdecl u_isdefined(UChar32 c);
UBool __cdecl u_isdigit(UChar32 c);
UBool __cdecl u_isgraph(UChar32 c);
UBool __cdecl u_islower(UChar32 c);
UBool __cdecl u_isprint(UChar32 c);
UBool __cdecl u_ispunct(UChar32 c);
UBool __cdecl u_isspace(UChar32 c);
UBool __cdecl u_istitle(UChar32 c);
UBool __cdecl u_isupper(UChar32 c);
UBool __cdecl u_isxdigit(UChar32 c);
int32_t __cdecl u_memcasecmp(const UChar *s1, const UChar *s2, int32_t length, uint32_t options);
UChar * __cdecl u_memchr(const UChar *s, UChar c, int32_t count);
UChar * __cdecl u_memchr32(const UChar *s, UChar32 c, int32_t count);
int32_t __cdecl u_memcmp(const UChar *buf1, const UChar *buf2, int32_t count);
int32_t __cdecl u_memcmpCodePointOrder(const UChar *s1, const UChar *s2, int32_t count);
UChar * __cdecl u_memcpy(UChar *dest, const UChar *src, int32_t count);
UChar * __cdecl u_memmove(UChar *dest, const UChar *src, int32_t count);
UChar * __cdecl u_memrchr(const UChar *s, UChar c, int32_t count);
UChar * __cdecl u_memrchr32(const UChar *s, UChar32 c, int32_t count);
UChar * __cdecl u_memset(UChar *dest, UChar c, int32_t count);
void __cdecl u_parseMessage(const char *locale, const UChar *pattern, int32_t patternLength, const UChar *source, int32_t sourceLength, UErrorCode *status, ...);
void __cdecl u_parseMessageWithError(const char *locale, const UChar *pattern, int32_t patternLength, const UChar *source, int32_t sourceLength, UParseError *parseError, UErrorCode *status, ...);
void __cdecl u_setMemoryFunctions(const void *context, UMemAllocFn *a, UMemReallocFn *r, UMemFreeFn *f, UErrorCode *status);
int32_t __cdecl u_shapeArabic(const UChar *source, int32_t sourceLength, UChar *dest, int32_t destCapacity, uint32_t options, UErrorCode *pErrorCode);
int32_t __cdecl u_strCaseCompare(const UChar *s1, int32_t length1, const UChar *s2, int32_t length2, uint32_t options, UErrorCode *pErrorCode);
int32_t __cdecl u_strCompare(const UChar *s1, int32_t length1, const UChar *s2, int32_t length2, UBool codePointOrder);
int32_t __cdecl u_strCompareIter(UCharIterator *iter1, UCharIterator *iter2, UBool codePointOrder);
UChar * __cdecl u_strFindFirst(const UChar *s, int32_t length, const UChar *sub, int32_t subLength);
UChar * __cdecl u_strFindLast(const UChar *s, int32_t length, const UChar *sub, int32_t subLength);
int32_t __cdecl u_strFoldCase(UChar *dest, int32_t destCapacity, const UChar *src, int32_t srcLength, uint32_t options, UErrorCode *pErrorCode);
UChar * __cdecl u_strFromJavaModifiedUTF8WithSub(UChar *dest, int32_t destCapacity, int32_t *pDestLength, const char *src, int32_t srcLength, UChar32 subchar, int32_t *pNumSubstitutions, UErrorCode *pErrorCode);
UChar * __cdecl u_strFromUTF32(UChar *dest, int32_t destCapacity, int32_t *pDestLength, const UChar32 *src, int32_t srcLength, UErrorCode *pErrorCode);
UChar * __cdecl u_strFromUTF32WithSub(UChar *dest, int32_t destCapacity, int32_t *pDestLength, const UChar32 *src, int32_t srcLength, UChar32 subchar, int32_t *pNumSubstitutions, UErrorCode *pErrorCode);
UChar * __cdecl u_strFromUTF8(UChar *dest, int32_t destCapacity, int32_t *pDestLength, const char *src, int32_t srcLength, UErrorCode *pErrorCode);
UChar * __cdecl u_strFromUTF8Lenient(UChar *dest, int32_t destCapacity, int32_t *pDestLength, const char *src, int32_t srcLength, UErrorCode *pErrorCode);
UChar * __cdecl u_strFromUTF8WithSub(UChar *dest, int32_t destCapacity, int32_t *pDestLength, const char *src, int32_t srcLength, UChar32 subchar, int32_t *pNumSubstitutions, UErrorCode *pErrorCode);
UChar * __cdecl u_strFromWCS(UChar *dest, int32_t destCapacity, int32_t *pDestLength, const WCHAR *src, int32_t srcLength, UErrorCode *pErrorCode);
UBool __cdecl u_strHasMoreChar32Than(const UChar *s, int32_t length, int32_t number);
char * __cdecl u_strToJavaModifiedUTF8(char *dest, int32_t destCapacity, int32_t *pDestLength, const UChar *src, int32_t srcLength, UErrorCode *pErrorCode);
int32_t __cdecl u_strToLower(UChar *dest, int32_t destCapacity, const UChar *src, int32_t srcLength, const char *locale, UErrorCode *pErrorCode);
int32_t __cdecl u_strToTitle(UChar *dest, int32_t destCapacity, const UChar *src, int32_t srcLength, UBreakIterator *titleIter, const char *locale, UErrorCode *pErrorCode);
UChar32 * __cdecl u_strToUTF32(UChar32 *dest, int32_t destCapacity, int32_t *pDestLength, const UChar *src, int32_t srcLength, UErrorCode *pErrorCode);
UChar32 * __cdecl u_strToUTF32WithSub(UChar32 *dest, int32_t destCapacity, int32_t *pDestLength, const UChar *src, int32_t srcLength, UChar32 subchar, int32_t *pNumSubstitutions, UErrorCode *pErrorCode);
char * __cdecl u_strToUTF8(char *dest, int32_t destCapacity, int32_t *pDestLength, const UChar *pSrc, int32_t srcLength, UErrorCode *pErrorCode);
char * __cdecl u_strToUTF8WithSub(char *dest, int32_t destCapacity, int32_t *pDestLength, const UChar *pSrc, int32_t srcLength, UChar32 subchar, int32_t *pNumSubstitutions, UErrorCode *pErrorCode);
int32_t __cdecl u_strToUpper(UChar *dest, int32_t destCapacity, const UChar *src, int32_t srcLength, const char *locale, UErrorCode *pErrorCode);
WCHAR * __cdecl u_strToWCS(WCHAR *dest, int32_t destCapacity, int32_t *pDestLength, const UChar *src, int32_t srcLength, UErrorCode *pErrorCode);
int32_t __cdecl u_strcasecmp(const UChar *s1, const UChar *s2, uint32_t options);
UChar * __cdecl u_strcat(UChar *dst, const UChar *src);
UChar * __cdecl u_strchr(const UChar *s, UChar c);
UChar * __cdecl u_strchr32(const UChar *s, UChar32 c);
int32_t __cdecl u_strcmp(const UChar *s1, const UChar *s2);
int32_t __cdecl u_strcmpCodePointOrder(const UChar *s1, const UChar *s2);
UChar * __cdecl u_strcpy(UChar *dst, const UChar *src);
int32_t __cdecl u_strcspn(const UChar *string, const UChar *matchSet);
int32_t __cdecl u_strlen(const UChar *s);
int32_t __cdecl u_strncasecmp(const UChar *s1, const UChar *s2, int32_t n, uint32_t options);
UChar * __cdecl u_strncat(UChar *dst, const UChar *src, int32_t n);
int32_t __cdecl u_strncmp(const UChar *s1, const UChar *s2, int32_t n);
int32_t __cdecl u_strncmpCodePointOrder(const UChar *s1, const UChar *s2, int32_t n);
UChar * __cdecl u_strncpy(UChar *dst, const UChar *src, int32_t n);
UChar * __cdecl u_strpbrk(const UChar *string, const UChar *matchSet);
UChar * __cdecl u_strrchr(const UChar *s, UChar c);
UChar * __cdecl u_strrchr32(const UChar *s, UChar32 c);
UChar * __cdecl u_strrstr(const UChar *s, const UChar *substring);
int32_t __cdecl u_strspn(const UChar *string, const UChar *matchSet);
UChar * __cdecl u_strstr(const UChar *s, const UChar *substring);
UChar * __cdecl u_strtok_r(UChar *src, const UChar *delim, UChar **saveState);
UChar32 __cdecl u_tolower(UChar32 c);
UChar32 __cdecl u_totitle(UChar32 c);
UChar32 __cdecl u_toupper(UChar32 c);
UChar * __cdecl u_uastrcpy(UChar *ucs1, const char *s2);
UChar * __cdecl u_uastrncpy(UChar *ucs1, const char *s2, int32_t n);
int32_t __cdecl u_unescape(const char *src, UChar *dest, int32_t destCapacity);
UChar32 __cdecl u_unescapeAt(UNESCAPE_CHAR_AT charAt, int32_t *offset, int32_t length, void *context);
void __cdecl u_versionFromString(UVersionInfo versionArray, const char *versionString);
void __cdecl u_versionFromUString(UVersionInfo versionArray, const UChar *versionString);
void __cdecl u_versionToString(const UVersionInfo versionArray, char *versionString);
int32_t __cdecl u_vformatMessage(const char *locale, const UChar *pattern, int32_t patternLength, UChar *result, int32_t resultLength, va_list ap, UErrorCode *status);
int32_t __cdecl u_vformatMessageWithError(const char *locale, const UChar *pattern, int32_t patternLength, UChar *result, int32_t resultLength, UParseError *parseError, va_list ap, UErrorCode *status);
void __cdecl u_vparseMessage(const char *locale, const UChar *pattern, int32_t patternLength, const UChar *source, int32_t sourceLength, va_list ap, UErrorCode *status);
void __cdecl u_vparseMessageWithError(const char *locale, const UChar *pattern, int32_t patternLength, const UChar *source, int32_t sourceLength, va_list ap, UParseError *parseError, UErrorCode *status);
void __cdecl ubidi_close(UBiDi *pBiDi);
int32_t __cdecl ubidi_countParagraphs(UBiDi *pBiDi);
int32_t __cdecl ubidi_countRuns(UBiDi *pBiDi, UErrorCode *pErrorCode);
UBiDiDirection __cdecl ubidi_getBaseDirection(const UChar *text, int32_t length);
void __cdecl ubidi_getClassCallback(UBiDi *pBiDi, UBiDiClassCallback **fn, const void **context);
UCharDirection __cdecl ubidi_getCustomizedClass(UBiDi *pBiDi, UChar32 c);
UBiDiDirection __cdecl ubidi_getDirection(const UBiDi *pBiDi);
int32_t __cdecl ubidi_getLength(const UBiDi *pBiDi);
UBiDiLevel __cdecl ubidi_getLevelAt(const UBiDi *pBiDi, int32_t charIndex);
const UBiDiLevel * __cdecl ubidi_getLevels(UBiDi *pBiDi, UErrorCode *pErrorCode);
int32_t __cdecl ubidi_getLogicalIndex(UBiDi *pBiDi, int32_t visualIndex, UErrorCode *pErrorCode);
void __cdecl ubidi_getLogicalMap(UBiDi *pBiDi, int32_t *indexMap, UErrorCode *pErrorCode);
void __cdecl ubidi_getLogicalRun(const UBiDi *pBiDi, int32_t logicalPosition, int32_t *pLogicalLimit, UBiDiLevel *pLevel);
UBiDiLevel __cdecl ubidi_getParaLevel(const UBiDi *pBiDi);
int32_t __cdecl ubidi_getParagraph(const UBiDi *pBiDi, int32_t charIndex, int32_t *pParaStart, int32_t *pParaLimit, UBiDiLevel *pParaLevel, UErrorCode *pErrorCode);
void __cdecl ubidi_getParagraphByIndex(const UBiDi *pBiDi, int32_t paraIndex, int32_t *pParaStart, int32_t *pParaLimit, UBiDiLevel *pParaLevel, UErrorCode *pErrorCode);
int32_t __cdecl ubidi_getProcessedLength(const UBiDi *pBiDi);
UBiDiReorderingMode __cdecl ubidi_getReorderingMode(UBiDi *pBiDi);
uint32_t __cdecl ubidi_getReorderingOptions(UBiDi *pBiDi);
int32_t __cdecl ubidi_getResultLength(const UBiDi *pBiDi);
const UChar * __cdecl ubidi_getText(const UBiDi *pBiDi);
int32_t __cdecl ubidi_getVisualIndex(UBiDi *pBiDi, int32_t logicalIndex, UErrorCode *pErrorCode);
void __cdecl ubidi_getVisualMap(UBiDi *pBiDi, int32_t *indexMap, UErrorCode *pErrorCode);
UBiDiDirection __cdecl ubidi_getVisualRun(UBiDi *pBiDi, int32_t runIndex, int32_t *pLogicalStart, int32_t *pLength);
void __cdecl ubidi_invertMap(const int32_t *srcMap, int32_t *destMap, int32_t length);
UBool __cdecl ubidi_isInverse(UBiDi *pBiDi);
UBool __cdecl ubidi_isOrderParagraphsLTR(UBiDi *pBiDi);
UBiDi * __cdecl ubidi_open(void);
UBiDi * __cdecl ubidi_openSized(int32_t maxLength, int32_t maxRunCount, UErrorCode *pErrorCode);
void __cdecl ubidi_orderParagraphsLTR(UBiDi *pBiDi, UBool orderParagraphsLTR);
void __cdecl ubidi_reorderLogical(const UBiDiLevel *levels, int32_t length, int32_t *indexMap);
void __cdecl ubidi_reorderVisual(const UBiDiLevel *levels, int32_t length, int32_t *indexMap);
void __cdecl ubidi_setClassCallback(UBiDi *pBiDi, UBiDiClassCallback *newFn, const void *newContext, UBiDiClassCallback **oldFn, const void **oldContext, UErrorCode *pErrorCode);
void __cdecl ubidi_setContext(UBiDi *pBiDi, const UChar *prologue, int32_t proLength, const UChar *epilogue, int32_t epiLength, UErrorCode *pErrorCode);
void __cdecl ubidi_setInverse(UBiDi *pBiDi, UBool isInverse);
void __cdecl ubidi_setLine(const UBiDi *pParaBiDi, int32_t start, int32_t limit, UBiDi *pLineBiDi, UErrorCode *pErrorCode);
void __cdecl ubidi_setPara(UBiDi *pBiDi, const UChar *text, int32_t length, UBiDiLevel paraLevel, UBiDiLevel *embeddingLevels, UErrorCode *pErrorCode);
void __cdecl ubidi_setReorderingMode(UBiDi *pBiDi, UBiDiReorderingMode reorderingMode);
void __cdecl ubidi_setReorderingOptions(UBiDi *pBiDi, uint32_t reorderingOptions);
int32_t __cdecl ubidi_writeReordered(UBiDi *pBiDi, UChar *dest, int32_t destSize, uint16_t options, UErrorCode *pErrorCode);
int32_t __cdecl ubidi_writeReverse(const UChar *src, int32_t srcLength, UChar *dest, int32_t destSize, uint16_t options, UErrorCode *pErrorCode);
void __cdecl ubiditransform_close(UBiDiTransform *pBidiTransform);
UBiDiTransform * __cdecl ubiditransform_open(UErrorCode *pErrorCode);
uint32_t __cdecl ubiditransform_transform(UBiDiTransform *pBiDiTransform, const UChar *src, int32_t srcLength, UChar *dest, int32_t destSize, UBiDiLevel inParaLevel, UBiDiOrder inOrder, UBiDiLevel outParaLevel, UBiDiOrder outOrder, UBiDiMirroring doMirroring, uint32_t shapingOptions, UErrorCode *pErrorCode);
UBlockCode __cdecl ublock_getCode(UChar32 c);
void __cdecl ubrk_close(UBreakIterator *bi);
int32_t __cdecl ubrk_countAvailable(void);
int32_t __cdecl ubrk_current(const UBreakIterator *bi);
int32_t __cdecl ubrk_first(UBreakIterator *bi);
int32_t __cdecl ubrk_following(UBreakIterator *bi, int32_t offset);
const char * __cdecl ubrk_getAvailable(int32_t index);
int32_t __cdecl ubrk_getBinaryRules(UBreakIterator *bi, uint8_t *binaryRules, int32_t rulesCapacity, UErrorCode *status);
const char * __cdecl ubrk_getLocaleByType(const UBreakIterator *bi, ULocDataLocaleType type, UErrorCode *status);
int32_t __cdecl ubrk_getRuleStatus(UBreakIterator *bi);
int32_t __cdecl ubrk_getRuleStatusVec(UBreakIterator *bi, int32_t *fillInVec, int32_t capacity, UErrorCode *status);
UBool __cdecl ubrk_isBoundary(UBreakIterator *bi, int32_t offset);
int32_t __cdecl ubrk_last(UBreakIterator *bi);
int32_t __cdecl ubrk_next(UBreakIterator *bi);
UBreakIterator * __cdecl ubrk_open(UBreakIteratorType type, const char *locale, const UChar *text, int32_t textLength, UErrorCode *status);
UBreakIterator * __cdecl ubrk_openBinaryRules(const uint8_t *binaryRules, int32_t rulesLength, const UChar *text, int32_t textLength, UErrorCode *status);
UBreakIterator * __cdecl ubrk_openRules(const UChar *rules, int32_t rulesLength, const UChar *text, int32_t textLength, UParseError *parseErr, UErrorCode *status);
int32_t __cdecl ubrk_preceding(UBreakIterator *bi, int32_t offset);
int32_t __cdecl ubrk_previous(UBreakIterator *bi);
void __cdecl ubrk_refreshUText(UBreakIterator *bi, UText *text, UErrorCode *status);
UBreakIterator * __cdecl ubrk_safeClone(const UBreakIterator *bi, void *stackBuffer, int32_t *pBufferSize, UErrorCode *status);
void __cdecl ubrk_setText(UBreakIterator *bi, const UChar *text, int32_t textLength, UErrorCode *status);
void __cdecl ubrk_setUText(UBreakIterator *bi, UText *text, UErrorCode *status);
void __cdecl ucal_add(UCalendar *cal, UCalendarDateFields field, int32_t amount, UErrorCode *status);
void __cdecl ucal_clear(UCalendar *calendar);
void __cdecl ucal_clearField(UCalendar *cal, UCalendarDateFields field);
UCalendar * __cdecl ucal_clone(const UCalendar *cal, UErrorCode *status);
void __cdecl ucal_close(UCalendar *cal);
int32_t __cdecl ucal_countAvailable(void);
UBool __cdecl ucal_equivalentTo(const UCalendar *cal1, const UCalendar *cal2);
int32_t __cdecl ucal_get(const UCalendar *cal, UCalendarDateFields field, UErrorCode *status);
int32_t __cdecl ucal_getAttribute(const UCalendar *cal, UCalendarAttribute attr);
const char * __cdecl ucal_getAvailable(int32_t index);
int32_t __cdecl ucal_getCanonicalTimeZoneID(const UChar *id, int32_t len, UChar *result, int32_t resultCapacity, UBool *isSystemID, UErrorCode *status);
int32_t __cdecl ucal_getDSTSavings(const UChar *zoneID, UErrorCode *ec);
UCalendarWeekdayType __cdecl ucal_getDayOfWeekType(const UCalendar *cal, UCalendarDaysOfWeek dayOfWeek, UErrorCode *status);
int32_t __cdecl ucal_getDefaultTimeZone(UChar *result, int32_t resultCapacity, UErrorCode *ec);
int32_t __cdecl ucal_getFieldDifference(UCalendar *cal, UDate target, UCalendarDateFields field, UErrorCode *status);
UDate __cdecl ucal_getGregorianChange(const UCalendar *cal, UErrorCode *pErrorCode);
UEnumeration * __cdecl ucal_getKeywordValuesForLocale(const char *arg0, const char *locale, UBool commonlyUsed, UErrorCode *status);
int32_t __cdecl ucal_getLimit(const UCalendar *cal, UCalendarDateFields field, UCalendarLimitType type, UErrorCode *status);
const char * __cdecl ucal_getLocaleByType(const UCalendar *cal, ULocDataLocaleType type, UErrorCode *status);
UDate __cdecl ucal_getMillis(const UCalendar *cal, UErrorCode *status);
UDate __cdecl ucal_getNow(void);
const char * __cdecl ucal_getTZDataVersion(UErrorCode *status);
int32_t __cdecl ucal_getTimeZoneDisplayName(const UCalendar *cal, UCalendarDisplayNameType type, const char *locale, UChar *result, int32_t resultLength, UErrorCode *status);
int32_t __cdecl ucal_getTimeZoneID(const UCalendar *cal, UChar *result, int32_t resultLength, UErrorCode *status);
int32_t __cdecl ucal_getTimeZoneIDForWindowsID(const UChar *winid, int32_t len, const char *region, UChar *id, int32_t idCapacity, UErrorCode *status);
UBool __cdecl ucal_getTimeZoneTransitionDate(const UCalendar *cal, UTimeZoneTransitionType type, UDate *transition, UErrorCode *status);
const char * __cdecl ucal_getType(const UCalendar *cal, UErrorCode *status);
int32_t __cdecl ucal_getWeekendTransition(const UCalendar *cal, UCalendarDaysOfWeek dayOfWeek, UErrorCode *status);
int32_t __cdecl ucal_getWindowsTimeZoneID(const UChar *id, int32_t len, UChar *winid, int32_t winidCapacity, UErrorCode *status);
UBool __cdecl ucal_inDaylightTime(const UCalendar *cal, UErrorCode *status);
UBool __cdecl ucal_isSet(const UCalendar *cal, UCalendarDateFields field);
UBool __cdecl ucal_isWeekend(const UCalendar *cal, UDate date, UErrorCode *status);
UCalendar * __cdecl ucal_open(const UChar *zoneID, int32_t len, const char *locale, UCalendarType caltype, UErrorCode *status);
UEnumeration * __cdecl ucal_openCountryTimeZones(const char *country, UErrorCode *ec);
UEnumeration * __cdecl ucal_openTimeZoneIDEnumeration(USystemTimeZoneType zoneType, const char *region, const int32_t *rawOffset, UErrorCode *ec);
UEnumeration * __cdecl ucal_openTimeZones(UErrorCode *ec);
void __cdecl ucal_roll(UCalendar *cal, UCalendarDateFields field, int32_t amount, UErrorCode *status);
void __cdecl ucal_set(UCalendar *cal, UCalendarDateFields field, int32_t value);
void __cdecl ucal_setAttribute(UCalendar *cal, UCalendarAttribute attr, int32_t newValue);
void __cdecl ucal_setDate(UCalendar *cal, int32_t year, int32_t month, int32_t date, UErrorCode *status);
void __cdecl ucal_setDateTime(UCalendar *cal, int32_t year, int32_t month, int32_t date, int32_t hour, int32_t minute, int32_t second, UErrorCode *status);
void __cdecl ucal_setDefaultTimeZone(const UChar *zoneID, UErrorCode *ec);
void __cdecl ucal_setGregorianChange(UCalendar *cal, UDate date, UErrorCode *pErrorCode);
void __cdecl ucal_setMillis(UCalendar *cal, UDate dateTime, UErrorCode *status);
void __cdecl ucal_setTimeZone(UCalendar *cal, const UChar *zoneID, int32_t len, UErrorCode *status);
void __cdecl ucasemap_close(UCaseMap *csm);
const UBreakIterator * __cdecl ucasemap_getBreakIterator(const UCaseMap *csm);
const char * __cdecl ucasemap_getLocale(const UCaseMap *csm);
uint32_t __cdecl ucasemap_getOptions(const UCaseMap *csm);
UCaseMap * __cdecl ucasemap_open(const char *locale, uint32_t options, UErrorCode *pErrorCode);
void __cdecl ucasemap_setBreakIterator(UCaseMap *csm, UBreakIterator *iterToAdopt, UErrorCode *pErrorCode);
void __cdecl ucasemap_setLocale(UCaseMap *csm, const char *locale, UErrorCode *pErrorCode);
void __cdecl ucasemap_setOptions(UCaseMap *csm, uint32_t options, UErrorCode *pErrorCode);
int32_t __cdecl ucasemap_toTitle(UCaseMap *csm, UChar *dest, int32_t destCapacity, const UChar *src, int32_t srcLength, UErrorCode *pErrorCode);
int32_t __cdecl ucasemap_utf8FoldCase(const UCaseMap *csm, char *dest, int32_t destCapacity, const char *src, int32_t srcLength, UErrorCode *pErrorCode);
int32_t __cdecl ucasemap_utf8ToLower(const UCaseMap *csm, char *dest, int32_t destCapacity, const char *src, int32_t srcLength, UErrorCode *pErrorCode);
int32_t __cdecl ucasemap_utf8ToTitle(UCaseMap *csm, char *dest, int32_t destCapacity, const char *src, int32_t srcLength, UErrorCode *pErrorCode);
int32_t __cdecl ucasemap_utf8ToUpper(const UCaseMap *csm, char *dest, int32_t destCapacity, const char *src, int32_t srcLength, UErrorCode *pErrorCode);
void __cdecl ucnv_cbFromUWriteBytes(UConverterFromUnicodeArgs *args, const char *source, int32_t length, int32_t offsetIndex, UErrorCode *err);
void __cdecl ucnv_cbFromUWriteSub(UConverterFromUnicodeArgs *args, int32_t offsetIndex, UErrorCode *err);
void __cdecl ucnv_cbFromUWriteUChars(UConverterFromUnicodeArgs *args, const UChar **source, const UChar *sourceLimit, int32_t offsetIndex, UErrorCode *err);
void __cdecl ucnv_cbToUWriteSub(UConverterToUnicodeArgs *args, int32_t offsetIndex, UErrorCode *err);
void __cdecl ucnv_cbToUWriteUChars(UConverterToUnicodeArgs *args, const UChar *source, int32_t length, int32_t offsetIndex, UErrorCode *err);
void __cdecl ucnv_close(UConverter *converter);
int __cdecl ucnv_compareNames(const char *name1, const char *name2);
int32_t __cdecl ucnv_convert(const char *toConverterName, const char *fromConverterName, char *target, int32_t targetCapacity, const char *source, int32_t sourceLength, UErrorCode *pErrorCode);
void __cdecl ucnv_convertEx(UConverter *targetCnv, UConverter *sourceCnv, char **target, const char *targetLimit, const char **source, const char *sourceLimit, UChar *pivotStart, UChar **pivotSource, UChar **pivotTarget, const UChar *pivotLimit, UBool reset, UBool flush, UErrorCode *pErrorCode);
uint16_t __cdecl ucnv_countAliases(const char *alias, UErrorCode *pErrorCode);
int32_t __cdecl ucnv_countAvailable(void);
uint16_t __cdecl ucnv_countStandards(void);
const char * __cdecl ucnv_detectUnicodeSignature(const char *source, int32_t sourceLength, int32_t *signatureLength, UErrorCode *pErrorCode);
void __cdecl ucnv_fixFileSeparator(const UConverter *cnv, UChar *source, int32_t sourceLength);
int32_t __cdecl ucnv_flushCache(void);
int32_t __cdecl ucnv_fromAlgorithmic(UConverter *cnv, UConverterType algorithmicType, char *target, int32_t targetCapacity, const char *source, int32_t sourceLength, UErrorCode *pErrorCode);
int32_t __cdecl ucnv_fromUChars(UConverter *cnv, char *dest, int32_t destCapacity, const UChar *src, int32_t srcLength, UErrorCode *pErrorCode);
int32_t __cdecl ucnv_fromUCountPending(const UConverter *cnv, UErrorCode *status);
void __cdecl ucnv_fromUnicode(UConverter *cnv, char **target, const char *targetLimit, const UChar **source, const UChar *sourceLimit, int32_t *offsets, UBool flush, UErrorCode *err);
const char * __cdecl ucnv_getAlias(const char *alias, uint16_t n, UErrorCode *pErrorCode);
void __cdecl ucnv_getAliases(const char *alias, const char **aliases, UErrorCode *pErrorCode);
const char * __cdecl ucnv_getAvailableName(int32_t n);
int32_t __cdecl ucnv_getCCSID(const UConverter *converter, UErrorCode *err);
const char * __cdecl ucnv_getCanonicalName(const char *alias, const char *standard, UErrorCode *pErrorCode);
const char * __cdecl ucnv_getDefaultName(void);
int32_t __cdecl ucnv_getDisplayName(const UConverter *cnv, const char *displayLocale, UChar *displayName, int32_t displayNameCapacity, UErrorCode *pErrorCode);
void __cdecl ucnv_getFromUCallBack(const UConverter *converter, UConverterFromUCallback *action, const void **context);
void __cdecl ucnv_getInvalidChars(const UConverter *converter, char *errBytes, int8_t *len, UErrorCode *err);
void __cdecl ucnv_getInvalidUChars(const UConverter *converter, UChar *errChars, int8_t *len, UErrorCode *err);
int8_t __cdecl ucnv_getMaxCharSize(const UConverter *converter);
int8_t __cdecl ucnv_getMinCharSize(const UConverter *converter);
const char * __cdecl ucnv_getName(const UConverter *converter, UErrorCode *err);
UChar32 __cdecl ucnv_getNextUChar(UConverter *cnv, const char **source, const char *sourceLimit, UErrorCode *err);
UConverterPlatform __cdecl ucnv_getPlatform(const UConverter *converter, UErrorCode *err);
const char * __cdecl ucnv_getStandard(uint16_t n, UErrorCode *pErrorCode);
const char * __cdecl ucnv_getStandardName(const char *name, const char *standard, UErrorCode *pErrorCode);
void __cdecl ucnv_getStarters(const UConverter *converter, UBool starters[256], UErrorCode *err);
void __cdecl ucnv_getSubstChars(const UConverter *converter, char *mySubChar, int8_t *len, UErrorCode *err);
void __cdecl ucnv_getToUCallBack(const UConverter *converter, UConverterToUCallback *action, const void **context);
UConverterType __cdecl ucnv_getType(const UConverter *converter);
void __cdecl ucnv_getUnicodeSet(const UConverter *cnv, USet *setFillIn, UConverterUnicodeSet whichSet, UErrorCode *pErrorCode);
UBool __cdecl ucnv_isAmbiguous(const UConverter *cnv);
UBool __cdecl ucnv_isFixedWidth(UConverter *cnv, UErrorCode *status);
UConverter * __cdecl ucnv_open(const char *name, UErrorCode *err);
UEnumeration * __cdecl ucnv_openAllNames(UErrorCode *pErrorCode);
UConverter * __cdecl ucnv_openCCSID(int32_t codepage, UConverterPlatform platform, UErrorCode *err);
UConverter * __cdecl ucnv_openPackage(const char *packageName, const char *converterName, UErrorCode *err);
UEnumeration * __cdecl ucnv_openStandardNames(const char *convName, const char *standard, UErrorCode *pErrorCode);
UConverter * __cdecl ucnv_openU(const UChar *name, UErrorCode *err);
void __cdecl ucnv_reset(UConverter *converter);
void __cdecl ucnv_resetFromUnicode(UConverter *converter);
void __cdecl ucnv_resetToUnicode(UConverter *converter);
UConverter * __cdecl ucnv_safeClone(const UConverter *cnv, void *stackBuffer, int32_t *pBufferSize, UErrorCode *status);
void __cdecl ucnv_setDefaultName(const char *arg0);
void __cdecl ucnv_setFallback(UConverter *cnv, UBool usesFallback);
void __cdecl ucnv_setFromUCallBack(UConverter *converter, UConverterFromUCallback newAction, const void *newContext, UConverterFromUCallback *oldAction, const void **oldContext, UErrorCode *err);
void __cdecl ucnv_setSubstChars(UConverter *converter, const char *mySubChar, int8_t len, UErrorCode *err);
void __cdecl ucnv_setSubstString(UConverter *cnv, const UChar *s, int32_t length, UErrorCode *err);
void __cdecl ucnv_setToUCallBack(UConverter *converter, UConverterToUCallback newAction, const void *newContext, UConverterToUCallback *oldAction, const void **oldContext, UErrorCode *err);
int32_t __cdecl ucnv_toAlgorithmic(UConverterType algorithmicType, UConverter *cnv, char *target, int32_t targetCapacity, const char *source, int32_t sourceLength, UErrorCode *pErrorCode);
int32_t __cdecl ucnv_toUChars(UConverter *cnv, UChar *dest, int32_t destCapacity, const char *src, int32_t srcLength, UErrorCode *pErrorCode);
int32_t __cdecl ucnv_toUCountPending(const UConverter *cnv, UErrorCode *status);
void __cdecl ucnv_toUnicode(UConverter *cnv, UChar **target, const UChar *targetLimit, const char **source, const char *sourceLimit, int32_t *offsets, UBool flush, UErrorCode *err);
UBool __cdecl ucnv_usesFallback(const UConverter *cnv);
void __cdecl ucnvsel_close(UConverterSelector *sel);
UConverterSelector * __cdecl ucnvsel_open(const char * const * converterList, int32_t converterListSize, const USet *excludedCodePoints, const UConverterUnicodeSet whichSet, UErrorCode *status);
UConverterSelector * __cdecl ucnvsel_openFromSerialized(const void *buffer, int32_t length, UErrorCode *status);
UEnumeration * __cdecl ucnvsel_selectForString(const UConverterSelector *sel, const UChar *s, int32_t length, UErrorCode *status);
UEnumeration * __cdecl ucnvsel_selectForUTF8(const UConverterSelector *sel, const char *s, int32_t length, UErrorCode *status);
int32_t __cdecl ucnvsel_serialize(const UConverterSelector *sel, void *buffer, int32_t bufferCapacity, UErrorCode *status);
int32_t __cdecl ucol_cloneBinary(const UCollator *coll, uint8_t *buffer, int32_t capacity, UErrorCode *status);
void __cdecl ucol_close(UCollator *coll);
void __cdecl ucol_closeElements(UCollationElements *elems);
int32_t __cdecl ucol_countAvailable(void);
UBool __cdecl ucol_equal(const UCollator *coll, const UChar *source, int32_t sourceLength, const UChar *target, int32_t targetLength);
UColAttributeValue __cdecl ucol_getAttribute(const UCollator *coll, UColAttribute attr, UErrorCode *status);
const char * __cdecl ucol_getAvailable(int32_t localeIndex);
int32_t __cdecl ucol_getBound(const uint8_t *source, int32_t sourceLength, UColBoundMode boundType, uint32_t noOfLevels, uint8_t *result, int32_t resultLength, UErrorCode *status);
void __cdecl ucol_getContractionsAndExpansions(const UCollator *coll, USet *contractions, USet *expansions, UBool addPrefixes, UErrorCode *status);
int32_t __cdecl ucol_getDisplayName(const char *objLoc, const char *dispLoc, UChar *result, int32_t resultLength, UErrorCode *status);
int32_t __cdecl ucol_getEquivalentReorderCodes(int32_t reorderCode, int32_t *dest, int32_t destCapacity, UErrorCode *pErrorCode);
int32_t __cdecl ucol_getFunctionalEquivalent(char *result, int32_t resultCapacity, const char *keyword, const char *locale, UBool *isAvailable, UErrorCode *status);
UEnumeration * __cdecl ucol_getKeywordValues(const char *keyword, UErrorCode *status);
UEnumeration * __cdecl ucol_getKeywordValuesForLocale(const char *key, const char *locale, UBool commonlyUsed, UErrorCode *status);
UEnumeration * __cdecl ucol_getKeywords(UErrorCode *status);
const char * __cdecl ucol_getLocaleByType(const UCollator *coll, ULocDataLocaleType type, UErrorCode *status);
int32_t __cdecl ucol_getMaxExpansion(const UCollationElements *elems, int32_t order);
UColReorderCode __cdecl ucol_getMaxVariable(const UCollator *coll);
int32_t __cdecl ucol_getOffset(const UCollationElements *elems);
int32_t __cdecl ucol_getReorderCodes(const UCollator *coll, int32_t *dest, int32_t destCapacity, UErrorCode *status);
const UChar * __cdecl ucol_getRules(const UCollator *coll, int32_t *length);
int32_t __cdecl ucol_getRulesEx(const UCollator *coll, UColRuleOption delta, UChar *buffer, int32_t bufferLen);
int32_t __cdecl ucol_getSortKey(const UCollator *coll, const UChar *source, int32_t sourceLength, uint8_t *result, int32_t resultLength);
UCollationStrength __cdecl ucol_getStrength(const UCollator *coll);
USet * __cdecl ucol_getTailoredSet(const UCollator *coll, UErrorCode *status);
void __cdecl ucol_getUCAVersion(const UCollator *coll, UVersionInfo info);
uint32_t __cdecl ucol_getVariableTop(const UCollator *coll, UErrorCode *status);
void __cdecl ucol_getVersion(const UCollator *coll, UVersionInfo versionInfo);
UBool __cdecl ucol_greater(const UCollator *coll, const UChar *source, int32_t sourceLength, const UChar *target, int32_t targetLength);
UBool __cdecl ucol_greaterOrEqual(const UCollator *coll, const UChar *source, int32_t sourceLength, const UChar *target, int32_t targetLength);
int32_t __cdecl ucol_keyHashCode(const uint8_t *key, int32_t length);
int32_t __cdecl ucol_mergeSortkeys(const uint8_t *src1, int32_t src1Length, const uint8_t *src2, int32_t src2Length, uint8_t *dest, int32_t destCapacity);
int32_t __cdecl ucol_next(UCollationElements *elems, UErrorCode *status);
int32_t __cdecl ucol_nextSortKeyPart(const UCollator *coll, UCharIterator *iter, uint32_t state[2], uint8_t *dest, int32_t count, UErrorCode *status);
UCollator * __cdecl ucol_open(const char *loc, UErrorCode *status);
UEnumeration * __cdecl ucol_openAvailableLocales(UErrorCode *status);
UCollator * __cdecl ucol_openBinary(const uint8_t *bin, int32_t length, const UCollator *base, UErrorCode *status);
UCollationElements * __cdecl ucol_openElements(const UCollator *coll, const UChar *text, int32_t textLength, UErrorCode *status);
UCollator * __cdecl ucol_openRules(const UChar *rules, int32_t rulesLength, UColAttributeValue normalizationMode, UCollationStrength strength, UParseError *parseError, UErrorCode *status);
int32_t __cdecl ucol_previous(UCollationElements *elems, UErrorCode *status);
int32_t __cdecl ucol_primaryOrder(int32_t order);
void __cdecl ucol_reset(UCollationElements *elems);
UCollator * __cdecl ucol_safeClone(const UCollator *coll, void *arg1, int32_t *pBufferSize, UErrorCode *status);
int32_t __cdecl ucol_secondaryOrder(int32_t order);
void __cdecl ucol_setAttribute(UCollator *coll, UColAttribute attr, UColAttributeValue value, UErrorCode *status);
void __cdecl ucol_setMaxVariable(UCollator *coll, UColReorderCode group, UErrorCode *pErrorCode);
void __cdecl ucol_setOffset(UCollationElements *elems, int32_t offset, UErrorCode *status);
void __cdecl ucol_setReorderCodes(UCollator *coll, const int32_t *reorderCodes, int32_t reorderCodesLength, UErrorCode *status);
void __cdecl ucol_setStrength(UCollator *coll, UCollationStrength strength);
void __cdecl ucol_setText(UCollationElements *elems, const UChar *text, int32_t textLength, UErrorCode *status);
UCollationResult __cdecl ucol_strcoll(const UCollator *coll, const UChar *source, int32_t sourceLength, const UChar *target, int32_t targetLength);
UCollationResult __cdecl ucol_strcollIter(const UCollator *coll, UCharIterator *sIter, UCharIterator *tIter, UErrorCode *status);
UCollationResult __cdecl ucol_strcollUTF8(const UCollator *coll, const char *source, int32_t sourceLength, const char *target, int32_t targetLength, UErrorCode *status);
int32_t __cdecl ucol_tertiaryOrder(int32_t order);
void __cdecl ucsdet_close(UCharsetDetector *ucsd);
const UCharsetMatch * __cdecl ucsdet_detect(UCharsetDetector *ucsd, UErrorCode *status);
const UCharsetMatch ** __cdecl ucsdet_detectAll(UCharsetDetector *ucsd, int32_t *maxMatchesFound, UErrorCode *status);
UBool __cdecl ucsdet_enableInputFilter(UCharsetDetector *ucsd, UBool filter);
UEnumeration * __cdecl ucsdet_getAllDetectableCharsets(const UCharsetDetector *arg0, UErrorCode *status);
int32_t __cdecl ucsdet_getConfidence(const UCharsetMatch *ucsm, UErrorCode *status);
const char * __cdecl ucsdet_getLanguage(const UCharsetMatch *ucsm, UErrorCode *status);
const char * __cdecl ucsdet_getName(const UCharsetMatch *ucsm, UErrorCode *status);
int32_t __cdecl ucsdet_getUChars(const UCharsetMatch *ucsm, UChar *buf, int32_t cap, UErrorCode *status);
UBool __cdecl ucsdet_isInputFilterEnabled(const UCharsetDetector *ucsd);
UCharsetDetector * __cdecl ucsdet_open(UErrorCode *status);
void __cdecl ucsdet_setDeclaredEncoding(UCharsetDetector *ucsd, const char *encoding, int32_t length, UErrorCode *status);
void __cdecl ucsdet_setText(UCharsetDetector *ucsd, const char *textIn, int32_t len, UErrorCode *status);
int32_t __cdecl ucurr_countCurrencies(const char *locale, UDate date, UErrorCode *ec);
int32_t __cdecl ucurr_forLocale(const char *locale, UChar *buff, int32_t buffCapacity, UErrorCode *ec);
int32_t __cdecl ucurr_forLocaleAndDate(const char *locale, UDate date, int32_t index, UChar *buff, int32_t buffCapacity, UErrorCode *ec);
int32_t __cdecl ucurr_getDefaultFractionDigits(const UChar *currency, UErrorCode *ec);
int32_t __cdecl ucurr_getDefaultFractionDigitsForUsage(const UChar *currency, const UCurrencyUsage usage, UErrorCode *ec);
UEnumeration * __cdecl ucurr_getKeywordValuesForLocale(const char *key, const char *locale, UBool commonlyUsed, UErrorCode *status);
const UChar * __cdecl ucurr_getName(const UChar *currency, const char *locale, UCurrNameStyle nameStyle, UBool *isChoiceFormat, int32_t *len, UErrorCode *ec);
int32_t __cdecl ucurr_getNumericCode(const UChar *currency);
const UChar * __cdecl ucurr_getPluralName(const UChar *currency, const char *locale, UBool *isChoiceFormat, const char *pluralCount, int32_t *len, UErrorCode *ec);
double __cdecl ucurr_getRoundingIncrement(const UChar *currency, UErrorCode *ec);
double __cdecl ucurr_getRoundingIncrementForUsage(const UChar *currency, const UCurrencyUsage usage, UErrorCode *ec);
UBool __cdecl ucurr_isAvailable(const UChar *isoCode, UDate from, UDate to, UErrorCode *errorCode);
UEnumeration * __cdecl ucurr_openISOCurrencies(uint32_t currType, UErrorCode *pErrorCode);
UCurrRegistryKey __cdecl ucurr_register(const UChar *isoCode, const char *locale, UErrorCode *status);
UBool __cdecl ucurr_unregister(UCurrRegistryKey key, UErrorCode *status);
void __cdecl udat_adoptNumberFormat(UDateFormat *fmt, UNumberFormat *numberFormatToAdopt);
void __cdecl udat_adoptNumberFormatForFields(UDateFormat *fmt, const UChar *fields, UNumberFormat *numberFormatToSet, UErrorCode *status);
void __cdecl udat_applyPattern(UDateFormat *format, UBool localized, const UChar *pattern, int32_t patternLength);
UDateFormat * __cdecl udat_clone(const UDateFormat *fmt, UErrorCode *status);
void __cdecl udat_close(UDateFormat *format);
int32_t __cdecl udat_countAvailable(void);
int32_t __cdecl udat_countSymbols(const UDateFormat *fmt, UDateFormatSymbolType type);
int32_t __cdecl udat_format(const UDateFormat *format, UDate dateToFormat, UChar *result, int32_t resultLength, UFieldPosition *position, UErrorCode *status);
int32_t __cdecl udat_formatCalendar(const UDateFormat *format, UCalendar *calendar, UChar *result, int32_t resultLength, UFieldPosition *position, UErrorCode *status);
int32_t __cdecl udat_formatCalendarForFields(const UDateFormat *format, UCalendar *calendar, UChar *result, int32_t resultLength, UFieldPositionIterator *fpositer, UErrorCode *status);
int32_t __cdecl udat_formatForFields(const UDateFormat *format, UDate dateToFormat, UChar *result, int32_t resultLength, UFieldPositionIterator *fpositer, UErrorCode *status);
UDate __cdecl udat_get2DigitYearStart(const UDateFormat *fmt, UErrorCode *status);
const char * __cdecl udat_getAvailable(int32_t index);
UBool __cdecl udat_getBooleanAttribute(const UDateFormat *fmt, UDateFormatBooleanAttribute attr, UErrorCode *status);
const UCalendar * __cdecl udat_getCalendar(const UDateFormat *fmt);
UDisplayContext __cdecl udat_getContext(const UDateFormat *fmt, UDisplayContextType type, UErrorCode *status);
const char * __cdecl udat_getLocaleByType(const UDateFormat *fmt, ULocDataLocaleType type, UErrorCode *status);
const UNumberFormat * __cdecl udat_getNumberFormat(const UDateFormat *fmt);
const UNumberFormat * __cdecl udat_getNumberFormatForField(const UDateFormat *fmt, UChar field);
int32_t __cdecl udat_getSymbols(const UDateFormat *fmt, UDateFormatSymbolType type, int32_t index, UChar *result, int32_t resultLength, UErrorCode *status);
UBool __cdecl udat_isLenient(const UDateFormat *fmt);
UDateFormat * __cdecl udat_open(UDateFormatStyle timeStyle, UDateFormatStyle dateStyle, const char *locale, const UChar *tzID, int32_t tzIDLength, const UChar *pattern, int32_t patternLength, UErrorCode *status);
UDate __cdecl udat_parse(const UDateFormat *format, const UChar *text, int32_t textLength, int32_t *parsePos, UErrorCode *status);
void __cdecl udat_parseCalendar(const UDateFormat *format, UCalendar *calendar, const UChar *text, int32_t textLength, int32_t *parsePos, UErrorCode *status);
void __cdecl udat_set2DigitYearStart(UDateFormat *fmt, UDate d, UErrorCode *status);
void __cdecl udat_setBooleanAttribute(UDateFormat *fmt, UDateFormatBooleanAttribute attr, UBool newValue, UErrorCode *status);
void __cdecl udat_setCalendar(UDateFormat *fmt, const UCalendar *calendarToSet);
void __cdecl udat_setContext(UDateFormat *fmt, UDisplayContext value, UErrorCode *status);
void __cdecl udat_setLenient(UDateFormat *fmt, UBool isLenient);
void __cdecl udat_setNumberFormat(UDateFormat *fmt, const UNumberFormat *numberFormatToSet);
void __cdecl udat_setSymbols(UDateFormat *format, UDateFormatSymbolType type, int32_t index, UChar *value, int32_t valueLength, UErrorCode *status);
UCalendarDateFields __cdecl udat_toCalendarDateField(UDateFormatField field);
int32_t __cdecl udat_toPattern(const UDateFormat *fmt, UBool localized, UChar *result, int32_t resultLength, UErrorCode *status);
UDateTimePatternConflict __cdecl udatpg_addPattern(UDateTimePatternGenerator *dtpg, const UChar *pattern, int32_t patternLength, UBool override, UChar *conflictingPattern, int32_t capacity, int32_t *pLength, UErrorCode *pErrorCode);
UDateTimePatternGenerator * __cdecl udatpg_clone(const UDateTimePatternGenerator *dtpg, UErrorCode *pErrorCode);
void __cdecl udatpg_close(UDateTimePatternGenerator *dtpg);
const UChar * __cdecl udatpg_getAppendItemFormat(const UDateTimePatternGenerator *dtpg, UDateTimePatternField field, int32_t *pLength);
const UChar * __cdecl udatpg_getAppendItemName(const UDateTimePatternGenerator *dtpg, UDateTimePatternField field, int32_t *pLength);
int32_t __cdecl udatpg_getBaseSkeleton(UDateTimePatternGenerator *arg0, const UChar *pattern, int32_t length, UChar *skeleton, int32_t capacity, UErrorCode *pErrorCode);
int32_t __cdecl udatpg_getBestPattern(UDateTimePatternGenerator *dtpg, const UChar *skeleton, int32_t length, UChar *bestPattern, int32_t capacity, UErrorCode *pErrorCode);
int32_t __cdecl udatpg_getBestPatternWithOptions(UDateTimePatternGenerator *dtpg, const UChar *skeleton, int32_t length, UDateTimePatternMatchOptions options, UChar *bestPattern, int32_t capacity, UErrorCode *pErrorCode);
const UChar * __cdecl udatpg_getDateTimeFormat(const UDateTimePatternGenerator *dtpg, int32_t *pLength);
const UChar * __cdecl udatpg_getDecimal(const UDateTimePatternGenerator *dtpg, int32_t *pLength);
int32_t __cdecl udatpg_getFieldDisplayName(const UDateTimePatternGenerator *dtpg, UDateTimePatternField field, UDateTimePGDisplayWidth width, UChar *fieldName, int32_t capacity, UErrorCode *pErrorCode);
const UChar * __cdecl udatpg_getPatternForSkeleton(const UDateTimePatternGenerator *dtpg, const UChar *skeleton, int32_t skeletonLength, int32_t *pLength);
int32_t __cdecl udatpg_getSkeleton(UDateTimePatternGenerator *arg0, const UChar *pattern, int32_t length, UChar *skeleton, int32_t capacity, UErrorCode *pErrorCode);
UDateTimePatternGenerator * __cdecl udatpg_open(const char *locale, UErrorCode *pErrorCode);
UEnumeration * __cdecl udatpg_openBaseSkeletons(const UDateTimePatternGenerator *dtpg, UErrorCode *pErrorCode);
UDateTimePatternGenerator * __cdecl udatpg_openEmpty(UErrorCode *pErrorCode);
UEnumeration * __cdecl udatpg_openSkeletons(const UDateTimePatternGenerator *dtpg, UErrorCode *pErrorCode);
int32_t __cdecl udatpg_replaceFieldTypes(UDateTimePatternGenerator *dtpg, const UChar *pattern, int32_t patternLength, const UChar *skeleton, int32_t skeletonLength, UChar *dest, int32_t destCapacity, UErrorCode *pErrorCode);
int32_t __cdecl udatpg_replaceFieldTypesWithOptions(UDateTimePatternGenerator *dtpg, const UChar *pattern, int32_t patternLength, const UChar *skeleton, int32_t skeletonLength, UDateTimePatternMatchOptions options, UChar *dest, int32_t destCapacity, UErrorCode *pErrorCode);
void __cdecl udatpg_setAppendItemFormat(UDateTimePatternGenerator *dtpg, UDateTimePatternField field, const UChar *value, int32_t length);
void __cdecl udatpg_setAppendItemName(UDateTimePatternGenerator *dtpg, UDateTimePatternField field, const UChar *value, int32_t length);
void __cdecl udatpg_setDateTimeFormat(const UDateTimePatternGenerator *dtpg, const UChar *dtFormat, int32_t length);
void __cdecl udatpg_setDecimal(UDateTimePatternGenerator *dtpg, const UChar *decimal, int32_t length);
void __cdecl udtitvfmt_close(UDateIntervalFormat *formatter);
int32_t __cdecl udtitvfmt_format(const UDateIntervalFormat *formatter, UDate fromDate, UDate toDate, UChar *result, int32_t resultCapacity, UFieldPosition *position, UErrorCode *status);
UDateIntervalFormat * __cdecl udtitvfmt_open(const char *locale, const UChar *skeleton, int32_t skeletonLength, const UChar *tzID, int32_t tzIDLength, UErrorCode *status);
void __cdecl uenum_close(UEnumeration *en);
int32_t __cdecl uenum_count(UEnumeration *en, UErrorCode *status);
const char * __cdecl uenum_next(UEnumeration *en, int32_t *resultLength, UErrorCode *status);
UEnumeration * __cdecl uenum_openCharStringsEnumeration(const char * const strings[], int32_t count, UErrorCode *ec);
UEnumeration * __cdecl uenum_openUCharStringsEnumeration(const UChar * const strings[], int32_t count, UErrorCode *ec);
void __cdecl uenum_reset(UEnumeration *en, UErrorCode *status);
const UChar * __cdecl uenum_unext(UEnumeration *en, int32_t *resultLength, UErrorCode *status);
void __cdecl ufieldpositer_close(UFieldPositionIterator *fpositer);
int32_t __cdecl ufieldpositer_next(UFieldPositionIterator *fpositer, int32_t *beginIndex, int32_t *endIndex);
UFieldPositionIterator * __cdecl ufieldpositer_open(UErrorCode *status);
void __cdecl ufmt_close(UFormattable *fmt);
UFormattable * __cdecl ufmt_getArrayItemByIndex(UFormattable *fmt, int32_t n, UErrorCode *status);
int32_t __cdecl ufmt_getArrayLength(const UFormattable *fmt, UErrorCode *status);
UDate __cdecl ufmt_getDate(const UFormattable *fmt, UErrorCode *status);
const char * __cdecl ufmt_getDecNumChars(UFormattable *fmt, int32_t *len, UErrorCode *status);
double __cdecl ufmt_getDouble(UFormattable *fmt, UErrorCode *status);
int64_t __cdecl ufmt_getInt64(UFormattable *fmt, UErrorCode *status);
int32_t __cdecl ufmt_getLong(UFormattable *fmt, UErrorCode *status);
const void * __cdecl ufmt_getObject(const UFormattable *fmt, UErrorCode *status);
UFormattableType __cdecl ufmt_getType(const UFormattable *fmt, UErrorCode *status);
const UChar * __cdecl ufmt_getUChars(UFormattable *fmt, int32_t *len, UErrorCode *status);
UBool __cdecl ufmt_isNumeric(const UFormattable *fmt);
UFormattable * __cdecl ufmt_open(UErrorCode *status);
const UGenderInfo * __cdecl ugender_getInstance(const char *locale, UErrorCode *status);
UGender __cdecl ugender_getListGender(const UGenderInfo *genderInfo, const UGender *genders, int32_t size, UErrorCode *status);
void __cdecl uidna_close(UIDNA *idna);
int32_t __cdecl uidna_labelToASCII(const UIDNA *idna, const UChar *label, int32_t length, UChar *dest, int32_t capacity, UIDNAInfo *pInfo, UErrorCode *pErrorCode);
int32_t __cdecl uidna_labelToASCII_UTF8(const UIDNA *idna, const char *label, int32_t length, char *dest, int32_t capacity, UIDNAInfo *pInfo, UErrorCode *pErrorCode);
int32_t __cdecl uidna_labelToUnicode(const UIDNA *idna, const UChar *label, int32_t length, UChar *dest, int32_t capacity, UIDNAInfo *pInfo, UErrorCode *pErrorCode);
int32_t __cdecl uidna_labelToUnicodeUTF8(const UIDNA *idna, const char *label, int32_t length, char *dest, int32_t capacity, UIDNAInfo *pInfo, UErrorCode *pErrorCode);
int32_t __cdecl uidna_nameToASCII(const UIDNA *idna, const UChar *name, int32_t length, UChar *dest, int32_t capacity, UIDNAInfo *pInfo, UErrorCode *pErrorCode);
int32_t __cdecl uidna_nameToASCII_UTF8(const UIDNA *idna, const char *name, int32_t length, char *dest, int32_t capacity, UIDNAInfo *pInfo, UErrorCode *pErrorCode);
int32_t __cdecl uidna_nameToUnicode(const UIDNA *idna, const UChar *name, int32_t length, UChar *dest, int32_t capacity, UIDNAInfo *pInfo, UErrorCode *pErrorCode);
int32_t __cdecl uidna_nameToUnicodeUTF8(const UIDNA *idna, const char *name, int32_t length, char *dest, int32_t capacity, UIDNAInfo *pInfo, UErrorCode *pErrorCode);
UIDNA * __cdecl uidna_openUTS46(uint32_t options, UErrorCode *pErrorCode);
UChar32 __cdecl uiter_current32(UCharIterator *iter);
uint32_t __cdecl uiter_getState(const UCharIterator *iter);
UChar32 __cdecl uiter_next32(UCharIterator *iter);
UChar32 __cdecl uiter_previous32(UCharIterator *iter);
void __cdecl uiter_setState(UCharIterator *iter, uint32_t state, UErrorCode *pErrorCode);
void __cdecl uiter_setString(UCharIterator *iter, const UChar *s, int32_t length);
void __cdecl uiter_setUTF16BE(UCharIterator *iter, const char *s, int32_t length);
void __cdecl uiter_setUTF8(UCharIterator *iter, const char *s, int32_t length);
void __cdecl uldn_close(ULocaleDisplayNames *ldn);
UDisplayContext __cdecl uldn_getContext(const ULocaleDisplayNames *ldn, UDisplayContextType type, UErrorCode *pErrorCode);
UDialectHandling __cdecl uldn_getDialectHandling(const ULocaleDisplayNames *ldn);
const char * __cdecl uldn_getLocale(const ULocaleDisplayNames *ldn);
int32_t __cdecl uldn_keyDisplayName(const ULocaleDisplayNames *ldn, const char *key, UChar *result, int32_t maxResultSize, UErrorCode *pErrorCode);
int32_t __cdecl uldn_keyValueDisplayName(const ULocaleDisplayNames *ldn, const char *key, const char *value, UChar *result, int32_t maxResultSize, UErrorCode *pErrorCode);
int32_t __cdecl uldn_languageDisplayName(const ULocaleDisplayNames *ldn, const char *lang, UChar *result, int32_t maxResultSize, UErrorCode *pErrorCode);
int32_t __cdecl uldn_localeDisplayName(const ULocaleDisplayNames *ldn, const char *locale, UChar *result, int32_t maxResultSize, UErrorCode *pErrorCode);
ULocaleDisplayNames * __cdecl uldn_open(const char *locale, UDialectHandling dialectHandling, UErrorCode *pErrorCode);
ULocaleDisplayNames * __cdecl uldn_openForContext(const char *locale, UDisplayContext *contexts, int32_t length, UErrorCode *pErrorCode);
int32_t __cdecl uldn_regionDisplayName(const ULocaleDisplayNames *ldn, const char *region, UChar *result, int32_t maxResultSize, UErrorCode *pErrorCode);
int32_t __cdecl uldn_scriptCodeDisplayName(const ULocaleDisplayNames *ldn, UScriptCode scriptCode, UChar *result, int32_t maxResultSize, UErrorCode *pErrorCode);
int32_t __cdecl uldn_scriptDisplayName(const ULocaleDisplayNames *ldn, const char *script, UChar *result, int32_t maxResultSize, UErrorCode *pErrorCode);
int32_t __cdecl uldn_variantDisplayName(const ULocaleDisplayNames *ldn, const char *variant, UChar *result, int32_t maxResultSize, UErrorCode *pErrorCode);
void __cdecl ulistfmt_close(UListFormatter *listfmt);
int32_t __cdecl ulistfmt_format(const UListFormatter *listfmt, const UChar * const strings[], const int32_t *stringLengths, int32_t stringCount, UChar *result, int32_t resultCapacity, UErrorCode *status);
UListFormatter * __cdecl ulistfmt_open(const char *locale, UErrorCode *status);
int32_t __cdecl uloc_acceptLanguage(char *result, int32_t resultAvailable, UAcceptResult *outResult, const char **acceptList, int32_t acceptListCount, UEnumeration *availableLocales, UErrorCode *status);
int32_t __cdecl uloc_acceptLanguageFromHTTP(char *result, int32_t resultAvailable, UAcceptResult *outResult, const char *httpAcceptLanguage, UEnumeration *availableLocales, UErrorCode *status);
int32_t __cdecl uloc_addLikelySubtags(const char *localeID, char *maximizedLocaleID, int32_t maximizedLocaleIDCapacity, UErrorCode *err);
int32_t __cdecl uloc_canonicalize(const char *localeID, char *name, int32_t nameCapacity, UErrorCode *err);
int32_t __cdecl uloc_countAvailable(void);
int32_t __cdecl uloc_forLanguageTag(const char *langtag, char *localeID, int32_t localeIDCapacity, int32_t *parsedLength, UErrorCode *status);
const char * __cdecl uloc_getAvailable(int32_t offset);
int32_t __cdecl uloc_getBaseName(const char *localeID, char *name, int32_t nameCapacity, UErrorCode *err);
ULayoutType __cdecl uloc_getCharacterOrientation(const char *localeId, UErrorCode *status);
int32_t __cdecl uloc_getCountry(const char *localeID, char *country, int32_t countryCapacity, UErrorCode *err);
const char * __cdecl uloc_getDefault(void);
int32_t __cdecl uloc_getDisplayCountry(const char *locale, const char *displayLocale, UChar *country, int32_t countryCapacity, UErrorCode *status);
int32_t __cdecl uloc_getDisplayKeyword(const char *keyword, const char *displayLocale, UChar *dest, int32_t destCapacity, UErrorCode *status);
int32_t __cdecl uloc_getDisplayKeywordValue(const char *locale, const char *keyword, const char *displayLocale, UChar *dest, int32_t destCapacity, UErrorCode *status);
int32_t __cdecl uloc_getDisplayLanguage(const char *locale, const char *displayLocale, UChar *language, int32_t languageCapacity, UErrorCode *status);
int32_t __cdecl uloc_getDisplayName(const char *localeID, const char *inLocaleID, UChar *result, int32_t maxResultSize, UErrorCode *err);
int32_t __cdecl uloc_getDisplayScript(const char *locale, const char *displayLocale, UChar *script, int32_t scriptCapacity, UErrorCode *status);
int32_t __cdecl uloc_getDisplayVariant(const char *locale, const char *displayLocale, UChar *variant, int32_t variantCapacity, UErrorCode *status);
const char * __cdecl uloc_getISO3Country(const char *localeID);
const char * __cdecl uloc_getISO3Language(const char *localeID);
const char * const * __cdecl uloc_getISOCountries(void);
const char * const * __cdecl uloc_getISOLanguages(void);
int32_t __cdecl uloc_getKeywordValue(const char *localeID, const char *keywordName, char *buffer, int32_t bufferCapacity, UErrorCode *status);
uint32_t __cdecl uloc_getLCID(const char *localeID);
int32_t __cdecl uloc_getLanguage(const char *localeID, char *language, int32_t languageCapacity, UErrorCode *err);
ULayoutType __cdecl uloc_getLineOrientation(const char *localeId, UErrorCode *status);
int32_t __cdecl uloc_getLocaleForLCID(uint32_t hostid, char *locale, int32_t localeCapacity, UErrorCode *status);
int32_t __cdecl uloc_getName(const char *localeID, char *name, int32_t nameCapacity, UErrorCode *err);
int32_t __cdecl uloc_getParent(const char *localeID, char *parent, int32_t parentCapacity, UErrorCode *err);
int32_t __cdecl uloc_getScript(const char *localeID, char *script, int32_t scriptCapacity, UErrorCode *err);
int32_t __cdecl uloc_getVariant(const char *localeID, char *variant, int32_t variantCapacity, UErrorCode *err);
UBool __cdecl uloc_isRightToLeft(const char *locale);
int32_t __cdecl uloc_minimizeSubtags(const char *localeID, char *minimizedLocaleID, int32_t minimizedLocaleIDCapacity, UErrorCode *err);
UEnumeration * __cdecl uloc_openKeywords(const char *localeID, UErrorCode *status);
void __cdecl uloc_setDefault(const char *newDefaultLocale, UErrorCode *err);
int32_t __cdecl uloc_setKeywordValue(const char *keywordName, const char *keywordValue, char *buffer, int32_t bufferCapacity, UErrorCode *status);
int32_t __cdecl uloc_toLanguageTag(const char *localeID, char *langtag, int32_t langtagCapacity, UBool strict, UErrorCode *status);
const char * __cdecl uloc_toLegacyKey(const char *keyword);
const char * __cdecl uloc_toLegacyType(const char *keyword, const char *value);
const char * __cdecl uloc_toUnicodeLocaleKey(const char *keyword);
const char * __cdecl uloc_toUnicodeLocaleType(const char *keyword, const char *value);
void __cdecl ulocdata_close(ULocaleData *uld);
void __cdecl ulocdata_getCLDRVersion(UVersionInfo versionArray, UErrorCode *status);
int32_t __cdecl ulocdata_getDelimiter(ULocaleData *uld, ULocaleDataDelimiterType type, UChar *result, int32_t resultLength, UErrorCode *status);
USet * __cdecl ulocdata_getExemplarSet(ULocaleData *uld, USet *fillIn, uint32_t options, ULocaleDataExemplarSetType extype, UErrorCode *status);
int32_t __cdecl ulocdata_getLocaleDisplayPattern(ULocaleData *uld, UChar *result, int32_t resultCapacity, UErrorCode *status);
int32_t __cdecl ulocdata_getLocaleSeparator(ULocaleData *uld, UChar *result, int32_t resultCapacity, UErrorCode *status);
UMeasurementSystem __cdecl ulocdata_getMeasurementSystem(const char *localeID, UErrorCode *status);
UBool __cdecl ulocdata_getNoSubstitute(ULocaleData *uld);
void __cdecl ulocdata_getPaperSize(const char *localeID, int32_t *height, int32_t *width, UErrorCode *status);
ULocaleData * __cdecl ulocdata_open(const char *localeID, UErrorCode *status);
void __cdecl ulocdata_setNoSubstitute(ULocaleData *uld, UBool setting);
void __cdecl umsg_applyPattern(UMessageFormat *fmt, const UChar *pattern, int32_t patternLength, UParseError *parseError, UErrorCode *status);
int32_t __cdecl umsg_autoQuoteApostrophe(const UChar *pattern, int32_t patternLength, UChar *dest, int32_t destCapacity, UErrorCode *ec);
UMessageFormat __cdecl umsg_clone(const UMessageFormat *fmt, UErrorCode *status);
void __cdecl umsg_close(UMessageFormat *format);
int32_t __cdecl umsg_format(const UMessageFormat *fmt, UChar *result, int32_t resultLength, UErrorCode *status, ...);
const char * __cdecl umsg_getLocale(const UMessageFormat *fmt);
UMessageFormat * __cdecl umsg_open(const UChar *pattern, int32_t patternLength, const char *locale, UParseError *parseError, UErrorCode *status);
void __cdecl umsg_parse(const UMessageFormat *fmt, const UChar *source, int32_t sourceLength, int32_t *count, UErrorCode *status, ...);
void __cdecl umsg_setLocale(UMessageFormat *fmt, const char *locale);
int32_t __cdecl umsg_toPattern(const UMessageFormat *fmt, UChar *result, int32_t resultLength, UErrorCode *status);
int32_t __cdecl umsg_vformat(const UMessageFormat *fmt, UChar *result, int32_t resultLength, va_list ap, UErrorCode *status);
void __cdecl umsg_vparse(const UMessageFormat *fmt, const UChar *source, int32_t sourceLength, int32_t *count, va_list ap, UErrorCode *status);
int32_t __cdecl unorm2_append(const UNormalizer2 *norm2, UChar *first, int32_t firstLength, int32_t firstCapacity, const UChar *second, int32_t secondLength, UErrorCode *pErrorCode);
void __cdecl unorm2_close(UNormalizer2 *norm2);
UChar32 __cdecl unorm2_composePair(const UNormalizer2 *norm2, UChar32 a, UChar32 b);
uint8_t __cdecl unorm2_getCombiningClass(const UNormalizer2 *norm2, UChar32 c);
int32_t __cdecl unorm2_getDecomposition(const UNormalizer2 *norm2, UChar32 c, UChar *decomposition, int32_t capacity, UErrorCode *pErrorCode);
const UNormalizer2 * __cdecl unorm2_getInstance(const char *packageName, const char *name, UNormalization2Mode mode, UErrorCode *pErrorCode);
const UNormalizer2 * __cdecl unorm2_getNFCInstance(UErrorCode *pErrorCode);
const UNormalizer2 * __cdecl unorm2_getNFDInstance(UErrorCode *pErrorCode);
const UNormalizer2 * __cdecl unorm2_getNFKCCasefoldInstance(UErrorCode *pErrorCode);
const UNormalizer2 * __cdecl unorm2_getNFKCInstance(UErrorCode *pErrorCode);
const UNormalizer2 * __cdecl unorm2_getNFKDInstance(UErrorCode *pErrorCode);
int32_t __cdecl unorm2_getRawDecomposition(const UNormalizer2 *norm2, UChar32 c, UChar *decomposition, int32_t capacity, UErrorCode *pErrorCode);
UBool __cdecl unorm2_hasBoundaryAfter(const UNormalizer2 *norm2, UChar32 c);
UBool __cdecl unorm2_hasBoundaryBefore(const UNormalizer2 *norm2, UChar32 c);
UBool __cdecl unorm2_isInert(const UNormalizer2 *norm2, UChar32 c);
UBool __cdecl unorm2_isNormalized(const UNormalizer2 *norm2, const UChar *s, int32_t length, UErrorCode *pErrorCode);
int32_t __cdecl unorm2_normalize(const UNormalizer2 *norm2, const UChar *src, int32_t length, UChar *dest, int32_t capacity, UErrorCode *pErrorCode);
int32_t __cdecl unorm2_normalizeSecondAndAppend(const UNormalizer2 *norm2, UChar *first, int32_t firstLength, int32_t firstCapacity, const UChar *second, int32_t secondLength, UErrorCode *pErrorCode);
UNormalizer2 * __cdecl unorm2_openFiltered(const UNormalizer2 *norm2, const USet *filterSet, UErrorCode *pErrorCode);
UNormalizationCheckResult __cdecl unorm2_quickCheck(const UNormalizer2 *norm2, const UChar *s, int32_t length, UErrorCode *pErrorCode);
int32_t __cdecl unorm2_spanQuickCheckYes(const UNormalizer2 *norm2, const UChar *s, int32_t length, UErrorCode *pErrorCode);
int32_t __cdecl unorm_compare(const UChar *s1, int32_t length1, const UChar *s2, int32_t length2, uint32_t options, UErrorCode *pErrorCode);
void __cdecl unum_applyPattern(UNumberFormat *fmt, UBool localized, const UChar *pattern, int32_t patternLength, UParseError *parseError, UErrorCode *status);
UNumberFormat * __cdecl unum_clone(const UNumberFormat *fmt, UErrorCode *status);
void __cdecl unum_close(UNumberFormat *fmt);
int32_t __cdecl unum_countAvailable(void);
int32_t __cdecl unum_format(const UNumberFormat *fmt, int32_t number, UChar *result, int32_t resultLength, UFieldPosition *pos, UErrorCode *status);
int32_t __cdecl unum_formatDecimal(const UNumberFormat *fmt, const char *number, int32_t length, UChar *result, int32_t resultLength, UFieldPosition *pos, UErrorCode *status);
int32_t __cdecl unum_formatDouble(const UNumberFormat *fmt, double number, UChar *result, int32_t resultLength, UFieldPosition *pos, UErrorCode *status);
int32_t __cdecl unum_formatDoubleCurrency(const UNumberFormat *fmt, double number, UChar *currency, UChar *result, int32_t resultLength, UFieldPosition *pos, UErrorCode *status);
int32_t __cdecl unum_formatDoubleForFields(const UNumberFormat *format, double number, UChar *result, int32_t resultLength, UFieldPositionIterator *fpositer, UErrorCode *status);
int32_t __cdecl unum_formatInt64(const UNumberFormat *fmt, int64_t number, UChar *result, int32_t resultLength, UFieldPosition *pos, UErrorCode *status);
int32_t __cdecl unum_formatUFormattable(const UNumberFormat *fmt, const UFormattable *number, UChar *result, int32_t resultLength, UFieldPosition *pos, UErrorCode *status);
int32_t __cdecl unum_getAttribute(const UNumberFormat *fmt, UNumberFormatAttribute attr);
const char * __cdecl unum_getAvailable(int32_t index);
UDisplayContext __cdecl unum_getContext(const UNumberFormat *fmt, UDisplayContextType type, UErrorCode *status);
double __cdecl unum_getDoubleAttribute(const UNumberFormat *fmt, UNumberFormatAttribute attr);
const char * __cdecl unum_getLocaleByType(const UNumberFormat *fmt, ULocDataLocaleType type, UErrorCode *status);
int32_t __cdecl unum_getSymbol(const UNumberFormat *fmt, UNumberFormatSymbol symbol, UChar *buffer, int32_t size, UErrorCode *status);
int32_t __cdecl unum_getTextAttribute(const UNumberFormat *fmt, UNumberFormatTextAttribute tag, UChar *result, int32_t resultLength, UErrorCode *status);
UNumberFormat * __cdecl unum_open(UNumberFormatStyle style, const UChar *pattern, int32_t patternLength, const char *locale, UParseError *parseErr, UErrorCode *status);
int32_t __cdecl unum_parse(const UNumberFormat *fmt, const UChar *text, int32_t textLength, int32_t *parsePos, UErrorCode *status);
int32_t __cdecl unum_parseDecimal(const UNumberFormat *fmt, const UChar *text, int32_t textLength, int32_t *parsePos, char *outBuf, int32_t outBufLength, UErrorCode *status);
double __cdecl unum_parseDouble(const UNumberFormat *fmt, const UChar *text, int32_t textLength, int32_t *parsePos, UErrorCode *status);
double __cdecl unum_parseDoubleCurrency(const UNumberFormat *fmt, const UChar *text, int32_t textLength, int32_t *parsePos, UChar *currency, UErrorCode *status);
int64_t __cdecl unum_parseInt64(const UNumberFormat *fmt, const UChar *text, int32_t textLength, int32_t *parsePos, UErrorCode *status);
UFormattable * __cdecl unum_parseToUFormattable(const UNumberFormat *fmt, UFormattable *result, const UChar *text, int32_t textLength, int32_t *parsePos, UErrorCode *status);
void __cdecl unum_setAttribute(UNumberFormat *fmt, UNumberFormatAttribute attr, int32_t newValue);
void __cdecl unum_setContext(UNumberFormat *fmt, UDisplayContext value, UErrorCode *status);
void __cdecl unum_setDoubleAttribute(UNumberFormat *fmt, UNumberFormatAttribute attr, double newValue);
void __cdecl unum_setSymbol(UNumberFormat *fmt, UNumberFormatSymbol symbol, const UChar *value, int32_t length, UErrorCode *status);
void __cdecl unum_setTextAttribute(UNumberFormat *fmt, UNumberFormatTextAttribute tag, const UChar *newValue, int32_t newValueLength, UErrorCode *status);
int32_t __cdecl unum_toPattern(const UNumberFormat *fmt, UBool isPatternLocalized, UChar *result, int32_t resultLength, UErrorCode *status);
void __cdecl unumf_close(UNumberFormatter *f);
void __cdecl unumf_closeResult(UFormattedNumber *uresult);
void __cdecl unumf_formatDecimal(const UNumberFormatter *uformatter, const char *value, int32_t valueLen, UFormattedNumber *uresult, UErrorCode *ec);
void __cdecl unumf_formatDouble(const UNumberFormatter *uformatter, double value, UFormattedNumber *uresult, UErrorCode *ec);
void __cdecl unumf_formatInt(const UNumberFormatter *uformatter, int64_t value, UFormattedNumber *uresult, UErrorCode *ec);
UNumberFormatter * __cdecl unumf_openForSkeletonAndLocale(const UChar *skeleton, int32_t skeletonLen, const char *locale, UErrorCode *ec);
UFormattedNumber * __cdecl unumf_openResult(UErrorCode *ec);
void __cdecl unumf_resultGetAllFieldPositions(const UFormattedNumber *uresult, UFieldPositionIterator *ufpositer, UErrorCode *ec);
UBool __cdecl unumf_resultNextFieldPosition(const UFormattedNumber *uresult, UFieldPosition *ufpos, UErrorCode *ec);
int32_t __cdecl unumf_resultToString(const UFormattedNumber *uresult, UChar *buffer, int32_t bufferCapacity, UErrorCode *ec);
void __cdecl unumsys_close(UNumberingSystem *unumsys);
int32_t __cdecl unumsys_getDescription(const UNumberingSystem *unumsys, UChar *result, int32_t resultLength, UErrorCode *status);
const char * __cdecl unumsys_getName(const UNumberingSystem *unumsys);
int32_t __cdecl unumsys_getRadix(const UNumberingSystem *unumsys);
UBool __cdecl unumsys_isAlgorithmic(const UNumberingSystem *unumsys);
UNumberingSystem * __cdecl unumsys_open(const char *locale, UErrorCode *status);
UEnumeration * __cdecl unumsys_openAvailableNames(UErrorCode *status);
UNumberingSystem * __cdecl unumsys_openByName(const char *name, UErrorCode *status);
void __cdecl uplrules_close(UPluralRules *uplrules);
UEnumeration * __cdecl uplrules_getKeywords(const UPluralRules *uplrules, UErrorCode *status);
UPluralRules * __cdecl uplrules_open(const char *locale, UErrorCode *status);
UPluralRules * __cdecl uplrules_openForType(const char *locale, UPluralType type, UErrorCode *status);
int32_t __cdecl uplrules_select(const UPluralRules *uplrules, double number, UChar *keyword, int32_t capacity, UErrorCode *status);
int32_t __cdecl uregex_appendReplacement(URegularExpression *regexp2, const UChar *replacementText, int32_t replacementLength, UChar **destBuf, int32_t *destCapacity, UErrorCode *status);
void __cdecl uregex_appendReplacementUText(URegularExpression *regexp2, UText *replText, UText *dest, UErrorCode *status);
int32_t __cdecl uregex_appendTail(URegularExpression *regexp2, UChar **destBuf, int32_t *destCapacity, UErrorCode *status);
UText * __cdecl uregex_appendTailUText(URegularExpression *regexp2, UText *dest, UErrorCode *status);
URegularExpression * __cdecl uregex_clone(const URegularExpression *source2, UErrorCode *status);
void __cdecl uregex_close(URegularExpression *re2);
int32_t __cdecl uregex_end(URegularExpression *regexp2, int32_t groupNum, UErrorCode *status);
int64_t __cdecl uregex_end64(URegularExpression *regexp2, int32_t groupNum, UErrorCode *status);
UBool __cdecl uregex_find(URegularExpression *regexp2, int32_t startIndex, UErrorCode *status);
UBool __cdecl uregex_find64(URegularExpression *regexp2, int64_t startIndex, UErrorCode *status);
UBool __cdecl uregex_findNext(URegularExpression *regexp2, UErrorCode *status);
int32_t __cdecl uregex_flags(const URegularExpression *regexp2, UErrorCode *status);
void __cdecl uregex_getFindProgressCallback(const URegularExpression *regexp2, URegexFindProgressCallback **callback, const void **context, UErrorCode *status);
void __cdecl uregex_getMatchCallback(const URegularExpression *regexp2, URegexMatchCallback **callback, const void **context, UErrorCode *status);
int32_t __cdecl uregex_getStackLimit(const URegularExpression *regexp2, UErrorCode *status);
const UChar * __cdecl uregex_getText(URegularExpression *regexp2, int32_t *textLength, UErrorCode *status);
int32_t __cdecl uregex_getTimeLimit(const URegularExpression *regexp2, UErrorCode *status);
UText * __cdecl uregex_getUText(URegularExpression *regexp2, UText *dest, UErrorCode *status);
int32_t __cdecl uregex_group(URegularExpression *regexp2, int32_t groupNum, UChar *dest, int32_t destCapacity, UErrorCode *status);
int32_t __cdecl uregex_groupCount(URegularExpression *regexp2, UErrorCode *status);
int32_t __cdecl uregex_groupNumberFromCName(URegularExpression *regexp2, const char *groupName, int32_t nameLength, UErrorCode *status);
int32_t __cdecl uregex_groupNumberFromName(URegularExpression *regexp2, const UChar *groupName, int32_t nameLength, UErrorCode *status);
UText * __cdecl uregex_groupUText(URegularExpression *regexp2, int32_t groupNum, UText *dest, int64_t *groupLength, UErrorCode *status);
UBool __cdecl uregex_hasAnchoringBounds(const URegularExpression *regexp2, UErrorCode *status);
UBool __cdecl uregex_hasTransparentBounds(const URegularExpression *regexp2, UErrorCode *status);
UBool __cdecl uregex_hitEnd(const URegularExpression *regexp2, UErrorCode *status);
UBool __cdecl uregex_lookingAt(URegularExpression *regexp2, int32_t startIndex, UErrorCode *status);
UBool __cdecl uregex_lookingAt64(URegularExpression *regexp2, int64_t startIndex, UErrorCode *status);
UBool __cdecl uregex_matches(URegularExpression *regexp2, int32_t startIndex, UErrorCode *status);
UBool __cdecl uregex_matches64(URegularExpression *regexp2, int64_t startIndex, UErrorCode *status);
URegularExpression * __cdecl uregex_open(const UChar *pattern, int32_t patternLength, uint32_t flags, UParseError *pe, UErrorCode *status);
URegularExpression * __cdecl uregex_openC(const char *pattern, uint32_t flags, UParseError *pe, UErrorCode *status);
URegularExpression * __cdecl uregex_openUText(UText *pattern, uint32_t flags, UParseError *pe, UErrorCode *status);
const UChar * __cdecl uregex_pattern(const URegularExpression *regexp2, int32_t *patLength, UErrorCode *status);
UText * __cdecl uregex_patternUText(const URegularExpression *regexp2, UErrorCode *status);
void __cdecl uregex_refreshUText(URegularExpression *regexp2, UText *text, UErrorCode *status);
int32_t __cdecl uregex_regionEnd(const URegularExpression *regexp2, UErrorCode *status);
int64_t __cdecl uregex_regionEnd64(const URegularExpression *regexp2, UErrorCode *status);
int32_t __cdecl uregex_regionStart(const URegularExpression *regexp2, UErrorCode *status);
int64_t __cdecl uregex_regionStart64(const URegularExpression *regexp2, UErrorCode *status);
int32_t __cdecl uregex_replaceAll(URegularExpression *regexp2, const UChar *replacementText, int32_t replacementLength, UChar *destBuf, int32_t destCapacity, UErrorCode *status);
UText * __cdecl uregex_replaceAllUText(URegularExpression *regexp2, UText *replacementText, UText *dest, UErrorCode *status);
int32_t __cdecl uregex_replaceFirst(URegularExpression *regexp2, const UChar *replacementText, int32_t replacementLength, UChar *destBuf, int32_t destCapacity, UErrorCode *status);
UText * __cdecl uregex_replaceFirstUText(URegularExpression *regexp2, UText *replacementText, UText *dest, UErrorCode *status);
UBool __cdecl uregex_requireEnd(const URegularExpression *regexp2, UErrorCode *status);
void __cdecl uregex_reset(URegularExpression *regexp2, int32_t index, UErrorCode *status);
void __cdecl uregex_reset64(URegularExpression *regexp2, int64_t index, UErrorCode *status);
void __cdecl uregex_setFindProgressCallback(URegularExpression *regexp2, URegexFindProgressCallback *callback, const void *context, UErrorCode *status);
void __cdecl uregex_setMatchCallback(URegularExpression *regexp2, URegexMatchCallback *callback, const void *context, UErrorCode *status);
void __cdecl uregex_setRegion(URegularExpression *regexp2, int32_t regionStart, int32_t regionLimit, UErrorCode *status);
void __cdecl uregex_setRegion64(URegularExpression *regexp2, int64_t regionStart, int64_t regionLimit, UErrorCode *status);
void __cdecl uregex_setRegionAndStart(URegularExpression *regexp2, int64_t regionStart, int64_t regionLimit, int64_t startIndex, UErrorCode *status);
void __cdecl uregex_setStackLimit(URegularExpression *regexp2, int32_t limit, UErrorCode *status);
void __cdecl uregex_setText(URegularExpression *regexp2, const UChar *text, int32_t textLength, UErrorCode *status);
void __cdecl uregex_setTimeLimit(URegularExpression *regexp2, int32_t limit, UErrorCode *status);
void __cdecl uregex_setUText(URegularExpression *regexp2, UText *text, UErrorCode *status);
int32_t __cdecl uregex_split(URegularExpression *regexp2, UChar *destBuf, int32_t destCapacity, int32_t *requiredCapacity, UChar *destFields[], int32_t destFieldsCapacity, UErrorCode *status);
int32_t __cdecl uregex_splitUText(URegularExpression *regexp2, UText *destFields[], int32_t destFieldsCapacity, UErrorCode *status);
int32_t __cdecl uregex_start(URegularExpression *regexp2, int32_t groupNum, UErrorCode *status);
int64_t __cdecl uregex_start64(URegularExpression *regexp2, int32_t groupNum, UErrorCode *status);
void __cdecl uregex_useAnchoringBounds(URegularExpression *regexp2, UBool b, UErrorCode *status);
void __cdecl uregex_useTransparentBounds(URegularExpression *regexp2, UBool b, UErrorCode *status);
UBool __cdecl uregion_areEqual(const URegion *uregion, const URegion *otherRegion);
UBool __cdecl uregion_contains(const URegion *uregion, const URegion *otherRegion);
UEnumeration * __cdecl uregion_getAvailable(URegionType type, UErrorCode *status);
UEnumeration * __cdecl uregion_getContainedRegions(const URegion *uregion, UErrorCode *status);
UEnumeration * __cdecl uregion_getContainedRegionsOfType(const URegion *uregion, URegionType type, UErrorCode *status);
const URegion * __cdecl uregion_getContainingRegion(const URegion *uregion);
const URegion * __cdecl uregion_getContainingRegionOfType(const URegion *uregion, URegionType type);
int32_t __cdecl uregion_getNumericCode(const URegion *uregion);
UEnumeration * __cdecl uregion_getPreferredValues(const URegion *uregion, UErrorCode *status);
const char * __cdecl uregion_getRegionCode(const URegion *uregion);
const URegion * __cdecl uregion_getRegionFromCode(const char *regionCode, UErrorCode *status);
const URegion * __cdecl uregion_getRegionFromNumericCode(int32_t code, UErrorCode *status);
URegionType __cdecl uregion_getType(const URegion *uregion);
void __cdecl ureldatefmt_close(URelativeDateTimeFormatter *reldatefmt);
int32_t __cdecl ureldatefmt_combineDateAndTime(const URelativeDateTimeFormatter *reldatefmt, const UChar *relativeDateString, int32_t relativeDateStringLen, const UChar *timeString, int32_t timeStringLen, UChar *result, int32_t resultCapacity, UErrorCode *status);
int32_t __cdecl ureldatefmt_format(const URelativeDateTimeFormatter *reldatefmt, double offset, URelativeDateTimeUnit unit, UChar *result, int32_t resultCapacity, UErrorCode *status);
int32_t __cdecl ureldatefmt_formatNumeric(const URelativeDateTimeFormatter *reldatefmt, double offset, URelativeDateTimeUnit unit, UChar *result, int32_t resultCapacity, UErrorCode *status);
URelativeDateTimeFormatter * __cdecl ureldatefmt_open(const char *locale, UNumberFormat *nfToAdopt, UDateRelativeDateTimeFormatterStyle width, UDisplayContext capitalizationContext, UErrorCode *status);
void __cdecl ures_close(UResourceBundle *resB);
const uint8_t * __cdecl ures_getBinary(const UResourceBundle *resB, int32_t *len, UErrorCode *status);
UResourceBundle * __cdecl ures_getByIndex(const UResourceBundle *resB, int32_t indexR, UResourceBundle *fillIn, UErrorCode *status);
UResourceBundle * __cdecl ures_getByKey(const UResourceBundle *resB, const char *inKey, UResourceBundle *fillIn, UErrorCode *status);
int32_t __cdecl ures_getInt(const UResourceBundle *resB, UErrorCode *status);
const int32_t * __cdecl ures_getIntVector(const UResourceBundle *resB, int32_t *len, UErrorCode *status);
const char * __cdecl ures_getKey(const UResourceBundle *resB);
const char * __cdecl ures_getLocaleByType(const UResourceBundle *resourceBundle, ULocDataLocaleType type, UErrorCode *status);
UResourceBundle * __cdecl ures_getNextResource(UResourceBundle *resB, UResourceBundle *fillIn, UErrorCode *status);
const UChar * __cdecl ures_getNextString(UResourceBundle *resB, int32_t *len, const char **key, UErrorCode *status);
int32_t __cdecl ures_getSize(const UResourceBundle *resB);
const UChar * __cdecl ures_getString(const UResourceBundle *resB, int32_t *len, UErrorCode *status);
const UChar * __cdecl ures_getStringByIndex(const UResourceBundle *resB, int32_t indexS, int32_t *len, UErrorCode *status);
const UChar * __cdecl ures_getStringByKey(const UResourceBundle *resB, const char *inKey, int32_t *len, UErrorCode *status);
UResType __cdecl ures_getType(const UResourceBundle *resB);
uint32_t __cdecl ures_getUInt(const UResourceBundle *resB, UErrorCode *status);
const char * __cdecl ures_getUTF8String(const UResourceBundle *resB, char *dest, int32_t *pLength, UBool forceCopy, UErrorCode *status);
const char * __cdecl ures_getUTF8StringByIndex(const UResourceBundle *resB, int32_t idx, char *dest, int32_t *pLength, UBool forceCopy, UErrorCode *status);
const char * __cdecl ures_getUTF8StringByKey(const UResourceBundle *resB, const char *key, char *dest, int32_t *pLength, UBool forceCopy, UErrorCode *status);
void __cdecl ures_getVersion(const UResourceBundle *resB, UVersionInfo versionInfo);
UBool __cdecl ures_hasNext(const UResourceBundle *resB);
UResourceBundle * __cdecl ures_open(const char *path, const char *localeID, UErrorCode *status);
UEnumeration * __cdecl ures_openAvailableLocales(const char *path, UErrorCode *status);
UResourceBundle * __cdecl ures_openDirect(const char *path, const char *localeID, UErrorCode *status);
UResourceBundle * __cdecl ures_openU(const UChar *myPath, const char *localeID, UErrorCode *status);
void __cdecl ures_resetIterator(UResourceBundle *resB);
UBool __cdecl uscript_breaksBetweenLetters(UScriptCode script);
int32_t __cdecl uscript_getCode(const char *nameOrAbbrOrLocale, UScriptCode *fillIn, int32_t capacity, UErrorCode *err);
const char * __cdecl uscript_getName(UScriptCode scriptCode);
int32_t __cdecl uscript_getSampleString(UScriptCode script, UChar *dest, int32_t capacity, UErrorCode *pErrorCode);
UScriptCode __cdecl uscript_getScript(UChar32 c, UErrorCode *pErrorCode);
int32_t __cdecl uscript_getScriptExtensions(UChar32 c, UScriptCode *scripts, int32_t capacity, UErrorCode *pErrorCode);
const char * __cdecl uscript_getShortName(UScriptCode scriptCode);
UScriptUsage __cdecl uscript_getUsage(UScriptCode script);
UBool __cdecl uscript_hasScript(UChar32 c, UScriptCode sc);
UBool __cdecl uscript_isCased(UScriptCode script);
UBool __cdecl uscript_isRightToLeft(UScriptCode script);
void __cdecl usearch_close(UStringSearch *searchiter);
int32_t __cdecl usearch_first(UStringSearch *strsrch, UErrorCode *status);
int32_t __cdecl usearch_following(UStringSearch *strsrch, int32_t position, UErrorCode *status);
USearchAttributeValue __cdecl usearch_getAttribute(const UStringSearch *strsrch, USearchAttribute attribute);
const UBreakIterator * __cdecl usearch_getBreakIterator(const UStringSearch *strsrch);
UCollator * __cdecl usearch_getCollator(const UStringSearch *strsrch);
int32_t __cdecl usearch_getMatchedLength(const UStringSearch *strsrch);
int32_t __cdecl usearch_getMatchedStart(const UStringSearch *strsrch);
int32_t __cdecl usearch_getMatchedText(const UStringSearch *strsrch, UChar *result, int32_t resultCapacity, UErrorCode *status);
int32_t __cdecl usearch_getOffset(const UStringSearch *strsrch);
const UChar * __cdecl usearch_getPattern(const UStringSearch *strsrch, int32_t *length);
const UChar * __cdecl usearch_getText(const UStringSearch *strsrch, int32_t *length);
int32_t __cdecl usearch_last(UStringSearch *strsrch, UErrorCode *status);
int32_t __cdecl usearch_next(UStringSearch *strsrch, UErrorCode *status);
UStringSearch * __cdecl usearch_open(const UChar *pattern, int32_t patternlength, const UChar *text, int32_t textlength, const char *locale, UBreakIterator *breakiter, UErrorCode *status);
UStringSearch * __cdecl usearch_openFromCollator(const UChar *pattern, int32_t patternlength, const UChar *text, int32_t textlength, const UCollator *collator, UBreakIterator *breakiter, UErrorCode *status);
int32_t __cdecl usearch_preceding(UStringSearch *strsrch, int32_t position, UErrorCode *status);
int32_t __cdecl usearch_previous(UStringSearch *strsrch, UErrorCode *status);
void __cdecl usearch_reset(UStringSearch *strsrch);
void __cdecl usearch_setAttribute(UStringSearch *strsrch, USearchAttribute attribute, USearchAttributeValue value, UErrorCode *status);
void __cdecl usearch_setBreakIterator(UStringSearch *strsrch, UBreakIterator *breakiter, UErrorCode *status);
void __cdecl usearch_setCollator(UStringSearch *strsrch, const UCollator *collator, UErrorCode *status);
void __cdecl usearch_setOffset(UStringSearch *strsrch, int32_t position, UErrorCode *status);
void __cdecl usearch_setPattern(UStringSearch *strsrch, const UChar *pattern, int32_t patternlength, UErrorCode *status);
void __cdecl usearch_setText(UStringSearch *strsrch, const UChar *text, int32_t textlength, UErrorCode *status);
void __cdecl uset_add(USet *set, UChar32 c);
void __cdecl uset_addAll(USet *set, const USet *additionalSet);
void __cdecl uset_addAllCodePoints(USet *set, const UChar *str, int32_t strLen);
void __cdecl uset_addRange(USet *set, UChar32 start, UChar32 end);
void __cdecl uset_addString(USet *set, const UChar *str, int32_t strLen);
void __cdecl uset_applyIntPropertyValue(USet *set, UProperty prop, int32_t value, UErrorCode *ec);
int32_t __cdecl uset_applyPattern(USet *set, const UChar *pattern, int32_t patternLength, uint32_t options, UErrorCode *status);
void __cdecl uset_applyPropertyAlias(USet *set, const UChar *prop, int32_t propLength, const UChar *value, int32_t valueLength, UErrorCode *ec);
UChar32 __cdecl uset_charAt(const USet *set, int32_t index);
void __cdecl uset_clear(USet *set);
USet * __cdecl uset_clone(const USet *set);
USet * __cdecl uset_cloneAsThawed(const USet *set);
void __cdecl uset_close(USet *set);
void __cdecl uset_closeOver(USet *set, int32_t attributes);
void __cdecl uset_compact(USet *set);
void __cdecl uset_complement(USet *set);
void __cdecl uset_complementAll(USet *set, const USet *complement);
UBool __cdecl uset_contains(const USet *set, UChar32 c);
UBool __cdecl uset_containsAll(const USet *set1, const USet *set2);
UBool __cdecl uset_containsAllCodePoints(const USet *set, const UChar *str, int32_t strLen);
UBool __cdecl uset_containsNone(const USet *set1, const USet *set2);
UBool __cdecl uset_containsRange(const USet *set, UChar32 start, UChar32 end);
UBool __cdecl uset_containsSome(const USet *set1, const USet *set2);
UBool __cdecl uset_containsString(const USet *set, const UChar *str, int32_t strLen);
UBool __cdecl uset_equals(const USet *set1, const USet *set2);
void __cdecl uset_freeze(USet *set);
int32_t __cdecl uset_getItem(const USet *uset, int32_t itemIndex, UChar32 *start, UChar32 *end, UChar *str, int32_t strCapacity, UErrorCode *ec);
int32_t __cdecl uset_getItemCount(const USet *uset);
UBool __cdecl uset_getSerializedRange(const USerializedSet *set, int32_t rangeIndex, UChar32 *pStart, UChar32 *pEnd);
int32_t __cdecl uset_getSerializedRangeCount(const USerializedSet *set);
UBool __cdecl uset_getSerializedSet(USerializedSet *fillSet, const uint16_t *src, int32_t srcLength);
int32_t __cdecl uset_indexOf(const USet *set, UChar32 c);
UBool __cdecl uset_isEmpty(const USet *set);
UBool __cdecl uset_isFrozen(const USet *set);
USet * __cdecl uset_open(UChar32 start, UChar32 end);
USet * __cdecl uset_openEmpty(void);
USet * __cdecl uset_openPattern(const UChar *pattern, int32_t patternLength, UErrorCode *ec);
USet * __cdecl uset_openPatternOptions(const UChar *pattern, int32_t patternLength, uint32_t options, UErrorCode *ec);
void __cdecl uset_remove(USet *set, UChar32 c);
void __cdecl uset_removeAll(USet *set, const USet *remove);
void __cdecl uset_removeAllStrings(USet *set);
void __cdecl uset_removeRange(USet *set, UChar32 start, UChar32 end);
void __cdecl uset_removeString(USet *set, const UChar *str, int32_t strLen);
UBool __cdecl uset_resemblesPattern(const UChar *pattern, int32_t patternLength, int32_t pos);
void __cdecl uset_retain(USet *set, UChar32 start, UChar32 end);
void __cdecl uset_retainAll(USet *set, const USet *retain);
int32_t __cdecl uset_serialize(const USet *set, uint16_t *dest, int32_t destCapacity, UErrorCode *ec);
UBool __cdecl uset_serializedContains(const USerializedSet *set, UChar32 c);
void __cdecl uset_set(USet *set, UChar32 start, UChar32 end);
void __cdecl uset_setSerializedToOne(USerializedSet *fillSet, UChar32 c);
int32_t __cdecl uset_size(const USet *set);
int32_t __cdecl uset_span(const USet *set, const UChar *s, int32_t length, USetSpanCondition spanCondition);
int32_t __cdecl uset_spanBack(const USet *set, const UChar *s, int32_t length, USetSpanCondition spanCondition);
int32_t __cdecl uset_spanBackUTF8(const USet *set, const char *s, int32_t length, USetSpanCondition spanCondition);
int32_t __cdecl uset_spanUTF8(const USet *set, const char *s, int32_t length, USetSpanCondition spanCondition);
int32_t __cdecl uset_toPattern(const USet *set, UChar *result, int32_t resultCapacity, UBool escapeUnprintable, UErrorCode *ec);
int32_t __cdecl uspoof_areConfusable(const USpoofChecker *sc, const UChar *id1, int32_t length1, const UChar *id2, int32_t length2, UErrorCode *status);
int32_t __cdecl uspoof_areConfusableUTF8(const USpoofChecker *sc, const char *id1, int32_t length1, const char *id2, int32_t length2, UErrorCode *status);
int32_t __cdecl uspoof_check(const USpoofChecker *sc, const UChar *id, int32_t length, int32_t *position, UErrorCode *status);
int32_t __cdecl uspoof_check2(const USpoofChecker *sc, const UChar *id, int32_t length, USpoofCheckResult *checkResult, UErrorCode *status);
int32_t __cdecl uspoof_check2UTF8(const USpoofChecker *sc, const char *id, int32_t length, USpoofCheckResult *checkResult, UErrorCode *status);
int32_t __cdecl uspoof_checkUTF8(const USpoofChecker *sc, const char *id, int32_t length, int32_t *position, UErrorCode *status);
USpoofChecker * __cdecl uspoof_clone(const USpoofChecker *sc, UErrorCode *status);
void __cdecl uspoof_close(USpoofChecker *sc);
void __cdecl uspoof_closeCheckResult(USpoofCheckResult *checkResult);
const USet * __cdecl uspoof_getAllowedChars(const USpoofChecker *sc, UErrorCode *status);
const char * __cdecl uspoof_getAllowedLocales(USpoofChecker *sc, UErrorCode *status);
int32_t __cdecl uspoof_getCheckResultChecks(const USpoofCheckResult *checkResult, UErrorCode *status);
const USet * __cdecl uspoof_getCheckResultNumerics(const USpoofCheckResult *checkResult, UErrorCode *status);
URestrictionLevel __cdecl uspoof_getCheckResultRestrictionLevel(const USpoofCheckResult *checkResult, UErrorCode *status);
int32_t __cdecl uspoof_getChecks(const USpoofChecker *sc, UErrorCode *status);
const USet * __cdecl uspoof_getInclusionSet(UErrorCode *status);
const USet * __cdecl uspoof_getRecommendedSet(UErrorCode *status);
URestrictionLevel __cdecl uspoof_getRestrictionLevel(const USpoofChecker *sc);
int32_t __cdecl uspoof_getSkeleton(const USpoofChecker *sc, uint32_t type, const UChar *id, int32_t length, UChar *dest, int32_t destCapacity, UErrorCode *status);
int32_t __cdecl uspoof_getSkeletonUTF8(const USpoofChecker *sc, uint32_t type, const char *id, int32_t length, char *dest, int32_t destCapacity, UErrorCode *status);
USpoofChecker * __cdecl uspoof_open(UErrorCode *status);
USpoofCheckResult * __cdecl uspoof_openCheckResult(UErrorCode *status);
USpoofChecker * __cdecl uspoof_openFromSerialized(const void *data, int32_t length, int32_t *pActualLength, UErrorCode *status);
USpoofChecker * __cdecl uspoof_openFromSource(const char *confusables, int32_t confusablesLen, const char *arg2, int32_t arg3, int32_t *errorType, UParseError *pe, UErrorCode *status);
int32_t __cdecl uspoof_serialize(USpoofChecker *sc, void *buf, int32_t capacity, UErrorCode *status);
void __cdecl uspoof_setAllowedChars(USpoofChecker *sc, const USet *chars, UErrorCode *status);
void __cdecl uspoof_setAllowedLocales(USpoofChecker *sc, const char *localesList, UErrorCode *status);
void __cdecl uspoof_setChecks(USpoofChecker *sc, int32_t checks, UErrorCode *status);
void __cdecl uspoof_setRestrictionLevel(USpoofChecker *sc, URestrictionLevel restrictionLevel);
void __cdecl usprep_close(UStringPrepProfile *profile);
UStringPrepProfile * __cdecl usprep_open(const char *path, const char *name, UErrorCode *status);
UStringPrepProfile * __cdecl usprep_openByType(UStringPrepProfileType type, UErrorCode *status);
int32_t __cdecl usprep_prepare(const UStringPrepProfile *profile, const UChar *src, int32_t srcLength, UChar *dest, int32_t destCapacity, int32_t options, UParseError *parseError, UErrorCode *status);
UChar32 __cdecl utext_char32At(UText *ut, int64_t nativeIndex);
UText * __cdecl utext_clone(UText *dest, const UText *src, UBool deep, UBool readOnly, UErrorCode *status);
UText * __cdecl utext_close(UText *ut);
void __cdecl utext_copy(UText *ut, int64_t nativeStart, int64_t nativeLimit, int64_t destIndex, UBool move, UErrorCode *status);
UChar32 __cdecl utext_current32(UText *ut);
UBool __cdecl utext_equals(const UText *a, const UText *b);
int32_t __cdecl utext_extract(UText *ut, int64_t start, int64_t limit, UChar *dest, int32_t destCapacity, UErrorCode *status);
void __cdecl utext_freeze(UText *ut);
int64_t __cdecl utext_getNativeIndex(const UText *ut);
int64_t __cdecl utext_getPreviousNativeIndex(UText *ut);
UBool __cdecl utext_hasMetaData(const UText *ut);
UBool __cdecl utext_isLengthExpensive(const UText *ut);
UBool __cdecl utext_isWritable(const UText *ut);
UBool __cdecl utext_moveIndex32(UText *ut, int32_t delta);
int64_t __cdecl utext_nativeLength(UText *ut);
UChar32 __cdecl utext_next32(UText *ut);
UChar32 __cdecl utext_next32From(UText *ut, int64_t index);
UText * __cdecl utext_openUChars(UText *ut, const UChar *s, int64_t length, UErrorCode *status);
UText * __cdecl utext_openUTF8(UText *ut, const char *s, int64_t length, UErrorCode *status);
UChar32 __cdecl utext_previous32(UText *ut);
UChar32 __cdecl utext_previous32From(UText *ut, int64_t index);
int32_t __cdecl utext_replace(UText *ut, int64_t nativeStart, int64_t nativeLimit, const UChar *replacementText, int32_t replacementLength, UErrorCode *status);
void __cdecl utext_setNativeIndex(UText *ut, int64_t index);
UText * __cdecl utext_setup(UText *ut, int32_t extraSpace, UErrorCode *status);
int32_t __cdecl utf8_appendCharSafeBody(uint8_t *s, int32_t i, int32_t length, UChar32 c, UBool *pIsError);
int32_t __cdecl utf8_back1SafeBody(const uint8_t *s, int32_t start, int32_t i);
UChar32 __cdecl utf8_nextCharSafeBody(const uint8_t *s, int32_t *pi, int32_t length, UChar32 c, UBool strict);
UChar32 __cdecl utf8_prevCharSafeBody(const uint8_t *s, int32_t start, int32_t *pi, UChar32 c, UBool strict);
int64_t __cdecl utmscale_fromInt64(int64_t otherTime, UDateTimeScale timeScale, UErrorCode *status);
int64_t __cdecl utmscale_getTimeScaleValue(UDateTimeScale timeScale, UTimeScaleValue value, UErrorCode *status);
int64_t __cdecl utmscale_toInt64(int64_t universalTime, UDateTimeScale timeScale, UErrorCode *status);
int32_t __cdecl utrace_format(char *outBuf, int32_t capacity, int32_t indent, const char *fmt, ...);
const char * __cdecl utrace_functionName(int32_t fnNumber);
void __cdecl utrace_getFunctions(const void **context, UTraceEntry **e, UTraceExit **x, UTraceData **d);
int32_t __cdecl utrace_getLevel(void);
void __cdecl utrace_setFunctions(const void *context, UTraceEntry *e, UTraceExit *x, UTraceData *d);
void __cdecl utrace_setLevel(int32_t level);
int32_t __cdecl utrace_vformat(char *outBuf, int32_t capacity, int32_t indent, const char *fmt, va_list args);
UTransliterator * __cdecl utrans_clone(const UTransliterator *trans, UErrorCode *status);
void __cdecl utrans_close(UTransliterator *trans);
int32_t __cdecl utrans_countAvailableIDs(void);
USet * __cdecl utrans_getSourceSet(const UTransliterator *trans, UBool ignoreFilter, USet *fillIn, UErrorCode *status);
const UChar * __cdecl utrans_getUnicodeID(const UTransliterator *trans, int32_t *resultLength);
UEnumeration * __cdecl utrans_openIDs(UErrorCode *pErrorCode);
UTransliterator * __cdecl utrans_openInverse(const UTransliterator *trans, UErrorCode *status);
UTransliterator * __cdecl utrans_openU(const UChar *id, int32_t idLength, UTransDirection dir, const UChar *rules, int32_t rulesLength, UParseError *parseError, UErrorCode *pErrorCode);
void __cdecl utrans_register(UTransliterator *adoptedTrans, UErrorCode *status);
void __cdecl utrans_setFilter(UTransliterator *trans, const UChar *filterPattern, int32_t filterPatternLen, UErrorCode *status);
int32_t __cdecl utrans_toRules(const UTransliterator *trans, UBool escapeUnprintable, UChar *result, int32_t resultLength, UErrorCode *status);
void __cdecl utrans_trans(const UTransliterator *trans, UReplaceable *rep, const UReplaceableCallbacks *repFunc, int32_t start, int32_t *limit, UErrorCode *status);
void __cdecl utrans_transIncremental(const UTransliterator *trans, UReplaceable *rep, const UReplaceableCallbacks *repFunc, UTransPosition *pos, UErrorCode *status);
void __cdecl utrans_transIncrementalUChars(const UTransliterator *trans, UChar *text, int32_t *textLength, int32_t textCapacity, UTransPosition *pos, UErrorCode *status);
void __cdecl utrans_transUChars(const UTransliterator *trans, UChar *text, int32_t *textLength, int32_t textCapacity, int32_t start, int32_t *limit, UErrorCode *status);
void __cdecl utrans_unregisterID(const UChar *id, int32_t idLength);

#endif  /* __WINE_ICU_H */
