/* libvalent-1.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Valent", gir_namespace = "Valent", gir_version = "1", lower_case_cprefix = "valent_")]
namespace Valent {
	[CCode (cheader_filename = "valent.h", type_id = "valent_application_get_type ()")]
	[Version (since = "1.0")]
	public sealed class Application : GLib.Application, GLib.ActionGroup, GLib.ActionMap {
		[CCode (has_construct_function = false)]
		protected Application ();
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_application_plugin_get_type ()")]
	[Version (since = "1.0")]
	public abstract class ApplicationPlugin : Valent.Extension, GLib.ActionGroup, GLib.ActionMap {
		[CCode (has_construct_function = false)]
		protected ApplicationPlugin ();
		public virtual bool activate ();
		public virtual int command_line (GLib.ApplicationCommandLine command_line);
		public virtual bool dbus_register (GLib.DBusConnection connection, string object_path) throws GLib.Error;
		public virtual void dbus_unregister (GLib.DBusConnection connection, string object_path);
		public virtual bool open ([CCode (array_length_cname = "n_files", array_length_pos = 1.5)] GLib.File[] files, string hint);
		public virtual void shutdown ();
		public virtual void startup ();
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_channel_get_type ()")]
	[Version (since = "1.0")]
	public class Channel : Valent.Object {
		[CCode (has_construct_function = false)]
		protected Channel ();
		public bool close (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool close_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual GLib.IOStream? download (Json.Node packet, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async GLib.IOStream? download_async (Json.Node packet, GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned Json.Node get_identity ();
		public unowned Json.Node get_peer_identity ();
		public async Json.Node read_packet (GLib.Cancellable? cancellable) throws GLib.Error;
		public GLib.IOStream? ref_base_stream ();
		public unowned GLib.TlsCertificate? ref_certificate ();
		public unowned GLib.TlsCertificate? ref_peer_certificate ();
		public virtual GLib.IOStream? upload (Json.Node packet, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async GLib.IOStream? upload_async (Json.Node packet, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool write_packet (Json.Node packet, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoAccessorMethod]
		public GLib.IOStream base_stream { owned get; construct; }
		[NoAccessorMethod]
		public GLib.TlsCertificate certificate { owned get; construct; }
		public Json.Node identity { get; construct; }
		[NoAccessorMethod]
		public GLib.TlsCertificate peer_certificate { owned get; construct; }
		public Json.Node peer_identity { get; construct; }
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_channel_service_get_type ()")]
	[Version (since = "1.0")]
	public abstract class ChannelService : Valent.Extension, GLib.ActionGroup, GLib.ActionMap {
		[CCode (has_construct_function = false)]
		protected ChannelService ();
		public virtual void build_identity ();
		public string dup_id ();
		public virtual void identify (string? target);
		public GLib.TlsCertificate ref_certificate ();
		public Json.Node ref_identity ();
		[NoAccessorMethod]
		public GLib.TlsCertificate certificate { owned get; construct; }
		[NoAccessorMethod]
		public string id { owned get; }
		[NoAccessorMethod]
		public Json.Node identity { owned get; }
		[HasEmitter]
		public virtual signal void channel (Valent.Channel channel);
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_clipboard_get_type ()")]
	[Version (since = "1.0")]
	public sealed class Clipboard : Valent.Component, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected Clipboard ();
		public static unowned Valent.Clipboard get_default ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[]? get_mimetypes ();
		public int64 get_timestamp ();
		public async GLib.Bytes? read_bytes (string mimetype, GLib.Cancellable? cancellable) throws GLib.Error;
		public async string? read_text (GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool write_bytes (string? mimetype, GLib.Bytes? bytes, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool write_text (string text, GLib.Cancellable? cancellable) throws GLib.Error;
		public signal void changed ();
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_clipboard_adapter_get_type ()")]
	[Version (since = "1.0")]
	public abstract class ClipboardAdapter : Valent.Extension, GLib.ActionGroup, GLib.ActionMap {
		[CCode (has_construct_function = false)]
		protected ClipboardAdapter ();
		[CCode (array_length = false, array_null_terminated = true)]
		public virtual string[]? get_mimetypes ();
		public virtual int64 get_timestamp ();
		public virtual async GLib.Bytes? read_bytes (string mimetype, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual async bool write_bytes (string? mimetype, GLib.Bytes? bytes, GLib.Cancellable? cancellable) throws GLib.Error;
		[HasEmitter]
		public virtual signal void changed ();
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_component_get_type ()")]
	[Version (since = "1.0")]
	public abstract class Component : Valent.Resource, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected Component ();
		[NoWrapper]
		public virtual void bind_extension (Valent.Extension extension);
		[NoWrapper]
		public virtual void bind_preferred (Valent.Extension extension);
		public void export_adapter (Valent.Extension extension);
		public unowned Valent.Extension? get_primary_adapter ();
		public void set_primary_adapter (Valent.Extension? extension);
		[NoWrapper]
		public virtual void unbind_extension (Valent.Extension extension);
		public void unexport_adapter (Valent.Extension extension);
		[NoAccessorMethod]
		public string plugin_domain { owned get; construct; }
		[NoAccessorMethod]
		public GLib.Type plugin_type { get; construct; }
		public Valent.Extension primary_adapter { get; set; }
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_contacts_get_type ()")]
	[Version (since = "1.0")]
	public sealed class Contacts : Valent.Component, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected Contacts ();
		public static unowned Valent.Contacts get_default ();
		public static GLib.Resource get_resource ();
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_contacts_adapter_get_type ()")]
	[Version (since = "1.0")]
	public abstract class ContactsAdapter : Valent.Extension, GLib.ActionGroup, GLib.ActionMap, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected ContactsAdapter ();
		[NoAccessorMethod]
		public Tracker.Sparql.Connection connection { owned get; construct; }
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_context_get_type ()")]
	[Version (since = "1.0")]
	public sealed class Context : Valent.Object {
		[CCode (has_construct_function = false)]
		protected Context ();
		public void clear ();
		public void clear_cache ();
		public GLib.Settings? create_settings (string schema_id);
		public GLib.File? get_cache_file (string filename);
		public GLib.File? get_config_file (string filename);
		public GLib.File? get_data_file (string filename);
		public unowned string get_domain ();
		public unowned string get_id ();
		public unowned Valent.Context? get_parent ();
		public unowned string get_path ();
		public Valent.Context get_plugin_context (Peas.PluginInfo plugin_info);
		public GLib.Settings? get_plugin_settings (Peas.PluginInfo plugin_info, string plugin_key);
		public Valent.Context @new (string? domain, string? id);
		public string domain { get; construct; }
		public string id { get; construct; }
		public Valent.Context parent { get; construct; }
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_device_get_type ()")]
	[Version (since = "1.0")]
	public sealed class Device : Valent.Resource, GLib.ActionGroup {
		[CCode (has_construct_function = false)]
		public Device (string id);
		public void add_channel (Valent.Channel channel);
		public static string generate_id ();
		public unowned GLib.ListModel get_channels ();
		public Valent.Context get_context ();
		public unowned string get_icon_name ();
		public unowned string get_id ();
		public unowned GLib.MenuModel get_menu ();
		public unowned string? get_name ();
		public static GLib.Resource get_resource ();
		public Valent.DeviceState get_state ();
		public string? get_verification_key ();
		public async bool send_packet (Json.Node packet, GLib.Cancellable? cancellable) throws GLib.Error;
		public static bool validate_id (string? id);
		public static bool validate_name (string? name);
		public Valent.Context context { owned get; construct; }
		public string icon_name { get; }
		public string id { get; construct; }
		public string name { get; }
		public Valent.DeviceState state { get; }
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_device_manager_get_type ()")]
	[Version (since = "1.0")]
	public sealed class DeviceManager : Valent.ApplicationPlugin, GLib.ActionGroup, GLib.ActionMap, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected DeviceManager ();
		public static unowned Valent.DeviceManager get_default ();
		public void refresh ();
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_device_plugin_get_type ()")]
	[Version (since = "1.0")]
	public abstract class DevicePlugin : Valent.Extension, GLib.ActionGroup, GLib.ActionMap {
		[CCode (has_construct_function = false)]
		protected DevicePlugin ();
		public virtual void handle_packet (string type, Json.Node packet);
		public void hide_notification (string id);
		public void queue_packet (Json.Node packet);
		public void set_menu_action (string action, string? label, string? icon_name);
		public void set_menu_item (string action, GLib.MenuItem? item);
		public void show_notification (string id, GLib.Notification notification);
		public virtual void update_state (Valent.DeviceState state);
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_device_transfer_get_type ()")]
	[Version (since = "1.0")]
	public sealed class DeviceTransfer : Valent.Transfer {
		[CCode (has_construct_function = false, type = "ValentTransfer*")]
		public DeviceTransfer (Valent.Device device, Json.Node packet, GLib.File file);
		public Valent.Device? ref_device ();
		public GLib.File? ref_file ();
		public Json.Node? ref_packet ();
		[NoAccessorMethod]
		public Valent.Device device { owned get; construct; }
		[NoAccessorMethod]
		public GLib.File file { owned get; construct; }
		[NoAccessorMethod]
		public Json.Node packet { owned get; construct; }
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_extension_get_type ()")]
	[Version (since = "1.0")]
	public abstract class Extension : Valent.Resource, GLib.ActionGroup, GLib.ActionMap {
		[CCode (has_construct_function = false)]
		protected Extension ();
		public unowned Valent.Context? get_context ();
		public unowned GLib.Settings? get_settings ();
		public void plugin_state_changed (Valent.PluginState state, GLib.Error? error);
		public Valent.PluginState plugin_state_check () throws GLib.Error;
		public void toggle_actions (bool enabled);
		public Valent.Context context { get; construct; }
		[NoAccessorMethod]
		public Peas.PluginInfo plugin_info { owned get; construct; }
		[NoAccessorMethod]
		public Valent.PluginState plugin_state { get; }
		public GLib.Settings settings { get; }
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_input_get_type ()")]
	[Version (since = "1.0")]
	public sealed class Input : Valent.Component, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected Input ();
		public static unowned Valent.Input get_default ();
		public void keyboard_keysym (uint32 keysym, bool state);
		public void pointer_axis (double dx, double dy);
		public void pointer_button (uint button, bool state);
		public void pointer_motion (double dx, double dy);
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_input_adapter_get_type ()")]
	[Version (since = "1.0")]
	public abstract class InputAdapter : Valent.Extension, GLib.ActionGroup, GLib.ActionMap {
		[CCode (has_construct_function = false)]
		protected InputAdapter ();
		public virtual void keyboard_keysym (uint32 keysym, bool state);
		public virtual void pointer_axis (double dx, double dy);
		public virtual void pointer_button (uint button, bool state);
		public virtual void pointer_motion (double dx, double dy);
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_media_get_type ()")]
	[Version (since = "1.0")]
	public sealed class Media : Valent.Component, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected Media ();
		public void export_player (Valent.MediaPlayer player);
		public static unowned Valent.Media get_default ();
		public void unexport_player (Valent.MediaPlayer player);
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_media_adapter_get_type ()")]
	[Version (since = "1.0")]
	public abstract class MediaAdapter : Valent.Extension, GLib.ActionGroup, GLib.ActionMap, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected MediaAdapter ();
		public virtual void export_player (Valent.MediaPlayer player);
		public void player_added (Valent.MediaPlayer player);
		public void player_removed (Valent.MediaPlayer player);
		public virtual void unexport_player (Valent.MediaPlayer player);
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_media_player_get_type ()")]
	[Version (since = "1.0")]
	public class MediaPlayer : Valent.Resource {
		[CCode (has_construct_function = false)]
		protected MediaPlayer ();
		public virtual Valent.MediaActions get_flags ();
		public virtual GLib.Variant get_metadata ();
		public virtual unowned string get_name ();
		public virtual double get_position ();
		public virtual Valent.MediaRepeat get_repeat ();
		public virtual bool get_shuffle ();
		public virtual Valent.MediaState get_state ();
		public virtual double get_volume ();
		public virtual void next ();
		public virtual void pause ();
		public virtual void play ();
		public virtual void previous ();
		public virtual void seek (double offset);
		public virtual void set_position (double position);
		public virtual void set_repeat (Valent.MediaRepeat repeat);
		public virtual void set_shuffle (bool shuffle);
		public virtual void set_volume (double volume);
		public virtual void stop ();
		public Valent.MediaActions flags { get; }
		public GLib.Variant metadata { owned get; }
		public string name { get; }
		public double position { get; set; }
		public Valent.MediaRepeat repeat { get; set; }
		public bool shuffle { get; set; }
		public Valent.MediaState state { get; }
		public double volume { get; set; }
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_message_get_type ()")]
	[Version (since = "1.0")]
	public sealed class Message : Valent.Resource {
		[CCode (has_construct_function = false)]
		protected Message ();
		public unowned GLib.ListModel get_attachments ();
		public Valent.MessageBox get_box ();
		public int64 get_date ();
		public int64 get_id ();
		public bool get_read ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[]? get_recipients ();
		public unowned string? get_sender ();
		public int64 get_subscription_id ();
		public unowned string? get_text ();
		public int64 get_thread_id ();
		public GLib.ListModel attachments { get; construct; }
		public uint box { get; construct; }
		public int64 date { get; construct; }
		public int64 id { get; construct; }
		public bool read { get; construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] recipients { get; construct; }
		public string sender { get; construct; }
		public int64 subscription_id { get; construct; }
		public string text { get; construct; }
		public int64 thread_id { get; construct; }
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_message_attachment_get_type ()")]
	[Version (since = "1.0")]
	public sealed class MessageAttachment : Valent.Resource {
		[CCode (has_construct_function = false)]
		protected MessageAttachment ();
		public unowned GLib.File? get_file ();
		public unowned GLib.Icon? get_preview ();
		public void set_file (GLib.File? file);
		public void set_preview (GLib.Icon? preview);
		public GLib.File file { get; set; }
		public GLib.Icon preview { get; set; }
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_messages_get_type ()")]
	[Version (since = "1.0")]
	public sealed class Messages : Valent.Component, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected Messages ();
		public static unowned Valent.Messages get_default ();
		public static GLib.Resource get_resource ();
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_messages_adapter_get_type ()")]
	[Version (since = "1.0")]
	public abstract class MessagesAdapter : Valent.Extension, GLib.ActionGroup, GLib.ActionMap, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected MessagesAdapter ();
		public virtual async bool send_message (Valent.Message message, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoAccessorMethod]
		public Tracker.Sparql.Connection connection { owned get; construct; }
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_mixer_get_type ()")]
	[Version (since = "1.0")]
	public sealed class Mixer : Valent.Component, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected Mixer ();
		public static unowned Valent.Mixer get_default ();
		public unowned Valent.MixerStream? get_default_input ();
		public unowned Valent.MixerStream? get_default_output ();
		public void set_default_input (Valent.MixerStream stream);
		public void set_default_output (Valent.MixerStream stream);
		public Valent.MixerStream default_input { get; set; }
		public Valent.MixerStream default_output { get; set; }
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_mixer_adapter_get_type ()")]
	[Version (since = "1.0")]
	public abstract class MixerAdapter : Valent.Extension, GLib.ActionGroup, GLib.ActionMap, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected MixerAdapter ();
		public virtual unowned Valent.MixerStream get_default_input ();
		public virtual unowned Valent.MixerStream get_default_output ();
		public virtual void set_default_input (Valent.MixerStream stream);
		public virtual void set_default_output (Valent.MixerStream stream);
		public void stream_added (Valent.MixerStream stream);
		public void stream_removed (Valent.MixerStream stream);
		public Valent.MixerStream default_input { get; set; }
		public Valent.MixerStream default_output { get; set; }
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_mixer_stream_get_type ()")]
	[Version (since = "1.0")]
	public class MixerStream : Valent.Resource {
		[CCode (has_construct_function = false)]
		protected MixerStream ();
		public virtual unowned string get_description ();
		public virtual Valent.MixerDirection get_direction ();
		public virtual uint get_level ();
		public virtual bool get_muted ();
		public virtual unowned string get_name ();
		public virtual void set_level (uint level);
		public virtual void set_muted (bool state);
		public string description { get; construct; }
		public Valent.MixerDirection direction { get; construct; }
		public uint level { get; set; }
		public bool muted { get; set; }
		public string name { get; construct; }
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_notification_get_type ()")]
	[Version (since = "1.0")]
	public sealed class Notification : Valent.Resource {
		[CCode (has_construct_function = false)]
		public Notification (string? title);
		public void add_button (string label, string action);
		public void add_button_with_target (string label, string action, GLib.Variant? target);
		public static void add_device_button (GLib.Notification notification, Valent.Device device, string label, string action, GLib.Variant? target);
		public static Valent.Notification? deserialize (GLib.Variant variant);
		public bool equal (Valent.Notification notification2);
		public unowned string? get_application ();
		public unowned string? get_body ();
		public unowned GLib.Icon? get_icon ();
		public unowned string get_id ();
		public GLib.NotificationPriority get_priority ();
		public int64 get_time ();
		public uint hash ();
		public GLib.Variant? serialize ();
		public void set_action (string action);
		public void set_action_and_target (string action, GLib.Variant? target);
		public void set_application (string? application);
		public void set_body (string? body);
		public static void set_device_action (GLib.Notification notification, Valent.Device device, string action, GLib.Variant? target);
		public void set_icon (GLib.Icon? icon);
		public void set_id (string id);
		public void set_priority (GLib.NotificationPriority priority);
		public void set_time (int64 time);
		public string action { set; }
		public string application { get; set; }
		public string body { get; set; }
		public GLib.Icon icon { get; set; }
		public string id { get; set; }
		public GLib.NotificationPriority priority { get; set; }
		public int64 time { get; set; }
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_notifications_get_type ()")]
	[Version (since = "1.0")]
	public sealed class Notifications : Valent.Component, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected Notifications ();
		public unowned GLib.Variant get_applications ();
		public static unowned Valent.Notifications get_default ();
		public signal void notification_added (Valent.Notification notification);
		public signal void notification_removed (string id);
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_notifications_adapter_get_type ()")]
	[Version (since = "1.0")]
	public abstract class NotificationsAdapter : Valent.Extension, GLib.ActionGroup, GLib.ActionMap {
		[CCode (has_construct_function = false)]
		protected NotificationsAdapter ();
		public virtual void add_notification (Valent.Notification notification);
		public virtual void remove_notification (string id);
		[HasEmitter]
		public virtual signal void notification_added (Valent.Notification notification);
		[HasEmitter]
		public virtual signal void notification_removed (string id);
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_object_get_type ()")]
	[Version (since = "1.0")]
	public class Object : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Object ();
		public bool in_destruction ();
		public void @lock ();
		public void notify (string property_name);
		public void notify_by_pspec (GLib.ParamSpec pspec);
		public GLib.Cancellable ref_cancellable ();
		public void @unlock ();
		[NoAccessorMethod]
		public GLib.Cancellable cancellable { owned get; construct; }
		[HasEmitter]
		public virtual signal void destroy ();
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_resource_get_type ()")]
	[Version (since = "1.0")]
	public class Resource : Valent.Object {
		[CCode (has_construct_function = false)]
		protected Resource ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[]? get_contributor ();
		public unowned string? get_coverage ();
		public unowned string? get_creator ();
		public unowned GLib.DateTime? get_date ();
		public unowned string? get_description ();
		public unowned string? get_format ();
		public unowned string? get_identifier ();
		public unowned string? get_iri ();
		public unowned string? get_language ();
		public unowned string? get_publisher ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[]? get_relation ();
		public unowned string? get_rights ();
		public unowned Valent.Resource? get_source ();
		public unowned string? get_subject ();
		public unowned string? get_title ();
		public unowned string? get_type_hint ();
		public void set_contributor ([CCode (array_length = false, array_null_terminated = true)] string[]? contributor);
		public void set_coverage (string? coverage);
		public void set_creator (string? creator);
		public void set_date (GLib.DateTime? date);
		public void set_description (string? description);
		public void set_format (string? format);
		public void set_identifier (string? identifier);
		public void set_language (string? language);
		public void set_publisher (string? publisher);
		public void set_relation ([CCode (array_length = false, array_null_terminated = true)] string[]? relation);
		public void set_rights (string? rights);
		public void set_subject (string? subject);
		public void set_title (string? title);
		public void set_type_hint (string? type_hint);
		public virtual void update (Valent.Resource update);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] contributor { get; set; }
		public string coverage { get; set; }
		public string creator { get; set; }
		public GLib.DateTime date { get; set; }
		public string description { get; set; }
		public string format { get; set; }
		public string identifier { get; construct; }
		public string iri { get; construct; }
		public string language { get; set; }
		public string publisher { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] relation { get; set; }
		public string rights { get; set; }
		public Valent.Resource source { get; construct; }
		public string subject { get; set; }
		public string title { get; set; }
		public string type_hint { get; set; }
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_session_get_type ()")]
	[Version (since = "1.0")]
	public sealed class Session : Valent.Component, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected Session ();
		public bool get_active ();
		public static unowned Valent.Session? get_default ();
		public bool get_locked ();
		public void set_locked (bool state);
		public bool active { get; }
		public bool locked { get; set; }
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_session_adapter_get_type ()")]
	[Version (since = "1.0")]
	public abstract class SessionAdapter : Valent.Extension, GLib.ActionGroup, GLib.ActionMap {
		[CCode (has_construct_function = false)]
		protected SessionAdapter ();
		public virtual bool get_active ();
		public virtual bool get_locked ();
		public virtual void set_locked (bool state);
		public bool active { get; }
		public bool locked { get; set; }
	}
	[CCode (cheader_filename = "valent.h", type_id = "valent_transfer_get_type ()")]
	[Version (since = "1.0")]
	public abstract class Transfer : Valent.Object {
		[CCode (has_construct_function = false)]
		protected Transfer ();
		public void cancel ();
		public bool check_status () throws GLib.Error;
		public string dup_id ();
		public virtual async bool execute (GLib.Cancellable? cancellable) throws GLib.Error;
		public double get_progress ();
		public Valent.TransferState get_state ();
		public void set_progress (double progress);
		[NoAccessorMethod]
		public string id { owned get; construct; }
		public double progress { get; set; }
		public Valent.TransferState state { get; }
	}
	[CCode (cheader_filename = "valent.h", cprefix = "VALENT_DEVICE_STATE_", type_id = "valent_device_state_get_type ()")]
	[Flags]
	[Version (since = "1.0")]
	public enum DeviceState {
		NONE,
		CONNECTED,
		PAIRED,
		PAIR_INCOMING,
		PAIR_OUTGOING
	}
	[CCode (cheader_filename = "valent.h", cprefix = "VALENT_MEDIA_ACTION_", type_id = "valent_media_actions_get_type ()")]
	[Flags]
	[Version (since = "1.0")]
	public enum MediaActions {
		NONE,
		PLAY,
		PAUSE,
		STOP,
		NEXT,
		PREVIOUS,
		SEEK,
		RESERVED1,
		RESERVED2
	}
	[CCode (cheader_filename = "valent.h", cprefix = "VALENT_MEDIA_REPEAT_", type_id = "valent_media_repeat_get_type ()")]
	[Version (since = "1.0")]
	public enum MediaRepeat {
		NONE,
		ALL,
		ONE
	}
	[CCode (cheader_filename = "valent.h", cprefix = "VALENT_MEDIA_STATE_", type_id = "valent_media_state_get_type ()")]
	[Version (since = "1.0")]
	public enum MediaState {
		STOPPED,
		PLAYING,
		PAUSED
	}
	[CCode (cheader_filename = "valent.h", cprefix = "VALENT_MESSAGE_BOX_", type_id = "valent_message_box_get_type ()")]
	[Version (since = "1.0")]
	public enum MessageBox {
		ALL,
		INBOX,
		SENT,
		DRAFTS,
		OUTBOX,
		FAILED,
		QUEUED
	}
	[CCode (cheader_filename = "valent.h", cprefix = "VALENT_MIXER_", type_id = "valent_mixer_direction_get_type ()")]
	[Version (since = "1.0")]
	public enum MixerDirection {
		INPUT,
		OUTPUT
	}
	[CCode (cheader_filename = "valent.h", cprefix = "VALENT_PLUGIN_STATE_", type_id = "valent_plugin_state_get_type ()")]
	[Version (since = "1.0")]
	public enum PluginState {
		ACTIVE,
		INACTIVE,
		ERROR
	}
	[CCode (cheader_filename = "valent.h", cprefix = "VALENT_TRANSFER_STATE_", type_id = "valent_transfer_state_get_type ()")]
	[Version (since = "1.0")]
	public enum TransferState {
		PENDING,
		ACTIVE,
		COMPLETE,
		FAILED
	}
	[CCode (cheader_filename = "valent.h", cprefix = "VALENT_PACKET_ERROR_", has_type_id = false)]
	[Version (since = "1.0")]
	public errordomain PacketError {
		UNKNOWN,
		INVALID_DATA,
		MALFORMED,
		INVALID_FIELD,
		MISSING_FIELD;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "valent.h", cname = "VALENT_API_VERSION")]
	public const string API_VERSION;
	[CCode (cheader_filename = "valent.h", cname = "VALENT_CONTACTS_GRAPH")]
	[Version (since = "1.0")]
	public const string CONTACTS_GRAPH;
	[CCode (cheader_filename = "valent.h", cname = "VALENT_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "valent.h", cname = "VALENT_MESSAGES_GRAPH")]
	[Version (since = "1.0")]
	public const string MESSAGES_GRAPH;
	[CCode (cheader_filename = "valent.h", cname = "VALENT_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "valent.h", cname = "VALENT_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "valent.h", cname = "VALENT_NETWORK_PROTOCOL_V7")]
	[Version (since = "1.0")]
	public const int NETWORK_PROTOCOL_V7;
	[CCode (cheader_filename = "valent.h", cname = "VALENT_NETWORK_PROTOCOL_V8")]
	[Version (since = "1.0")]
	public const int NETWORK_PROTOCOL_V8;
	[CCode (cheader_filename = "valent.h", cname = "VALENT_POINTER_MIDDLE")]
	public const int POINTER_MIDDLE;
	[CCode (cheader_filename = "valent.h", cname = "VALENT_POINTER_PRIMARY")]
	public const int POINTER_PRIMARY;
	[CCode (cheader_filename = "valent.h", cname = "VALENT_POINTER_SECONDARY")]
	public const int POINTER_SECONDARY;
	[CCode (cheader_filename = "valent.h", cname = "VALENT_VCS_TAG")]
	public const string VCS_TAG;
	[CCode (cheader_filename = "valent.h", cname = "VALENT_VERSION")]
	public const string VERSION;
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static unowned string? certificate_get_common_name (GLib.TlsCertificate certificate);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static unowned GLib.ByteArray certificate_get_public_key (GLib.TlsCertificate certificate);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static async GLib.TlsCertificate? certificate_new (string? path, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static GLib.TlsCertificate? certificate_new_sync (string? path) throws GLib.Error;
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static bool check_version (uint major, uint minor);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static Tracker.Resource contact_resource_from_econtact (E.Contact contact);
	[CCode (cheader_filename = "valent.h")]
	public static GLib.Resource core_get_resource ();
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static void debug_clear ();
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static void debug_init ();
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static uint get_major_version ();
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static uint get_micro_version ();
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static uint get_minor_version ();
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static unowned Peas.Engine get_plugin_engine ();
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static unowned string get_user_directory (GLib.UserDirectory directory);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static GLib.File get_user_file (string dirname, string basename, bool unique);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static bool packet_check_field (Json.Node packet, string field);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static Json.Node? packet_deserialize (string json) throws GLib.Error;
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static string[]? packet_dup_strv (Json.Node packet, string field);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static async Json.Node packet_from_stream (GLib.InputStream stream, ssize_t max_len, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static bool packet_get_array (Json.Node packet, string field, out Json.Array? value);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static unowned Json.Object? packet_get_body (Json.Node packet);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static bool packet_get_boolean (Json.Node packet, string field, out bool value);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static bool packet_get_double (Json.Node packet, string field, out double value);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static int64 packet_get_id (Json.Node packet);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static bool packet_get_int (Json.Node packet, string field, out int64 value);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static bool packet_get_object (Json.Node packet, string field, out Json.Object? value);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static unowned Json.Object? packet_get_payload_full (Json.Node packet, out int64 size) throws GLib.Error;
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static unowned Json.Object? packet_get_payload_info (Json.Node packet);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static int64 packet_get_payload_size (Json.Node packet);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static bool packet_get_string (Json.Node packet, string field, out string? value);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static unowned string? packet_get_type (Json.Node packet);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static bool packet_has_payload (Json.Node packet);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static Json.Node packet_new (string type);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static string? packet_serialize (Json.Node packet, out size_t length);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static void packet_set_payload_full (Json.Node packet, owned Json.Object info, int64 size);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static void packet_set_payload_info (Json.Node packet, owned Json.Object info);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static void packet_set_payload_size (Json.Node packet, int64 size);
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static async bool packet_to_stream (GLib.OutputStream stream, Json.Node packet, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static bool packet_validate (Json.Node? packet) throws GLib.Error;
	[CCode (cheader_filename = "valent.h")]
	[Version (since = "1.0")]
	public static int64 timestamp_ms ();
}
