/*
 * Decompiled with CFR 0.152.
 */
package com.jarego.jayatana.swing;

import com.jarego.jayatana.Feature;
import com.jarego.jayatana.FeatureManager;
import com.jarego.jayatana.basic.GlobalMenu;
import com.jarego.jayatana.swing.SwingGlobalMenuWindow;
import java.awt.AWTEvent;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;

public class SwingGlobalMenu
implements Feature,
AWTEventListener {
    @Override
    public void deploy() {
        GlobalMenu.nativeInitialize();
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event.getID() == 200) {
            if (event.getSource() instanceof JFrame) {
                this.installOnWindow((JFrame)event.getSource());
            } else if (event.getSource() instanceof JDialog) {
                this.installOnWindow((JDialog)event.getSource());
            }
        }
    }

    protected void installOnWindow(JFrame jframe) {
        JMenuBar menubar = this.retriveMenuBar(jframe);
        if (menubar != null) {
            this.tryInstallGlobalMenu(jframe, menubar);
        }
    }

    protected void installOnWindow(JDialog jdialog) {
        JMenuBar menubar = this.retriveMenuBar(jdialog);
        if (menubar != null) {
            this.tryInstallGlobalMenu(jdialog, menubar);
        } else if (jdialog.getModalityType() == Dialog.ModalityType.APPLICATION_MODAL) {
            this.installLockParentGlobalMenu(jdialog.getOwner(), jdialog);
        }
    }

    protected JMenuBar retriveMenuBar(JFrame jframe) {
        JMenuBar menuBar = null;
        menuBar = jframe.getRootPane().getClientProperty("jayatana.menubar") instanceof JMenuBar ? (JMenuBar)jframe.getRootPane().getClientProperty("jayatana.menubar") : jframe.getJMenuBar();
        return menuBar;
    }

    protected JMenuBar retriveMenuBar(JDialog jdialog) {
        JMenuBar menuBar = null;
        menuBar = jdialog.getRootPane().getClientProperty("jayatana.menubar") instanceof JMenuBar ? (JMenuBar)jdialog.getRootPane().getClientProperty("jayatana.menubar") : jdialog.getJMenuBar();
        return menuBar;
    }

    private void tryInstallGlobalMenu(Window window, JMenuBar menubar) {
        FeatureManager.deployOnce("gMainLoop");
        SwingGlobalMenuWindow swingGlobalMenuWindow = new SwingGlobalMenuWindow(window, menubar);
        this.setSwingGlobalMenuWindowController(window, swingGlobalMenuWindow);
        swingGlobalMenuWindow.registerWatcher();
    }

    private void installLockParentGlobalMenu(Window parent, Window child) {
        if (parent != null) {
            ArrayList<SwingGlobalMenuWindow> swingGlobalMenuWindowList = new ArrayList<SwingGlobalMenuWindow>();
            if (parent == JOptionPane.getRootFrame()) {
                for (Window w : Window.getOwnerlessWindows()) {
                    SwingGlobalMenuWindow swingGlobalMenuWindow = this.getSwingGlobalMenuWindowController(w);
                    if (swingGlobalMenuWindow == null) continue;
                    swingGlobalMenuWindow.lockMenuBar();
                    swingGlobalMenuWindowList.add(swingGlobalMenuWindow);
                }
            } else {
                SwingGlobalMenuWindow swingGlobalMenuWindow = this.getSwingGlobalMenuWindowController(parent);
                if (swingGlobalMenuWindow != null) {
                    swingGlobalMenuWindow.lockMenuBar();
                    swingGlobalMenuWindowList.add(swingGlobalMenuWindow);
                }
            }
            ApplicationModalWindowListener listener = new ApplicationModalWindowListener(this, swingGlobalMenuWindowList);
            child.addWindowListener(listener);
            child.addComponentListener(listener);
        }
    }

    private void setSwingGlobalMenuWindowController(Window window, SwingGlobalMenuWindow sgm) {
        if (window instanceof JFrame) {
            ((JFrame)window).getRootPane().putClientProperty("jayatana.globalmenu.controller", sgm);
        } else if (window instanceof JDialog) {
            ((JDialog)window).getRootPane().putClientProperty("jayatana.globalmenu.controller", sgm);
        }
    }

    private SwingGlobalMenuWindow getSwingGlobalMenuWindowController(Window window) {
        SwingGlobalMenuWindow swingGlobalMenuWindow = null;
        if (window instanceof JFrame) {
            swingGlobalMenuWindow = (SwingGlobalMenuWindow)((JFrame)window).getRootPane().getClientProperty("jayatana.globalmenu.controller");
        } else if (window instanceof JDialog) {
            swingGlobalMenuWindow = (SwingGlobalMenuWindow)((JDialog)window).getRootPane().getClientProperty("jayatana.globalmenu.controller");
        }
        return swingGlobalMenuWindow;
    }

    private class ApplicationModalWindowListener
    implements WindowListener,
    ComponentListener {
        boolean locked;
        private List<SwingGlobalMenuWindow> swingGlobalMenuWindowList;

        public ApplicationModalWindowListener(SwingGlobalMenu swingGlobalMenu, List<SwingGlobalMenuWindow> swingGlobalMenuWindowList) {
            Objects.requireNonNull(swingGlobalMenu);
            this.swingGlobalMenuWindowList = swingGlobalMenuWindowList;
            this.locked = true;
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            if (this.locked) {
                for (SwingGlobalMenuWindow sgw : this.swingGlobalMenuWindowList) {
                    sgw.unlockMenuBar();
                }
                this.locked = false;
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (!this.locked) {
                for (SwingGlobalMenuWindow sgw : this.swingGlobalMenuWindowList) {
                    sgw.lockMenuBar();
                }
                this.locked = true;
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            if (this.locked) {
                for (SwingGlobalMenuWindow sgw : this.swingGlobalMenuWindowList) {
                    sgw.unlockMenuBar();
                }
                this.locked = false;
            }
            e.getWindow().removeWindowListener(this);
            e.getWindow().removeComponentListener(this);
        }
    }
}

