/*
 * Decompiled with CFR 0.152.
 */
package com.jarego.jayatana.basic;

import com.jarego.jayatana.basic.GlobalMenu;
import com.jarego.jayatana.swing.SwingGlobalMenuWindow;
import java.awt.Window;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class GlobalMenuAdapter {
    private static final int SPINCOUNT = 200;
    private final GlobalMenuImp globalMenuImp;
    private boolean lockedMenuBar = false;
    protected long approveRefreshWatcher = -1L;
    private Object window;
    private long windowXID;

    public GlobalMenuAdapter(Window window) {
        this(window, GlobalMenu.getWindowXID(window));
    }

    public GlobalMenuAdapter(Object window, long windowXID) {
        this.window = window;
        this.windowXID = windowXID;
        this.globalMenuImp = new GlobalMenuImp(this);
    }

    public void registerWatcher() {
        this.globalMenuImp.registerWatcher(this.windowXID);
    }

    protected void unregisterWatcher() {
        this.globalMenuImp.unregisterWatcher(this.windowXID);
    }

    protected void refreshWatcher() {
        this.globalMenuImp.refreshWatcher(this.windowXID);
    }

    protected void addMenu(int menuId, String label, char mnemonic, boolean enabled, boolean visible) {
        if (this.approveRefreshWatcher != -1L) {
            this.approveRefreshWatcher = System.currentTimeMillis() + 200L;
        }
        this.globalMenuImp.addMenu(this.windowXID, -1, menuId, GlobalMenuAdapter.formatLabelString(label, mnemonic), this.lockedMenuBar ? false : enabled, visible);
    }

    protected void addMenu(int menuParentId, int menuId, String label, char mnemonic, boolean enabled, boolean visible) {
        if (this.approveRefreshWatcher != -1L) {
            this.approveRefreshWatcher = System.currentTimeMillis() + 200L;
        }
        this.globalMenuImp.addMenu(this.windowXID, menuParentId, menuId, GlobalMenuAdapter.formatLabelString(label, mnemonic), enabled, visible);
    }

    protected void addMenuItem(int menuParentId, int menuId, String label, char mnemonic, boolean enabled, int modifiers, int keycode) {
        if (this.approveRefreshWatcher != -1L) {
            this.approveRefreshWatcher = System.currentTimeMillis() + 200L;
        }
        this.globalMenuImp.addMenuItem(this.windowXID, menuParentId, menuId, GlobalMenuAdapter.formatLabelString(label, mnemonic), enabled, modifiers, keycode);
    }

    protected void addMenuItemCheck(int menuParentId, int menuId, String label, char mnemonic, boolean enabled, int modifiers, int keycode, boolean selected) {
        if (this.approveRefreshWatcher != -1L) {
            this.approveRefreshWatcher = System.currentTimeMillis() + 200L;
        }
        this.globalMenuImp.addMenuItemCheck(this.windowXID, menuParentId, menuId, GlobalMenuAdapter.formatLabelString(label, mnemonic), enabled, modifiers, keycode, selected);
    }

    protected void addMenuItemRadio(int menuParentId, int menuId, String label, char mnemonic, boolean enabled, int modifiers, int keycode, boolean selected) {
        if (this.approveRefreshWatcher != -1L) {
            this.approveRefreshWatcher = System.currentTimeMillis() + 200L;
        }
        this.globalMenuImp.addMenuItemRadio(this.windowXID, menuParentId, menuId, GlobalMenuAdapter.formatLabelString(label, mnemonic), enabled, modifiers, keycode, selected);
    }

    protected void addSeparator(int menuParentId) {
        if (this.approveRefreshWatcher != -1L) {
            this.approveRefreshWatcher = System.currentTimeMillis() + 200L;
        }
        this.globalMenuImp.addSeparator(this.windowXID, menuParentId);
    }

    protected void updateMenu(int menuId, String label, char mnemonics, boolean enabled, boolean visible) {
        if (this.approveRefreshWatcher != -1L) {
            this.approveRefreshWatcher = System.currentTimeMillis() + 200L;
        }
        this.globalMenuImp.updateMenu(this.windowXID, menuId, GlobalMenuAdapter.formatLabelString(label, mnemonics), enabled, visible);
    }

    protected Object getWindow() {
        return this.window;
    }

    protected long getWindowXID() {
        return this.windowXID;
    }

    private static String formatLabelString(String text, char mnemonic) {
        if (text == null) {
            return "";
        }
        if (mnemonic > '\u0000') {
            Object output = "";
            boolean founded = false;
            for (char chr : text.toCharArray()) {
                if (!founded && Character.toUpperCase(mnemonic) == Character.toUpperCase(chr)) {
                    output = (String)output + "_";
                    founded = true;
                }
                output = (String)output + chr;
            }
            return output;
        }
        return text;
    }

    protected void refreshWatcherSafe() {
        if (this.approveRefreshWatcher == -1L) {
            this.approveRefreshWatcher = System.currentTimeMillis() + 200L;
            new Thread(this){
                final /* synthetic */ GlobalMenuAdapter this$0;
                {
                    GlobalMenuAdapter globalMenuAdapter = this$0;
                    Objects.requireNonNull(globalMenuAdapter);
                    this.this$0 = globalMenuAdapter;
                }

                @Override
                public void run() {
                    try {
                        while (System.currentTimeMillis() < this.this$0.approveRefreshWatcher) {
                            Thread.sleep(100L);
                        }
                    }
                    catch (InterruptedException e) {
                        Logger.getLogger(SwingGlobalMenuWindow.class.getName()).log(Level.WARNING, "Can't wait approve rebuild", e);
                    }
                    finally {
                        this.this$0.approveRefreshWatcher = -1L;
                        this.this$0.refreshWatcher();
                    }
                }
            }.start();
        } else {
            this.approveRefreshWatcher = System.currentTimeMillis() + 200L;
        }
    }

    public void lockMenuBar() {
        if (!this.lockedMenuBar) {
            this.lockedMenuBar = true;
            this.refreshWatcherSafe();
        }
    }

    public void unlockMenuBar() {
        if (this.lockedMenuBar) {
            this.lockedMenuBar = false;
            this.refreshWatcherSafe();
        }
    }

    protected abstract void register(int var1);

    protected abstract void unregister();

    protected abstract void menuActivated(int var1, int var2);

    protected abstract void menuAboutToShow(int var1, int var2);

    protected abstract void menuAfterClose(int var1, int var2);

    private static class GlobalMenuImp
    extends GlobalMenu {
        private final GlobalMenuAdapter globalMenuAdapter;

        public GlobalMenuImp(GlobalMenuAdapter globalMenuAdapter) {
            this.globalMenuAdapter = globalMenuAdapter;
        }

        @Override
        protected void register(int state) {
            this.globalMenuAdapter.register(state);
        }

        @Override
        protected void unregister() {
            this.globalMenuAdapter.unregister();
        }

        @Override
        protected void menuActivated(int parentMenuId, int menuId) {
            this.globalMenuAdapter.menuActivated(parentMenuId, menuId);
        }

        @Override
        protected void menuAboutToShow(int parentMenuId, int menuId) {
            if (this.globalMenuAdapter.approveRefreshWatcher != -1L) {
                this.globalMenuAdapter.approveRefreshWatcher = System.currentTimeMillis() + 200L;
            }
            this.globalMenuAdapter.menuAboutToShow(parentMenuId, menuId);
        }

        @Override
        protected void menuAfterClose(int parentMenuId, int menuId) {
            if (this.globalMenuAdapter.approveRefreshWatcher != -1L) {
                this.globalMenuAdapter.approveRefreshWatcher = System.currentTimeMillis() + 200L;
            }
            this.globalMenuAdapter.menuAfterClose(parentMenuId, menuId);
        }
    }
}

