/*
 * Decompiled with CFR 0.152.
 */
package com.jarego.jayatana;

import com.jarego.jayatana.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FeatureWrapper {
    private final List<FeatureWrapper> dependencies;
    private final String className;
    private Feature feature = null;
    private boolean deployed = false;

    private static List<FeatureWrapper> toFeatureWrapperArray(List<String> classNameList) {
        ArrayList<FeatureWrapper> fwList = new ArrayList<FeatureWrapper>();
        for (String cn : classNameList) {
            fwList.add(new FeatureWrapper(cn));
        }
        return fwList;
    }

    public FeatureWrapper(String className) {
        this(className, (List<FeatureWrapper>)null);
    }

    public FeatureWrapper(String className, String ... dependencies) {
        this(className, FeatureWrapper.toFeatureWrapperArray(Arrays.asList(dependencies)));
    }

    public FeatureWrapper(String className, FeatureWrapper ... dependencies) {
        this(className, Arrays.asList(dependencies));
    }

    public FeatureWrapper(String className, List<FeatureWrapper> dependencies) {
        this.className = className;
        this.dependencies = dependencies;
    }

    private Feature getInstance() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.feature == null) {
            this.feature = (Feature)Class.forName(this.className).newInstance();
        }
        return this.feature;
    }

    public synchronized boolean isDeployed() {
        return this.deployed;
    }

    public synchronized boolean deployOnce() {
        if (!this.deployed) {
            try {
                Feature feature;
                boolean ok = true;
                if (this.dependencies != null) {
                    for (FeatureWrapper fm : this.dependencies) {
                        if (!fm.isDeployed()) {
                            fm.deployOnce();
                        }
                        if (ok = ok && fm.isDeployed()) continue;
                        throw new Exception("failed dependency: " + fm.className);
                    }
                }
                if ((feature = this.getInstance()) != null) {
                    feature.deploy();
                    this.deployed = true;
                    return true;
                }
            }
            catch (Exception e) {
                Logger.getLogger(FeatureWrapper.class.getName()).log(Level.WARNING, "can't deploy feature: " + this.className, e);
            }
        }
        return false;
    }
}

