/* planify.vapi generated by valac 0.56.18-dirty, do not modify. */

namespace Constants {
	[CCode (cheader_filename = "planify.h")]
	public const string BACKUP_VERSION;
	[CCode (cheader_filename = "planify.h")]
	public const bool BLOCK_PAST_DAYS;
	[CCode (cheader_filename = "planify.h")]
	public const int COMPLETED_PAGE_SIZE;
	[CCode (cheader_filename = "planify.h")]
	public const string CONTACT_US;
	[CCode (cheader_filename = "planify.h")]
	public const int DESTROY_TIMEOUT;
	[CCode (cheader_filename = "planify.h")]
	public const string DISCORD_URL;
	[CCode (cheader_filename = "planify.h")]
	public const string FLATHUB_URL;
	[CCode (cheader_filename = "planify.h")]
	public const int HEADERBAR_TITLE_SCROLL_THRESHOLD;
	[CCode (cheader_filename = "planify.h")]
	public const string ISSUE_URL;
	[CCode (cheader_filename = "planify.h")]
	public const string KOFI_URL;
	[CCode (cheader_filename = "planify.h")]
	public const string LIBERAPAY_URL;
	[CCode (cheader_filename = "planify.h")]
	public const string MASTODON_URL;
	[CCode (cheader_filename = "planify.h")]
	public const string PATREON_URL;
	[CCode (cheader_filename = "planify.h")]
	public const string PAYPAL_ME_URL;
	[CCode (cheader_filename = "planify.h")]
	public const int PRIORITY_1;
	[CCode (cheader_filename = "planify.h")]
	public const int PRIORITY_2;
	[CCode (cheader_filename = "planify.h")]
	public const int PRIORITY_3;
	[CCode (cheader_filename = "planify.h")]
	public const int PRIORITY_4;
	[CCode (cheader_filename = "planify.h")]
	public const int SCROLL_STEPS;
	[CCode (cheader_filename = "planify.h")]
	public const int SHORT_NAME_SIZE;
	[CCode (cheader_filename = "planify.h")]
	public const string SOUP_USER_AGENT;
	[CCode (cheader_filename = "planify.h")]
	public const int STARTUP_SYNC_TIMEOUT;
	[CCode (cheader_filename = "planify.h")]
	public const string TODOIST_CLIENT_ID;
	[CCode (cheader_filename = "planify.h")]
	public const string TODOIST_CLIENT_SECRET;
	[CCode (cheader_filename = "planify.h")]
	public const string TODOIST_SCOPE;
	[CCode (cheader_filename = "planify.h")]
	public const string TWITTER_URL;
	[CCode (cheader_filename = "planify.h")]
	public const int UPDATE_TIMEOUT;
	[CCode (cheader_filename = "planify.h")]
	public const string WEBLATE_URL;
}
namespace Layouts {
	[CCode (cheader_filename = "planify.h")]
	public class HeaderItem : Adw.Bin {
		public string _header_title;
		public string _placeholder_message;
		public string _subheader_title;
		public Gtk.Grid drop_target_end;
		public Gtk.Revealer drop_target_end_revealer;
		public Gtk.ListBox listbox;
		public HeaderItem (string? header_title = null);
		public void add_child (Gtk.Widget widget);
		public void add_widget_end (Gtk.Widget widget);
		public void check_visibility (int size);
		public void clean_up ();
		public void clear ();
		public GLib.List<Gtk.ListBoxRow> get_children ();
		public void insert_child (Gtk.Widget widget, int position);
		public void invalidate_filter ();
		public void remove_child (Gtk.Widget widget);
		public void set_filter_func (owned Gtk.ListBoxFilterFunc? filter_func);
		public void set_sort_func (owned Gtk.ListBoxSortFunc? sort_func);
		public bool card { set; }
		public string header_title { get; set; }
		public Gtk.ListBox items { get; }
		public int listbox_margin_top { set; }
		public bool listbox_no_margin { set; }
		public string placeholder_message { get; set; }
		public bool reveal { get; set; }
		public bool reveal_child { set; }
		public bool separator_lines { set; }
		public bool separator_space { set; }
		public bool show_separator { set; }
		public string subheader_title { get; set; }
		public signal void add_activated ();
		public signal void row_activated (Gtk.Widget widget);
	}
	[CCode (cheader_filename = "planify.h")]
	public class QuickAddCore : Adw.Bin {
		public enum FocusedWidget {
			CONTENT_ENTRY,
			DESCRIPTION_TEXTVIEW
		}
		public const string SHORTCUTS_KEY_PROJECTS;
		public const string SHORTCUTS_KEY_REMINDERS;
		public QuickAddCore (bool is_window_quick_add = false);
		public void added_successfully ();
		public void clean_up ();
		public void for_parent (Objects.Item _item);
		public void for_project (Objects.Project project);
		public void for_section (Objects.Section section);
		public void set_due (GLib.DateTime? datetime);
		public void set_duedate (Objects.DueDate duedate);
		public void set_labels (Gee.HashMap<string,Objects.Label> new_labels);
		public void set_pinned (bool pinned);
		public void set_priority (int priority);
		public void update_content (string content = "");
		public bool ctrl_pressed { get; set; }
		public Layouts.QuickAddCore.FocusedWidget current_focus { get; private set; }
		public bool is_loading { set; }
		public bool is_window_quick_add { get; construct; }
		public Objects.Item item { get; set; }
		public bool labels_picker_activate_shortcut { get; set; }
		public NewTaskPosition new_task_position { get; set; }
		public int position { get; set; }
		public bool project_picker_activate_shortcut { get; set; }
		public bool reminder_picker_activate_shortcut { get; set; }
		public signal void add_item_db (Objects.Item item, Gee.ArrayList<Objects.Reminder> reminders);
		public signal void error (HttpResponse response);
		public signal void hide_destroy ();
		public signal void parent_can_close (bool active);
		public signal void send_interface_id (string id);
	}
}
namespace Utils {
	[CCode (cheader_filename = "planify.h")]
	public class Datetime {
		public Datetime ();
		public static ICal.Time datetimes_to_icaltime (GLib.DateTime date, GLib.DateTime? time_local, ICal.Timezone? timezone = get_system_timezone ().copy ());
		public static string days_left (GLib.DateTime datetime, bool show_today = false);
		public static GLib.DateTime format_date (GLib.DateTime date);
		public static string get_calendar_icon (GLib.DateTime date);
		public static GLib.DateTime get_date_from_string (string date);
		public static GLib.DateTime get_date_only (GLib.DateTime date);
		public static GLib.DateTime get_datetime_no_seconds (GLib.DateTime date, GLib.DateTime? time = null);
		public static int get_days_of_month (int index, int year_nav);
		public static string get_default_date_format (bool with_weekday = false, bool with_day = true, bool with_year = false);
		public static string get_default_date_format_from_date (GLib.DateTime? date);
		public static string get_default_time_format (bool is_12h = is_clock_format_12h (), bool with_second = false);
		public static string get_markdown_format_date (Objects.Item item);
		public static int get_next_day_of_week_from_recurrency_week (GLib.DateTime datetime, Objects.DueDate duedate);
		public static string get_recurrency_weeks (RecurrencyType recurrency_type, int recurrency_interval, string recurrency_weeks, string end = "");
		public static string get_relative_date_from_date (GLib.DateTime? datetime);
		public static GLib.DateTime get_start_of_month (owned GLib.DateTime? date = null);
		public static ICal.Timezone? get_system_timezone ();
		public static GLib.DateTime get_today_format_date ();
		public static GLib.DateTime? get_todoist_datetime (string? date);
		public static string get_todoist_datetime_format (GLib.DateTime date);
		public static bool has_time (GLib.DateTime datetime);
		public static bool has_time_from_string (string date);
		public static ICal.Time ical_convert_to_local (ICal.Time time);
		public static GLib.DateTime ical_to_date_time_local (ICal.Time date);
		public static bool is_clock_format_12h ();
		public static bool is_current_month (GLib.DateTime date);
		public static bool is_next_week (GLib.DateTime date);
		public static bool is_next_x_week (GLib.DateTime date, int days);
		public static bool is_overdue (GLib.DateTime date);
		public static bool is_same_day (GLib.DateTime day1, GLib.DateTime day2);
		public static bool is_this_month (GLib.DateTime date);
		public static bool is_this_week (GLib.DateTime date);
		public static bool is_today (GLib.DateTime date);
		public static bool is_tomorrow (GLib.DateTime date);
		public static bool is_yesterday (GLib.DateTime date);
		public static GLib.DateTime next_recurrency (GLib.DateTime datetime, Objects.DueDate duedate);
		public static GLib.DateTime next_recurrency_week (GLib.DateTime datetime, Objects.DueDate duedate, bool user = false);
		public static void parse_todoist_recurrency (Objects.DueDate duedate, Json.Object object);
		public static void recurrence_to_due (ICal.Recurrence recurrence, Objects.DueDate due);
	}
}
namespace Services {
	namespace CalDAV {
		namespace Providers {
			[CCode (cheader_filename = "planify.h")]
			public class Nextcloud : GLib.Object {
				public Nextcloud ();
				public async HttpResponse start_login_flow (string server_url, GLib.Cancellable cancellable, bool ignore_ssl = false);
			}
		}
		[CCode (cheader_filename = "planify.h")]
		public class CalDAVClient : Services.CalDAV.WebDAVClient {
			public delegate void ProgressCallback (int current, int total, string message);
			public CalDAVClient (Soup.Session session, string base_url, string username, string password, bool ignore_ssl = false);
			public async HttpResponse add_item (Objects.Item item, bool update = false);
			public async HttpResponse complete_item (Objects.Item item);
			public async HttpResponse create_project (Objects.Project project);
			public async HttpResponse delete_item (Objects.Item item);
			public async HttpResponse delete_project (Objects.Project project);
			public async void fetch_items_for_project (Objects.Project project, GLib.Cancellable cancellable, owned Services.CalDAV.CalDAVClient.ProgressCallback? progress_callback = null) throws GLib.Error;
			public async void fetch_project_details (Objects.Project project, GLib.Cancellable cancellable) throws GLib.Error;
			public async Gee.ArrayList<Objects.Project> fetch_project_list (Objects.Source source, GLib.Cancellable cancellable) throws GLib.Error;
			public async string? get_calendar_home (string principal_url, GLib.Cancellable cancellable) throws GLib.Error;
			public async string? get_principal_url (GLib.Cancellable cancellable) throws GLib.Error;
			public bool is_deleted_calendar (GXml.DomElement? resourcetype);
			public async HttpResponse move_item (Objects.Item item, Objects.Project destination_project);
			public async void sync (Objects.Source source, GLib.Cancellable cancellable) throws GLib.Error;
			public async void sync_tasklist (Objects.Project project, GLib.Cancellable cancellable) throws GLib.Error;
			public async HttpResponse update_project (Objects.Project project);
			public async void update_sync_token (Objects.Project project, GLib.Cancellable cancellable) throws GLib.Error;
			public async void update_userdata (string principal_url, Objects.Source source, GLib.Cancellable cancellable) throws GLib.Error;
		}
		[CCode (cheader_filename = "planify.h")]
		public class Core : GLib.Object {
			public Core ();
			public async HttpResponse add_caldav_account (Objects.Source source, GLib.Cancellable cancellable);
			public void clear ();
			public Services.CalDAV.CalDAVClient get_client (Objects.Source source);
			public Services.CalDAV.CalDAVClient? get_client_by_id (string source_id);
			public static Services.CalDAV.Core get_default ();
			public async HttpResponse login (CalDAVType caldav_type, string dav_url, string username, string password, string calendar_home, GLib.Cancellable cancellable, bool ignore_ssl = false);
			public void remove_client (string source_id);
			public async string? resolve_calendar_home (CalDAVType caldav_type, string dav_url, string username, string password, GLib.Cancellable cancellable, bool ignore_ssl = false) throws GLib.Error;
			public async string resolve_well_known_caldav (Soup.Session session, string base_url, bool ignore_ssl = false) throws GLib.Error;
			public async void sync (Objects.Source source);
			public signal void sync_progress (int current, int total, string message);
		}
		[CCode (cheader_filename = "planify.h")]
		public class WebDAVClient : GLib.Object {
			protected string base_url;
			protected bool ignore_ssl;
			protected string password;
			protected Soup.Session session;
			protected string username;
			public WebDAVClient (Soup.Session session, string base_url, string username, string password, bool ignore_ssl = false);
			public void cleanup ();
			public string get_absolute_url (string href);
			public async Services.CalDAV.WebDAVMultiStatus propfind (string url, string xml, string depth, GLib.Cancellable cancellable) throws GLib.Error;
			public async Services.CalDAV.WebDAVMultiStatus report (string url, string xml, string depth, GLib.Cancellable cancellable) throws GLib.Error;
			protected async string send_request (string method, string url, string content_type, string? body, string? depth, GLib.Cancellable? cancellable, Soup.Status[] expected_statuses, GLib.HashTable<string,string>? extra_headers = null) throws GLib.Error;
		}
		[CCode (cheader_filename = "planify.h")]
		public class WebDAVMultiStatus : GLib.Object {
			public WebDAVMultiStatus ();
			public void debug_print ();
			public WebDAVMultiStatus.from_string (string xml) throws GLib.Error;
			public string? get_first_text_content_by_tag_name (string tag_name);
			public Gee.ArrayList<Services.CalDAV.WebDAVResponse> responses ();
		}
		[CCode (cheader_filename = "planify.h")]
		public class WebDAVPropStat : GLib.Object {
			public WebDAVPropStat (GXml.DomElement element);
			public GXml.DomElement? get_first_prop_with_tagname (string tagname);
			public GXml.DomElement prop { get; private set; }
			public Soup.Status status { get; private set; }
		}
		[CCode (cheader_filename = "planify.h")]
		public class WebDAVResponse : GLib.Object {
			public WebDAVResponse (GXml.DomElement element);
			public Gee.ArrayList<Services.CalDAV.WebDAVPropStat> propstats ();
			public string? href { get; private set; }
			public Soup.Status status { get; private set; }
		}
	}
	[CCode (cheader_filename = "planify.h")]
	public class Database : GLib.Object {
		public Database ();
		public Objects.Attachment _fill_attachment (Sqlite.Statement stmt);
		public Objects.Item _fill_item (Sqlite.Statement stmt);
		public Objects.Label _fill_label (Sqlite.Statement stmt);
		public Objects.ObjectEvent _fill_object_event (Sqlite.Statement stmt);
		public Objects.Project _fill_project (Sqlite.Statement stmt);
		public Objects.Queue _fill_queue (Sqlite.Statement stmt);
		public Objects.Reminder _fill_reminder (Sqlite.Statement stmt);
		public Objects.Section _fill_section (Sqlite.Statement stmt);
		public void add_calendar_url_to_project ();
		public void add_int_column (string table, string column, int default_value);
		public void add_item_label_column ();
		public void add_project_labels_source_id ();
		public void add_text_column (string table, string column, string default_value);
		public bool archive_project (Objects.Project project);
		public bool archive_section (Objects.Section section);
		public void clear_cur_temp_ids ();
		public void clear_database ();
		public void clear_queue ();
		public bool column_exists (string table, string column);
		public bool complete_item (Objects.Item item, bool old_checked);
		public bool curTempIds_exists (string id);
		public bool delete_attachment (Objects.Attachment attachment);
		public bool delete_item (Objects.Item item);
		public bool delete_label (Objects.Label label);
		public bool delete_project (Objects.Project project);
		public void delete_project_db (Objects.Project project);
		public bool delete_reminder (Objects.Reminder reminder);
		public bool delete_section (Objects.Section section);
		public bool delete_source (Objects.Source source);
		public Gee.ArrayList<Objects.Queue> get_all_queue ();
		public Gee.ArrayList<Objects.Attachment> get_attachments_collection ();
		public static Services.Database get_default ();
		public Json.Object? get_due_parameter (string data);
		public Gee.ArrayList<Objects.ObjectEvent> get_events_by_item (string id, int start_week, int end_week);
		public Objects.Item get_item_by_id (string id);
		public Gee.ArrayList<Objects.Item> get_items_collection ();
		public Gee.ArrayList<Objects.Label> get_labels_collection ();
		public string get_labels_ids (Gee.ArrayList<Objects.Label> labels);
		public Gee.ArrayList<Objects.Project> get_projects_collection ();
		public Gee.ArrayList<Objects.Reminder> get_reminders_by_item_id (string id);
		public Gee.ArrayList<Objects.Reminder> get_reminders_collection ();
		public Gee.ArrayList<Objects.Section> get_sections_collection ();
		public Gee.ArrayList<Objects.Source> get_sources_collection ();
		public string get_temp_id (string id);
		public void init_database ();
		public void insert_CurTempIds (string id, string temp_id, string object);
		public bool insert_attachment (Objects.Attachment attachment);
		public bool insert_item (Objects.Item item, bool insert = true);
		public bool insert_label (Objects.Label label);
		public bool insert_project (Objects.Project project);
		public void insert_queue (Objects.Queue queue);
		public bool insert_reminder (Objects.Reminder reminder);
		public bool insert_section (Objects.Section section);
		public bool insert_source (Objects.Source source);
		public bool move_item (Objects.Item item);
		public bool move_section (Objects.Section section, string old_project_id);
		public bool move_section_items (Objects.Section section);
		public void patch_database ();
		public void remove_CurTempIds (string id);
		public void remove_queue (string uuid);
		public void update_child_order (Objects.BaseObject base_object);
		public bool update_item (Objects.Item item, string update_id = "");
		public bool update_item_child_id (string current_id, string new_id);
		public bool update_item_id (string current_id, string new_id);
		public bool update_label (Objects.Label label);
		public bool update_project (Objects.Project project);
		public bool update_project_id (string current_id, string new_id);
		public bool update_project_item_id (string current_id, string new_id);
		public bool update_project_section_id (string current_id, string new_id);
		public bool update_section (Objects.Section section);
		public bool update_section_id (string current_id, string new_id);
		public bool update_section_item_id (string current_id, string new_id);
		public bool update_source (Objects.Source source);
		public bool verify_integrity ();
		public bool is_opened { get; set; }
		public signal void opened ();
		public signal void reset ();
	}
	[CCode (cheader_filename = "planify.h")]
	public class EventBus : GLib.Object {
		public bool _mobile_mode;
		public bool ctrl_key_pressed;
		public bool item_edit_active;
		public bool multi_select_enabled;
		public EventBus ();
		public static Services.EventBus get_default ();
		public bool mobile_mode { get; set; }
		public signal void avatar_downloaded ();
		public signal void checked_toggled (Objects.Item item, bool old_checked);
		public signal void close_item ();
		public signal void close_item_edit ();
		public signal void connect_all_accels ();
		public signal void connect_typing_accel ();
		public signal void day_changed ();
		public signal void delete_row_project (Objects.Project project);
		public signal void dim_content (bool active, string focused_item_id = "");
		public signal void disconnect_all_accels ();
		public signal void disconnect_typing_accel ();
		public signal void drag_items_end (string project_id);
		public signal void drag_n_drop_active (string project_id, bool active);
		public signal void escape_pressed ();
		public signal void expand_all (string project_id, bool active);
		public signal void favorite_toggled (Objects.Project project);
		public signal void item_moved (Objects.Item item, string old_project_id, string old_section_id, string old_parent_id = "");
		public signal void item_selected (string? id);
		public signal void magic_button_activated (bool activated);
		public signal void magic_button_visible (bool active);
		public signal void mobile_mode_change ();
		public signal void open_item (Objects.Item item);
		public signal void pane_selected (PaneType panel_type, string id);
		public signal void project_parent_changed (Objects.Project project, string old_parent_id, bool collapsed = false);
		public signal void project_picker_changed (string id);
		public signal void projects_drag_begin (string source_id);
		public signal void projects_drag_end (string source_id);
		public signal void push_item (Objects.Item item);
		public signal void section_picker_changed (string id);
		public signal void section_sort_order_changed (string project_id);
		public signal void select_item (Gtk.Widget itemrow);
		public signal void send_error_toast (int error_code, string error_message);
		public signal void send_task_completed_toast (string project_id);
		public signal void send_toast (Adw.Toast toast);
		public signal void show_item_backdrop ();
		public signal void show_multi_select (bool enabled);
		public signal void task_selected (string? uid);
		public signal void theme_changed ();
		public signal void unselect_all ();
		public signal void unselect_item (Gtk.Widget itemrow);
		public signal void update_inserted_item_map (Gtk.Widget row, string old_section_id, string old_parent_id);
		public signal void update_inserted_project_map (Gtk.Widget row, string old_parent_id);
		public signal void update_section_sort_func (string project_id, string section_id, bool active);
		public signal void update_sources_position ();
	}
	[CCode (cheader_filename = "planify.h")]
	public class Promise<T> : GLib.Object {
		public Promise ();
		public void reject (string error);
		public void resolve (T result);
		public signal void rejected (string error);
		public signal void resolved (T value);
	}
	[CCode (cheader_filename = "planify.h")]
	public class Settings : GLib.Object {
		public GLib.Settings settings;
		public GLib.SettingsSchema settings_schema;
		public const string ID;
		public Settings ();
		public bool get_boolean (string key);
		public static Services.Settings get_default ();
		public double get_double (string key);
		public NewTaskPosition get_new_task_position ();
		public string get_string (string key);
		public bool has_key (string key);
		public void reset_settings ();
	}
	[CCode (cheader_filename = "planify.h")]
	public class Store : GLib.Object {
		public Store ();
		public void add_item (Objects.Item item, bool insert = true);
		public void archive_item (Objects.Item item, bool is_archived);
		public void archive_project (Objects.Project project);
		public void archive_section (Objects.Section section);
		public void complete_item (Objects.Item item, bool old_checked, bool complete_subitems = true);
		public void delete_attachment (Objects.Attachment attachment);
		public void delete_item (Objects.Item item);
		public void delete_label (Objects.Label label);
		public async void delete_project (Objects.Project project);
		public void delete_reminder (Objects.Reminder reminder);
		public void delete_section (Objects.Section section);
		public async void delete_source (Objects.Source source);
		public Gee.ArrayList<Objects.Item> get_all_items_by_search (string search_text);
		public Gee.ArrayList<Objects.Label> get_all_labels_by_search (string search_text);
		public Gee.ArrayList<Objects.Project> get_all_projects_archived ();
		public Gee.ArrayList<Objects.Project> get_all_projects_by_search (string search_text);
		public Gee.ArrayList<Objects.Section> get_all_sections_by_search (string search_text);
		public Gee.ArrayList<Objects.Attachment> get_attachments_by_item (Objects.Item item);
		public Gee.ArrayList<Objects.BaseObject> get_collection_by_type (Objects.BaseObject base_object);
		public Objects.Source? get_default_source ();
		public Objects.Project get_inbox_project ();
		public Objects.Item get_item (string id);
		public Objects.Item get_item_by_ical_url (string ical_url);
		public Gee.ArrayList<Objects.Item> get_items_by_baseobject (Objects.BaseObject object);
		public Gee.ArrayList<Objects.Item> get_items_by_date (GLib.DateTime date, bool checked = true);
		public Gee.ArrayList<Objects.Item> get_items_by_date_range (GLib.DateTime start_date, GLib.DateTime end_date, bool checked = true);
		public Gee.ArrayList<Objects.Item> get_items_by_label (Objects.Label label, bool checked = true);
		public Gee.ArrayList<Objects.Item> get_items_by_month (GLib.DateTime date, bool checked = true);
		public Gee.ArrayList<Objects.Item> get_items_by_overdeue_view (bool checked = true);
		public Gee.ArrayList<Objects.Item> get_items_by_priority (int priority, bool checked = true);
		public Gee.ArrayList<Objects.Item> get_items_by_project (Objects.Project project);
		public Gee.ArrayList<Objects.Item> get_items_by_project_pinned (Objects.Project project);
		public Gee.ArrayList<Objects.Item> get_items_by_scheduled (bool checked = true);
		public Gee.ArrayList<Objects.Item> get_items_checked ();
		public Gee.ArrayList<Objects.Item> get_items_checked_by_project (Objects.Project project);
		public Gee.ArrayList<Objects.Item> get_items_completed ();
		public Gee.ArrayList<Objects.Item> get_items_has_labels ();
		public Gee.ArrayList<Objects.Item> get_items_no_date (bool checked = true);
		public Gee.ArrayList<Objects.Item> get_items_no_parent (bool checked = true);
		public Gee.ArrayList<Objects.Item> get_items_pinned (bool checked = true);
		public Gee.ArrayList<Objects.Item> get_items_repeating (bool checked = true);
		public Gee.ArrayList<Objects.Item> get_items_unlabeled (bool checked = true);
		public Objects.Label get_label (string id);
		public Objects.Label? get_label_by_name (string name, bool lowercase = false, string source_id = "");
		public Gee.ArrayList<Objects.Label> get_labels_by_item_labels (string labels);
		public Gee.ArrayList<Objects.Label> get_labels_by_source (string source_id);
		public Objects.Project get_project (string id);
		public Objects.Project get_project_via_url (string calendar_url);
		public Gee.ArrayList<Objects.Project> get_projects_by_source (string source_id);
		public Objects.Reminder get_reminder (string id);
		public Gee.ArrayList<Objects.Reminder> get_reminders_by_item (Objects.Item item);
		public Objects.Section get_section (string id);
		public Gee.ArrayList<Objects.Section> get_sections_archived_by_project (Objects.Project project);
		public Gee.ArrayList<Objects.Section> get_sections_by_project (Objects.Project project);
		public Objects.Source get_source (string id);
		public Gee.ArrayList<Objects.Item> get_subitems (Objects.Item i);
		public Gee.ArrayList<Objects.Item> get_subitems_uncomplete (Objects.Item i);
		public Gee.ArrayList<Objects.Project> get_subprojects (Objects.Project _project);
		public void insert_attachment (Objects.Attachment attachment);
		public void insert_item (Objects.Item item, bool insert = true);
		public void insert_label (Objects.Label label);
		public void insert_project (Objects.Project project);
		public void insert_reminder (Objects.Reminder reminder);
		public void insert_section (Objects.Section section);
		public void insert_source (Objects.Source source);
		public static unowned Services.Store instance ();
		public bool is_database_empty ();
		public bool is_sources_empty ();
		public bool label_exists (string id);
		public void move_item (Objects.Item item, string old_project_id = "", string old_section_id = "", string old_parent_id = "");
		public void move_section (Objects.Section section, string old_project_id);
		public int next_item_child_order (string project_id, string section_id);
		public int next_project_child_order (Objects.Source source);
		public bool source_caldav_exists (string server_url, string username);
		public bool source_todoist_exists (string email);
		public void update_item (Objects.Item item, string update_id = "");
		public void update_item_id (string current_id, string new_id);
		public void update_item_pin (Objects.Item item);
		public void update_label (Objects.Label label);
		public void update_project (Objects.Project project);
		public void update_project_id (string current_id, string new_id);
		public void update_section (Objects.Section section);
		public void update_section_id (string current_id, string new_id);
		public void update_source (Objects.Source source);
		public bool valid_item_by_date (Objects.Item item, GLib.DateTime date, bool checked = true);
		public bool valid_item_by_date_range (Objects.Item item, GLib.DateTime start_date, GLib.DateTime end_date, bool checked = true);
		public bool valid_item_by_month (Objects.Item item, GLib.DateTime date, bool checked = true);
		public bool valid_item_by_overdue (Objects.Item item, GLib.DateTime date, bool checked = true);
		public Gee.ArrayList<Objects.Attachment> attachments { get; }
		public Gee.ArrayList<Objects.Item> items { get; }
		public Gee.ArrayList<Objects.Label> labels { get; }
		public Gee.ArrayList<Objects.Project> projects { get; }
		public Gee.ArrayList<Objects.Reminder> reminders { get; }
		public Gee.ArrayList<Objects.Section> sections { get; }
		public Gee.ArrayList<Objects.Source> sources { get; }
		public signal void attachment_deleted (Objects.Attachment attachment);
		public signal void item_added (Objects.Item item, bool insert = true);
		public signal void item_archived (Objects.Item item);
		public signal void item_deleted (Objects.Item item);
		public signal void item_label_added (Objects.Label label);
		public signal void item_label_deleted (Objects.Label label);
		public signal void item_moved (Objects.Item item, string old_project_id, string old_section_id, string old_parent_id);
		public signal void item_pin_change (Objects.Item item);
		public signal void item_unarchived (Objects.Item item);
		public signal void item_updated (Objects.Item item, string update_id);
		public signal void label_added (Objects.Label label);
		public signal void label_deleted (Objects.Label label);
		public signal void label_updated (Objects.Label label);
		public signal void project_added (Objects.Project project);
		public signal void project_archived (Objects.Project project);
		public signal void project_deleted (Objects.Project project);
		public signal void project_unarchived (Objects.Project project);
		public signal void project_updated (Objects.Project project);
		public signal void reminder_added (Objects.Reminder reminder);
		public signal void reminder_deleted (Objects.Reminder reminder);
		public signal void section_archived (Objects.Section section);
		public signal void section_deleted (Objects.Section section);
		public signal void section_moved (Objects.Section section, string old_project_id);
		public signal void section_unarchived (Objects.Section section);
		public signal void source_added (Objects.Source source);
		public signal void source_deleted (Objects.Source source);
		public signal void source_updated (Objects.Source source);
	}
	[CCode (cheader_filename = "planify.h")]
	public class Todoist : GLib.Object {
		public Todoist ();
		public async HttpResponse add (Objects.BaseObject object);
		public async void add_todoist_account (string token, HttpResponse response);
		public async HttpResponse complete_item (Objects.Item item);
		public async HttpResponse @delete (Objects.BaseObject object);
		public async HttpResponse duplicate_project (Objects.Project project);
		public static Services.Todoist get_default ();
		public string get_delete_json (string id, string type, string uuid);
		public int64 get_int_member_by_object (string object, string member);
		public Json.Object get_object_by_string (string object);
		public Json.Object get_object_member_by_object (string object, string member);
		public string get_queue_json (Gee.ArrayList<Objects.Queue?> queue);
		public string get_string_member_by_object (string object, string member);
		public string get_todoist_error (uint code);
		public GLib.Type get_type_by_member (string object, string member);
		public string get_update_items_json (Gee.ArrayList<Objects.Item> objects);
		public bool is_null_member (string object, string member);
		public bool is_todoist_error (uint status_code);
		public async HttpResponse login (string _url);
		public async HttpResponse login_token (string token);
		public async HttpResponse move_item (Objects.Item item, string type, string id);
		public async HttpResponse move_project_section (Objects.BaseObject base_object, string project_id);
		public async void queue (Objects.Source source);
		public async void sync (Objects.Source source);
		public async HttpResponse update (Objects.BaseObject object);
		public async void update_items (Gee.ArrayList<Objects.Item> objects);
	}
}
namespace ColorSchemeSettings {
	namespace FDO {
	}
	namespace Portal {
	}
	[CCode (cheader_filename = "planify.h")]
	public class Settings : GLib.Object {
		public enum ColorScheme {
			NO_PREFERENCE,
			DARK,
			LIGHT
		}
		public static unowned ColorSchemeSettings.Settings get_default ();
		public ColorSchemeSettings.Settings.ColorScheme prefers_color_scheme { get; private set; }
	}
}
namespace Chrono {
	namespace En {
		[CCode (cheader_filename = "planify.h")]
		public class ENCasualDateParser : GLib.Object, Chrono.AbstractParser {
			public ENCasualDateParser ();
		}
		[CCode (cheader_filename = "planify.h")]
		public class Parse : Chrono.Configuration {
			public Parse ();
		}
	}
	[CCode (cheader_filename = "planify.h")]
	public class Configuration : GLib.Object {
		public Configuration ();
		public Gee.ArrayList<Chrono.AbstractParser> parsers { get; set; }
	}
	[CCode (cheader_filename = "planify.h")]
	public class Parse : GLib.Object {
		public Parse (string lang = "en");
		public void parse (string text);
		public string lang { get; construct; }
	}
	[CCode (cheader_filename = "planify.h")]
	public class ParsingResult : GLib.Object {
		public ParsingResult ();
		public GLib.DateTime? datetime { get; set; }
		public int index { get; set; }
		public string text { get; set; }
	}
	[CCode (cheader_filename = "planify.h")]
	public interface AbstractParser : GLib.Object {
		public abstract Chrono.ParsingResult inner_extract (GLib.MatchInfo match);
		public abstract GLib.Regex inner_pattern ();
	}
}
namespace Widgets {
	namespace Calendar {
		[CCode (cheader_filename = "planify.h")]
		public class Calendar : Gtk.Box {
			public Calendar (bool block_past_days = Constants.BLOCK_PAST_DAYS);
			public void clean_up ();
			public void next_month ();
			public void previous_month ();
			public void reset ();
			public bool block_past_days { get; construct; }
			public GLib.DateTime current_date { get; }
			public GLib.DateTime date { get; set; }
			public signal void day_selected ();
		}
		[CCode (cheader_filename = "planify.h")]
		public class CalendarDay : Adw.Bin {
			public CalendarDay ();
			public void clean_up ();
			public GLib.DateTime date { get; set; }
			public int day { get; set; }
			public signal void day_selected ();
		}
		[CCode (cheader_filename = "planify.h")]
		public class CalendarHeader : Gtk.Box {
			public CalendarHeader ();
			public GLib.DateTime date { set; }
			public signal void center_clicked ();
			public signal void left_clicked ();
			public signal void right_clicked ();
		}
		[CCode (cheader_filename = "planify.h")]
		public class CalendarView : Adw.Bin {
			public CalendarView ();
			public void clean_up ();
			public void clear_style ();
			public void fill_grid_days (int start_day, int max_day, GLib.DateTime day, bool show_day, bool block_past_days);
			public GLib.DateTime current_date { get; }
			public signal void day_selected (int day);
		}
		[CCode (cheader_filename = "planify.h")]
		public class CalendarWeek : Gtk.Box {
			public CalendarWeek ();
			public void update ();
		}
	}
	namespace ContextMenu {
		[CCode (cheader_filename = "planify.h")]
		public class MenuCheckPicker : Adw.Bin {
			public Gee.HashMap<string,Widgets.ContextMenu.MenuItemCheckPicker> filters_map;
			public MenuCheckPicker (string title, string? icon = null);
			public void set_items (Gee.ArrayList<Objects.Filters.FilterItem> filters);
			public void unchecked (Objects.Filters.FilterItem filter);
			public string? icon { get; construct; }
			public string title { get; construct; }
			public signal void filter_change (Objects.Filters.FilterItem filter, bool active);
		}
		[CCode (cheader_filename = "planify.h")]
		public class MenuItem : Gtk.Button {
			public MenuItem (string title, string? icon = null);
			public bool arrow { get; set; }
			public bool autohide_popover { get; set; }
			public string icon { get; set; }
			public bool is_loading { get; set; }
			public int max_width_chars { set; }
			public string secondary_text { set; }
			public bool selected { get; set; }
			public string title { set; }
			public signal void activate_item ();
		}
		[CCode (cheader_filename = "planify.h")]
		public class MenuItemCheckPicker : Gtk.ListBoxRow {
			public MenuItemCheckPicker (Objects.Filters.FilterItem filter);
			public bool active { get; set; }
			public Objects.Filters.FilterItem filter { get; construct; }
			public signal void checked (Objects.Filters.FilterItem filter, bool active);
		}
		[CCode (cheader_filename = "planify.h")]
		public class MenuPicker : Adw.Bin {
			public class MenuItemPicker : Gtk.ListBoxRow {
				public MenuItemPicker (string title, string value);
				public bool active { get; set; }
				public Gtk.CheckButton group { set; }
				public string title { get; construct; }
				public string value { get; construct; }
				public signal void selected (string value);
			}
			public string _selected;
			public MenuPicker (string title, string? icon = null);
			public void add_item (string title, string value);
			public void update_selected (string value);
			public string? icon { get; construct; }
			public string selected { get; set; }
			public string title { get; construct; }
		}
		[CCode (cheader_filename = "planify.h")]
		public class MenuSeparator : Adw.Bin {
			public MenuSeparator ();
		}
		[CCode (cheader_filename = "planify.h")]
		public class MenuSwitch : Gtk.Button {
			public MenuSwitch (string title, string? icon = null);
			public bool active { get; set; }
			public string icon { set; }
			public string title { set; }
			public signal void activate_item ();
		}
	}
	namespace DateTimePicker {
		[CCode (cheader_filename = "planify.h")]
		public class DateTimePicker : Gtk.Popover {
			public DateTimePicker ();
			public void clean_up ();
			public void reset ();
			public void set_recurrency (Objects.DueDate _duedate);
			public Objects.DueDate duedate { get; set; }
			public bool visible_no_date { set; }
			public signal void duedate_changed ();
		}
		[CCode (cheader_filename = "planify.h")]
		public class RepeatConfig : Adw.NavigationPage {
			public RepeatConfig ();
			public void clean_up ();
			public Objects.DueDate duedate { set; }
			public signal void duedate_change (Objects.DueDate duedate);
		}
		[CCode (cheader_filename = "planify.h")]
		public class TimePicker : Adw.Bin {
			public TimePicker ();
			public void clean_up ();
			public void reset ();
			public string format_12 { get; construct; }
			public string format_24 { get; construct; }
			public bool has_time { get; set; }
			public bool no_time_visible { set; }
			public GLib.DateTime time { get; set; }
			public signal void activated ();
			public signal void time_added ();
			public signal void time_changed ();
		}
	}
	namespace LabelPicker {
		[CCode (cheader_filename = "planify.h")]
		public class LabelButton : Adw.Bin {
			public LabelButton ();
			public void clean_up ();
			public LabelButton.for_board ();
			public void open_picker ();
			public void reset ();
			public void update_tooltip_from_item (Objects.Item item);
			public bool is_board { get; construct; }
			public Gee.ArrayList<Objects.Label> labels { set; }
			public Objects.Source source { get; set; }
			public signal void labels_changed (Gee.HashMap<string,Objects.Label> labels);
			public signal void picker_opened (bool active);
		}
		[CCode (cheader_filename = "planify.h")]
		public class LabelPicker : Gtk.Popover {
			public LabelPicker ();
			public void clean_up ();
			public void reset ();
			public Gee.ArrayList<Objects.Label> labels { set; }
			public Gee.HashMap<string,Objects.Label> picked { get; }
			public Objects.Source source { set; }
		}
		[CCode (cheader_filename = "planify.h")]
		public class LabelQuickPicker : Gtk.Popover {
			public Gee.HashMap<string,Widgets.LabelPicker.LabelRow> labels_widgets_map;
			public LabelQuickPicker ();
			public void activate_selected ();
			public void navigate_listbox (bool down);
			public void reset_filter ();
			public void select_first_item ();
			public string filter_text { get; set; }
			public Objects.Source source { get; set; }
			public signal void label_selected (Objects.Label label);
		}
		[CCode (cheader_filename = "planify.h")]
		public class LabelRow : Gtk.ListBoxRow {
			public LabelRow (Objects.Label label);
			public void clean_up ();
			public void show_loading (bool show);
			public void update_checked_toggled ();
			public bool active { set; }
			public bool hide_check_button { get; set; }
			public Objects.Label label { get; construct; }
			public signal void checked_toggled (Objects.Label label, bool active);
		}
	}
	namespace ProjectPicker {
		[CCode (cheader_filename = "planify.h")]
		public class ProjectPickerButton : Adw.Bin {
			public Gee.HashMap<string,Widgets.SectionPicker.SectionPickerRow> sections_map;
			public ProjectPickerButton ();
			public void clean_up ();
			public void open_picker ();
			public void update_project_request ();
			public Objects.Project project { get; set; }
			public Objects.Section section { set; }
			public signal void picker_opened (bool active);
			public signal void project_change (Objects.Project project);
			public signal void section_change (Objects.Section? section);
		}
		[CCode (cheader_filename = "planify.h")]
		public class ProjectPickerPopover : Gtk.Popover {
			public ProjectPickerPopover ();
			public void clean_up ();
			public void set_selected_project (Objects.Project project);
			public signal void selected (Objects.Project project);
		}
		[CCode (cheader_filename = "planify.h")]
		public class ProjectPickerRow : Gtk.ListBoxRow {
			public ProjectPickerRow (Objects.Project project);
			public void clean_up ();
			public void update_request ();
			public bool is_selected { get; set; }
			public Objects.Project project { get; construct; }
			public signal void selected ();
		}
	}
	namespace ReminderPicker {
		[CCode (cheader_filename = "planify.h")]
		public class ReminderButton : Adw.Bin {
			public ReminderButton (bool is_creating = false);
			public void add_reminder (Objects.Reminder reminder, Gee.ArrayList<Objects.Reminder> reminders);
			public void clean_up ();
			public void delete_reminder (Objects.Reminder reminder, Gee.ArrayList<Objects.Reminder> reminders);
			public ReminderButton.for_board ();
			public void open_picker (bool suggestions_view = false);
			public Gee.ArrayList<Objects.Reminder> reminders ();
			public void set_reminders (Gee.ArrayList<Objects.Reminder> reminders);
			public bool is_board { get; construct; }
			public bool is_creating { get; construct; }
			public signal void picker_opened (bool active);
			public signal void reminder_added (Objects.Reminder reminder);
		}
		[CCode (cheader_filename = "planify.h")]
		public class ReminderPicker : Gtk.Popover {
			public ReminderPicker (bool is_creating = false);
			public void add_reminder (Objects.Reminder reminder);
			public void clean_up ();
			public void clear ();
			public void delete_reminder (Objects.Reminder reminder);
			public Gee.ArrayList<Objects.Reminder> reminders ();
			public void set_reminders (Gee.ArrayList<Objects.Reminder> reminders);
			public bool has_reminders { get; }
			public bool is_creating { get; construct; }
			public bool suggestions_view { set; }
			public signal void reminder_added (Objects.Reminder reminder);
			public signal void reminder_deleted (Objects.Reminder reminder);
		}
		[CCode (cheader_filename = "planify.h")]
		public class ReminderRow : Gtk.ListBoxRow {
			public ReminderRow (Objects.Reminder reminder);
			public void clean_up ();
			public void hide_destroy ();
			public ReminderRow.@new ();
			public Objects.Reminder reminder { get; construct; }
			public signal void activated ();
			public signal void deleted ();
		}
	}
	namespace SectionPicker {
		[CCode (cheader_filename = "planify.h")]
		public class SectionButton : Adw.Bin {
			public SectionButton ();
			public void set_sections (Gee.ArrayList<Objects.Section> sections);
			public void update_from_item (Objects.Item item);
			public signal void selected (Objects.Section section);
		}
		[CCode (cheader_filename = "planify.h")]
		public class SectionPicker : Gtk.Popover {
			public SectionPicker ();
			public void set_section (string section_id);
			public void set_sections (Gee.ArrayList<Objects.Section> sections);
			public signal void selected (Objects.Section section);
		}
		[CCode (cheader_filename = "planify.h")]
		public class SectionPickerRow : Gtk.ListBoxRow {
			public SectionPickerRow (Objects.Section section);
			public SectionPickerRow.for_no_section ();
			public Objects.Section section { get; construct; }
			public signal void update_section ();
		}
	}
	[CCode (cheader_filename = "planify.h")]
	public class CircularProgressBar : Gtk.DrawingArea {
		public CircularProgressBar (int size = 16);
		public void draw (Gtk.DrawingArea da, Cairo.Context cr, int width, int height);
		public override Gtk.SizeRequestMode get_request_mode ();
		[Description (blurb = "Width of the outer border", nick = "Border Width")]
		public int border_width { get; set; }
		[Description (blurb = "Center pad fill color (Check Gdk.RGBA parse method)", nick = "Inside circle fill color")]
		public string center_fill_color { get; set; }
		[Description (blurb = "Center Fill toggle", nick = "Center Fill")]
		public bool center_filled { get; set; }
		public string color { set; }
		[Description (blurb = "Gap between border and progress circle", nick = "Gap")]
		public int gap { get; set; }
		[Description (blurb = "Line Cap for stroke as in Cairo.LineCap", nick = "Line Cap")]
		public Cairo.LineCap line_cap { get; set; }
		[Description (blurb = "The circle radius line width", nick = "Circle width")]
		public int line_width { get; set; }
		[Description (blurb = "The percentage value [0.0 ... 1.0]", nick = "Percentage/Value")]
		public double percentage { get; set; }
		[Description (blurb = "Progress line color (Check GdkRGBA parse method)", nick = "Progress fill color")]
		public string progress_fill_color { get; set; }
		[Description (blurb = "The circular pad fill color (Check GdkRGBA parse method)", nick = "Circular radius fill color")]
		public string radius_fill_color { get; set; }
		[Description (blurb = "Radius Fill toggle", nick = "Radius Fill")]
		public bool radius_filled { get; set; }
		public int size { get; construct; }
		[Description (blurb = "Use thick circular style", nick = "Thick Style")]
		public bool thick_style { get; set; }
	}
	[CCode (cheader_filename = "planify.h")]
	public class IconColorProject : Adw.Bin {
		public Gtk.Image inbox_icon;
		public IconColorProject (int pixel_size);
		public void clean_up ();
		public void update_request ();
		public int pixel_size { get; construct; }
		public Objects.Project project { get; set; }
	}
	[CCode (cheader_filename = "planify.h")]
	public class ItemLabelChild : Gtk.Button {
		public ItemLabelChild (Objects.Label label);
		public void clean_up ();
		public void hide_destroy ();
		public void update_request ();
		public bool clickable { get; set; }
		public Objects.Label label { get; construct; }
	}
	[CCode (cheader_filename = "planify.h")]
	public class ItemLabels : Adw.Bin {
		public ItemLabels (Objects.Item item);
		public void add_item_label (Objects.Label label);
		public void add_labels ();
		public void clean_up ();
		public void remove_item_label (Objects.Label label);
		public void reset ();
		public void update_labels ();
		public Objects.Item item { get; construct; }
		public int top_margin { set; }
		public signal void label_clicked (Objects.Label label);
	}
	[CCode (cheader_filename = "planify.h")]
	public class LabelsPickerCore : Adw.Bin {
		public Gee.HashMap<string,Widgets.LabelPicker.LabelRow> labels_widgets_map;
		public Gee.HashMap<string,Objects.Label> picked;
		public LabelsPickerCore (LabelPickerType picker_type);
		public void add_labels_list (Gee.ArrayList<Objects.Label> labels_list);
		public void clean_up ();
		public void reset ();
		public bool is_loading { set; }
		public Gee.ArrayList<Objects.Label> labels { set; }
		public LabelPickerType picker_type { get; construct; }
		public Objects.Source source { get; set; }
		public signal void close ();
	}
	[CCode (cheader_filename = "planify.h")]
	public class LoadingButton : Gtk.Button {
		public LoadingButton (LoadingButtonType loading_type, string text_icon);
		public void update_icon (string icon_name);
		public LoadingButton.with_icon (string icon_name, int icon_size = 16);
		public LoadingButton.with_label (string label);
		public int icon_size { get; construct; }
		[Description (blurb = "Show loading", nick = "Show loading")]
		public bool is_loading { get; set; }
		public LoadingButtonType loading_type { get; construct; }
		public string text_icon { get; construct; }
	}
	[CCode (cheader_filename = "planify.h")]
	public class MarkdownEditor : Adw.Bin {
		public GtkSource.Buffer buffer;
		public Gtk.TextView text_view;
		public MarkdownEditor ();
		public void apply_h1_format ();
		public void apply_h2_format ();
		public void apply_ordered_list_format ();
		public void apply_unordered_list_format ();
		public void cleanup ();
		public void clear ();
		public void focus ();
		public string get_plain_text ();
		public string get_text ();
		public void set_text (string text);
		public void toggle_bold_format ();
		public void toggle_code_format ();
		public void toggle_italic_format ();
		public void toggle_strikethrough_format ();
		public void view_focus ();
		public bool is_editable { get; set; }
		public string placeholder_text { get; set; }
		public bool text_mode { get; }
		public signal void escape_pressed ();
		public signal void focus_in ();
		public signal void focus_out ();
		public signal void return_pressed ();
		public signal void text_changed (string text);
	}
	[CCode (cheader_filename = "planify.h")]
	public class PinButton : Gtk.Button {
		public PinButton ();
		public void reset ();
		public void update_from_item (Objects.Item item);
		public void update_request (bool pinned);
		public signal void changed ();
	}
	[CCode (cheader_filename = "planify.h")]
	public class PriorityButton : Adw.Bin {
		public PriorityButton ();
		public void animation ();
		public Gtk.Popover build_popover ();
		public void clean_up ();
		public PriorityButton.for_board ();
		public void reset ();
		public void set_priority (int priority);
		public void update_from_item (Objects.Item item);
		public bool is_board { get; construct; }
		public signal void changed (int priority);
		public signal void picker_opened (bool active);
	}
	[CCode (cheader_filename = "planify.h")]
	public class ProjectPickerCore : Adw.Bin {
		public ProjectPickerCore (Objects.Source? source = null);
		public void clean_up ();
		public void set_selected_project (Objects.Project project);
		public Objects.Source? source { get; construct; }
		public signal void close ();
		public signal void selected (Objects.Project project);
	}
	[CCode (cheader_filename = "planify.h")]
	public class ScheduleButton : Gtk.Grid {
		public ScheduleButton (string label = GLib._ ("Schedule"));
		public void clean_up ();
		public ScheduleButton.for_board (string label = GLib._ ("Schedule"));
		public void reset ();
		public void update_from_item (Objects.Item item);
		public Objects.DueDate duedate { get; set; }
		public bool is_board { get; construct; }
		public string label { get; construct; }
		public bool visible_clear_button { set; }
		public bool visible_no_date { set; }
		public signal void duedate_changed ();
		public signal void picker_opened (bool active);
	}
	[CCode (cheader_filename = "planify.h")]
	public class StatusButton : Adw.Bin {
		public StatusButton ();
		public Gtk.Popover build_popover ();
		public void set_status (bool active);
		public void update_from_item (Objects.Item item);
		public bool is_board { get; construct; }
		public signal void changed (bool status);
	}
	[CCode (cheader_filename = "planify.h")]
	public class TextView : Gtk.TextView {
		public TextView ();
		public string get_text ();
		public void set_text (string text);
		public void update_on_leave ();
		public bool event_focus { get; set; }
		public string placeholder_text { get; set; }
		public signal void enter ();
		public signal void leave ();
	}
}
namespace Objects {
	namespace Filters {
		[CCode (cheader_filename = "planify.h")]
		public class AllItems : Objects.BaseObject {
			public AllItems ();
			public override void count_update ();
			public static Objects.Filters.AllItems get_default ();
			public override string theme_color ();
			public override int update_count ();
		}
		[CCode (cheader_filename = "planify.h")]
		public class Anytime : Objects.BaseObject {
			public Anytime ();
			public override void count_update ();
			public static Objects.Filters.Anytime get_default ();
			public override string theme_color ();
			public override int update_count ();
		}
		[CCode (cheader_filename = "planify.h")]
		public class Completed : Objects.BaseObject {
			public Completed ();
			public override void count_update ();
			public static Objects.Filters.Completed get_default ();
			public override string theme_color ();
			public override int update_count ();
		}
		[CCode (cheader_filename = "planify.h")]
		public class FilterItem : GLib.Object {
			public FilterItem ();
			public FilterItemType filter_type { get; set; }
			public string id { get; }
			public string name { get; set; }
			public string value { get; set; }
		}
		[CCode (cheader_filename = "planify.h")]
		public class Inbox : Objects.BaseObject {
			public Inbox ();
			public static Objects.Filters.Inbox get_default ();
			public override string theme_color ();
		}
		[CCode (cheader_filename = "planify.h")]
		public class Labels : Objects.BaseObject {
			public Labels ();
			public override void count_update ();
			public static Objects.Filters.Labels get_default ();
			public override string theme_color ();
			public override int update_count ();
		}
		[CCode (cheader_filename = "planify.h")]
		public class Pinboard : Objects.BaseObject {
			public Pinboard ();
			public override void count_update ();
			public static Objects.Filters.Pinboard get_default ();
			public override string theme_color ();
			public override int update_count ();
		}
		[CCode (cheader_filename = "planify.h")]
		public class Priority : Objects.BaseObject {
			public const int HIGH;
			public const int LOW;
			public const int MEDIUM;
			public const int NONE;
			public Priority (int priority);
			public static Objects.Filters.Priority get_default (int priority);
			public static Objects.Filters.Priority high ();
			public static Objects.Filters.Priority low ();
			public static Objects.Filters.Priority medium ();
			public static Objects.Filters.Priority none ();
			public string color { get; }
			public int count { get; set; }
			public string icon { get; }
			public int priority { get; construct; }
			public string title { get; }
		}
		[CCode (cheader_filename = "planify.h")]
		public class Repeating : Objects.BaseObject {
			public Repeating ();
			public override void count_update ();
			public static Objects.Filters.Repeating get_default ();
			public override string theme_color ();
			public override int update_count ();
		}
		[CCode (cheader_filename = "planify.h")]
		public class Scheduled : Objects.BaseObject {
			public Scheduled ();
			public override void count_update ();
			public static Objects.Filters.Scheduled get_default ();
			public override string theme_color ();
			public override int update_count ();
			public int scheduled_count { get; set; }
		}
		[CCode (cheader_filename = "planify.h")]
		public class Today : Objects.BaseObject {
			public Today ();
			public override void count_update ();
			public static Objects.Filters.Today get_default ();
			public override int update_count ();
			public int overdeue_count { get; set; }
		}
		[CCode (cheader_filename = "planify.h")]
		public class Tomorrow : Objects.BaseObject {
			public Tomorrow ();
			public override void count_update ();
			public static Objects.Filters.Tomorrow get_default ();
			public override string theme_color ();
			public override int update_count ();
		}
		[CCode (cheader_filename = "planify.h")]
		public class Unlabeled : Objects.BaseObject {
			public Unlabeled ();
			public override void count_update ();
			public static Objects.Filters.Unlabeled get_default ();
			public override string theme_color ();
			public override int update_count ();
		}
	}
	[CCode (cheader_filename = "planify.h")]
	public class Attachment : GLib.Object {
		public Attachment ();
		public void @delete ();
		public Objects.Attachment duplicate ();
		public string to_string ();
		public string file_name { get; set; }
		public string file_path { get; set; }
		public int64 file_size { get; set; }
		public string file_type { get; set; }
		public string id { get; set; }
		public Objects.Item item { get; set; }
		public string item_id { get; set; }
		public signal void deleted ();
	}
	[CCode (cheader_filename = "planify.h")]
	public class BaseObject : GLib.Object {
		public int? _item_count;
		public double? _percentage;
		public Gee.HashMap<string,Objects.Filters.FilterItem> filters;
		public BaseObject ();
		public void add_filter (Objects.Filters.FilterItem filter);
		public virtual void count_update ();
		public virtual string get_add_json (string temp_id, string uuid);
		public Objects.Filters.FilterItem? get_filter (string id);
		public virtual string get_move_json (string uuid, string new_project_id);
		public virtual string get_update_json (string uuid, string? temp_id = null);
		public void remove_filter (Objects.Filters.FilterItem filter);
		public virtual string theme_color ();
		public virtual string to_json ();
		public virtual int update_count ();
		public void update_filter (Objects.Filters.FilterItem filter);
		public virtual double update_percentage ();
		public string color { get; set; }
		public string column_order_name { get; }
		public string icon_name { get; set; }
		public string id { get; set; }
		public string id_string { get; }
		public int item_count { get; set; }
		public string keywords { get; set; }
		public bool loading { get; set; }
		public string name { get; set; }
		public ObjectType object_type { get; }
		public string object_type_string { get; }
		public double percentage { get; }
		public bool sensitive { get; set; }
		public Objects.Source source { get; }
		public string table_name { get; }
		public string type_add { get; }
		public string type_delete { get; }
		public string type_update { get; }
		public uint update_timeout_id { get; set; }
		public string view_id { get; set; }
		public signal void archived ();
		public signal void count_updated ();
		public signal void deleted ();
		public signal void filter_added (Objects.Filters.FilterItem filters);
		public signal void filter_removed (Objects.Filters.FilterItem filters);
		public signal void filter_updated (Objects.Filters.FilterItem filters);
		public signal void handle_scroll_visibility_change (bool visible);
		public signal void loading_change ();
		public signal void sensitive_change ();
		public signal void unarchived ();
		public signal void updated (string update_id = "");
	}
	[CCode (cheader_filename = "planify.h")]
	public class Color : GLib.Object {
		public Color (int id, string name, string hexadecimal);
		public string hexadecimal { get; construct; }
		public int id { get; construct; }
		public string name { get; construct; }
	}
	[CCode (cheader_filename = "planify.h")]
	public class DueDate : GLib.Object {
		public DueDate ();
		public Objects.DueDate duplicate ();
		public DueDate.from_json (Json.Object object);
		public bool is_recurrency_equal (Objects.DueDate duedate);
		public void reset ();
		public string to_friendly_string ();
		public string to_string ();
		public void update_from_json (Json.Object object);
		public void update_from_todoist_json (Json.Object object);
		public string date { get; set; }
		public GLib.DateTime? datetime { get; set; }
		public GLib.DateTime end_datetime { get; }
		public RecurrencyEndType end_type { get; }
		public bool has_weeks { get; }
		public bool is_recurrency_end { get; }
		public bool is_recurring { get; set; }
		public bool recurrence_supported { get; set; }
		public int recurrency_count { get; set; }
		public string recurrency_end { get; set; }
		public int recurrency_interval { get; set; }
		public RecurrencyType recurrency_type { get; set; }
		public string recurrency_weeks { get; set; }
		public string time_zone { get; set; }
	}
	[CCode (cheader_filename = "planify.h")]
	public class Item : Objects.BaseObject {
		public Item ();
		public Gee.ArrayList<Objects.Label> _get_labels ();
		public Objects.Attachment? add_attachment_if_not_exists (Objects.Attachment attachment);
		public void add_item (Objects.Item item);
		public Objects.Item add_item_if_not_exists (Objects.Item new_item, bool insert = true);
		public void add_item_label (Objects.Label label);
		public Objects.Label add_label_if_not_exists (Objects.Label label);
		public void add_reminder (Objects.Reminder reminder);
		public void add_reminder_events (Objects.Reminder reminder);
		public Objects.Reminder? add_reminder_if_not_exists (Objects.Reminder reminder, bool insert_db = true);
		public void check_labels (Gee.HashMap<string,Objects.Label> new_labels);
		public async HttpResponse complete_item (bool old_checked);
		public void copy_clipboard ();
		public void delete_item ();
		public Objects.Label? delete_item_label (string id);
		public Objects.Item duplicate ();
		public bool exists_project (Objects.Project project);
		public Item.from_import_json (Json.Node node, Gee.ArrayList<Objects.Label> _labels = new Gee.ArrayList<Objects.Label> (null));
		public Item.from_json (Json.Node node);
		public Item.from_vtodo (string data, string _ical_url, string _project_id);
		public Objects.Item generate_copy ();
		public override string get_add_json (string temp_id, string uuid);
		public string get_check_json (string uuid, string type);
		public Objects.Item? get_item (string id);
		public Objects.Label? get_label (string id);
		public Gee.ArrayList<Objects.Label> get_labels_from_json (Json.Node node);
		public Gee.ArrayList<Objects.Label> get_labels_from_labels_json (Json.Node node, Gee.ArrayList<Objects.Label> labels_list);
		public Gee.HashMap<string,Objects.Label> get_labels_maps_from_caldav (GLib.SList<string> categories_list);
		public Gee.HashMap<string,Objects.Label> get_labels_maps_from_json (Json.Node node);
		public string get_labels_names (Gee.ArrayList<Objects.Label> labels);
		public string get_move_item (string uuid, string type, string move_id);
		public override string get_update_json (string uuid, string? temp_id = null);
		public bool has_label (string id);
		public bool has_labels ();
		public void move (Objects.Project project, string _section_id);
		public void patch_from_vtodo (string data, string _ical_url, bool is_update = false);
		public void set_parent (Objects.Item item);
		public void set_project (Objects.Project project);
		public void set_recurrency (Objects.DueDate duedate);
		public void set_section (Objects.Section section);
		public override string to_json ();
		public string to_markdown (int level = 0);
		public string to_move_json (string type, string move_id);
		public string to_vtodo ();
		public void update (string update_id = "");
		public void update_async (string update_id = "");
		public void update_async_timeout (string update_id = "");
		public void update_date (GLib.DateTime? datetime);
		public void update_due (Objects.DueDate duedate);
		public void update_from_json (Json.Node node);
		public void update_from_vtodo (string data, string _ical_url);
		public void update_local ();
		public void update_next_recurrency (Services.Promise<GLib.DateTime>? promise);
		public void update_pin (bool _pinned);
		public bool was_archived ();
		public bool activate_name_editable { get; set; }
		public string added_at { get; set; }
		public GLib.DateTime added_datetime { get; }
		public Gee.ArrayList<Objects.Attachment> attachments { get; }
		public Json.Builder builder { get; }
		public string calendar_data { get; }
		public bool checked { get; set; }
		public int child_order { get; set; }
		public bool collapsed { get; set; }
		public bool completed { get; }
		public string completed_at { get; set; }
		public GLib.DateTime completed_date { get; }
		public string content { get; set; }
		public int day_order { get; set; }
		public string description { get; set; }
		public Objects.DueDate due { get; set; }
		public string extra_data { get; set; }
		public bool has_due { get; }
		public bool has_parent { get; }
		public bool has_section { get; }
		public bool has_time { get; }
		public string ical_url { get; }
		public bool is_deleted { get; set; }
		public ItemType item_type { get; set; }
		public Gee.ArrayList<Objects.Item> items { get; }
		public Gee.ArrayList<Objects.Item> items_uncomplete { get; }
		public Gee.ArrayList<Objects.Label> labels { get; set; }
		public Objects.Item parent { get; }
		public string parent_id { get; set; }
		public bool pinned { get; set; }
		public string pinned_icon { get; }
		public int priority { get; set; }
		public string priority_color { get; }
		public string priority_icon { get; }
		public string priority_text { get; }
		public Objects.Project project { get; }
		public string project_id { get; set; }
		public Gee.ArrayList<Objects.Reminder> reminders { get; }
		public Objects.Section section { get; }
		public string section_id { get; set; }
		public string short_content { get; }
		public bool show_item { get; set; }
		public string updated_at { get; set; }
		public GLib.DateTime updated_datetime { get; }
		public signal void attachment_added (Objects.Attachment attachment);
		public signal void attachment_deleted (Objects.Attachment attachment);
		public signal void collapsed_change ();
		public signal void item_added (Objects.Item item);
		public signal void item_label_added (Objects.Label label);
		public signal void item_label_deleted (Objects.Label label);
		public signal void pin_updated ();
		public signal void reminder_added (Objects.Reminder reminder);
		public signal void reminder_deleted (Objects.Reminder reminder);
		public signal void show_item_changed ();
	}
	[CCode (cheader_filename = "planify.h")]
	public class Label : Objects.BaseObject {
		public Label ();
		public async void delete_label (Gtk.Window window);
		public Label.from_import_json (Json.Node node);
		public Label.from_json (Json.Node node);
		public override string get_add_json (string temp_id, string uuid);
		public override string get_update_json (string uuid, string? temp_id = null);
		public void update_from_json (Json.Node node);
		public SourceType backend_type { get; set; }
		public bool is_deleted { get; set; }
		public bool is_favorite { get; set; }
		public int item_order { get; set; }
		public int label_count { get; set; }
		public string short_name { get; }
		public Objects.Source source { get; }
		public string source_id { get; set; }
		public SourceType source_type { get; }
		public signal void label_count_updated ();
	}
	[CCode (cheader_filename = "planify.h")]
	public class ObjectEvent : GLib.Object {
		public ObjectEvent ();
		public Objects.DueDate? get_due_value (string value);
		public string get_labels_value (string value);
		public GLib.DateTime date { get; }
		public GLib.DateTime datetime { get; }
		public string event_date { get; set; }
		public ObjectEventType event_type { get; set; }
		public string icon_name { get; }
		public int64 id { get; set; }
		public string object_id { get; set; }
		public ObjectEventKeyType object_key { get; set; }
		public string object_new_value { get; set; }
		public string object_old_value { get; set; }
		public string object_type { get; set; }
		public string parent_item_id { get; set; }
		public string parent_project_id { get; set; }
		public string time { get; }
	}
	[CCode (cheader_filename = "planify.h")]
	public class Project : Objects.BaseObject {
		public Project ();
		public void add_item (Objects.Item item);
		public Objects.Item add_item_if_not_exists (Objects.Item new_item, bool insert = true);
		public void add_section (Objects.Section section);
		public Objects.Section add_section_if_not_exists (Objects.Section new_section);
		public Objects.Project? add_subproject_if_not_exists (Objects.Project new_project);
		public void archive_project (Gtk.Window window);
		public override void count_update ();
		public void delete_project (Gtk.Window window);
		public Objects.Project duplicate ();
		public Project.from_google_tasklist_json (Json.Node node);
		public Project.from_import_json (Json.Node node);
		public Project.from_json (Json.Node node);
		public Project.from_propstat (Services.CalDAV.WebDAVPropStat propstat, string url);
		public override string get_add_json (string temp_id, string uuid);
		public string get_content (GXml.DomElement element);
		public string get_id_from_url (GXml.DomElement element);
		public Objects.Item? get_item (string id);
		public override string get_move_json (string uuid, string new_parent_id);
		public Objects.Section? get_section (string id);
		public Objects.Project? get_subproject (string id);
		public override string get_update_json (string uuid, string? temp_id = null);
		public void remove_section (Objects.Section section);
		public void set_parent (Objects.Project project);
		public void share_mail ();
		public void share_markdown ();
		public override string to_json ();
		public string to_string ();
		public void unarchive_project ();
		public void update (bool use_timeout = true, bool show_loading = true);
		public override int update_count ();
		public void update_from_google_tasklist_json (Json.Node node);
		public void update_from_json (Json.Node node);
		public void update_from_propstat (Services.CalDAV.WebDAVPropStat propstat, bool update_sync_token = true);
		public void update_local ();
		public override double update_percentage ();
		public Gee.ArrayList<Objects.Item> all_items { get; }
		public SourceType backend_type { get; set; }
		public string calendar_url { get; set; }
		public int child_order { get; set; }
		public bool collapsed { get; set; }
		public string color_hex { get; }
		public string description { get; set; }
		public string due_date { get; set; }
		public string emoji { get; set; }
		public ProjectIconStyle icon_style { get; set; }
		public bool inbox_project { get; set; }
		public bool inbox_section_hidded { get; set; }
		public bool is_archived { get; set; }
		public bool is_deck { get; }
		public bool is_deleted { get; set; }
		public bool is_favorite { get; set; }
		public bool is_inbox_project { get; }
		public Gee.ArrayList<Objects.Item> items { get; }
		public Gee.ArrayList<Objects.Item> items_checked { get; }
		public Gee.ArrayList<Objects.Item> items_pinned { get; }
		public Objects.Project parent { get; }
		public string parent_id { get; set; }
		public string parent_id_string { get; }
		public Gee.ArrayList<Objects.Section> sections { get; }
		public Gee.ArrayList<Objects.Section> sections_archived { get; }
		public bool shared { get; set; }
		public string short_name { get; }
		public bool show_completed { get; set; }
		public bool show_multi_select { get; set; }
		public SortOrderType sort_order { get; set; }
		public SortedByType sorted_by { get; set; }
		public Objects.Source source { get; }
		public string source_id { get; set; }
		public SourceType source_type { get; }
		public Gee.ArrayList<Objects.Project> subprojects { get; }
		public string sync_id { get; set; }
		public bool team_inbox { get; set; }
		public string view_id { get; }
		public ProjectViewStyle view_style { get; set; }
		public signal void item_added (Objects.Item item);
		public signal void item_deleted (Objects.Item item);
		public signal void loading_changed (bool value);
		public signal void section_added (Objects.Section section);
		public signal void section_sort_order_changed ();
		public signal void show_completed_changed ();
		public signal void show_multi_select_change ();
		public signal void sort_order_changed ();
		public signal void sorted_by_changed ();
		public signal void subproject_added (Objects.Project project);
		public signal void sync_finished ();
		public signal void sync_started ();
		public signal void view_style_changed ();
	}
	[CCode (cheader_filename = "planify.h")]
	public class Queue : GLib.Object {
		public Queue ();
		public string args { get; set; }
		public string date_added { get; set; }
		public string object_id { get; set; }
		public string query { get; set; }
		public string temp_id { get; set; }
		public string uuid { get; set; }
	}
	[CCode (cheader_filename = "planify.h")]
	public class Release : GLib.Object {
		public Release ();
		public Release.from_json (Json.Object object);
		public string? get_release_message ();
		public string description { get; set; }
		public string release_type { get; set; }
		public int64 timestamp { get; set; }
		public string version { get; set; }
	}
	[CCode (cheader_filename = "planify.h")]
	public class Reminder : Objects.BaseObject {
		public Reminder ();
		public void @delete ();
		public Objects.Reminder duplicate ();
		public Reminder.from_json (Json.Node node);
		public override string get_add_json (string temp_id, string uuid);
		public override string get_update_json (string uuid, string? temp_id = null);
		public GLib.DateTime datetime { get; }
		public Objects.DueDate due { get; set; }
		public int is_deleted { get; set; }
		public Objects.Item item { get; set; }
		public string item_id { get; set; }
		public int mm_offset { get; set; }
		public int64 notify_uid { get; set; }
		public string relative_text { get; }
		public ReminderType reminder_type { get; set; }
		public string service { get; set; }
	}
	[CCode (cheader_filename = "planify.h")]
	public class Section : Objects.BaseObject {
		public Section ();
		public void add_item (Objects.Item item);
		public Objects.Item add_item_if_not_exists (Objects.Item new_item, bool insert = true);
		public void archive_section (Gtk.Window window);
		public void delete_section (Gtk.Window window);
		public Objects.Section duplicate ();
		public Section.from_import_json (Json.Node node);
		public Section.from_json (Json.Node node);
		public override string get_add_json (string temp_id, string uuid);
		public Objects.Item? get_item (string id);
		public override string get_move_json (string uuid, string new_project_id);
		public override string get_update_json (string uuid, string? temp_id = null);
		public void set_project (Objects.Project project);
		public override string to_json ();
		public void unarchive_section ();
		public void update (bool cloud = true);
		public void update_count ();
		public void update_from_json (Json.Node node);
		public void update_local ();
		public bool was_archived ();
		public bool activate_name_editable { get; set; }
		public string added_at { get; set; }
		public string archived_at { get; set; }
		public bool collapsed { get; set; }
		public string description { get; set; }
		public bool hidded { get; set; }
		public bool is_archived { get; set; }
		public bool is_deleted { get; set; }
		public Gee.ArrayList<Objects.Item> items { get; }
		public Objects.Project project { get; }
		public string project_id { get; set; }
		public int section_count { get; set; }
		public int section_order { get; set; }
		public string short_name { get; }
		public signal void item_added (Objects.Item item);
		public signal void item_deleted (Objects.Item item);
		public signal void section_count_updated ();
	}
	[CCode (cheader_filename = "planify.h")]
	public class Source : Objects.BaseObject {
		public Source ();
		public async void delete_source ();
		public Source.from_import_json (Json.Node node);
		public void remove_sync_server ();
		public void run_server ();
		public void save ();
		public string to_string ();
		public string added_at { get; set; }
		public string avatar_path { get; }
		public Objects.SourceCalDAVData caldav_data { get; }
		public int child_order { get; set; }
		public Objects.SourceData data { get; set; }
		public string display_name { get; set; }
		public string header_text { get; }
		public bool is_visible { get; set; }
		public string last_sync { get; set; }
		public SourceType source_type { get; set; }
		public string subheader_text { get; }
		public bool sync_server { get; set; }
		public Objects.SourceTodoistData todoist_data { get; }
		public string updated_at { get; set; }
		public string user_displayname { get; }
		public string user_email { get; }
		public signal void sync_failed ();
		public signal void sync_finished ();
		public signal void sync_started ();
	}
	[CCode (cheader_filename = "planify.h")]
	public class SourceCalDAVData : Objects.SourceData {
		public SourceCalDAVData ();
		public SourceCalDAVData.from_json (string json);
		public override string to_json ();
		public CalDAVType caldav_type { get; set; }
		public string calendar_home_url { get; set; }
		public bool ignore_ssl { get; set; }
		public string password { get; set; }
		public string server_url { get; set; }
		public string user_displayname { get; set; }
		public string user_email { get; set; }
		public string username { get; set; }
	}
	[CCode (cheader_filename = "planify.h")]
	public class SourceData : GLib.Object {
		public SourceData ();
		public virtual string to_json ();
		public Json.Builder builder { get; }
	}
	[CCode (cheader_filename = "planify.h")]
	public class SourceTodoistData : Objects.SourceData {
		public SourceTodoistData ();
		public SourceTodoistData.from_json (string json);
		public override string to_json ();
		public string access_token { get; set; }
		public string sync_token { get; set; }
		public string user_avatar { get; set; }
		public string user_email { get; set; }
		public string user_image_id { get; set; }
		public bool user_is_premium { get; set; }
		public string user_name { get; set; }
	}
	[CCode (cheader_filename = "planify.h")]
	public class TranslationMetric : GLib.Object {
		public TranslationMetric ();
		public TranslationMetric.from_json (string code, Json.Object object);
		public string code { get; set; }
		public string language { get; set; }
		public int total_strings { get; set; }
		public double translated_percent { get; set; }
		public int translated_strings { get; set; }
	}
}
[CCode (cheader_filename = "planify.h")]
public enum ColorScheme {
	NO_PREFERENCE,
	DARK,
	LIGHT
}
[CCode (cheader_filename = "planify.h")]
public enum NotificationStyle {
	NORMAL,
	ERROR
}
[CCode (cheader_filename = "planify.h")]
public enum ProjectViewStyle {
	LIST,
	BOARD;
	public string to_string ();
	public static ProjectViewStyle parse (string value);
}
[CCode (cheader_filename = "planify.h")]
public enum ProjectIconStyle {
	PROGRESS,
	EMOJI;
	public string to_string ();
	public static ProjectIconStyle parse (string value);
}
[CCode (cheader_filename = "planify.h")]
public enum SourceType {
	NONE,
	LOCAL,
	TODOIST,
	GOOGLE_TASKS,
	CALDAV;
	public string to_string ();
	public static SourceType parse (string value);
}
[CCode (cheader_filename = "planify.h")]
public enum PaneType {
	FILTER,
	FAVORITE,
	PROJECT,
	LABEL
}
[CCode (cheader_filename = "planify.h")]
public enum LoadingButtonType {
	LABEL,
	ICON
}
[CCode (cheader_filename = "planify.h")]
public enum ObjectType {
	PROJECT,
	SECTION,
	ITEM,
	LABEL,
	TASK,
	TASK_LIST,
	FILTER;
	public string get_header ();
}
[CCode (cheader_filename = "planify.h")]
public enum RecurrencyEndType {
	NEVER,
	ON_DATE,
	AFTER
}
[CCode (cheader_filename = "planify.h")]
public enum RecurrencyType {
	MINUTELY,
	HOURLY,
	EVERY_DAY,
	EVERY_WEEK,
	EVERY_MONTH,
	EVERY_YEAR,
	NONE;
	public string to_friendly_string (int? interval = null);
}
[CCode (cheader_filename = "planify.h")]
public enum PickerType {
	PROJECTS,
	SECTIONS;
	public string to_string ();
}
[CCode (cheader_filename = "planify.h")]
public enum NewTaskPosition {
	START,
	END
}
[CCode (cheader_filename = "planify.h")]
public enum CalDAVType {
	NEXTCLOUD,
	GENERIC;
	public string to_string ();
	public string title ();
	public static CalDAVType parse_index (uint value);
	public static CalDAVType parse (string value);
}
[CCode (cheader_filename = "planify.h")]
public enum FilterItemType {
	PRIORITY,
	LABEL,
	DUE_DATE,
	SECTION;
	public string to_string ();
	public string get_title ();
	public string get_icon ();
}
[CCode (cheader_filename = "planify.h")]
public enum ReminderType {
	ABSOLUTE,
	RELATIVE;
	public string to_string ();
}
[CCode (cheader_filename = "planify.h")]
public enum ItemType {
	TASK,
	NOTE;
	public string to_string ();
	public static ItemType parse (string value);
}
[CCode (cheader_filename = "planify.h")]
public enum ObjectEventType {
	INSERT,
	UPDATE;
	public static ObjectEventType parse (string value);
	public string to_string ();
	public string get_label ();
}
[CCode (cheader_filename = "planify.h")]
public enum ObjectEventKeyType {
	CONTENT,
	DESCRIPTION,
	DUE,
	PRIORITY,
	LABELS,
	PINNED,
	CHECKED,
	PROJECT,
	SECTION;
	public static ObjectEventKeyType parse (string value);
	public string get_label ();
}
[CCode (cheader_filename = "planify.h")]
public enum LabelPickerType {
	FILTER_AND_CREATE,
	FILTER_ONLY
}
[CCode (cheader_filename = "planify.h")]
public enum ItemPriority {
	HIGHT,
	MEDIUM,
	LOW,
	NONE;
	public static ItemPriority parse (string value);
	public string get_color ();
}
[CCode (cheader_filename = "planify.h")]
public enum SortOrderType {
	ASC,
	DESC;
	public string to_string ();
	public static SortOrderType parse (string value);
}
[CCode (cheader_filename = "planify.h")]
public enum SortedByType {
	MANUAL,
	NAME,
	DUE_DATE,
	ADDED_DATE,
	PRIORITY;
	public string to_string ();
	public static SortedByType parse (string value);
}
[CCode (cheader_filename = "planify.h")]
public enum Appearance {
	LIGHT,
	DARK,
	DARK_BLUE;
	public string to_string ();
	public static Appearance parse (int value);
	public static Appearance get_default ();
}
[CCode (cheader_filename = "planify.h")]
public class Util : GLib.Object {
	public Util ();
	public async void add_final_duplicate_item (Objects.Item new_item, Objects.Item item);
	public void clear_database (string title, string message, Gtk.Window window);
	public void create_default_labels ();
	public Objects.Project create_inbox_project ();
	public Objects.Source create_local_source ();
	public Adw.Toast create_toast (string title, uint timeout = 2, Adw.ToastPriority priority = Adw.ToastPriority.NORMAL);
	public void create_tutorial_project ();
	public void download_profile_image (string id, string avatar_url);
	public async void duplicate_item (Objects.Item item, string project_id, string section_id = "", string parent_id = "", bool notify = true);
	public async void duplicate_project (Objects.Project project, string parent_id = "");
	public async void duplicate_section (Objects.Section section, string project_id, bool notify = true);
	public static bool find_boolean_value (string key, string data);
	public static string find_string_value (string key, string data);
	public static string generate_extra_data (string ical_url, string etag, string data);
	public string generate_id (Objects.BaseObject? base_object = null);
	public string generate_string ();
	public string get_avatar_path (string id);
	public string get_badge_name ();
	public GLib.List<Gtk.ListBoxRow> get_children (Gtk.ListBox list);
	public string get_color (string? key);
	public string get_color_name (string key);
	public Gee.HashMap<string,Objects.Color> get_colors ();
	public static string[] get_current_languages ();
	public static Util get_default ();
	public int get_default_priority ();
	public string get_encode_text (string text);
	public GLib.List<Gtk.FlowBoxChild> get_flowbox_children (Gtk.FlowBox list);
	public string get_random_color ();
	public static int get_reminders_mm_offset ();
	public static string get_reminders_mm_offset_text (int value);
	public string get_short_name (string name, int size = Constants.SHORT_NAME_SIZE);
	public string get_theme_name ();
	public bool is_dark_theme ();
	public bool is_flatpak ();
	public bool is_input_valid (Gtk.Entry entry);
	public bool is_text_valid (string text);
	public string line_break_to_space (string str);
	public string markup_accel_tooltip (string description, string accel);
	public string markup_accels_tooltip (string description, string[] accels);
	public async void move_backend_type_item (Objects.Item item, Objects.Project target_project, string parent_id = "");
	public static async void nap (uint interval, int priority = GLib.Priority.DEFAULT);
	public int natural_compare (string a, string b);
	public void play_audio ();
	public int set_item_sort_func (Objects.Item item1, Objects.Item item2, SortedByType sorted_by, SortOrderType sort_order);
	public void set_widget_color (string? color, Gtk.Widget? widget);
	public void set_widget_priority (int priority, Gtk.Widget widget);
	public void show_alert_destroy (Gtk.Window window);
	public int to_caldav_priority (int priority);
	public void update_font_scale ();
	public void update_theme ();
}
[CCode (cheader_filename = "planify.h")]
public class MarkdownProcessor : GLib.Object {
	public MarkdownProcessor ();
	public static MarkdownProcessor get_default ();
	public string markup_string (string text);
}
[CCode (cheader_filename = "planify.h")]
public class HttpResponse {
	public HttpResponse ();
	public void from_error_json (Json.Node node);
	public void from_error_xml (GXml.DomDocument doc, int error_code);
	public string data { get; set; }
	public GLib.Value data_object { get; set; }
	public string error { get; set; }
	public int error_code { get; set; }
	public int http_code { get; set; }
	public bool status { get; set; }
}
