/**
 * penguins-eggs
 * class: distro.ts
 * author: Piero Proietti (modified by Hossein Seilani)
 * license: MIT
 *
 * FINAL VERSION WITH EXPLAINED COMMENTS AND NEW CHANGE TAGS
 */
import { IDistro } from '../interfaces/index.js';
declare class Distro implements IDistro {
    bugReportUrl: string;
    codenameId: string;
    distroUniqueId: string;
    distroId: string;
    distroLike: string;
    familyId: string;
    homeUrl: string;
    isCalamaresAvailable: boolean;
    liveMediumPath: string;
    releaseId: string;
    squashfs: string;
    supportUrl: string;
    syslinuxPath: string;
    usrLibPath: string;
    constructor();
    /**
     * NEW CHANGE6: Modular configuration for main distro types like Alpine, Fedora-family, etc.
     * This simplifies the constructor and keeps distro-specific logic isolated.
     */
    private configureDistro;
    /**
     * NEW CHANGE12: Map Debian, Ubuntu, Devuan codenames to proper IDs and paths
     * This avoids long if/else chains and allows easier future updates.
     */
    private configureDebianUbuntuDevuan;
    /**
     * NEW CHANGE15: Async derivative detection from YAML files
     * This allows future-proofing and easy updates for new distros.
     */
    private detectDerivatives;
    /**
     * NEW CHANGE16: Apply family-specific paths for usrLibPath, squashfs, and liveMediumPath
     * Handles Debian, openSUSE, Manjaro and derivatives consistently.
     */
    private applyFamilySpecificPaths;
    /**
     * NEW CHANGE17: Load custom HOME, SUPPORT, BUG_REPORT URLs from /etc/os-release
     * Allows overrides of default URLs for user-friendly experience.
     */
    private loadOSReleaseUrls;
}
export default Distro;
