# Noctalia shell

**_quiet by design_**

<p align="center">
  <img src="https://assets.noctalia.dev/noctalia-logo.svg?v=2" alt="Noctalia Logo" style="width: 192px" />
</p>

<p align="center">
  <a href="https://github.com/noctalia-dev/noctalia-shell/commits">
    <img src="https://img.shields.io/github/last-commit/noctalia-dev/noctalia-shell?style=for-the-badge&labelColor=0C0D11&color=A8AEFF&logo=git&logoColor=FFFFFF&label=commit" alt="Last commit" />
  </a>
  <a href="https://github.com/noctalia-dev/noctalia-shell/stargazers">
    <img src="https://img.shields.io/github/stars/noctalia-dev/noctalia-shell?style=for-the-badge&labelColor=0C0D11&color=A8AEFF&logo=github&logoColor=FFFFFF" alt="GitHub stars" />
  </a>
  <a href="https://docs.noctalia.dev">
    <img src="https://img.shields.io/badge/docs-A8AEFF?style=for-the-badge&logo=gitbook&logoColor=FFFFFF&labelColor=0C0D11" alt="Documentation" />
  </a>
  <a href="https://discord.noctalia.dev">
    <img src="https://img.shields.io/badge/discord-A8AEFF?style=for-the-badge&labelColor=0C0D11&logo=discord&logoColor=FFFFFF" alt="Discord" />
  </a>
</p>

---

A beautiful, minimal desktop shell for Wayland that actually gets out of your way. Built on Quickshell with a warm lavender aesthetic that you can easily customize to match your vibe.

## Preview

https://github.com/user-attachments/assets/72c6d6dc-48b0-48a0-bd8b-c7e70990edc4

<details>
<summary>Screenshots</summary>

![Dark 1](/Assets/Screenshots/noctalia-dark-1.png)
![Dark 2](/Assets/Screenshots/noctalia-dark-2.png)
![Dark 3](/Assets/Screenshots/noctalia-dark-3.png)

![Light 1](/Assets/Screenshots/noctalia-light-1.png)
![Light 2](/Assets/Screenshots/noctalia-light-2.png)
![Light 3](/Assets/Screenshots/noctalia-light-3.png)

</details>

---

## ⚠️ BREAKING CHANGE ⚠️

With the release of `v3.0.0` we introduced a small breaking change. This is solely for niri users, we reworked how we handle the wallpaper / overview. Please read [the docs](https://docs.noctalia.dev/getting-started/compositor-settings/#niri-wallpaper-and-overview-setup) to adapt your niri config.

---

## 🚀 Getting Started

**New to Noctalia?**  
Check out our documentation & installation guide to get started!

<a href="https://docs.noctalia.dev/getting-started/installation">
  <img src="https://img.shields.io/badge/⚡%20Quick%20Install-Get%20Started-A8AEFF?style=for-the-badge&logoColor=FFFFFF&labelColor=0C0D11" alt="Quick Install" />
</a>
  
  
**Need help?** Join our [Discord community](https://discord.noctalia.dev) or browse the [FAQ](https://docs.noctalia.dev/getting-started/faq/).

---

## 🖥️ Wayland Compositors

Noctalia provides native support for **Niri**, **Hyprland** and **Sway**. Other Wayland compositors will work but may require additional workspace logic configuration.

---

## 🤝 Contributing

We welcome contributions of any size - bug fixes, new features, documentation improvements, or custom themes and configs.

**Get involved:**
- **Found a bug?** [Open an issue](https://github.com/noctalia-dev/noctalia-shell/issues/new)
- **Want to code?** Check out our [development guidelines](https://docs.noctalia.dev/development/guideline)
- **Need help?** Join our [Discord](https://discord.noctalia.dev)

### ✨ Nix DevShell (new)

Nix users can use the flake's devShell to access a development environment. Run nix develop the repo root to enter the dev shell. It includes packages, utilities and environment variables needed to develop Noctalia.

---

## 💜 Credits

A heartfelt thank you to our incredible community of [**contributors**](https://github.com/noctalia-dev/noctalia-shell/graphs/contributors). We are immensely grateful for your dedicated participation and the constructive feedback you've provided, which continue to shape and improve our project for everyone.

---

## ☕ Donations

While all donations are greatly appreciated, they are completely voluntary.

<a href="https://ko-fi.com/lysec">
  <img src="https://img.shields.io/badge/donate-ko--fi-A8AEFF?style=for-the-badge&logo=kofi&logoColor=FFFFFF&labelColor=0C0D11" alt="Ko-Fi" />
</a>

### Thank you to everyone who supports the project 💜!
* Gohma
* DiscoCevapi
* <a href="https://pika-os.com/" target="_blank">PikaOS</a>
* LionHeartP
* Nyxion ツ
* RockDuck
* MrDowntempo
* Tempus Thales
* Raine
* JustCurtis

---

## 📄 License

MIT License - see [LICENSE](./LICENSE) for details.
