/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.Stats;

public class ConsumePower
extends Consume {
    public float usage;
    public float capacity;
    public boolean buffered;

    public ConsumePower(float usage, float capacity, boolean buffered) {
        this.usage = usage;
        this.capacity = capacity;
        this.buffered = buffered;
    }

    protected ConsumePower() {
        this(0.0f, 0.0f, false);
    }

    @Override
    public void apply(Block block) {
        block.hasPower = true;
        block.consPower = this;
    }

    @Override
    public boolean ignore() {
        return this.buffered;
    }

    @Override
    public float efficiency(Building build) {
        return build.power.status;
    }

    @Override
    public void display(Stats stats) {
        if (this.buffered) {
            stats.add(Stat.powerCapacity, this.capacity, StatUnit.none);
        } else if (this.usage > 0.0f) {
            stats.add(Stat.powerUse, this.usage * 60.0f, StatUnit.powerSecond);
        }
    }

    public float requestedPower(Building entity) {
        return this.buffered ? (1.0f - entity.power.status) * this.capacity : this.usage * (entity.shouldConsume() ? 1.0f : 0.0f);
    }
}

