/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.func.Func;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import mindustry.gen.Building;
import mindustry.type.ItemStack;
import mindustry.ui.ReqImage;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.StatValues;

public class ConsumeItemDynamic
extends Consume {
    public final Func<Building, ItemStack[]> items;

    public <T extends Building> ConsumeItemDynamic(Func<T, ItemStack[]> items) {
        this.items = items;
    }

    @Override
    public void apply(Block block) {
        block.hasItems = true;
        block.acceptsItems = true;
    }

    @Override
    public void build(Building build, Table table) {
        ItemStack[][] current = new ItemStack[][]{this.items.get(build)};
        table.table(cont -> {
            table.update(() -> {
                if (current[0] != this.items.get(build)) {
                    this.rebuild(build, (Table)cont);
                    current[0] = this.items.get(build);
                }
            });
            this.rebuild(build, (Table)cont);
        });
    }

    private void rebuild(Building build, Table table) {
        table.clear();
        int i = 0;
        for (ItemStack stack : this.items.get(build)) {
            table.add(new ReqImage((Element)StatValues.stack(stack.item, Math.round((float)stack.amount * this.multiplier.get(build))), () -> build.items != null && build.items.has(stack.item, Math.round((float)stack.amount * this.multiplier.get(build))))).padRight(8.0f).left();
            if (++i % 4 != 0) continue;
            table.row();
        }
    }

    @Override
    public void trigger(Building build) {
        for (ItemStack stack : this.items.get(build)) {
            build.items.remove(stack.item, Math.round((float)stack.amount * this.multiplier.get(build)));
        }
    }

    @Override
    public float efficiency(Building build) {
        return build.consumeTriggerValid() || build.items.has(this.items.get(build), this.multiplier.get(build)) ? 1.0f : 0.0f;
    }
}

