/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.world.Edges;
import mindustry.world.blocks.distribution.DuctRouter;

public class StackRouter
extends DuctRouter {
    public float baseEfficiency = 0.0f;
    public TextureRegion glowRegion;
    public float glowAlpha = 1.0f;
    public Color glowColor = Pal.redLight;

    public StackRouter(String name) {
        super(name);
        this.itemCapacity = 10;
    }

    public class StackRouterBuild
    extends DuctRouter.DuctRouterBuild {
        public boolean unloading = false;

        @Override
        public void updateTile() {
            float eff = this.enabled ? this.efficiency + StackRouter.this.baseEfficiency : 0.0f;
            float cap = StackRouter.this.speed;
            if (!this.unloading && this.current != null && this.items.total() >= StackRouter.this.itemCapacity) {
                if (this.progress < cap) {
                    this.progress += eff;
                }
                if (this.progress >= cap) {
                    this.unloading = true;
                    this.progress %= cap;
                }
            }
            if (this.unloading && this.current != null) {
                Building target = this.target();
                while (target != null && this.items.get(this.current) > 0) {
                    target.handleItem(this, this.current);
                    this.items.remove(this.current, 1);
                    target = this.target();
                }
                if (this.items.get(this.current) == 0) {
                    this.current = null;
                    this.unloading = false;
                }
            }
            if ((this.current == null || this.items.get(this.current) == 0) && this.items.total() > 0) {
                this.current = this.items.first();
            }
            if (this.items.empty()) {
                this.unloading = false;
                this.current = null;
            }
        }

        @Override
        public void draw() {
            super.draw();
            if (StackRouter.this.glowRegion.found() && this.power != null && this.power.status > 0.0f) {
                Draw.z(31.0f);
                Draw.color(StackRouter.this.glowColor, StackRouter.this.glowAlpha * this.power.status);
                Draw.blend(Blending.additive);
                Draw.rect(StackRouter.this.glowRegion, this.x, this.y, (float)(this.rotation * 90));
                Draw.blend();
                Draw.color();
            }
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return !this.unloading && (this.current == null || item == this.current) && this.items.total() < StackRouter.this.itemCapacity && Edges.getFacingEdge(source.tile, this.tile).relativeTo(this.tile) == this.rotation;
        }
    }
}

