/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world;

import arc.Core;
import arc.audio.Sound;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Cons2;
import arc.func.Floatf;
import arc.func.Func;
import arc.func.Intc2;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Rect;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.EnumSet;
import arc.struct.ObjectFloatMap;
import arc.struct.ObjectMap;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Structs;
import arc.util.Time;
import arc.util.pooling.Pools;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.core.Renderer;
import mindustry.core.UI;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.ContentRegions;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.graphics.BlockRenderer;
import mindustry.graphics.CacheLayer;
import mindustry.graphics.Drawf;
import mindustry.graphics.MultiPacker;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.logic.Senseable;
import mindustry.mod.NoPatch;
import mindustry.type.Category;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.type.Planet;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.ui.Fonts;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.blocks.Attributes;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OverlayFloor;
import mindustry.world.blocks.power.BeamNode;
import mindustry.world.blocks.power.PowerNode;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeCoolant;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.consumers.ConsumeLiquids;
import mindustry.world.consumers.ConsumePower;
import mindustry.world.consumers.ConsumePowerCondition;
import mindustry.world.consumers.ConsumePowerDynamic;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.BuildVisibility;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class Block
extends UnlockableContent
implements Senseable {
    public boolean hasItems;
    public boolean hasLiquids;
    public boolean hasPower;
    public boolean outputsLiquid = false;
    public boolean consumesPower = true;
    public boolean outputsPower = false;
    public boolean connectedPower = true;
    public boolean conductivePower = false;
    public boolean outputsPayload = false;
    public boolean acceptsUnitPayloads = false;
    public boolean acceptsPayload = false;
    public boolean acceptsItems = false;
    public boolean alwaysAllowDeposit = false;
    public boolean separateItemCapacity = false;
    public int itemCapacity = 10;
    public float liquidCapacity = 10.0f;
    public float liquidPressure = 1.0f;
    public boolean outputFacing = true;
    public boolean noSideBlend = false;
    public boolean displayFlow = true;
    public boolean inEditor = true;
    public boolean editorConfigurable;
    @NoPatch
    @Nullable
    public Object lastConfig;
    public boolean saveConfig = false;
    public boolean copyConfig = true;
    public boolean clearOnDoubleTap = false;
    @NoPatch
    public boolean update;
    public boolean destructible;
    public boolean unloadable = true;
    public boolean isDuct = false;
    public boolean allowResupply = false;
    public boolean solid;
    public boolean solidifes;
    public boolean teamPassable;
    public boolean underBullets;
    public boolean rotate;
    public boolean rotateDraw = true;
    public boolean rotateDrawEditor = true;
    public float visualRotationOffset = 0.0f;
    public boolean lockRotation = true;
    public boolean ignoreLineRotation = false;
    public boolean invertFlip = false;
    public int variants = 0;
    public boolean drawArrow = true;
    public boolean drawTeamOverlay = true;
    public boolean saveData;
    public boolean breakable;
    public boolean unitMoveBreakable;
    public boolean rebuildable = true;
    public boolean privileged = false;
    public boolean requiresWater = false;
    public boolean placeableLiquid = false;
    public boolean placeablePlayer = true;
    public boolean placeableOn = true;
    public boolean insulated = false;
    public boolean squareSprite = true;
    public boolean absorbLasers = false;
    public boolean enableDrawStatus = true;
    public boolean drawDisabled = true;
    public boolean autoResetEnabled = true;
    public boolean noUpdateDisabled = false;
    public boolean updateInUnits = true;
    public boolean alwaysUpdateInUnits = false;
    public boolean canPickup = true;
    public boolean deconstructDropAllLiquid = false;
    public boolean useColor = true;
    @Nullable
    public Item itemDrop = null;
    public boolean playerUnmineable = false;
    public Attributes attributes = new Attributes();
    public float scaledHealth = -1.0f;
    public int health = -1;
    public float armor = 0.0f;
    public float baseExplosiveness = 0.0f;
    public float explosivenessScale = 1.0f;
    public float flammabilityScale = 1.0f;
    public float baseShake = 3.0f;
    @Nullable
    public BulletType destroyBullet = null;
    public boolean destroyBulletSameTeam = false;
    @Nullable
    public Liquid lightLiquid;
    public boolean drawCracks = true;
    public boolean createRubble = true;
    public boolean floating = false;
    @NoPatch
    public int size = 1;
    public float offset = 0.0f;
    public int sizeOffset = 0;
    public float clipSize = -1.0f;
    public float lightClipSize;
    public float placeOverlapRange = 50.0f;
    public float crushDamageMultiplier = 1.0f;
    public int timers = 0;
    public CacheLayer cacheLayer = CacheLayer.normal;
    public boolean fillsTile = true;
    public boolean forceDark = false;
    public boolean alwaysReplace = false;
    public boolean replaceable = true;
    public BlockGroup group = BlockGroup.none;
    public EnumSet<BlockFlag> flags = EnumSet.of((Enum[])new BlockFlag[0]);
    public float priority = 0.0f;
    public int unitCapModifier = 0;
    public boolean configurable;
    public boolean ignoreResizeConfig;
    public boolean commandable;
    public boolean allowConfigInventory = true;
    public int selectionRows = 5;
    public int selectionColumns = 4;
    public boolean logicConfigurable = false;
    public boolean consumesTap;
    public boolean drawLiquidLight = true;
    public int envRequired = 0;
    public int envEnabled = 1;
    public int envDisabled = 0;
    public boolean sync;
    public boolean conveyorPlacement;
    public boolean allowDiagonal = true;
    public boolean swapDiagonalPlacement;
    public boolean allowRectanglePlacement = false;
    public int schematicPriority = 0;
    public Color mapColor = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    public boolean hasColor = false;
    public boolean targetable = true;
    public boolean attacks = false;
    public boolean suppressable = false;
    public boolean canOverdrive = true;
    public Color outlineColor = Color.valueOf("404049");
    public boolean outlineIcon = false;
    public int outlineRadius = 4;
    public int outlinedIcon = -1;
    public boolean hasShadow = true;
    public boolean customShadow = false;
    public boolean placePitchChange = true;
    public boolean breakPitchChange = true;
    public Sound placeSound = Sounds.place;
    public Sound breakSound = Sounds.breaks;
    public Sound destroySound = Sounds.boom;
    public float destroyPitchMin = 1.0f;
    public float destroyPitchMax = 1.0f;
    public float albedo = 0.0f;
    public Color lightColor = Color.white.cpy();
    public boolean emitLight = false;
    public boolean obstructsLight = true;
    public float lightRadius = 60.0f;
    public int fogRadius = -1;
    public Sound ambientSound = Sounds.none;
    public float ambientSoundVolume = 0.05f;
    public ItemStack[] requirements = new ItemStack[0];
    public Category category = Category.distribution;
    public float buildTime = -1.0f;
    public BuildVisibility buildVisibility = BuildVisibility.hidden;
    public float buildCostMultiplier = 1.0f;
    public float deconstructThreshold = 0.0f;
    public boolean instantDeconstruct = false;
    public boolean instantBuild = false;
    public boolean ignoreBuildDarkness = false;
    public Effect placeEffect = Fx.placeBlock;
    public Effect breakEffect = Fx.breakBlock;
    public Effect destroyEffect = Fx.dynamicExplosion;
    public float researchCostMultiplier = 1.0f;
    public ObjectFloatMap<Item> researchCostMultipliers = new ObjectFloatMap();
    @Nullable
    public ItemStack[] researchCost;
    @Nullable
    public Team forceTeam;
    public boolean instantTransfer = false;
    public boolean quickRotate = true;
    public boolean allowDerelictRepair = true;
    @Nullable
    public Class<?> subclass;
    public float selectScroll;
    @NoPatch
    public Prov<Building> buildType = null;
    @NoPatch
    public ObjectMap<Class<?>, Cons2> configurations = new ObjectMap();
    @NoPatch
    public boolean[] itemFilter = new boolean[0];
    @NoPatch
    public boolean[] liquidFilter = new boolean[0];
    @NoPatch
    public Consume[] consumers = new Consume[0];
    @NoPatch
    public Consume[] optionalConsumers = new Consume[0];
    @NoPatch
    public Consume[] nonOptionalConsumers = new Consume[0];
    @NoPatch
    public Consume[] updateConsumers = new Consume[0];
    @NoPatch
    public boolean hasConsumers;
    @NoPatch
    @Nullable
    public ConsumePower consPower;
    @NoPatch
    protected OrderedMap<String, Func<Building, Bar>> barMap = new OrderedMap();
    @NoPatch
    protected Seq<Consume> consumeBuilder = new Seq();
    protected TextureRegion[] generatedIcons;
    public int regionRotated1 = -1;
    public int regionRotated2 = -1;
    public TextureRegion region;
    public TextureRegion customShadowRegion;
    public TextureRegion teamRegion;
    public TextureRegion[] teamRegions;
    public TextureRegion[] variantRegions;
    public TextureRegion[] variantShadowRegions;
    protected static final Seq<Tile> tempTiles = new Seq();
    protected static final Seq<Building> tempBuilds = new Seq();
    protected final int timerDump = this.timers++;
    public int dumpTime = 5;

    public Block(String name) {
        super(name);
        this.initBuilding();
        this.selectionSize = 28.0f;
    }

    public void drawBase(Tile tile) {
        if (tile.build != null) {
            tile.build.draw();
        } else {
            Draw.rect(this.variants == 0 ? this.region : this.variantRegions[Mathf.randomSeed((long)tile.pos(), 0, Math.max(0, this.variantRegions.length - 1))], tile.drawx(), tile.drawy());
        }
    }

    public void drawShadow(Tile tile) {
        Draw.color(0.0f, 0.0f, 0.0f, BlockRenderer.shadowColor.a);
        Draw.rect(this.variants == 0 ? this.customShadowRegion : this.variantShadowRegions[Mathf.randomSeed((long)tile.pos(), 0, Math.max(0, this.variantShadowRegions.length - 1))], tile.drawx(), tile.drawy());
        Draw.color();
    }

    public float percentSolid(int x, int y) {
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return 0.0f;
        }
        return tile.getLinkedTilesAs(this, tempTiles).sumf(other -> !other.floor().isLiquid ? 1.0f : 0.0f) / (float)this.size / (float)this.size;
    }

    public void drawEnvironmentLight(Tile tile) {
        Drawf.light(tile.worldx(), tile.worldy(), this.lightRadius, this.lightColor, this.lightColor.a);
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        this.drawPotentialLinks(x, y);
        this.drawOverlay((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, rotation);
    }

    public void drawSideRegion(TextureRegion region, float x, float y, int rotation) {
        Point2 p = Geometry.d4[Mathf.mod(rotation, 4)];
        float s = (float)(this.size * 8) / 2.0f;
        Draw.rect(region, x + (float)p.x * (s - (float)region.width / 2.0f * region.scl()), y + (float)p.y * (s - (float)region.width / 2.0f * region.scl()), (float)rotation * 90.0f);
    }

    public void drawPotentialLinks(int x, int y) {
        Tile tile;
        if ((this.consumesPower || this.outputsPower) && this.hasPower && this.connectedPower && (tile = Vars.world.tile(x, y)) != null) {
            PowerNode.getNodeLinks(tile, this, Vars.player.team(), other -> {
                PowerNode node = (PowerNode)other.block;
                Draw.color(node.laserColor1, Renderer.laserOpacity * 0.5f);
                node.drawLaser((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, other.x, other.y, this.size, other.block.size);
                Drawf.square(other.x, other.y, (float)(other.block.size * 8) / 2.0f + 2.0f, Pal.place);
            });
            BeamNode.getNodeLinks(tile, this, Vars.player.team(), other -> {
                BeamNode node = (BeamNode)other.block;
                Draw.color(node.laserColor1, Renderer.laserOpacity * 0.5f);
                node.drawLaser(other.x, other.y, (float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.size, other.block.size);
                Drawf.square(other.x, other.y, (float)(other.block.size * 8) / 2.0f + 2.0f, Pal.place);
            });
        }
    }

    public float drawPlaceText(String text, int x, int y, boolean valid) {
        if (Vars.renderer.pixelate) {
            return 0.0f;
        }
        Color color = valid ? Pal.accent : Pal.remove;
        Font font = Fonts.outline;
        GlyphLayout layout = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        boolean ints = font.usesIntegerPositions();
        font.setUseIntegerPositions(false);
        font.getData().setScale(0.25f / Scl.scl(1.0f));
        layout.setText(font, text);
        float width = layout.width;
        font.setColor(color);
        float dx = (float)(x * 8) + this.offset;
        float dy = (float)(y * 8) + this.offset + (float)(this.size * 8) / 2.0f + 3.0f;
        font.draw(text, dx, dy + layout.height + 1.0f, 1);
        Lines.stroke(2.0f, Color.darkGray);
        Lines.line(dx - layout.width / 2.0f - 2.0f, dy -= 1.0f, dx + layout.width / 2.0f + 1.5f, dy);
        Lines.stroke(1.0f, color);
        Lines.line(dx - layout.width / 2.0f - 2.0f, dy, dx + layout.width / 2.0f + 1.5f, dy);
        font.setUseIntegerPositions(ints);
        font.setColor(Color.white);
        font.getData().setScale(1.0f);
        Draw.reset();
        Pools.free(layout);
        return width;
    }

    public void drawOverlay(float x, float y, int rotation) {
    }

    public boolean displayShadow(Tile tile) {
        return this.hasShadow;
    }

    public float sumAttribute(@Nullable Attribute attr, int x, int y) {
        if (attr == null) {
            return 0.0f;
        }
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return 0.0f;
        }
        return tile.getLinkedTilesAs(this, tempTiles).sumf(other -> !this.floating && other.floor().isDeep() ? 0.0f : other.floor().attributes.get(attr));
    }

    public TextureRegion getDisplayIcon(Tile tile) {
        return tile.build == null ? this.uiIcon : tile.build.getDisplayIcon();
    }

    public String getDisplayName(Tile tile) {
        return tile.build == null ? this.localizedName : tile.build.getDisplayName();
    }

    public int minimapColor(Tile tile) {
        return 0;
    }

    public boolean outputsItems() {
        return this.hasItems;
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        return true;
    }

    public boolean canBreak(Tile tile) {
        return true;
    }

    public boolean rotatedOutput(int x, int y) {
        return this.rotate;
    }

    public boolean rotatedOutput(int fromX, int fromY, Tile destination) {
        return this.rotatedOutput(fromX, fromY);
    }

    public boolean synthetic() {
        return this.update || this.destructible;
    }

    public boolean checkForceDark(Tile tile) {
        return this.forceDark;
    }

    public boolean isDarkened(Tile tile) {
        return this.solid && (!this.synthetic() && this.fillsTile || this.checkForceDark(tile));
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.size, "@x@", this.size, this.size);
        if (this.synthetic()) {
            this.stats.add(Stat.health, this.health, StatUnit.none);
            if (this.armor > 0.0f) {
                this.stats.add(Stat.armor, this.armor, StatUnit.none);
            }
        }
        if (this.canBeBuilt() && this.requirements.length > 0) {
            this.stats.add(Stat.buildTime, this.buildTime / 60.0f, StatUnit.seconds);
            this.stats.add(Stat.buildCost, StatValues.items(false, this.requirements));
        }
        if (this.instantTransfer) {
            this.stats.add(Stat.maxConsecutive, 2.0f, StatUnit.none);
        }
        for (Consume c : this.consumers) {
            c.display(this.stats);
        }
        if (this.hasLiquids) {
            this.stats.add(Stat.liquidCapacity, this.liquidCapacity, StatUnit.liquidUnits);
        }
        if (this.hasItems && this.itemCapacity > 0) {
            this.stats.add(Stat.itemCapacity, this.itemCapacity, StatUnit.items);
        }
    }

    public <T extends Building> void addBar(String name, Func<T, Bar> sup) {
        this.barMap.put(name, sup);
    }

    public void removeBar(String name) {
        this.barMap.remove(name);
    }

    public Iterable<Func<Building, Bar>> listBars() {
        return this.barMap.values();
    }

    public void addLiquidBar(Liquid liq) {
        this.addBar("liquid-" + liq.name, entity -> !liq.unlockedNow() ? null : new Bar(() -> liq.localizedName, liq::barColor, () -> entity.liquids.get(liq) / this.liquidCapacity));
    }

    public <T extends Building> void addLiquidBar(Func<T, Liquid> current) {
        this.addBar("liquid", entity -> new Bar(() -> current.get(entity) == null || entity.liquids.get((Liquid)current.get(entity)) <= 0.001f ? Core.bundle.get("bar.liquid") : ((Liquid)current.get(entity)).localizedName, () -> current.get(entity) == null ? Color.clear : ((Liquid)current.get(entity)).barColor(), () -> current.get(entity) == null ? 0.0f : entity.liquids.get((Liquid)current.get(entity)) / this.liquidCapacity));
    }

    public void setBars() {
        this.addBar("health", entity -> new Bar("stat.health", Pal.health, entity::healthf).blink(Color.white));
        if (this.consPower != null) {
            boolean buffered = this.consPower.buffered;
            float capacity = this.consPower.capacity;
            this.addBar("power", entity -> new Bar(() -> buffered ? Core.bundle.format("bar.poweramount", Float.isNaN(entity.power.status * capacity) ? "<ERROR>" : UI.formatAmount((int)(entity.power.status * capacity))) : Core.bundle.get("bar.power"), () -> Pal.powerBar, () -> Mathf.zero(this.consPower.requestedPower((Building)entity)) && entity.power.graph.getPowerProduced() + entity.power.graph.getBatteryStored() > 0.0f ? 1.0f : entity.power.status));
        }
        if (this.hasItems && this.configurable) {
            this.addBar("items", entity -> new Bar(() -> Core.bundle.format("bar.items", entity.items.total()), () -> Pal.items, () -> (float)entity.items.total() / (float)this.itemCapacity));
        }
        if (this.unitCapModifier != 0) {
            this.stats.add(Stat.maxUnits, (this.unitCapModifier < 0 ? "-" : "+") + Math.abs(this.unitCapModifier), new Object[0]);
        }
        if (this.hasLiquids) {
            boolean added = false;
            for (Consume consl : this.consumers) {
                if (consl instanceof ConsumeLiquid) {
                    ConsumeLiquid liq = (ConsumeLiquid)consl;
                    added = true;
                    this.addLiquidBar(liq.liquid);
                    continue;
                }
                if (!(consl instanceof ConsumeLiquids)) continue;
                ConsumeLiquids multi = (ConsumeLiquids)consl;
                added = true;
                for (LiquidStack stack : multi.liquids) {
                    this.addLiquidBar(stack.liquid);
                }
            }
            if (!added) {
                this.addLiquidBar((T build) -> build.liquids.current());
            }
        }
    }

    @Override
    public void afterPatch() {
        super.afterPatch();
        this.barMap.clear();
        this.setBars();
        this.offset = (float)((this.size + 1) % 2 * 8) / 2.0f;
        this.sizeOffset = -((this.size - 1) / 2);
    }

    public boolean consumesItem(Item item) {
        return this.itemFilter[item.id];
    }

    public boolean consumesLiquid(Liquid liq) {
        return this.liquidFilter[liq.id];
    }

    public boolean canReplace(Block other) {
        if (other.alwaysReplace) {
            return true;
        }
        if (other.privileged) {
            return false;
        }
        return other.replaceable && (other != this || this.rotate && this.quickRotate) && (this.group != BlockGroup.none && other.group == this.group || other == this) && (this.size == other.size || this.size >= other.size && (this.subclass != null && this.subclass == other.subclass || this.group.anyReplace));
    }

    public Block getReplacement(BuildPlan req, Seq<BuildPlan> plans) {
        return this;
    }

    public void changePlacementPath(Seq<Point2> points, int rotation, boolean diagonalOn) {
        this.changePlacementPath(points, rotation);
    }

    public void changePlacementPath(Seq<Point2> points, int rotation) {
    }

    public void handlePlacementLine(Seq<BuildPlan> plans) {
    }

    public boolean configSenseable() {
        return this.configurations.containsKey(Item.class) || this.configurations.containsKey(Liquid.class) || this.configurations.containsKey(UnlockableContent.class) || this.configurations.containsKey(Block.class) || this.configurations.containsKey(UnitType.class);
    }

    public Object nextConfig() {
        if (this.saveConfig && this.lastConfig != null) {
            return this.lastConfig;
        }
        return null;
    }

    public void onNewPlan(BuildPlan plan) {
    }

    public void drawPlan(BuildPlan plan, Eachable<BuildPlan> list, boolean valid) {
        this.drawPlan(plan, list, valid, 1.0f);
    }

    public void drawPlan(BuildPlan plan, Eachable<BuildPlan> list, boolean valid, float alpha) {
        Draw.reset();
        Draw.mixcol(!valid ? Pal.breakInvalid : Color.white, (!valid ? 0.4f : 0.24f) + Mathf.absin(Time.globalTime, 6.0f, 0.28f));
        Draw.alpha(alpha);
        float prevScale = Draw.scl;
        Draw.scl *= plan.animScale;
        this.drawPlanRegion(plan, list);
        Draw.scl = prevScale;
        Draw.reset();
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawDefaultPlanRegion(plan, list);
    }

    public void drawDefaultPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        TextureRegion reg = this.getPlanRegion(plan, list);
        Draw.rect(reg, plan.drawx(), plan.drawy(), !this.rotate || !this.rotateDraw ? 0.0f : (float)(plan.rotation * 90));
        if (plan.worldContext && Vars.player != null && this.teamRegion != null && this.teamRegion.found()) {
            if (this.teamRegions[Vars.player.team().id] == this.teamRegion) {
                Draw.color(Vars.player.team().color);
            }
            Draw.rect(this.teamRegions[Vars.player.team().id], plan.drawx(), plan.drawy());
            Draw.color();
        }
        this.drawPlanConfig(plan, list);
    }

    public TextureRegion getPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        return this.fullIcon;
    }

    public void drawPlanConfig(BuildPlan plan, Eachable<BuildPlan> list) {
    }

    public void drawPlanConfigCenter(BuildPlan plan, Object content, String region, boolean cross) {
        Color color;
        Color color2;
        if (content == null) {
            if (cross) {
                Draw.rect("cross", plan.drawx(), plan.drawy());
            }
            return;
        }
        if (content instanceof Item) {
            Item i = (Item)content;
            color2 = i.color;
        } else if (content instanceof Liquid) {
            Liquid l = (Liquid)content;
            color2 = l.color;
        } else {
            color2 = color = null;
        }
        if (color == null) {
            return;
        }
        Draw.color(color);
        Draw.rect(region, plan.drawx(), plan.drawy());
        Draw.color();
    }

    public void drawPlanConfigCenter(BuildPlan plan, Object content, String region) {
        this.drawPlanConfigCenter(plan, content, region, false);
    }

    public void drawPlanConfigTop(BuildPlan plan, Eachable<BuildPlan> list) {
    }

    public Object pointConfig(Object config, Cons<Point2> transformer) {
        return config;
    }

    public <E extends Building> void configClear(Cons<E> cons) {
        this.configurations.put(Void.TYPE, (tile, value) -> cons.get((Building)tile));
    }

    public <T, E extends Building> void config(Class<T> type, Cons2<E, T> config) {
        this.configurations.put(type, config);
    }

    public boolean isAccessible() {
        return this.hasItems && this.itemCapacity > 0;
    }

    public void nearbySide(int x, int y, int rotation, int index, Point2 out) {
        int cornerX = x - (this.size - 1) / 2;
        int cornerY = y - (this.size - 1) / 2;
        int s = this.size;
        switch (rotation) {
            case 0: {
                out.set(cornerX + s, cornerY + index);
                break;
            }
            case 1: {
                out.set(cornerX + index, cornerY + s);
                break;
            }
            case 2: {
                out.set(cornerX - 1, cornerY + index);
                break;
            }
            case 3: {
                out.set(cornerX + index, cornerY - 1);
            }
        }
    }

    public Point2[] getEdges() {
        return Edges.getEdges(this.size);
    }

    public Point2[] getInsideEdges() {
        return Edges.getInsideEdges(this.size);
    }

    public void iterateTaken(int x, int y, Intc2 placer) {
        if (this.isMultiblock()) {
            int offsetx = -(this.size - 1) / 2;
            int offsety = -(this.size - 1) / 2;
            for (int dx = 0; dx < this.size; ++dx) {
                for (int dy = 0; dy < this.size; ++dy) {
                    placer.get(dx + offsetx + x, dy + offsety + y);
                }
            }
        } else {
            placer.get(x, y);
        }
    }

    public TextureRegion[] makeIconRegions() {
        return new TextureRegion[0];
    }

    protected TextureRegion[] icons() {
        TextureRegion[] textureRegionArray;
        TextureRegion r;
        TextureRegion textureRegion = r = this.variants > 0 ? Core.atlas.find(this.name + "1") : this.region;
        if (this.teamRegion.found() && this.minfo.mod == null) {
            TextureRegion[] textureRegionArray2 = new TextureRegion[2];
            textureRegionArray2[0] = r;
            textureRegionArray = textureRegionArray2;
            textureRegionArray2[1] = this.teamRegions[Team.sharded.id];
        } else {
            TextureRegion[] textureRegionArray3 = new TextureRegion[1];
            textureRegionArray = textureRegionArray3;
            textureRegionArray3[0] = r;
        }
        return textureRegionArray;
    }

    public void getRegionsToOutline(Seq<TextureRegion> out) {
    }

    public TextureRegion[] getGeneratedIcons() {
        TextureRegion[] textureRegionArray;
        if (this.generatedIcons == null) {
            this.generatedIcons = this.icons();
            textureRegionArray = this.generatedIcons;
        } else {
            textureRegionArray = this.generatedIcons;
        }
        return textureRegionArray;
    }

    public void resetGeneratedIcons() {
        this.generatedIcons = null;
    }

    public TextureRegion[] variantRegions() {
        TextureRegion[] textureRegionArray;
        if (this.variantRegions == null) {
            this.variantRegions = new TextureRegion[]{this.fullIcon};
            textureRegionArray = this.variantRegions;
        } else {
            textureRegionArray = this.variantRegions;
        }
        return textureRegionArray;
    }

    public boolean hasBuilding() {
        return this.destructible || this.update;
    }

    public final Building newBuilding() {
        return this.buildType.get();
    }

    public void updateClipRadius(float radiusInWorldUnits) {
        this.clipSize = Math.max(this.clipSize, (float)(this.size * 8) + radiusInWorldUnits * 2.0f);
    }

    public Rect bounds(int x, int y, Rect rect) {
        return rect.setSize(this.size * 8).setCenter((float)(x * 8) + this.offset, (float)(y * 8) + this.offset);
    }

    public boolean isMultiblock() {
        return this.size > 1;
    }

    public boolean isVisible() {
        return !this.isHidden() && (Vars.state.rules.editor || !Vars.state.rules.hideBannedBlocks || !this.isBanned());
    }

    public boolean isPlaceable() {
        return this.isVisible() && (!this.isBanned() || Vars.state.rules.editor) && this.supportsEnv(Vars.state.rules.env);
    }

    @Override
    public boolean isBanned() {
        return Vars.state.rules.isBanned(this);
    }

    public boolean supportsEnv(int env) {
        return (this.envEnabled & env) != 0 && (this.envDisabled & env) == 0 && (this.envRequired == 0 || (this.envRequired & env) == this.envRequired);
    }

    public void buildEditorConfig(Table table) {
    }

    public void onPicked(Tile tile) {
    }

    public Object getConfig(Tile tile) {
        return null;
    }

    public void blockChanged(Tile tile) {
    }

    public void placeBegan(Tile tile, Block previous) {
    }

    public void placeBegan(Tile tile, Block previous, @Nullable Unit builder) {
        this.placeBegan(tile, previous);
    }

    public void placeEnded(Tile tile, @Nullable Unit builder, int rotation, @Nullable Object config) {
    }

    public void beforePlaceBegan(Tile tile, Block previous) {
    }

    public void editorPicked(Tile tile) {
    }

    public boolean isFloor() {
        return this instanceof Floor;
    }

    public boolean isOverlay() {
        return this instanceof OverlayFloor;
    }

    public Floor asFloor() {
        return (Floor)this;
    }

    public boolean isAir() {
        return this.id == 0;
    }

    public boolean canBeBuilt() {
        return this.buildVisibility != BuildVisibility.hidden && this.buildVisibility != BuildVisibility.debugOnly;
    }

    public boolean environmentBuildable() {
        return this.isOnPlanet(Vars.state.getPlanet());
    }

    public boolean isStatic() {
        return this.cacheLayer == CacheLayer.walls;
    }

    public <T extends Consume> T findConsumer(Boolf<Consume> filter) {
        return (T)(this.consumers.length == 0 ? this.consumeBuilder.find(filter) : Structs.find(this.consumers, filter));
    }

    public boolean hasConsumer(Consume cons) {
        return this.consumeBuilder.contains(cons);
    }

    public void removeConsumer(Consume cons) {
        if (this.consumers.length > 0) {
            throw new IllegalStateException("You can only remove consumers before init(). After init(), all consumers have already been initialized.");
        }
        this.consumeBuilder.remove(cons);
    }

    public void removeConsumers(Boolf<Consume> b) {
        this.consumeBuilder.removeAll(b);
        if (!this.consumeBuilder.contains((Consume)((Object)((Boolf<Consume>)c -> c instanceof ConsumePower)))) {
            this.consPower = null;
        }
    }

    public ConsumeLiquid consumeLiquid(Liquid liquid, float amount) {
        return this.consume(new ConsumeLiquid(liquid, amount));
    }

    public ConsumeLiquids consumeLiquids(LiquidStack ... stacks) {
        return this.consume(new ConsumeLiquids(stacks));
    }

    public ConsumePower consumePower(float powerPerTick) {
        return this.consume(new ConsumePower(powerPerTick, 0.0f, false));
    }

    public <T extends Building> ConsumePower consumePowerCond(float usage, Boolf<T> cons) {
        return this.consume(new ConsumePowerCondition(usage, cons));
    }

    public <T extends Building> ConsumePower consumePowerDynamic(Floatf<T> usage) {
        return this.consume(new ConsumePowerDynamic(usage));
    }

    public <T extends Building> ConsumePower consumePowerDynamic(float displayed, Floatf<T> usage) {
        return this.consume(new ConsumePowerDynamic(displayed, usage));
    }

    public ConsumePower consumePowerBuffered(float powerCapacity) {
        return this.consume(new ConsumePower(0.0f, powerCapacity, true));
    }

    public ConsumeItems consumeItem(Item item) {
        return this.consumeItem(item, 1);
    }

    public ConsumeItems consumeItem(Item item, int amount) {
        return this.consume(new ConsumeItems(new ItemStack[]{new ItemStack(item, amount)}));
    }

    public ConsumeItems consumeItems(ItemStack ... items) {
        return this.consume(new ConsumeItems(items));
    }

    public ConsumeCoolant consumeCoolant(float amount) {
        return this.consume(new ConsumeCoolant(amount));
    }

    public ConsumeCoolant consumeCoolant(float amount, boolean allowLiquid, boolean allowGas) {
        return this.consume(new ConsumeCoolant(amount, allowLiquid, allowGas));
    }

    public <T extends Consume> T consume(T consume) {
        if (consume instanceof ConsumePower) {
            this.consumeBuilder.removeAll(b -> b instanceof ConsumePower);
            this.consPower = (ConsumePower)consume;
        }
        this.consumeBuilder.add(consume);
        return consume;
    }

    public void setupRequirements(Category cat, ItemStack[] stacks) {
        this.requirements(cat, stacks);
    }

    public void setupRequirements(Category cat, BuildVisibility visible, ItemStack[] stacks) {
        this.requirements(cat, visible, stacks);
    }

    public void requirements(Category cat, ItemStack[] stacks, boolean unlocked) {
        this.requirements(cat, BuildVisibility.shown, stacks);
        this.alwaysUnlocked = unlocked;
    }

    public void requirements(Category cat, ItemStack[] stacks) {
        this.requirements(cat, BuildVisibility.shown, stacks);
    }

    public void requirements(Category cat, BuildVisibility visible, ItemStack[] stacks) {
        this.category = cat;
        this.requirements = stacks;
        this.buildVisibility = visible;
        Arrays.sort(this.requirements, Structs.comparingInt(i -> i.item.id));
    }

    protected void initBuilding() {
        try {
            Class<?> current = this.getClass();
            if (current.isAnonymousClass()) {
                current = current.getSuperclass();
            }
            this.subclass = current;
            while (this.buildType == null && Block.class.isAssignableFrom(current)) {
                Class type = Structs.find(current.getDeclaredClasses(), t -> Building.class.isAssignableFrom((Class<?>)t) && !t.isInterface());
                if (type != null) {
                    Constructor cons = type.getDeclaredConstructor(type.getDeclaringClass());
                    this.buildType = () -> {
                        try {
                            return (Building)cons.newInstance(this);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    };
                }
                current = current.getSuperclass();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.buildType == null) {
            this.buildType = Building::create;
        }
    }

    @Override
    public ItemStack[] researchRequirements() {
        if (this.researchCost != null) {
            return this.researchCost;
        }
        if (this.researchCostMultiplier <= 0.0f) {
            return ItemStack.empty;
        }
        ItemStack[] out = new ItemStack[this.requirements.length];
        for (int i = 0; i < out.length; ++i) {
            int quantity = Mathf.round(60.0f * this.researchCostMultiplier + Mathf.pow((float)this.requirements[i].amount, 1.11f) * 20.0f * this.researchCostMultiplier * this.researchCostMultipliers.get(this.requirements[i].item, 1.0f), 10);
            out[i] = new ItemStack(this.requirements[i].item, UI.roundAmount(quantity));
        }
        return out;
    }

    @Override
    public void getDependencies(Cons<UnlockableContent> cons) {
        for (ItemStack stack : this.requirements) {
            cons.get(stack.item);
        }
        for (Consume c : this.consumeBuilder) {
            if (c.optional || !(c instanceof ConsumeItems)) continue;
            ConsumeItems i = (ConsumeItems)c;
            for (ItemStack stack : i.items) {
                cons.get(stack.item);
            }
        }
    }

    @Override
    public ContentType getContentType() {
        return ContentType.block;
    }

    @Override
    public boolean logicVisible() {
        return this.buildVisibility != BuildVisibility.hidden;
    }

    @Override
    public void postInit() {
        if (this.requirements.length > 0 && this.shownPlanets.isEmpty()) {
            for (Planet planet : Vars.content.planets()) {
                if (!planet.isLandable() || Structs.contains(this.requirements, s -> !s.item.isOnPlanet(planet))) continue;
                this.shownPlanets.add(planet);
            }
        }
        super.postInit();
    }

    @Override
    public void init() {
        super.init();
        if (this.customShadow) {
            this.hasShadow = false;
        }
        if (this.underBullets) {
            this.priority = -2.0f;
        }
        if (this.fogRadius > 0) {
            this.flags = this.flags.with(BlockFlag.hasFogRadius);
        }
        if (this.sync) {
            this.flags = this.flags.with(BlockFlag.synced);
        }
        if (this.health == -1) {
            boolean round = false;
            if (this.scaledHealth < 0.0f) {
                this.scaledHealth = 40.0f;
                float scaling = 1.0f;
                for (ItemStack stack : this.requirements) {
                    scaling += stack.item.healthScaling;
                }
                this.scaledHealth *= scaling;
                round = true;
            }
            this.health = round ? Mathf.round((float)(this.size * this.size) * this.scaledHealth, 5) : (int)((float)(this.size * this.size) * this.scaledHealth);
        }
        this.clipSize = Math.max(this.clipSize, (float)(this.size * 8));
        this.lightClipSize = Math.max(this.lightClipSize, this.clipSize);
        if (this.hasLiquids && this.drawLiquidLight) {
            this.emitLight = true;
            this.lightClipSize = Math.max(this.lightClipSize, (float)this.size * 30.0f * 2.0f);
        }
        if (this.emitLight) {
            this.lightClipSize = Math.max(this.lightClipSize, this.lightRadius * 2.0f);
        }
        if (this.group == BlockGroup.transportation || this.category == Category.distribution) {
            this.acceptsItems = true;
        }
        this.offset = (float)((this.size + 1) % 2 * 8) / 2.0f;
        this.sizeOffset = -((this.size - 1) / 2);
        if (this.requirements.length > 0 && this.buildTime < 0.0f) {
            this.buildTime = 0.0f;
            for (ItemStack stack : this.requirements) {
                this.buildTime += (float)stack.amount * stack.item.cost;
            }
        }
        if (this.buildTime < 0.0f) {
            this.buildTime = 20.0f;
        }
        this.buildTime *= this.buildCostMultiplier;
        this.consumers = (Consume[])this.consumeBuilder.toArray(Consume.class);
        this.optionalConsumers = (Consume[])this.consumeBuilder.select(consume -> consume.optional && !consume.ignore()).toArray(Consume.class);
        this.nonOptionalConsumers = (Consume[])this.consumeBuilder.select(consume -> !consume.optional && !consume.ignore()).toArray(Consume.class);
        this.updateConsumers = (Consume[])this.consumeBuilder.select(consume -> consume.update && !consume.ignore()).toArray(Consume.class);
        this.hasConsumers = this.consumers.length > 0;
        this.itemFilter = new boolean[Vars.content.items().size];
        this.liquidFilter = new boolean[Vars.content.liquids().size];
        for (Consume cons : this.consumers) {
            cons.apply(this);
        }
        this.setBars();
        this.stats.useCategories = true;
        if (!this.logicConfigurable) {
            this.configurations.each((key, val) -> {
                if (UnlockableContent.class.isAssignableFrom((Class<?>)key)) {
                    this.logicConfigurable = true;
                }
            });
        }
        if (!this.outputsPower && this.consPower != null && this.consPower.buffered) {
            Log.warn("Consumer using buffered power: @. Disabling buffered power.", this.name);
            this.consPower.buffered = false;
        }
        if (this.buildVisibility == BuildVisibility.sandboxOnly) {
            this.hideDetails = false;
        }
    }

    public void reinitializeConsumers() {
        this.consumers = (Consume[])this.consumeBuilder.toArray(Consume.class);
        this.consPower = (ConsumePower)Structs.find(this.consumers, c -> c instanceof ConsumePower);
        this.optionalConsumers = (Consume[])this.consumeBuilder.select(consume -> consume.optional && !consume.ignore()).toArray(Consume.class);
        this.nonOptionalConsumers = (Consume[])this.consumeBuilder.select(consume -> !consume.optional && !consume.ignore()).toArray(Consume.class);
        this.updateConsumers = (Consume[])this.consumeBuilder.select(consume -> consume.update && !consume.ignore()).toArray(Consume.class);
        this.hasConsumers = this.consumers.length > 0;
        this.itemFilter = new boolean[Vars.content.items().size];
        this.liquidFilter = new boolean[Vars.content.liquids().size];
        for (Consume cons : this.consumers) {
            cons.apply(this);
        }
    }

    @Override
    public void load() {
        super.load();
        this.region = Core.atlas.find(this.name);
        ContentRegions.loadRegions(this);
        this.teamRegions = new TextureRegion[Team.all.length];
        for (Team team : Team.all) {
            this.teamRegions[team.id] = this.teamRegion.found() && team.hasPalette ? Core.atlas.find(this.name + "-team-" + team.name, this.teamRegion) : this.teamRegion;
        }
        if (this.variants != 0) {
            int i;
            this.variantRegions = new TextureRegion[this.variants];
            for (i = 0; i < this.variants; ++i) {
                this.variantRegions[i] = Core.atlas.find(this.name + (i + 1));
            }
            this.region = this.variantRegions[0];
            if (this.customShadow) {
                this.variantShadowRegions = new TextureRegion[this.variants];
                for (i = 0; i < this.variants; ++i) {
                    this.variantShadowRegions[i] = Core.atlas.find(this.name + "-shadow" + (i + 1));
                }
            }
        }
    }

    @Override
    public boolean isHidden() {
        return !this.buildVisibility.visible() && !Vars.state.rules.revealedBlocks.contains(this);
    }

    @Override
    public void createIcons(MultiPacker packer) {
        super.createIcons(packer);
        if (!this.synthetic()) {
            PixmapRegion image = Core.atlas.getPixmap(this.fullIcon);
            this.mapColor.set(image.get(image.width / 2, image.height / 2));
        }
        Seq<Pixmap> toDispose = new Seq<Pixmap>();
        if (this.teamRegion != null && this.teamRegion.found()) {
            for (Team team : Team.all) {
                if (!team.hasPalette || Core.atlas.has(this.name + "-team-" + team.name)) continue;
                PixmapRegion base = Core.atlas.getPixmap(this.teamRegion);
                Pixmap out = new Pixmap(base.width, base.height);
                for (int x = 0; x < base.width; ++x) {
                    for (int y = 0; y < base.height; ++y) {
                        int n;
                        int color = base.get(x, y);
                        switch (color) {
                            case -1: {
                                n = 0;
                                break;
                            }
                            case -607795713: 
                            case -590952705: {
                                n = 1;
                                break;
                            }
                            case -1652588545: 
                            case -1635745537: {
                                n = 2;
                                break;
                            }
                            default: {
                                n = -1;
                            }
                        }
                        int index = n;
                        out.setRaw(x, y, index == -1 ? base.get(x, y) : team.palettei[index]);
                    }
                }
                Drawf.checkBleed(out);
                packer.add(MultiPacker.PageType.main, this.name + "-team-" + team.name, out);
                toDispose.add(out);
            }
            this.teamRegions = new TextureRegion[Team.all.length];
            for (Team team : Team.all) {
                this.teamRegions[team.id] = this.teamRegion.found() && team.hasPalette ? Core.atlas.find(this.name + "-team-" + team.name, this.teamRegion) : this.teamRegion;
            }
        }
        Pixmap last = null;
        TextureRegion[] gen = this.icons();
        if (this.outlineIcon) {
            TextureAtlas.AtlasRegion atlasRegion = (TextureAtlas.AtlasRegion)gen[this.outlinedIcon >= 0 ? Math.min(this.outlinedIcon, gen.length - 1) : gen.length - 1];
            PixmapRegion region = Core.atlas.getPixmap(atlasRegion);
            Pixmap out = last = Pixmaps.outline(region, this.outlineColor, this.outlineRadius);
            Drawf.checkBleed(out);
            packer.add(MultiPacker.PageType.main, atlasRegion.name, out);
            toDispose.add(out);
        }
        Seq<TextureRegion> toOutline = new Seq<TextureRegion>();
        this.getRegionsToOutline(toOutline);
        for (TextureRegion region : toOutline) {
            if (!(region instanceof TextureAtlas.AtlasRegion)) continue;
            TextureAtlas.AtlasRegion atlas = (TextureAtlas.AtlasRegion)region;
            String regionName = atlas.name;
            Pixmap outlined = Pixmaps.outline(Core.atlas.getPixmap(region), this.outlineColor, this.outlineRadius);
            Drawf.checkBleed(outlined);
            packer.add(MultiPacker.PageType.main, regionName + "-outline", outlined);
            toDispose.add(outlined);
        }
        if (gen.length > 1) {
            Pixmap base = Core.atlas.getPixmap(gen[0]).crop();
            for (int i = 1; i < gen.length; ++i) {
                if (i == gen.length - 1 && last != null) {
                    base.draw(last, 0, 0, true);
                    continue;
                }
                base.draw(Core.atlas.getPixmap(gen[i]), true);
            }
            packer.add(MultiPacker.PageType.main, "block-" + this.name + "-full", base);
            toDispose.add(base);
        } else if (gen[0] != null) {
            packer.add(MultiPacker.PageType.main, "block-" + this.name + "-full", Core.atlas.getPixmap(gen[0]));
        }
        toDispose.each(Pixmap::dispose);
    }

    public int planRotation(int rot) {
        return !this.rotate && this.lockRotation ? 0 : rot;
    }

    public void flipRotation(BuildPlan req, boolean x) {
        if (x == (req.rotation % 2 == 0) != this.invertFlip) {
            req.rotation = this.planRotation(Mathf.mod(req.rotation + 2, 4));
        }
    }

    public void getPlanConfigs(Seq<UnlockableContent> options) {
        if (this.configurations.containsKey(Item.class)) {
            options.add(Vars.content.items());
        }
        if (this.configurations.containsKey(Liquid.class)) {
            options.add(Vars.content.liquids());
        }
    }

    @Override
    public double sense(LAccess sensor) {
        double d;
        switch (sensor) {
            case color: {
                d = this.mapColor.toDoubleBits();
                break;
            }
            case health: 
            case maxHealth: {
                d = this.health;
                break;
            }
            case solid: {
                if (this.solid) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case size: {
                d = this.size;
                break;
            }
            case itemCapacity: {
                d = this.itemCapacity;
                break;
            }
            case liquidCapacity: {
                d = this.liquidCapacity;
                break;
            }
            case powerCapacity: {
                if (this.consPower != null && this.consPower.buffered) {
                    d = this.consPower.capacity;
                    break;
                }
                d = 0.0;
                break;
            }
            case id: {
                d = this.getLogicId();
                break;
            }
            default: {
                d = Double.NaN;
            }
        }
        return d;
    }

    @Override
    public double sense(Content content) {
        if (content instanceof Item) {
            Item item = (Item)content;
            if (Vars.state.rules.infiniteResources) {
                return 0.0;
            }
            for (ItemStack r : this.requirements) {
                if (r.item != item) continue;
                return Math.round((float)r.amount * Vars.state.rules.buildCostMultiplier);
            }
            return 0.0;
        }
        return Double.NaN;
    }

    @Override
    public Object senseObject(LAccess sensor) {
        if (sensor == LAccess.name) {
            return this.name;
        }
        return noSensed;
    }
}

