/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.func.Boolc;
import arc.func.Boolp;
import arc.func.Cons;
import arc.func.Floatc;
import arc.func.Floatp;
import arc.func.Intc;
import arc.func.Intp;
import arc.func.Prov;
import arc.graphics.Color;
import arc.scene.style.Drawable;
import arc.scene.ui.Button;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.CheckBox;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.content.Items;
import mindustry.content.Planets;
import mindustry.ctype.ContentType;
import mindustry.editor.BannedContentDialog;
import mindustry.game.Rules;
import mindustry.game.SpawnGroup;
import mindustry.game.Team;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.io.JsonIO;
import mindustry.type.ItemStack;
import mindustry.type.Planet;
import mindustry.type.UnitType;
import mindustry.type.Weather;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.LoadoutDialog;
import mindustry.world.Block;

public class CustomRulesDialog
extends BaseDialog {
    Rules rules;
    private Table main;
    private Prov<Rules> resetter;
    private LoadoutDialog loadoutDialog;
    private BannedContentDialog<Block> bannedBlocks = new BannedContentDialog<Block>("@bannedblocks", ContentType.block, Block::canBeBuilt);
    private BannedContentDialog<UnitType> bannedUnits = new BannedContentDialog<UnitType>("@bannedunits", ContentType.unit, u -> !u.isHidden());
    public boolean showRuleEditRule;
    public Seq<Table> categories;
    public Table current;
    public Seq<String> categoryNames;
    public String currentName = "";
    public String ruleSearch = "";
    public Seq<Runnable> additionalSetup;

    public CustomRulesDialog() {
        this(false);
    }

    public CustomRulesDialog(boolean showRuleEditRule) {
        super("@mode.custom");
        this.showRuleEditRule = showRuleEditRule;
        this.loadoutDialog = new LoadoutDialog();
        this.setFillParent(true);
        this.shown(this::setup);
        this.addCloseButton();
        this.additionalSetup = new Seq();
        this.categories = new Seq();
        this.categoryNames = new Seq();
        this.buttons.button("@edit", Icon.pencil, () -> {
            BaseDialog dialog = new BaseDialog("@waves.edit");
            dialog.addCloseButton();
            dialog.setFillParent(false);
            dialog.cont.table(Tex.button, t -> {
                TextButton.TextButtonStyle style = Styles.cleart;
                t.defaults().size(280.0f, 64.0f).pad(2.0f);
                t.button("@waves.copy", (Drawable)Icon.copy, style, () -> {
                    Vars.ui.showInfoFade("@copied");
                    Seq<SpawnGroup> spawns = this.rules.spawns;
                    this.rules.spawns = new Seq();
                    Core.app.setClipboardText(JsonIO.write(this.rules));
                    this.rules.spawns = spawns;
                    dialog.hide();
                }).marginLeft(12.0f).row();
                t.button("@waves.load", (Drawable)Icon.download, style, () -> {
                    try {
                        Rules newRules = JsonIO.read(Rules.class, Core.app.getClipboardText());
                        newRules.spawns = this.rules.spawns;
                        newRules.objectives = this.rules.objectives;
                        JsonIO.copy(newRules, this.rules);
                        this.refresh();
                    }
                    catch (Throwable e) {
                        Log.err(e);
                        Vars.ui.showErrorMessage("@rules.invaliddata");
                    }
                    dialog.hide();
                }).disabled(Core.app.getClipboardText() == null || !Core.app.getClipboardText().startsWith("{")).marginLeft(12.0f).row();
                t.button("@settings.reset", (Drawable)Icon.refresh, style, () -> {
                    JsonIO.copy(this.resetter.get(), this.rules);
                    this.refresh();
                }).marginLeft(12.0f);
            });
            dialog.show();
        });
    }

    void refresh() {
        this.setup();
        this.requestKeyboard();
        this.requestScroll();
    }

    public void show(Rules rules, Prov<Rules> resetter) {
        this.rules = rules;
        this.resetter = resetter;
        this.show();
    }

    void setup() {
        this.cont.clear();
        this.cont.table((Table t) -> {
            t.add("@search").padRight(10.0f);
            TextField field = t.field(this.ruleSearch, text -> {
                this.ruleSearch = text.trim().replaceAll(" +", " ").toLowerCase();
                this.setupMain();
            }).grow().pad(8.0f).get();
            field.setCursorPosition(this.ruleSearch.length());
            Core.scene.setKeyboardFocus(field);
            t.button((Drawable)Icon.cancel, Styles.emptyi, () -> {
                this.ruleSearch = "";
                this.setupMain();
            }).padLeft(10.0f).size(35.0f);
        }).row();
        Cell<ScrollPane> paneCell = this.cont.pane((Table m) -> {
            this.main = m;
        });
        this.setupMain();
        paneCell.scrollX(this.main.getPrefWidth() + 40.0f > (float)Core.graphics.getWidth());
    }

    void setupMain() {
        this.categories.clear();
        this.main.clear();
        this.main.left().defaults().fillX().left();
        this.main.row();
        this.category("waves");
        this.check("@rules.waves", b -> {
            this.rules.waves = b;
        }, () -> this.rules.waves);
        this.check("@rules.wavesending", b -> {
            this.rules.waveSending = b;
        }, () -> this.rules.waveSending, () -> this.rules.waves);
        this.check("@rules.wavetimer", b -> {
            this.rules.waveTimer = b;
        }, () -> this.rules.waveTimer, () -> this.rules.waves);
        this.check("@rules.waitForWaveToEnd", b -> {
            this.rules.waitEnemies = b;
        }, () -> this.rules.waitEnemies, () -> this.rules.waves && this.rules.waveTimer);
        this.check("@rules.randomwaveai", b -> {
            this.rules.randomWaveAI = b;
        }, () -> this.rules.randomWaveAI, () -> this.rules.waves);
        this.check("@rules.wavespawnatcores", b -> {
            this.rules.wavesSpawnAtCores = b;
        }, () -> this.rules.wavesSpawnAtCores, () -> this.rules.waves);
        this.check("@rules.airUseSpawns", b -> {
            this.rules.airUseSpawns = b;
        }, () -> this.rules.airUseSpawns, () -> this.rules.waves);
        this.numberi("@rules.wavelimit", f -> {
            this.rules.winWave = f;
        }, () -> this.rules.winWave, () -> this.rules.waves, 0, Integer.MAX_VALUE);
        this.number("@rules.wavespacing", false, f -> {
            this.rules.waveSpacing = f * 60.0f;
        }, () -> this.rules.waveSpacing / 60.0f, () -> this.rules.waves && this.rules.waveTimer, 1.0f, Float.MAX_VALUE);
        this.number("@rules.initialwavespacing", false, f -> {
            this.rules.initialWaveSpacing = f * 60.0f;
        }, () -> this.rules.initialWaveSpacing / 60.0f, () -> this.rules.waves && this.rules.waveTimer, 0.0f, Float.MAX_VALUE);
        this.number("@rules.dropzoneradius", false, (float f) -> {
            this.rules.dropZoneRadius = f * 8.0f;
        }, () -> this.rules.dropZoneRadius / 8.0f, () -> this.rules.waves);
        this.category("resourcesbuilding");
        this.check("@rules.alloweditworldprocessors", b -> {
            this.rules.allowEditWorldProcessors = b;
        }, () -> this.rules.allowEditWorldProcessors);
        this.check("@rules.infiniteresources", b -> {
            this.rules.infiniteResources = b;
        }, () -> this.rules.infiniteResources);
        this.check("@rules.onlydepositcore", b -> {
            this.rules.onlyDepositCore = b;
        }, () -> this.rules.onlyDepositCore);
        this.check("@rules.derelictrepair", b -> {
            this.rules.derelictRepair = b;
        }, () -> this.rules.derelictRepair);
        this.check("@rules.reactorexplosions", b -> {
            this.rules.reactorExplosions = b;
        }, () -> this.rules.reactorExplosions);
        this.check("@rules.schematic", b -> {
            this.rules.schematicsAllowed = b;
        }, () -> this.rules.schematicsAllowed);
        this.check("@rules.coreincinerates", b -> {
            this.rules.coreIncinerates = b;
        }, () -> this.rules.coreIncinerates);
        this.check("@rules.cleanupdeadteams", b -> {
            this.rules.cleanupDeadTeams = b;
        }, () -> this.rules.cleanupDeadTeams, () -> this.rules.pvp);
        this.check("@rules.disableworldprocessors", b -> {
            this.rules.disableWorldProcessors = b;
        }, () -> this.rules.disableWorldProcessors);
        this.number("@rules.buildcostmultiplier", false, (float f) -> {
            this.rules.buildCostMultiplier = f;
        }, () -> this.rules.buildCostMultiplier, () -> !this.rules.infiniteResources);
        this.number("@rules.buildspeedmultiplier", f -> {
            this.rules.buildSpeedMultiplier = f;
        }, () -> this.rules.buildSpeedMultiplier, 0.001f, 50.0f);
        this.number("@rules.deconstructrefundmultiplier", false, f -> {
            this.rules.deconstructRefundMultiplier = f;
        }, () -> this.rules.deconstructRefundMultiplier, () -> !this.rules.infiniteResources, 0.0f, 1.0f);
        this.number("@rules.blockhealthmultiplier", f -> {
            this.rules.blockHealthMultiplier = f;
        }, () -> this.rules.blockHealthMultiplier);
        this.number("@rules.blockdamagemultiplier", f -> {
            this.rules.blockDamageMultiplier = f;
        }, () -> this.rules.blockDamageMultiplier);
        if (Core.bundle.get("configure").toLowerCase().contains(this.ruleSearch)) {
            this.current.button("@configure", () -> this.loadoutDialog.show(999999, this.rules.loadout, i -> true, () -> this.rules.loadout.clear().add(new ItemStack(Items.copper, 100)), () -> {}, () -> {})).left().width(300.0f).row();
        }
        if (Core.bundle.get("bannedblocks").toLowerCase().contains(this.ruleSearch)) {
            this.current.button("@bannedblocks", () -> this.bannedBlocks.show(this.rules.bannedBlocks)).left().width(300.0f).row();
        }
        this.check("@rules.hidebannedblocks", b -> {
            this.rules.hideBannedBlocks = b;
        }, () -> this.rules.hideBannedBlocks);
        this.check("@bannedblocks.whitelist", b -> {
            this.rules.blockWhitelist = b;
        }, () -> this.rules.blockWhitelist);
        this.category("unit");
        this.check("@rules.unitcapvariable", b -> {
            this.rules.unitCapVariable = b;
        }, () -> this.rules.unitCapVariable);
        this.check("@rules.unitpayloadsexplode", b -> {
            this.rules.unitPayloadsExplode = b;
        }, () -> this.rules.unitPayloadsExplode);
        this.numberi("@rules.unitcap", f -> {
            this.rules.unitCap = f;
        }, () -> this.rules.unitCap, -999, 999);
        this.number("@rules.unitdamagemultiplier", f -> {
            this.rules.unitDamageMultiplier = f;
        }, () -> this.rules.unitDamageMultiplier);
        this.number("@rules.unitcrashdamagemultiplier", f -> {
            this.rules.unitCrashDamageMultiplier = f;
        }, () -> this.rules.unitCrashDamageMultiplier);
        this.number("@rules.unitminespeedmultiplier", f -> {
            this.rules.unitMineSpeedMultiplier = f;
        }, () -> this.rules.unitMineSpeedMultiplier);
        this.number("@rules.unitbuildspeedmultiplier", f -> {
            this.rules.unitBuildSpeedMultiplier = f;
        }, () -> this.rules.unitBuildSpeedMultiplier, 0.0f, 50.0f);
        this.number("@rules.unitcostmultiplier", f -> {
            this.rules.unitCostMultiplier = f;
        }, () -> this.rules.unitCostMultiplier);
        this.number("@rules.unithealthmultiplier", f -> {
            this.rules.unitHealthMultiplier = f;
        }, () -> this.rules.unitHealthMultiplier);
        if (Core.bundle.get("bannedunits").toLowerCase().contains(this.ruleSearch)) {
            this.current.button("@bannedunits", () -> this.bannedUnits.show(this.rules.bannedUnits)).left().width(300.0f).row();
        }
        this.check("@bannedunits.whitelist", b -> {
            this.rules.unitWhitelist = b;
        }, () -> this.rules.unitWhitelist);
        this.category("enemy");
        this.check("@rules.attack", b -> {
            this.rules.attackMode = b;
        }, () -> this.rules.attackMode);
        this.check("@rules.corecapture", b -> {
            this.rules.coreCapture = b;
        }, () -> this.rules.coreCapture);
        this.check("@rules.placerangecheck", b -> {
            this.rules.placeRangeCheck = b;
        }, () -> this.rules.placeRangeCheck);
        this.check("@rules.polygoncoreprotection", b -> {
            this.rules.polygonCoreProtection = b;
        }, () -> this.rules.polygonCoreProtection);
        this.number("@rules.enemycorebuildradius", f -> {
            this.rules.enemyCoreBuildRadius = f * 8.0f;
        }, () -> Math.min(this.rules.enemyCoreBuildRadius / 8.0f, 200.0f), () -> !this.rules.polygonCoreProtection);
        this.category("environment");
        this.check("@rules.explosions", b -> {
            this.rules.damageExplosions = b;
        }, () -> this.rules.damageExplosions);
        this.check("@rules.fire", b -> {
            this.rules.fire = b;
        }, () -> this.rules.fire);
        this.check("@rules.fog", b -> {
            this.rules.fog = b;
        }, () -> this.rules.fog);
        this.check("@rules.lighting", b -> {
            this.rules.lighting = b;
        }, () -> this.rules.lighting);
        this.check("@rules.limitarea", b -> {
            this.rules.limitMapArea = b;
        }, () -> this.rules.limitMapArea, () -> !Vars.state.isGame());
        this.numberi("x", x -> {
            this.rules.limitX = x;
        }, () -> this.rules.limitX, () -> this.rules.limitMapArea && !Vars.state.isGame(), 0, 10000);
        this.numberi("y", y -> {
            this.rules.limitY = y;
        }, () -> this.rules.limitY, () -> this.rules.limitMapArea && !Vars.state.isGame(), 0, 10000);
        this.numberi("w", w -> {
            this.rules.limitWidth = w;
        }, () -> this.rules.limitWidth, () -> this.rules.limitMapArea && !Vars.state.isGame(), 0, 10000);
        this.numberi("h", h -> {
            this.rules.limitHeight = h;
        }, () -> this.rules.limitHeight, () -> this.rules.limitMapArea && !Vars.state.isGame(), 0, 10000);
        this.number("@rules.solarmultiplier", f -> {
            this.rules.solarMultiplier = f;
        }, () -> this.rules.solarMultiplier);
        if (Core.bundle.get("rules.ambientlight").toLowerCase().contains(this.ruleSearch)) {
            this.current.button((Button b) -> {
                b.left();
                b.table(Tex.pane, in -> in.stack(new Image(Tex.alphaBg), new Image(Tex.whiteui){
                    {
                        this.update(() -> this.setColor(CustomRulesDialog.this.rules.ambientLight));
                    }
                }).grow()).margin(4.0f).size(50.0f).padRight(10.0f);
                b.add("@rules.ambientlight");
            }, () -> Vars.ui.picker.show(this.rules.ambientLight, this.rules.ambientLight::set)).left().width(250.0f).row();
        }
        if (Core.bundle.get("rules.weather").toLowerCase().contains(this.ruleSearch)) {
            this.current.button("@rules.weather", this::weatherDialog).width(250.0f).left().row();
        }
        this.category("planet");
        if (Core.bundle.get("rules.title.planet").toLowerCase().contains(this.ruleSearch)) {
            this.current.table(Tex.button, t -> {
                t.margin(10.0f);
                ButtonGroup group = new ButtonGroup();
                TextButton.TextButtonStyle style = Styles.flatTogglet;
                t.defaults().size(140.0f, 50.0f);
                for (Planet planet : Vars.content.planets().select(p -> p.accessible && p.visible && p.isLandable())) {
                    t.button(planet.localizedName, style, () -> planet.applyRules(this.rules, true)).group(group).checked(b -> this.rules.planet == planet);
                    if (t.getChildren().size % 3 != 0) continue;
                    t.row();
                }
                t.button("@rules.anyenv", style, () -> {
                    this.rules.env = 233;
                    this.rules.planet = Planets.sun;
                }).group(group).checked(b -> this.rules.planet == Planets.sun);
            }).left().fill(false).expand(false, false).row();
        }
        this.category("teams");
        if (this.showRuleEditRule) {
            this.check("@rules.allowedit", b -> {
                this.rules.allowEditRules = b;
            }, () -> this.rules.allowEditRules);
        }
        this.team("@rules.playerteam", t -> {
            this.rules.defaultTeam = t;
        }, () -> this.rules.defaultTeam);
        this.team("@rules.enemyteam", t -> {
            this.rules.waveTeam = t;
        }, () -> this.rules.waveTeam);
        for (Team team : Team.baseTeams) {
            boolean[] shown = new boolean[]{false};
            Table wasCurrent = this.current;
            Table teamRules = new Table();
            teamRules.button(team.coloredName(), (Drawable)Icon.downOpen, Styles.togglet, () -> {
                shown[0] = !shown[0];
            }).marginLeft(14.0f).width(260.0f).height(55.0f).update((T t) -> {
                ((Image)t.getChildren().get(1)).setDrawable(shown[0] ? Icon.upOpen : Icon.downOpen);
                t.setChecked(shown[0]);
            }).left().padBottom(2.0f).row();
            teamRules.collapser((Table c) -> {
                c.left().defaults().fillX().left().pad(5.0f);
                this.current = c;
                Rules.TeamRule teams = this.rules.teams.get(team);
                this.number("@rules.blockhealthmultiplier", f -> {
                    teams.blockHealthMultiplier = f;
                }, () -> teams.blockHealthMultiplier);
                this.number("@rules.blockdamagemultiplier", f -> {
                    teams.blockDamageMultiplier = f;
                }, () -> teams.blockDamageMultiplier);
                this.check("@rules.rtsai", b -> {
                    teams.rtsAi = b;
                }, () -> teams.rtsAi, () -> team != this.rules.defaultTeam);
                this.numberi("@rules.rtsminsquadsize", f -> {
                    teams.rtsMinSquad = f;
                }, () -> teams.rtsMinSquad, () -> teams.rtsAi, 0, 100);
                this.numberi("@rules.rtsmaxsquadsize", f -> {
                    teams.rtsMaxSquad = f;
                }, () -> teams.rtsMaxSquad, () -> teams.rtsAi, 1, 1000);
                this.number("@rules.rtsminattackweight", f -> {
                    teams.rtsMinWeight = f;
                }, () -> teams.rtsMinWeight, () -> teams.rtsAi);
                this.check("@rules.buildai", b -> {
                    teams.buildAi = b;
                }, () -> teams.buildAi, () -> team != this.rules.defaultTeam && this.rules.env != Planets.erekir.defaultEnv && !this.rules.pvp);
                this.number("@rules.buildaitier", false, f -> {
                    teams.buildAiTier = f;
                }, () -> teams.buildAiTier, () -> teams.buildAi && this.rules.env != Planets.erekir.defaultEnv && !this.rules.pvp, 0.0f, 1.0f);
                this.number("@rules.extracorebuildradius", f -> {
                    teams.extraCoreBuildRadius = f * 8.0f;
                }, () -> Math.min(teams.extraCoreBuildRadius / 8.0f, 200.0f), () -> !this.rules.polygonCoreProtection);
                this.check("@rules.infiniteresources", b -> {
                    teams.infiniteResources = b;
                }, () -> teams.infiniteResources);
                this.check("@rules.fillitems", b -> {
                    teams.fillItems = b;
                }, () -> teams.fillItems);
                this.number("@rules.buildspeedmultiplier", f -> {
                    teams.buildSpeedMultiplier = f;
                }, () -> teams.buildSpeedMultiplier, 0.001f, 50.0f);
                this.number("@rules.unitdamagemultiplier", f -> {
                    teams.unitDamageMultiplier = f;
                }, () -> teams.unitDamageMultiplier);
                this.number("@rules.unitcrashdamagemultiplier", f -> {
                    teams.unitCrashDamageMultiplier = f;
                }, () -> teams.unitCrashDamageMultiplier);
                this.number("@rules.unitminespeedmultiplier", f -> {
                    teams.unitMineSpeedMultiplier = f;
                }, () -> teams.unitMineSpeedMultiplier);
                this.number("@rules.unitbuildspeedmultiplier", f -> {
                    teams.unitBuildSpeedMultiplier = f;
                }, () -> teams.unitBuildSpeedMultiplier, 0.001f, 50.0f);
                this.number("@rules.unitcostmultiplier", f -> {
                    teams.unitCostMultiplier = f;
                }, () -> teams.unitCostMultiplier);
                this.number("@rules.unithealthmultiplier", f -> {
                    teams.unitHealthMultiplier = f;
                }, () -> teams.unitHealthMultiplier);
                if (!this.current.hasChildren()) {
                    teamRules.clear();
                } else {
                    wasCurrent.add(teamRules).row();
                }
                this.current = wasCurrent;
            }, () -> shown[0]).left().growX().row();
        }
        this.additionalSetup.each(Runnable::run);
        for (int i = 0; i < this.categories.size; ++i) {
            this.addToMain(this.categories.get(i), Core.bundle.get("rules.title." + this.categoryNames.get(i)));
        }
    }

    public void category(String name) {
        this.current = new Table();
        this.current.left().defaults().fillX().expandX().left().pad(5.0f);
        this.currentName = name;
        this.categories.add(this.current);
        this.categoryNames.add(this.currentName);
    }

    void addToMain(Table category, String title) {
        if (category.hasChildren()) {
            this.main.add(title).color(Pal.accent).padTop(20.0f).padRight(100.0f).padBottom(-3.0f).fillX().left().pad(5.0f).row();
            this.main.image().color(Pal.accent).height(3.0f).padRight(100.0f).padBottom(20.0f).fillX().left().pad(5.0f).row();
            this.main.add(category).row();
        }
    }

    public void team(String text, Cons<Team> cons, Prov<Team> prov) {
        if (!Core.bundle.get(text.substring(1)).toLowerCase().contains(this.ruleSearch)) {
            return;
        }
        this.current.table((Table t) -> {
            t.left();
            t.add(text).left().padRight(5.0f);
            for (Team team : Team.baseTeams) {
                t.button(Tex.whiteui, Styles.squareTogglei, 38.0f, () -> cons.get(team)).pad(1.0f).checked(b -> prov.get() == team).size(60.0f).tooltip(team.coloredName()).with(i -> {
                    i.getStyle().imageUpColor = team.color;
                });
            }
        }).padTop(0.0f).row();
    }

    public void number(String text, Floatc cons, Floatp prov) {
        this.number(text, false, cons, prov, () -> true, 0.0f, Float.MAX_VALUE);
    }

    public void number(String text, Floatc cons, Floatp prov, float min, float max) {
        this.number(text, false, cons, prov, () -> true, min, max);
    }

    public void number(String text, boolean integer, Floatc cons, Floatp prov, Boolp condition) {
        this.number(text, integer, cons, prov, condition, 0.0f, Float.MAX_VALUE);
    }

    public void number(String text, Floatc cons, Floatp prov, Boolp condition) {
        this.number(text, false, cons, prov, condition, 0.0f, Float.MAX_VALUE);
    }

    public void numberi(String text, Intc cons, Intp prov, int min, int max) {
        this.numberi(text, cons, prov, () -> true, min, max);
    }

    public void numberi(String text, Intc cons, Intp prov, Boolp condition, int min, int max) {
        if (!Core.bundle.get(text.substring(1)).toLowerCase().contains(this.ruleSearch)) {
            return;
        }
        Cell<Table> cell = this.current.table((Table t) -> {
            t.left();
            t.add(text).left().padRight(5.0f).update((T a) -> a.setColor(condition.get() ? Color.white : Color.gray));
            t.field(prov.get() + "", s -> cons.get(Strings.parseInt(s))).update((T a) -> a.setDisabled(!condition.get())).padRight(100.0f).valid(f -> Strings.parseInt(f) >= min && Strings.parseInt(f) <= max).width(120.0f).left();
        }).padTop(0.0f);
        this.ruleInfo(cell, text);
        this.current.row();
    }

    public void number(String text, boolean integer, Floatc cons, Floatp prov, Boolp condition, float min, float max) {
        if (!Core.bundle.get(text.substring(1)).toLowerCase().contains(this.ruleSearch)) {
            return;
        }
        Cell<Table> cell = this.current.table((Table t) -> {
            t.left();
            t.add(text).left().padRight(5.0f).update((T a) -> a.setColor(condition.get() ? Color.white : Color.gray));
            t.field((integer ? (float)((int)prov.get()) : prov.get()) + "", s -> cons.get(Strings.parseFloat(s))).padRight(50.0f).update((T a) -> a.setDisabled(!condition.get())).valid(f -> Strings.canParsePositiveFloat(f) && Strings.parseFloat(f) >= min && Strings.parseFloat(f) <= max).width(120.0f).left();
        }).padTop(0.0f);
        this.ruleInfo(cell, text);
        this.current.row();
    }

    public void check(String text, Boolc cons, Boolp prov) {
        this.check(text, cons, prov, () -> true);
    }

    public void check(String text, Boolc cons, Boolp prov, Boolp condition) {
        if (!Core.bundle.get(text.substring(1)).toLowerCase().contains(this.ruleSearch)) {
            return;
        }
        Cell<CheckBox> cell = this.current.check(text, cons).checked(prov.get()).update((T a) -> a.setDisabled(!condition.get()));
        cell.get().left();
        this.ruleInfo(cell, text);
        this.current.row();
    }

    public void ruleInfo(Cell<?> cell, String text) {
        if (Core.bundle.has(text.substring(1) + ".info")) {
            if (Vars.mobile && !Core.graphics.isPortrait()) {
                Table table = new Table();
                table.add(cell.get()).left().expandX().fillX();
                cell.clearElement();
                table.button(Icon.infoSmall, () -> Vars.ui.showInfo(text + ".info")).size(32.0f).right();
                cell.setElement(table).left().expandX().fillX();
            } else {
                cell.tooltip(text + ".info");
            }
        }
    }

    Cell<TextField> field(Table table, float value, Floatc setter) {
        return table.field(Strings.autoFixed(value, 2), v -> setter.get(Strings.parseFloat(v))).valid(Strings::canParsePositiveFloat).size(90.0f, 40.0f).pad(2.0f);
    }

    void weatherDialog() {
        BaseDialog dialog = new BaseDialog("@rules.weather");
        Runnable[] rebuild = new Runnable[]{null};
        dialog.cont.pane((Table base) -> {
            rebuild[0] = () -> {
                base.clearChildren();
                int cols = Math.max(1, (int)((float)Core.graphics.getWidth() / Scl.scl(450.0f)));
                int idx = 0;
                this.rules.weather.removeAll(w -> w.weather == null);
                for (Weather.WeatherEntry entry : this.rules.weather) {
                    base.top();
                    base.table(Tex.pane, c -> {
                        c.margin(0.0f);
                        c.table(Tex.whiteui, t -> {
                            t.setColor(Pal.gray);
                            t.top().left();
                            t.add(entry.weather.localizedName).left().padLeft(6.0f);
                            t.add().growX();
                            ImageButton.ImageButtonStyle style = Styles.geni;
                            t.defaults().size(42.0f);
                            t.button((Drawable)Icon.cancel, style, () -> {
                                this.rules.weather.remove(entry);
                                rebuild[0].run();
                            });
                        }).growX();
                        c.row();
                        c.table((Table f) -> {
                            f.marginLeft(4.0f);
                            f.left().top();
                            f.defaults().padRight(4.0f).left();
                            f.add("@rules.weather.duration");
                            this.field((Table)f, entry.minDuration / 3600.0f, (float v) -> {
                                entry.minDuration = v * 3600.0f;
                            }).disabled(v -> entry.always);
                            f.add("@waves.to");
                            this.field((Table)f, entry.maxDuration / 3600.0f, (float v) -> {
                                entry.maxDuration = v * 3600.0f;
                            }).disabled(v -> entry.always);
                            f.add("@unit.minutes");
                            f.row();
                            f.add("@rules.weather.frequency");
                            this.field((Table)f, entry.minFrequency / 3600.0f, (float v) -> {
                                entry.minFrequency = v * 3600.0f;
                            }).disabled(v -> entry.always);
                            f.add("@waves.to");
                            this.field((Table)f, entry.maxFrequency / 3600.0f, (float v) -> {
                                entry.maxFrequency = v * 3600.0f;
                            }).disabled(v -> entry.always);
                            f.add("@unit.minutes");
                            f.row();
                            f.check("@rules.weather.always", val -> {
                                entry.always = val;
                            }).checked(cc -> entry.always).padBottom(4.0f);
                        }).grow().left().pad(6.0f).top();
                    }).width(410.0f).pad(3.0f).top().left().fillY();
                    if (++idx % cols != 0) continue;
                    base.row();
                }
            };
            rebuild[0].run();
        }).grow();
        dialog.addCloseButton();
        dialog.buttons.button("@add", Icon.add, () -> {
            BaseDialog add = new BaseDialog("@add");
            add.cont.pane((Table t) -> {
                t.background(Tex.button);
                int i = 0;
                for (Weather weather : Vars.content.getBy(ContentType.weather)) {
                    if (weather.hidden) continue;
                    t.button(weather.localizedName, Styles.flatt, () -> {
                        this.rules.weather.add(new Weather.WeatherEntry(weather));
                        rebuild[0].run();
                        add.hide();
                    }).size(140.0f, 50.0f);
                    if (++i % 2 != 0) continue;
                    t.row();
                }
            });
            add.addCloseButton();
            add.show();
        }).width(170.0f);
        dialog.show();
    }
}

