/*
 * Decompiled with CFR 0.152.
 */
package mindustry.server;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.backend.headless.HeadlessApplication;
import arc.util.Log;
import arc.util.Strings;
import java.time.LocalDateTime;
import mindustry.Vars;
import mindustry.core.Logic;
import mindustry.core.NetServer;
import mindustry.core.Platform;
import mindustry.core.UI;
import mindustry.ctype.Content;
import mindustry.game.EventType;
import mindustry.mod.Mod;
import mindustry.mod.Mods;
import mindustry.net.CrashHandler;
import mindustry.net.Net;
import mindustry.server.ServerControl;
import mindustry.ui.Fonts;

public class ServerLauncher
implements ApplicationListener {
    static String[] args;

    public static void main(String[] args) {
        try {
            ServerLauncher.args = args;
            Vars.platform = new Platform(){};
            Vars.net = new Net(Vars.platform.getNet());
            Log.logger = (level1, text) -> {
                String result = "[" + ServerControl.dateTime.format(LocalDateTime.now()) + "] " + Log.format(ServerControl.tags[level1.ordinal()] + " " + text + "&fr", new Object[0]);
                System.out.println(result);
            };
            new HeadlessApplication(new ServerLauncher(), throwable -> CrashHandler.handle(throwable, f -> {}));
        }
        catch (Throwable t) {
            CrashHandler.handle(t, f -> {});
        }
    }

    @Override
    public void init() {
        Core.settings.setDataDirectory(Core.files.local("config"));
        Vars.loadLocales = false;
        Vars.headless = true;
        Vars.loadSettings();
        Vars.init();
        UI.loadColors();
        Fonts.loadContentIconsHeadless();
        Vars.content.createBaseContent();
        Vars.mods.loadScripts();
        Vars.content.createModContent();
        Vars.content.init();
        if (Vars.mods.hasContentErrors()) {
            Log.err("Error occurred loading mod content:", new Object[0]);
            for (Mods.LoadedMod mod : Vars.mods.list()) {
                if (!mod.hasContentErrors()) continue;
                Log.err("| &ly[@]", mod.name);
                for (Content cont : mod.erroredContent) {
                    Log.err("| | &y@: &c@", cont.minfo.sourceFile.name(), Strings.getSimpleMessage(cont.minfo.baseError).replace("\n", " "));
                }
            }
            Log.err("The server will now exit.", new Object[0]);
            System.exit(1);
        }
        Vars.bases.load();
        Core.app.addListener(new ApplicationListener(){

            @Override
            public void update() {
                Vars.asyncCore.begin();
            }
        });
        Vars.logic = new Logic();
        Core.app.addListener(Vars.logic);
        Vars.netServer = new NetServer();
        Core.app.addListener(Vars.netServer);
        Core.app.addListener(new ServerControl(args));
        Core.app.addListener(new ApplicationListener(){

            @Override
            public void update() {
                Vars.asyncCore.end();
            }
        });
        Vars.mods.eachClass(Mod::init);
        Events.fire(new EventType.ServerLoadEvent());
    }
}

