/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Player;
import mindustry.input.InputHandler;
import mindustry.io.TypeIO;
import mindustry.net.NetConnection;
import mindustry.net.Packet;

public class RotateBlockCallPacket
extends Packet {
    private byte[] DATA = NODATA;
    public Player player;
    public Building build;
    public boolean direction;

    @Override
    public void write(Writes WRITE) {
        if (Vars.net.server()) {
            TypeIO.writeEntity(WRITE, this.player);
        }
        TypeIO.writeBuilding(WRITE, this.build);
        WRITE.bool(this.direction);
    }

    @Override
    public void read(Reads READ, int LENGTH) {
        this.DATA = READ.b(LENGTH);
    }

    @Override
    public void handled() {
        BAIS.setBytes(this.DATA);
        if (Vars.net.client()) {
            this.player = (Player)TypeIO.readEntity(READ);
        }
        this.build = TypeIO.readBuilding(READ);
        this.direction = READ.bool();
    }

    @Override
    public void handleServer(NetConnection con) {
        if (con.player == null || con.kicked) {
            return;
        }
        Player player = con.player;
        InputHandler.rotateBlock(player, this.build, this.direction);
        Call.rotateBlock__forward(con, player, this.build, this.direction);
    }

    @Override
    public void handleClient() {
        InputHandler.rotateBlock(this.player, this.build, this.direction);
    }
}

