/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities;

import arc.Events;
import arc.util.Nullable;
import arc.util.Structs;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.game.EventType;
import mindustry.gen.Fire;
import mindustry.world.Tile;

public class Fires {
    private static final float baseLifetime = 1000.0f;

    public static void create(Tile tile) {
        if (Vars.net.client() || tile == null || !Vars.state.rules.fire || !Vars.state.rules.hasEnv(128)) {
            return;
        }
        Fire fire = Fires.get(tile);
        if (fire == null) {
            fire = Fire.create();
            fire.tile = tile;
            fire.lifetime = 1000.0f;
            fire.set(tile.worldx(), tile.worldy());
            fire.add();
            Fires.set(tile, fire);
        } else {
            fire.lifetime = 1000.0f;
            fire.time = 0.0f;
        }
    }

    @Nullable
    public static Fire get(Tile tile) {
        return tile == null ? null : Vars.world.tiles.getFire(tile.array());
    }

    @Nullable
    public static Fire get(int x, int y) {
        return Structs.inBounds(x, y, Vars.world.width(), Vars.world.height()) ? Vars.world.tiles.getFire(Vars.world.packArray(x, y)) : null;
    }

    private static void set(Tile tile, Fire fire) {
        Vars.world.tiles.setFire(tile.array(), fire);
    }

    public static boolean has(int x, int y) {
        if (!Structs.inBounds(x, y, Vars.world.width(), Vars.world.height())) {
            return false;
        }
        Fire fire = Fires.get(x, y);
        return fire != null && fire.isAdded() && fire.fin() < 1.0f && fire.tile != null && fire.tile.x == x && fire.tile.y == y;
    }

    public static void extinguish(Tile tile, float intensity) {
        Fire fire;
        if (tile != null && (fire = Fires.get(tile)) != null) {
            fire.time += intensity * Time.delta;
            Fx.steam.at(fire);
            if (fire.time >= fire.lifetime) {
                Events.fire(EventType.Trigger.fireExtinguish);
            }
        }
    }

    public static void remove(Tile tile) {
        if (tile != null) {
            Fires.set(tile, null);
        }
    }

    public static void register(Fire fire) {
        if (fire.tile != null) {
            Fires.set(fire.tile, fire);
        }
    }
}

