/*
 * Decompiled with CFR 0.152.
 */
package mindustry.audio;

import arc.Core;
import arc.audio.Sound;
import arc.struct.Seq;
import mindustry.gen.Sounds;

public class SoundPriority {
    static int lastGroup = 1;

    public static void init() {
        SoundPriority.max(7, Sounds.laserbig, Sounds.beam, Sounds.laserbeam);
        SoundPriority.set(2.0f, Sounds.laserbig, Sounds.beam, Sounds.laserbeam, Sounds.beamPlasma);
        SoundPriority.set(1.5f, Sounds.railgun, Sounds.largeCannon, Sounds.lasercharge, Sounds.lasercharge2, Sounds.lasercharge3);
        SoundPriority.set(1.0f, Sounds.conveyor, Sounds.smelter, Sounds.drill, Sounds.extractLoop, Sounds.flux, Sounds.hum, Sounds.respawning);
        Sounds.laser.setMaxConcurrent(5);
        SoundPriority.sameGroup(Sounds.flame, Sounds.flamePlasma);
        SoundPriority.sameGroup(Sounds.missile, Sounds.missileShort, Sounds.missilePlasmaShort);
        SoundPriority.sameGroup(Sounds.spark, Sounds.shock);
        for (Sound sound : Core.assets.getAll(Sound.class, new Seq())) {
            sound.setMinConcurrentInterrupt(Math.min(0.25f, sound.getLength() * 0.5f));
        }
        Sounds.mechStep.setMinConcurrentInterrupt(0.5f);
        Sounds.walkerStep.setMinConcurrentInterrupt(0.6f);
        Sounds.mechStepHeavy.setMinConcurrentInterrupt(0.6f);
        Sounds.shieldHit.setMaxConcurrent(4);
        SoundPriority.max(4, Sounds.mechStep, Sounds.mechStepHeavy, Sounds.walkerStep);
    }

    static void max(int max, Sound ... sounds) {
        for (Sound s : sounds) {
            s.setMaxConcurrent(max);
        }
    }

    static void sameGroup(Sound ... sounds) {
        int id = lastGroup++;
        for (Sound s : sounds) {
            s.setConcurrentGroup(id);
        }
    }

    static void set(float value, Sound ... sounds) {
        for (Sound s : sounds) {
            s.setPriority(value);
        }
    }
}

