/*
 * Decompiled with CFR 0.152.
 */
package arc.math.geom;

public class Spring1D {
    public float value;
    public float target;
    public float velocity;
    public float damping;
    public float frequency;

    public Spring1D(float damping, float frequency) {
        this.damping = damping;
        this.frequency = frequency;
    }

    public void update(float deltaTime) {
        float angularFrequency = this.frequency;
        float f = 1.0f + 2.0f * deltaTime * this.damping * (angularFrequency *= (float)Math.PI * 2);
        float oo = angularFrequency * angularFrequency;
        float hoo = deltaTime * oo;
        float hhoo = deltaTime * hoo;
        float detInv = 1.0f / (f + hhoo);
        float detX = f * this.value + deltaTime * this.velocity + hhoo * this.target;
        float detV = this.velocity + hoo * (this.target - this.value);
        this.value = detX * detInv;
        this.velocity = detV * detInv;
    }
}

