/*
 * Decompiled with CFR 0.152.
 */
package arc.assets.loaders;

import arc.assets.AssetDescriptor;
import arc.assets.AssetLoaderParameters;
import arc.assets.AssetManager;
import arc.assets.loaders.AsynchronousAssetLoader;
import arc.assets.loaders.FileHandleResolver;
import arc.assets.loaders.TextureLoader;
import arc.files.Fi;
import arc.graphics.Texture;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;

public class FontLoader
extends AsynchronousAssetLoader<Font, FontParameter> {
    Font.FontData data;

    public FontLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public Seq<AssetDescriptor> getDependencies(String fileName, Fi file, FontParameter parameter) {
        Seq<AssetDescriptor> deps = new Seq<AssetDescriptor>();
        if (parameter != null && parameter.fontData != null) {
            this.data = parameter.fontData;
            return deps;
        }
        this.data = new Font.FontData(file, parameter != null && parameter.flip);
        if (parameter != null && parameter.atlasName != null) {
            deps.add(new AssetDescriptor<TextureAtlas>(parameter.atlasName, TextureAtlas.class));
        } else {
            for (int i = 0; i < this.data.getImagePaths().length; ++i) {
                String path = this.data.getImagePath(i);
                Fi resolved = this.resolve(path);
                TextureLoader.TextureParameter textureParams = new TextureLoader.TextureParameter();
                if (parameter != null) {
                    textureParams.genMipMaps = parameter.genMipMaps;
                    textureParams.minFilter = parameter.minFilter;
                    textureParams.magFilter = parameter.magFilter;
                }
                AssetDescriptor<Texture> descriptor = new AssetDescriptor<Texture>(resolved, Texture.class, textureParams);
                deps.add(descriptor);
            }
        }
        return deps;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, Fi file, FontParameter parameter) {
    }

    @Override
    public Font loadSync(AssetManager manager, String fileName, Fi file, FontParameter parameter) {
        if (parameter != null && parameter.atlasName != null) {
            String name;
            TextureAtlas atlas = manager.get(parameter.atlasName, TextureAtlas.class);
            TextureAtlas.AtlasRegion region = atlas.find(name = file.sibling(this.data.imagePaths[0]).nameWithoutExtension());
            if (region == null) {
                throw new ArcRuntimeException("Could not find font region " + name + " in atlas " + parameter.atlasName);
            }
            return new Font(file, region);
        }
        int n = this.data.getImagePaths().length;
        Seq<TextureRegion> regs = new Seq<TextureRegion>(n);
        for (int i = 0; i < n; ++i) {
            regs.add(new TextureRegion(manager.get(this.data.getImagePath(i), Texture.class)));
        }
        return new Font(this.data, regs, true);
    }

    public static class FontParameter
    extends AssetLoaderParameters<Font> {
        public boolean flip = false;
        public boolean genMipMaps = false;
        public Texture.TextureFilter minFilter = Texture.TextureFilter.nearest;
        public Texture.TextureFilter magFilter = Texture.TextureFilter.nearest;
        public Font.FontData fontData = null;
        public String atlasName = null;
    }
}

