/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.func.Func;
import arc.scene.ui.layout.Table;
import mindustry.gen.Building;
import mindustry.type.LiquidStack;
import mindustry.ui.ReqImage;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;

public class ConsumeLiquidsDynamic
extends Consume {
    public final Func<Building, LiquidStack[]> liquids;

    public <T extends Building> ConsumeLiquidsDynamic(Func<T, LiquidStack[]> liquids) {
        this.liquids = liquids;
    }

    @Override
    public void apply(Block block) {
        block.hasLiquids = true;
    }

    @Override
    public void build(Building build, Table table) {
        LiquidStack[][] current = new LiquidStack[][]{this.liquids.get(build)};
        table.table(cont -> {
            table.update(() -> {
                if (current[0] != this.liquids.get(build)) {
                    this.rebuild(build, (Table)cont);
                    current[0] = this.liquids.get(build);
                }
            });
            this.rebuild(build, (Table)cont);
        });
    }

    private void rebuild(Building build, Table table) {
        table.clear();
        int i = 0;
        for (LiquidStack stack : this.liquids.get(build)) {
            table.add(new ReqImage(stack.liquid.uiIcon, () -> build.liquids != null && build.liquids.get(stack.liquid) > 0.0f)).size(32.0f).padRight(8.0f);
            if (++i % 4 != 0) continue;
            table.row();
        }
    }

    @Override
    public void update(Building build) {
        float mult = this.multiplier.get(build);
        for (LiquidStack stack : this.liquids.get(build)) {
            build.liquids.remove(stack.liquid, stack.amount * build.edelta() * mult);
        }
    }

    @Override
    public float efficiency(Building build) {
        float ed = build.edelta();
        if (ed <= 1.0E-8f) {
            return 0.0f;
        }
        float min = 1.0f;
        for (LiquidStack stack : this.liquids.get(build)) {
            min = Math.min(build.liquids.get(stack.liquid) / (stack.amount * ed * this.multiplier.get(build)), min);
        }
        return min;
    }
}

