/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.units;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.ImageButton;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.ai.UnitCommand;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.gen.Sounds;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.io.TypeIO;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.blocks.units.UnitBlock;
import mindustry.world.consumers.ConsumeItemDynamic;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;

public class UnitFactory
extends UnitBlock {
    public int[] capacities = new int[0];
    public Seq<UnitPlan> plans = new Seq(4);

    public UnitFactory(String name) {
        super(name);
        this.update = true;
        this.hasPower = true;
        this.hasItems = true;
        this.solid = true;
        this.configurable = true;
        this.clearOnDoubleTap = true;
        this.outputsPayload = true;
        this.rotate = true;
        this.regionRotated1 = 1;
        this.commandable = true;
        this.ambientSound = Sounds.respawning;
        this.config(Integer.class, (build, i) -> {
            if (!this.configurable) {
                return;
            }
            if (build.currentPlan == i) {
                return;
            }
            build.currentPlan = i < 0 || i >= this.plans.size ? -1 : i;
            build.progress = 0.0f;
            if (!(build.command == null || build.unit() != null && build.unit().commands.contains(build.command))) {
                build.command = null;
            }
        });
        this.config(UnitType.class, (build, val) -> {
            if (!this.configurable) {
                return;
            }
            int next = this.plans.indexOf(p -> p.unit == val);
            if (build.currentPlan == next) {
                return;
            }
            build.currentPlan = next;
            build.progress = 0.0f;
            if (build.command != null && !val.commands.contains(build.command)) {
                build.command = null;
            }
        });
        this.config(UnitCommand.class, (build, command) -> {
            build.command = command;
        });
        this.configClear(build -> {
            build.command = null;
        });
        this.consume(new ConsumeItemDynamic(e -> e.currentPlan != -1 ? this.plans.get((int)Math.min((int)e.currentPlan, (int)(this.plans.size - 1))).requirements : ItemStack.empty));
    }

    @Override
    public void init() {
        this.initCapacities();
        super.init();
    }

    @Override
    public void afterPatch() {
        this.initCapacities();
        super.afterPatch();
    }

    public void initCapacities() {
        this.capacities = new int[Vars.content.items().size];
        this.itemCapacity = 10;
        for (UnitPlan plan : this.plans) {
            for (ItemStack stack : plan.requirements) {
                this.capacities[stack.item.id] = Math.max(this.capacities[stack.item.id], stack.amount * 2);
                this.itemCapacity = Math.max(this.itemCapacity, stack.amount * 2);
            }
        }
        this.consumeBuilder.each(c -> {
            c.multiplier = b -> Vars.state.rules.unitCost(b.team);
        });
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("progress", e -> new Bar("bar.progress", Pal.ammo, e::fraction));
        this.addBar("units", e -> new Bar(() -> e.unit() == null ? "[lightgray]\ue815" : Core.bundle.format("bar.unitcap", Fonts.getUnicodeStr(e.unit().name), e.team.data().countType(e.unit()), e.unit() == null ? Units.getStringCap(e.team) : (e.unit().useUnitCap ? Units.getStringCap(e.team) : "\u221e")), () -> Pal.power, () -> e.unit() == null ? 0.0f : (e.unit().useUnitCap ? (float)e.team.data().countType(e.unit()) / (float)Units.getCap(e.team) : 1.0f)));
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.itemCapacity);
        this.stats.add(Stat.output, table -> {
            table.row();
            for (UnitPlan plan : this.plans) {
                table.table(Styles.grayPanel, t -> {
                    if (plan.unit.isBanned()) {
                        t.image(Icon.cancel).color(Pal.remove).size(40.0f);
                        return;
                    }
                    if (plan.unit.unlockedNow()) {
                        t.image(plan.unit.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit).with(i -> StatValues.withTooltip(i, plan.unit));
                        t.table(info -> {
                            info.add(plan.unit.localizedName).left();
                            info.row();
                            info.add(Strings.autoFixed(plan.time / 60.0f, 1) + " " + Core.bundle.get("unit.seconds")).color(Color.lightGray);
                        }).left();
                        t.table(req -> {
                            req.right();
                            for (int i = 0; i < plan.requirements.length; ++i) {
                                if (i % 6 == 0) {
                                    req.row();
                                }
                                ItemStack stack = plan.requirements[i];
                                req.add(StatValues.displayItem(stack.item, stack.amount, plan.time, true)).pad(5.0f);
                            }
                        }).right().grow().pad(10.0f);
                    } else {
                        t.image(Icon.lock).color(Pal.darkerGray).size(40.0f);
                    }
                }).growX().pad(5.0f);
                table.row();
            }
        });
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.outRegion, this.topRegion};
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect(this.region, plan.drawx(), plan.drawy());
        Draw.rect(this.outRegion, plan.drawx(), plan.drawy(), (float)(plan.rotation * 90));
        Draw.rect(this.topRegion, plan.drawx(), plan.drawy());
    }

    @Override
    public void getPlanConfigs(Seq<UnlockableContent> options) {
        for (UnitPlan plan : this.plans) {
            if (plan.unit.isBanned()) continue;
            options.add(plan.unit);
        }
    }

    public static class UnitPlan {
        public UnitType unit;
        public ItemStack[] requirements;
        public float time;

        public UnitPlan(UnitType unit, float time, ItemStack[] requirements) {
            this.unit = unit;
            this.time = time;
            this.requirements = requirements;
        }

        UnitPlan() {
        }
    }

    public class UnitFactoryBuild
    extends UnitBlock.UnitBuild {
        @Nullable
        public Vec2 commandPos;
        @Nullable
        public UnitCommand command;
        public int currentPlan = -1;

        public float fraction() {
            return this.currentPlan == -1 ? 0.0f : this.progress / UnitFactory.this.plans.get((int)this.currentPlan).time;
        }

        public boolean canSetCommand() {
            UnitType output = this.unit();
            return output != null && output.commands.size > 1 && output.allowChangeCommands && (output.commands.size != 2 || output.commands.get(1) != UnitCommand.enterPayloadCommand);
        }

        @Override
        public void created() {
            if (this.currentPlan == -1) {
                this.currentPlan = UnitFactory.this.plans.indexOf(u -> u.unit.unlockedNow());
            }
        }

        @Override
        public void drawSelect() {
            super.drawSelect();
            if (UnitFactory.this.plans.size > 1 && this.currentPlan != -1 && this.currentPlan < UnitFactory.this.plans.size) {
                this.drawItemSelection(UnitFactory.this.plans.get((int)this.currentPlan).unit);
            }
        }

        @Override
        public Vec2 getCommandPosition() {
            return this.commandPos;
        }

        @Override
        public void onCommand(Vec2 target) {
            this.commandPos = target;
        }

        @Override
        public Object senseObject(LAccess sensor) {
            if (sensor == LAccess.config) {
                return this.currentPlan == -1 ? null : UnitFactory.this.plans.get((int)this.currentPlan).unit;
            }
            return super.senseObject(sensor);
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                return Mathf.clamp(this.fraction());
            }
            if (sensor == LAccess.itemCapacity) {
                return Mathf.round((float)UnitFactory.this.itemCapacity * Vars.state.rules.unitCost(this.team));
            }
            return super.sense(sensor);
        }

        @Override
        public void buildConfiguration(Table table) {
            Seq<UnitType> units = Seq.with(UnitFactory.this.plans).map(u -> u.unit).retainAll(u -> u.unlockedNow() && !u.isBanned());
            if (units.any()) {
                ItemSelection.buildTable(UnitFactory.this, table, units, () -> this.currentPlan == -1 ? null : UnitFactory.this.plans.get((int)this.currentPlan).unit, unit -> this.configure(UnitFactory.this.plans.indexOf(u -> u.unit == unit)), UnitFactory.this.selectionRows, UnitFactory.this.selectionColumns);
                table.row();
                Table commands = new Table();
                commands.top().left();
                Runnable rebuildCommands = () -> {
                    commands.clear();
                    commands.background(null);
                    UnitType unit = this.unit();
                    if (unit != null && this.canSetCommand()) {
                        commands.background(Styles.black6);
                        ButtonGroup group = new ButtonGroup();
                        group.setMinCheckCount(0);
                        int i = 0;
                        int columns = Mathf.clamp(units.size, 2, UnitFactory.this.selectionColumns);
                        Seq<UnitCommand> list = unit.commands;
                        commands.image(Tex.whiteui, Pal.gray).height(4.0f).growX().colspan(columns).row();
                        for (UnitCommand item : list) {
                            ImageButton button = commands.button(item.getIcon(), Styles.clearNoneTogglei, 40.0f, () -> this.configure(item)).tooltip(item.localized()).group(group).get();
                            button.update(() -> button.setChecked(this.command == item || this.command == null && unit.defaultCommand == item));
                            if (++i % columns != 0) continue;
                            commands.row();
                        }
                        if (list.size < columns) {
                            for (int j = 0; j < columns - list.size; ++j) {
                                commands.add().size(40.0f);
                            }
                        }
                    }
                };
                rebuildCommands.run();
                table.row();
                table.add(commands).fillX().left();
            } else {
                table.table(Styles.black3, t -> t.add("@none").color(Color.lightGray));
            }
        }

        @Override
        public boolean acceptPayload(Building source, Payload payload) {
            return false;
        }

        @Override
        public void display(Table table) {
            super.display(table);
            TextureRegionDrawable reg = new TextureRegionDrawable();
            table.row();
            table.table(t -> {
                t.left();
                t.image().update(i -> {
                    i.setDrawable(this.currentPlan == -1 ? Icon.cancel : reg.set(UnitFactory.this.plans.get((int)this.currentPlan).unit.uiIcon));
                    i.setScaling(Scaling.fit);
                    i.setColor(this.currentPlan == -1 ? Color.lightGray : Color.white);
                }).size(32.0f).padBottom(-4.0f).padRight(2.0f);
                t.label(() -> this.currentPlan == -1 ? "@none" : UnitFactory.this.plans.get((int)this.currentPlan).unit.localizedName).wrap().width(230.0f).color(Color.lightGray);
            }).left();
        }

        @Override
        public Object config() {
            return this.currentPlan;
        }

        @Override
        public void draw() {
            Draw.rect(UnitFactory.this.region, this.x, this.y);
            Draw.rect(UnitFactory.this.outRegion, this.x, this.y, this.rotdeg());
            if (this.currentPlan != -1) {
                UnitPlan plan = UnitFactory.this.plans.get(this.currentPlan);
                Draw.draw(35.0f, () -> Drawf.construct((Building)this, plan.unit, this.rotdeg() - 90.0f, this.progress / plan.time, this.speedScl, this.time));
            }
            Draw.z(35.0f);
            this.payRotation = this.rotdeg();
            this.drawPayload();
            Draw.z(35.1f);
            Draw.rect(UnitFactory.this.topRegion, this.x, this.y);
        }

        @Override
        public void updateTile() {
            if (!UnitFactory.this.configurable) {
                this.currentPlan = 0;
            }
            if (this.currentPlan < 0 || this.currentPlan >= UnitFactory.this.plans.size) {
                this.currentPlan = -1;
            }
            if (this.efficiency > 0.0f && this.currentPlan != -1) {
                this.time += this.edelta() * this.speedScl * Vars.state.rules.unitBuildSpeed(this.team);
                this.progress += this.edelta() * Vars.state.rules.unitBuildSpeed(this.team);
                this.speedScl = Mathf.lerpDelta(this.speedScl, 1.0f, 0.05f);
            } else {
                this.speedScl = Mathf.lerpDelta(this.speedScl, 0.0f, 0.05f);
            }
            this.moveOutPayload();
            if (this.currentPlan != -1 && this.payload == null) {
                UnitPlan plan = UnitFactory.this.plans.get(this.currentPlan);
                if (plan.unit.isBanned()) {
                    this.currentPlan = -1;
                    return;
                }
                if (this.progress >= plan.time) {
                    this.progress %= 1.0f;
                    Unit unit = plan.unit.create(this.team);
                    if (unit.isCommandable()) {
                        if (this.commandPos != null) {
                            unit.command().commandPosition(this.commandPos);
                        }
                        unit.command().command(this.command == null && unit.type.defaultCommand != null ? unit.type.defaultCommand : this.command);
                    }
                    this.payload = new UnitPayload(unit);
                    this.payVector.setZero();
                    this.consume();
                    Events.fire(new EventType.UnitCreateEvent(((UnitPayload)this.payload).unit, this));
                }
                this.progress = Mathf.clamp(this.progress, 0.0f, plan.time);
            } else {
                this.progress = 0.0f;
            }
        }

        @Override
        public boolean shouldConsume() {
            if (this.currentPlan == -1) {
                return false;
            }
            return this.enabled && this.payload == null;
        }

        @Override
        public int getMaximumAccepted(Item item) {
            return Mathf.round((float)UnitFactory.this.capacities[item.id] * Vars.state.rules.unitCost(this.team));
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.currentPlan != -1 && this.items.get(item) < this.getMaximumAccepted(item) && Structs.contains(UnitFactory.this.plans.get((int)this.currentPlan).requirements, stack -> stack.item == item);
        }

        @Nullable
        public UnitType unit() {
            return this.currentPlan == -1 ? null : UnitFactory.this.plans.get((int)this.currentPlan).unit;
        }

        @Override
        public byte version() {
            return 3;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
            write.s(this.currentPlan);
            TypeIO.writeVecNullable(write, this.commandPos);
            TypeIO.writeCommand(write, this.command);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.progress = read.f();
            this.currentPlan = read.s();
            if (revision >= 2) {
                this.commandPos = TypeIO.readVecNullable(read);
            }
            if (revision >= 3) {
                this.command = TypeIO.readCommand(read);
            }
        }
    }
}

