/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Tmp;
import mindustry.graphics.Drawf;
import mindustry.world.blocks.power.PowerNode;

public class LongPowerNode
extends PowerNode {
    public TextureRegion glow;
    public Color glowColor = Color.valueOf("cbfd81").a(0.45f);
    public float glowScl = 16.0f;
    public float glowMag = 0.6f;

    public LongPowerNode(String name) {
        super(name);
        this.drawRange = false;
    }

    @Override
    public void load() {
        super.load();
        this.laser = Core.atlas.find(this.name + "-beam", Core.atlas.find("power-beam"));
        this.laserEnd = Core.atlas.find(this.name + "-beam-end", Core.atlas.find("power-beam-end"));
    }

    public class LongPowerNodeBuild
    extends PowerNode.PowerNodeBuild {
        public float warmup;

        public LongPowerNodeBuild() {
            super(LongPowerNode.this);
            this.warmup = 0.0f;
        }

        @Override
        public void updateTile() {
            super.updateTile();
            this.warmup = Mathf.lerpDelta(this.warmup, this.power.links.size > 0 ? 1.0f : 0.0f, 0.05f);
        }

        @Override
        public void draw() {
            super.draw();
            if (this.warmup > 0.001f) {
                Drawf.additive(LongPowerNode.this.glow, Tmp.c1.set(LongPowerNode.this.glowColor).mula(this.warmup).mula(1.0f - LongPowerNode.this.glowMag + Mathf.absin(LongPowerNode.this.glowScl, LongPowerNode.this.glowMag)), this.x, this.y);
            }
        }
    }
}

