/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.payloads;

import arc.audio.Sound;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import arc.struct.Queue;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.world.blocks.RotBlock;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.PayloadBlock;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class PayloadMassDriver
extends PayloadBlock {
    public float range = 100.0f;
    public float rotateSpeed = 5.0f;
    public float length = 11.125f;
    public float knockback = 5.0f;
    public float reload = 30.0f;
    public float chargeTime = 100.0f;
    public float maxPayloadSize = 3.0f;
    public float grabWidth = 8.0f;
    public float grabHeight = 2.75f;
    public Effect shootEffect = Fx.shootBig2;
    public Effect smokeEffect = Fx.shootPayloadDriver;
    public Effect receiveEffect = Fx.payloadReceive;
    public Sound shootSound = Sounds.massdriver;
    public Sound receiveSound = Sounds.massdriverReceive;
    public float shootSoundVolume = 0.7f;
    public float shake = 3.0f;
    public Effect transferEffect = new Effect(11.0f, 600.0f, e -> {
        Object patt1354$temp = e.data;
        if (!(patt1354$temp instanceof PayloadMassDriverData)) {
            return;
        }
        PayloadMassDriverData data = (PayloadMassDriverData)patt1354$temp;
        Tmp.v1.set(data.x, data.y).lerp(data.ox, data.oy, Interp.sineIn.apply(e.fin()));
        data.payload.set(Tmp.v1.x, Tmp.v1.y, e.rotation);
        data.payload.draw();
    }).layer(89.0f);
    public TextureRegion baseRegion;
    public TextureRegion capRegion;
    public TextureRegion leftRegion;
    public TextureRegion rightRegion;
    public TextureRegion capOutlineRegion;
    public TextureRegion leftOutlineRegion;
    public TextureRegion rightOutlineRegion;
    public TextureRegion arrow;

    public PayloadMassDriver(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.configurable = true;
        this.hasPower = true;
        this.outlineIcon = true;
        this.sync = true;
        this.rotate = true;
        this.outputsPayload = true;
        this.group = BlockGroup.units;
        this.regionRotated1 = 1;
        this.config(Point2.class, (tile, point) -> {
            tile.link = Point2.pack(point.x + tile.tileX(), point.y + tile.tileY());
        });
        this.config(Integer.class, (tile, point) -> {
            tile.link = point;
        });
    }

    @Override
    public void init() {
        super.init();
        this.updateClipRadius(this.range + 4.0f);
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.payloadCapacity, StatValues.squared(this.maxPayloadSize, StatUnit.blocksSquared));
        this.stats.add(Stat.reload, 60.0f / (this.chargeTime + this.reload), StatUnit.perSecond);
        this.stats.add(Stat.shootRange, this.range / 8.0f, StatUnit.blocks);
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.baseRegion, this.outRegion, this.region};
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect(this.baseRegion, plan.drawx(), plan.drawy());
        Draw.rect(this.topRegion, plan.drawx(), plan.drawy());
        Draw.rect(this.outRegion, plan.drawx(), plan.drawy(), (float)(plan.rotation * 90));
        Draw.rect(this.region, plan.drawx(), plan.drawy());
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle(x * 8, y * 8, this.range, Pal.accent);
        if (!Vars.control.input.config.isShown()) {
            return;
        }
        Building selected = Vars.control.input.config.getSelected();
        if (selected == null || selected.block != this || !selected.within(x * 8, y * 8, this.range)) {
            return;
        }
        float sin = Mathf.absin(Time.time, 6.0f, 1.0f);
        Tmp.v1.set((float)(x * 8) + this.offset, (float)(y * 8) + this.offset).sub(selected.x, selected.y).limit(((float)this.size / 2.0f + 1.0f) * 8.0f + sin + 0.5f);
        float x2 = (float)(x * 8) - Tmp.v1.x;
        float y2 = (float)(y * 8) - Tmp.v1.y;
        float x1 = selected.x + Tmp.v1.x;
        float y1 = selected.y + Tmp.v1.y;
        int segs = (int)(selected.dst(x * 8, y * 8) / 8.0f);
        Lines.stroke(4.0f, Pal.gray);
        Lines.dashLine(x1, y1, x2, y2, segs);
        Lines.stroke(2.0f, Pal.placing);
        Lines.dashLine(x1, y1, x2, y2, segs);
        Draw.reset();
    }

    @Override
    public void getRegionsToOutline(Seq<TextureRegion> out) {
        out.add(this.leftRegion, this.rightRegion, this.capRegion);
    }

    public class PayloadDriverBuild
    extends PayloadBlock.PayloadBlockBuild<Payload>
    implements RotBlock {
        public int link = -1;
        public float turretRotation = 90.0f;
        public float reloadCounter = 0.0f;
        public float charge = 0.0f;
        public float targetSize;
        public float curSize;
        public float payLength;
        public float effectDelayTimer;
        public PayloadDriverBuild lastOther;
        public boolean loaded;
        public boolean charging;
        public PayloadDriverState state;
        public Queue<Building> waitingShooters;
        public Payload recPayload;

        public PayloadDriverBuild() {
            this.curSize = this.targetSize = PayloadMassDriver.this.grabWidth * 2.0f;
            this.payLength = 0.0f;
            this.effectDelayTimer = -1.0f;
            this.state = PayloadDriverState.idle;
            this.waitingShooters = new Queue();
        }

        public Building currentShooter() {
            return this.waitingShooters.isEmpty() ? null : this.waitingShooters.first();
        }

        @Override
        public float buildRotation() {
            return this.rotation;
        }

        @Override
        public void updateTile() {
            boolean hasLink;
            Building link;
            block36: {
                block37: {
                    Building current;
                    super.updateTile();
                    link = Vars.world.build(this.link);
                    hasLink = this.linkValid();
                    if (!this.charging) {
                        this.charge -= Time.delta * 10.0f;
                        if (this.charge < 0.0f) {
                            this.charge = 0.0f;
                        }
                    }
                    this.curSize = Mathf.lerpDelta(this.curSize, this.targetSize, 0.05f);
                    this.targetSize = PayloadMassDriver.this.grabWidth * 2.0f;
                    if (this.payload != null) {
                        this.targetSize = this.payload.size();
                    }
                    boolean pos = this.effectDelayTimer > 0.0f;
                    this.effectDelayTimer -= Time.delta;
                    if (this.effectDelayTimer <= 0.0f && pos && this.lastOther != null) {
                        PayloadDriverBuild other = this.lastOther;
                        float cx = Angles.trnsx(other.turretRotation, PayloadMassDriver.this.length);
                        float cy = Angles.trnsy(other.turretRotation, PayloadMassDriver.this.length);
                        PayloadMassDriver.this.receiveEffect.at(this.x - cx / 2.0f, this.y - cy / 2.0f, this.turretRotation);
                        this.reloadCounter = 1.0f;
                        Effect.shake(PayloadMassDriver.this.shake, PayloadMassDriver.this.shake, this);
                        PayloadMassDriver.this.receiveSound.at(this.x, this.y, 1.0f + Mathf.range(0.2f), PayloadMassDriver.this.shootSoundVolume);
                    }
                    this.charging = false;
                    if (hasLink) {
                        this.link = link.pos();
                    }
                    this.reloadCounter -= this.edelta() / PayloadMassDriver.this.reload;
                    if (this.reloadCounter < 0.0f) {
                        this.reloadCounter = 0.0f;
                    }
                    if ((current = this.currentShooter()) == null) break block36;
                    if (!(current instanceof PayloadDriverBuild)) break block37;
                    PayloadDriverBuild entity = (PayloadDriverBuild)current;
                    if (current.isValid() && entity.efficiency > 0.0f && entity.block == this.block && entity.link == this.pos() && this.within(current, PayloadMassDriver.this.range)) break block36;
                }
                this.waitingShooters.removeFirst();
            }
            if (this.state == PayloadDriverState.idle) {
                if (!this.waitingShooters.isEmpty() && this.payload == null) {
                    this.state = PayloadDriverState.accepting;
                } else if (hasLink) {
                    this.state = PayloadDriverState.shooting;
                }
            }
            if ((this.state == PayloadDriverState.idle || this.state == PayloadDriverState.accepting) && this.payload != null) {
                if (this.loaded) {
                    this.payLength -= PayloadMassDriver.this.payloadSpeed * this.delta();
                    if (this.payLength <= 0.0f) {
                        this.loaded = false;
                        this.payVector.setZero();
                        this.payRotation = Angles.moveToward(this.payRotation, this.turretRotation + 180.0f, PayloadMassDriver.this.payloadRotateSpeed * this.delta());
                    }
                } else if (this.effectDelayTimer <= 0.0f) {
                    this.moveOutPayload();
                }
            }
            if (this.efficiency <= 0.0f) {
                return;
            }
            if (this.state == PayloadDriverState.accepting) {
                if (this.currentShooter() == null || this.payload != null) {
                    this.state = PayloadDriverState.idle;
                    return;
                }
                if (this.currentShooter().getPayload() != null) {
                    this.targetSize = this.recPayload == null ? this.currentShooter().getPayload().size() : this.recPayload.size();
                }
                this.turretRotation = Angles.moveToward(this.turretRotation, this.angleTo(this.currentShooter()), PayloadMassDriver.this.rotateSpeed * this.efficiency);
            } else if (this.state == PayloadDriverState.shooting) {
                if (!hasLink || !this.waitingShooters.isEmpty() && this.payload == null) {
                    this.state = PayloadDriverState.idle;
                    return;
                }
                float targetRotation = this.angleTo(link);
                boolean movedOut = false;
                this.payRotation = Angles.moveToward(this.payRotation, this.turretRotation, PayloadMassDriver.this.payloadRotateSpeed * this.delta());
                if (this.loaded) {
                    float loadLength = PayloadMassDriver.this.length - this.reloadCounter * PayloadMassDriver.this.knockback;
                    this.payLength += PayloadMassDriver.this.payloadSpeed * this.delta();
                    if (this.payLength >= loadLength) {
                        this.payLength = loadLength;
                        movedOut = true;
                    }
                } else if (this.moveInPayload()) {
                    this.payLength = 0.0f;
                    this.loaded = true;
                }
                if (movedOut && this.payload != null && link.getPayload() == null) {
                    PayloadDriverBuild other = (PayloadDriverBuild)link;
                    if (!other.waitingShooters.contains(this)) {
                        other.waitingShooters.addLast(this);
                    }
                    if (this.reloadCounter <= 0.0f) {
                        this.turretRotation = Angles.moveToward(this.turretRotation, targetRotation, PayloadMassDriver.this.rotateSpeed * this.efficiency);
                        if (other.currentShooter() == this && other.state == PayloadDriverState.accepting && other.reloadCounter <= 0.0f && Angles.within(this.turretRotation, targetRotation, 1.0f) && Angles.within(other.turretRotation, targetRotation + 180.0f, 1.0f)) {
                            this.charge += this.edelta();
                            this.charging = true;
                            if (this.charge >= PayloadMassDriver.this.chargeTime) {
                                float cx = Angles.trnsx(this.turretRotation, PayloadMassDriver.this.length);
                                float cy = Angles.trnsy(this.turretRotation, PayloadMassDriver.this.length);
                                PayloadMassDriver.this.shootEffect.at(this.x + cx, this.y + cy, this.turretRotation);
                                PayloadMassDriver.this.smokeEffect.at(this.x, this.y, this.turretRotation);
                                Effect.shake(PayloadMassDriver.this.shake, PayloadMassDriver.this.shake, this);
                                PayloadMassDriver.this.shootSound.at(this.x, this.y, Mathf.random(0.9f, 1.1f), PayloadMassDriver.this.shootSoundVolume);
                                PayloadMassDriver.this.transferEffect.at(this.x + cx, this.y + cy, this.turretRotation, new PayloadMassDriverData(this.x + cx, this.y + cy, other.x - cx, other.y - cy, this.payload));
                                Payload pay = this.payload;
                                other.recPayload = this.payload;
                                other.effectDelayTimer = PayloadMassDriver.this.transferEffect.lifetime;
                                other.handlePayload(this, pay);
                                other.lastOther = this;
                                other.payVector.set(-cx, -cy);
                                other.payRotation = this.turretRotation;
                                other.payLength = PayloadMassDriver.this.length;
                                other.loaded = true;
                                other.updatePayload();
                                other.recPayload = null;
                                if (other.waitingShooters.size != 0 && other.waitingShooters.first() == this) {
                                    other.waitingShooters.removeFirst();
                                }
                                other.state = PayloadDriverState.idle;
                                this.payload = null;
                                this.payLength = 0.0f;
                                this.loaded = false;
                                this.state = PayloadDriverState.idle;
                                this.reloadCounter = 1.0f;
                            }
                        }
                    }
                }
            }
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                return Mathf.clamp(1.0f - this.reloadCounter / PayloadMassDriver.this.reload);
            }
            return super.sense(sensor);
        }

        @Override
        public void updatePayload() {
            if (this.payload != null) {
                if (this.loaded) {
                    this.payload.set(this.x + Angles.trnsx(this.turretRotation, this.payLength), this.y + Angles.trnsy(this.turretRotation, this.payLength), this.payRotation);
                } else {
                    this.payload.set(this.x + this.payVector.x, this.y + this.payVector.y, this.payRotation);
                }
            }
        }

        @Override
        public void draw() {
            float tx = this.x + Angles.trnsx(this.turretRotation + 180.0f, this.reloadCounter * PayloadMassDriver.this.knockback);
            float ty = this.y + Angles.trnsy(this.turretRotation + 180.0f, this.reloadCounter * PayloadMassDriver.this.knockback);
            float r = this.turretRotation - 90.0f;
            Draw.rect(PayloadMassDriver.this.baseRegion, this.x, this.y);
            for (int i = 0; i < 4; ++i) {
                if (!this.blends(i) || i == this.rotation) continue;
                Draw.rect(PayloadMassDriver.this.inRegion, this.x, this.y, (float)(i * 90 - 180));
            }
            Draw.rect(PayloadMassDriver.this.outRegion, this.x, this.y, this.rotdeg());
            if (this.payload != null) {
                this.updatePayload();
                if (this.effectDelayTimer <= 0.0f) {
                    Draw.z(this.loaded ? 35.2f : 35.0f);
                    this.payload.draw();
                }
            }
            Draw.z(35.1f);
            Draw.rect(PayloadMassDriver.this.topRegion, this.x, this.y);
            Draw.z(50.0f);
            Drawf.shadow(PayloadMassDriver.this.region, tx - (float)PayloadMassDriver.this.size / 2.0f, ty - (float)PayloadMassDriver.this.size / 2.0f, r);
            Tmp.v1.trns(this.turretRotation, 0.0f, -(this.curSize / 2.0f - PayloadMassDriver.this.grabWidth));
            Tmp.v2.trns(this.rotation, -Math.max(this.curSize / 2.0f - PayloadMassDriver.this.grabHeight - PayloadMassDriver.this.length, 0.0f), 0.0f);
            float rx = tx + Tmp.v1.x + Tmp.v2.x;
            float ry = ty + Tmp.v1.y + Tmp.v2.y;
            float lx = tx - Tmp.v1.x + Tmp.v2.x;
            float ly = ty - Tmp.v1.y + Tmp.v2.y;
            Draw.rect(PayloadMassDriver.this.capOutlineRegion, tx, ty, r);
            Draw.rect(PayloadMassDriver.this.leftOutlineRegion, lx, ly, r);
            Draw.rect(PayloadMassDriver.this.rightOutlineRegion, rx, ry, r);
            Draw.rect(PayloadMassDriver.this.leftRegion, lx, ly, r);
            Draw.rect(PayloadMassDriver.this.rightRegion, rx, ry, r);
            Draw.rect(PayloadMassDriver.this.capRegion, tx, ty, r);
            Draw.z(110.0f);
            if (this.charge > 0.0f && this.linkValid()) {
                Building link = Vars.world.build(this.link);
                float fin = Interp.pow2Out.apply(this.charge / PayloadMassDriver.this.chargeTime);
                float fout = 1.0f - fin;
                float len = PayloadMassDriver.this.length * 1.8f;
                float w = this.curSize / 2.0f + 7.0f * fout;
                Vec2 right = Tmp.v1.trns(this.turretRotation, len, w);
                Vec2 left = Tmp.v2.trns(this.turretRotation, len, -w);
                Lines.stroke(fin * 1.2f, Pal.accent);
                Lines.line(this.x + left.x, this.y + left.y, link.x - right.x, link.y - right.y);
                Lines.line(this.x + right.x, this.y + right.y, link.x - left.x, link.y - left.y);
                for (int i = 0; i < 4; ++i) {
                    Tmp.v3.set(this.x, this.y).lerp(link.x, link.y, 0.5f + (float)(i - 2) * 0.1f);
                    Draw.scl(fin * 1.1f);
                    Draw.rect(PayloadMassDriver.this.arrow, Tmp.v3.x, Tmp.v3.y, this.turretRotation);
                    Draw.scl();
                }
                Draw.reset();
            }
        }

        @Override
        public void drawConfigure() {
            float sin = Mathf.absin(Time.time, 6.0f, 1.0f);
            Draw.color(Pal.accent);
            Lines.stroke(1.0f);
            Drawf.circles(this.x, this.y, ((float)this.tile.block().size / 2.0f + 1.0f) * 8.0f + sin - 2.0f, Pal.accent);
            for (Building shooter : this.waitingShooters) {
                Drawf.circles(shooter.x, shooter.y, ((float)this.tile.block().size / 2.0f + 1.0f) * 8.0f + sin - 2.0f, Pal.place);
                Drawf.arrow(shooter.x, shooter.y, this.x, this.y, (float)(PayloadMassDriver.this.size * 8) + sin, 4.0f + sin, Pal.place);
            }
            if (this.linkValid()) {
                Building target = Vars.world.build(this.link);
                Drawf.circles(target.x, target.y, ((float)target.block.size / 2.0f + 1.0f) * 8.0f + sin - 2.0f, Pal.place);
                Drawf.arrow(this.x, this.y, target.x, target.y, (float)(PayloadMassDriver.this.size * 8) + sin, 4.0f + sin);
            }
            Drawf.dashCircle(this.x, this.y, PayloadMassDriver.this.range, Pal.accent);
        }

        @Override
        public boolean onConfigureBuildTapped(Building other) {
            if (this == other) {
                if (this.link == -1) {
                    this.deselect();
                }
                this.configure(-1);
                return false;
            }
            if (this.link == other.pos()) {
                this.configure(-1);
                return false;
            }
            if (other.block instanceof PayloadMassDriver && other.dst(this.tile) <= PayloadMassDriver.this.range && other.team == this.team) {
                this.configure(other.pos());
                return false;
            }
            return true;
        }

        @Override
        public boolean acceptPayload(Building source, Payload payload) {
            return super.acceptPayload(source, payload) && payload.size() <= PayloadMassDriver.this.maxPayloadSize * 8.0f;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean linkValid() {
            if (this.link == -1) return false;
            Building building = Vars.world.build(this.link);
            if (!(building instanceof PayloadDriverBuild)) return false;
            PayloadDriverBuild other = (PayloadDriverBuild)building;
            if (other.block != this.block) return false;
            if (other.team != this.team) return false;
            if (!this.within(other, PayloadMassDriver.this.range)) return false;
            return true;
        }

        @Override
        public Point2 config() {
            if (this.tile == null) {
                return null;
            }
            return Point2.unpack(this.link).sub(this.tile.x, this.tile.y);
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.i(this.link);
            write.f(this.turretRotation);
            write.b((byte)this.state.ordinal());
            write.f(this.reloadCounter);
            write.f(this.charge);
            write.bool(this.loaded);
            write.bool(this.charging);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.link = read.i();
            this.turretRotation = read.f();
            this.state = PayloadDriverState.all[read.b()];
            if (revision >= 1) {
                this.reloadCounter = read.f();
                this.charge = read.f();
                this.loaded = read.bool();
                this.charging = read.bool();
            }
        }
    }

    public static class PayloadMassDriverData {
        public float x;
        public float y;
        public float ox;
        public float oy;
        public Payload payload;

        public PayloadMassDriverData(float x, float y, float ox, float oy, Payload payload) {
            this.x = x;
            this.y = y;
            this.ox = ox;
            this.oy = oy;
            this.payload = payload;
        }
    }

    public static enum PayloadDriverState {
        idle,
        accepting,
        shooting;

        public static final PayloadDriverState[] all;

        static {
            all = PayloadDriverState.values();
        }
    }
}

