/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.liquid;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.world.blocks.liquid.LiquidBlock;
import mindustry.world.meta.Stat;

public class LiquidJunction
extends LiquidBlock {
    public LiquidJunction(String name) {
        super(name);
        this.floating = true;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.liquidCapacity);
    }

    @Override
    public void setBars() {
        super.setBars();
        this.removeBar("liquid");
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region};
    }

    public class LiquidJunctionBuild
    extends Building {
        @Override
        public void draw() {
            Draw.rect(LiquidJunction.this.region, this.x, this.y);
        }

        @Override
        public Building getLiquidDestination(Building source, Liquid liquid) {
            if (!this.enabled) {
                return this;
            }
            int dir = (source.relativeTo(this.tile.x, this.tile.y) + 4) % 4;
            Building next = this.nearby(dir);
            if (next == null || !next.acceptLiquid(this, liquid) && !(next.block instanceof LiquidJunction)) {
                return this;
            }
            return next.getLiquidDestination(this, liquid);
        }
    }
}

