/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Player;
import mindustry.input.InputHandler;
import mindustry.io.TypeIO;
import mindustry.net.NetConnection;
import mindustry.net.Packet;

public class TileConfigCallPacket
extends Packet {
    private byte[] DATA = NODATA;
    public Player player;
    public Building build;
    public Object value;

    @Override
    public void write(Writes WRITE) {
        if (Vars.net.server()) {
            TypeIO.writeEntity(WRITE, this.player);
        }
        TypeIO.writeBuilding(WRITE, this.build);
        TypeIO.writeObject(WRITE, this.value);
    }

    @Override
    public void read(Reads READ, int LENGTH) {
        this.DATA = READ.b(LENGTH);
    }

    @Override
    public void handled() {
        BAIS.setBytes(this.DATA);
        if (Vars.net.client()) {
            this.player = (Player)TypeIO.readEntity(READ);
        }
        this.build = TypeIO.readBuilding(READ);
        this.value = TypeIO.readObject(READ);
    }

    @Override
    public void handleServer(NetConnection con) {
        if (con.player == null || con.kicked) {
            return;
        }
        Player player = con.player;
        InputHandler.tileConfig(player, this.build, this.value);
        Call.tileConfig__forward(con, player, this.build, this.value);
    }

    @Override
    public void handleClient() {
        InputHandler.tileConfig(this.player, this.build, this.value);
    }
}

