/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.math.Mathf;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Lightning;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.graphics.Pal;

public class LightningBulletType
extends BulletType {
    public LightningBulletType() {
        this.damage = 1.0f;
        this.speed = 0.0f;
        this.lifetime = 1.0f;
        this.despawnEffect = Fx.none;
        this.hitEffect = Fx.hitLancer;
        this.keepVelocity = false;
        this.hittable = false;
        this.status = StatusEffects.shocked;
        this.lightningLength = 25;
        this.lightningLengthRand = 0;
        this.lightningColor = Pal.lancerLaser;
    }

    @Override
    protected float calculateRange() {
        return ((float)this.lightningLength + (float)this.lightningLengthRand / 2.0f) * 6.0f;
    }

    @Override
    public float estimateDPS() {
        return super.estimateDPS() * Math.max((float)this.lightningLength / 10.0f, 1.0f);
    }

    @Override
    public void init(Bullet b) {
        super.init(b);
        Lightning.create(b, this.lightningColor, this.damage, b.x, b.y, b.rotation(), this.lightningLength + Mathf.random(this.lightningLengthRand));
    }
}

