/*
 * Decompiled with CFR 0.152.
 */
package arc.fx.filters;

import arc.Core;
import arc.fx.FxFilter;
import arc.graphics.Texture;
import arc.graphics.gl.FrameBuffer;

public final class MixFilter
extends FxFilter {
    private Texture inputTexture2 = null;
    public float mix = 0.5f;

    public MixFilter() {
        super(MixFilter.compileShader(Core.files.classpath("vfxshaders/screenspace.vert"), Core.files.classpath("vfxshaders/mix.frag")));
        this.rebind();
    }

    public MixFilter setInput(FrameBuffer buffer1, FrameBuffer buffer2) {
        this.inputTexture = (Texture)buffer1.getTexture();
        this.inputTexture2 = (Texture)buffer2.getTexture();
        return this;
    }

    public MixFilter setInput(Texture texture1, Texture texture2) {
        this.inputTexture = texture1;
        this.inputTexture2 = texture2;
        return this;
    }

    @Override
    public MixFilter setInput(FrameBuffer input) {
        throw new UnsupportedOperationException("Use #setInput(FboWrapper, FboWrapper)} instead.");
    }

    @Override
    public MixFilter setInput(Texture input) {
        throw new UnsupportedOperationException("Use #setInput(Texture, Texture)} instead.");
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void setParams() {
        this.shader.setUniformi("u_texture0", 0);
        this.shader.setUniformi("u_texture1", 1);
        this.shader.setUniformf("u_mix", this.mix);
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
        this.inputTexture2.bind(1);
    }
}

