/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Eachable;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.blocks.heat.HeatConsumer;
import mindustry.world.draw.DrawBlock;

public class DrawHeatInput
extends DrawBlock {
    public String suffix = "-heat";
    public Color heatColor = new Color(1.0f, 0.22f, 0.22f, 0.8f);
    public float heatPulse = 0.3f;
    public float heatPulseScl = 10.0f;
    public TextureRegion heat;

    public DrawHeatInput(String suffix) {
        this.suffix = suffix;
    }

    public DrawHeatInput() {
    }

    @Override
    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
    }

    @Override
    public void draw(Building build) {
        Draw.z(31.0f);
        if (build instanceof HeatConsumer) {
            HeatConsumer hc = (HeatConsumer)((Object)build);
            float[] side = hc.sideHeat();
            for (int i = 0; i < 4; ++i) {
                if (!(side[i] > 0.0f)) continue;
                Draw.blend(Blending.additive);
                Draw.color(this.heatColor, side[i] / hc.heatRequirement() * (this.heatColor.a * (1.0f - this.heatPulse + Mathf.absin(this.heatPulseScl, this.heatPulse))));
                Draw.rect(this.heat, build.x, build.y, (float)i * 90.0f);
                Draw.blend();
                Draw.color();
            }
        }
        Draw.z(30.0f);
    }

    @Override
    public void load(Block block) {
        this.heat = Core.atlas.find(block.name + this.suffix);
    }
}

