/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.Events;
import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.consumers.ConsumeItemFilter;
import mindustry.world.meta.Stats;

public class ConsumeItemExplode
extends ConsumeItemFilter {
    public float damage = 4.0f;
    public float threshold;
    public float baseChance = 0.06f;
    public Effect explodeEffect = Fx.generatespark;

    public ConsumeItemExplode(float threshold) {
        this.filter = item -> item.explosiveness >= this.threshold;
        this.threshold = threshold;
    }

    public ConsumeItemExplode() {
        this(0.5f);
    }

    @Override
    public void update(Building build) {
        Item item = this.getConsumed(build);
        if (item != null && Vars.state.rules.reactorExplosions && Mathf.chance(build.delta() * this.baseChance * Mathf.clamp(item.explosiveness - this.threshold))) {
            build.damage(this.damage);
            this.explodeEffect.at(build.x + Mathf.range((float)(build.block.size * 8) / 2.0f), build.y + Mathf.range((float)(build.block.size * 8) / 2.0f));
            Events.fire(EventType.Trigger.blastGenerator);
        }
    }

    @Override
    public void build(Building build, Table table) {
    }

    @Override
    public void trigger(Building build) {
    }

    @Override
    public void display(Stats stats) {
    }

    @Override
    public void apply(Block block) {
    }

    @Override
    public float efficiency(Building build) {
        return 1.0f;
    }
}

