/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.units;

import arc.graphics.g2d.Draw;
import arc.math.Mathf;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Units;
import mindustry.entities.units.AIController;
import mindustry.gen.Building;
import mindustry.gen.BuildingTetherc;
import mindustry.gen.Groups;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.world.Block;

public class DroneCenter
extends Block {
    public int unitsSpawned = 4;
    public UnitType droneType;
    public StatusEffect status = StatusEffects.overdrive;
    public float droneConstructTime = 180.0f;
    public float statusDuration = 120.0f;
    public float droneRange = 50.0f;

    public DroneCenter(String name) {
        super(name);
        this.solid = true;
        this.update = true;
        this.configurable = true;
    }

    @Override
    public void init() {
        super.init();
        this.droneType.aiController = () -> new EffectDroneAI();
    }

    public class EffectDroneAI
    extends AIController {
        @Override
        public void updateUnit() {
            Unit unit = this.unit;
            if (!(unit instanceof BuildingTetherc)) {
                return;
            }
            BuildingTetherc tether = (BuildingTetherc)((Object)unit);
            Building building = tether.building();
            if (!(building instanceof DroneCenterBuild)) {
                return;
            }
            DroneCenterBuild build = (DroneCenterBuild)building;
            if (build.target == null) {
                return;
            }
            this.target = build.target;
            this.moveTo(this.target, build.target.hitSize / 1.8f + DroneCenter.this.droneRange - 10.0f);
            this.unit.lookAt(this.target);
            if (this.unit.within(this.target, DroneCenter.this.droneRange + build.target.hitSize)) {
                build.target.apply(DroneCenter.this.status, DroneCenter.this.statusDuration);
            }
        }
    }

    public class DroneCenterBuild
    extends Building {
        protected IntSeq readUnits = new IntSeq();
        protected int readTarget = -1;
        public Seq<Unit> units = new Seq();
        @Nullable
        public Unit target;
        public float droneProgress;
        public float droneWarmup;
        public float totalDroneProgress;

        @Override
        public void updateTile() {
            if (!this.readUnits.isEmpty()) {
                this.units.clear();
                this.readUnits.each(i -> {
                    Unit unit = Groups.unit.getByID(i);
                    if (unit != null) {
                        this.units.add(unit);
                    }
                });
                this.readUnits.clear();
            }
            this.units.removeAll(u -> !u.isAdded() || u.dead);
            this.droneWarmup = Mathf.lerpDelta(this.droneWarmup, this.units.size < DroneCenter.this.unitsSpawned ? this.efficiency : 0.0f, 0.1f);
            this.totalDroneProgress += this.droneWarmup * Time.delta;
            if (this.readTarget != 0) {
                this.target = Groups.unit.getByID(this.readTarget);
                this.readTarget = 0;
            }
            if (this.units.size < DroneCenter.this.unitsSpawned) {
                float f;
                this.droneProgress += this.edelta() / DroneCenter.this.droneConstructTime;
                if (f >= 1.0f) {
                    Unit unit = DroneCenter.this.droneType.create(this.team);
                    if (unit instanceof BuildingTetherc) {
                        BuildingTetherc bt = (BuildingTetherc)((Object)unit);
                        bt.building(this);
                    }
                    unit.set(this.x, this.y);
                    unit.rotation = 90.0f;
                    unit.add();
                    Fx.spawn.at(unit);
                    this.units.add(unit);
                    this.droneProgress = 0.0f;
                }
            }
            if (this.target != null && !this.target.isValid()) {
                this.target = null;
            }
            if (this.target == null) {
                this.target = Units.closest(this.team, this.x, this.y, u -> !u.spawnedByCore && u.type != DroneCenter.this.droneType);
            }
        }

        @Override
        public void drawConfigure() {
            Drawf.square(this.x, this.y, (float)(this.tile.block().size * 8) / 2.0f + 1.0f + Mathf.absin(Time.time, 4.0f, 1.0f));
            if (this.target != null) {
                Drawf.square(this.target.x, this.target.y, this.target.hitSize * 0.8f);
            }
        }

        @Override
        public void draw() {
            super.draw();
            if (this.droneWarmup > 0.0f) {
                Draw.draw(35.2f, () -> Drawf.construct(this, DroneCenter.this.droneType.fullIcon, Pal.accent, 0.0f, this.droneProgress, this.droneWarmup, this.totalDroneProgress, 14.0f));
            }
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.i(this.target == null ? -1 : this.target.id);
            write.s(this.units.size);
            for (Unit unit : this.units) {
                write.i(unit.id);
            }
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.readTarget = read.i();
            int count = read.s();
            this.readUnits.clear();
            for (int i = 0; i < count; ++i) {
                this.readUnits.add(read.i());
            }
        }
    }
}

