/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Prop;

public class Seaweed
extends Prop {
    public Seaweed(String name) {
        super(name);
        this.obstructsLight = false;
    }

    @Override
    public void drawBase(Tile tile) {
        TextureRegion region = this.variants > 0 ? this.variantRegions[Mathf.randomSeed((long)tile.pos(), 0, Math.max(0, this.variantRegions.length - 1))] : this.region;
        float x = tile.worldx();
        float y = tile.worldy();
        float rotmag = 3.0f;
        float rotscl = 0.5f;
        float rot = Mathf.randomSeedRange(tile.pos(), 20.0f) - 45.0f + Mathf.sin(Time.time + x, 50.0f * rotscl, 0.5f * rotmag) + Mathf.sin(Time.time - y, 65.0f * rotscl, 0.9f * rotmag) + Mathf.sin(Time.time + y - x, 85.0f * rotscl, 0.9f * rotmag);
        float w = (float)region.width * region.scl();
        float h = (float)region.height * region.scl();
        float scl = 30.0f;
        float mag = 0.3f;
        Draw.rectv(region, x, y, w, h, rot, vec -> vec.add(Mathf.sin(vec.y * 3.0f + Time.time, scl, mag) + Mathf.sin(vec.x * 3.0f - Time.time, 70.0f, 0.8f), Mathf.cos(vec.x * 3.0f + Time.time + 8.0f, scl + 6.0f, mag * 1.1f) + Mathf.sin(vec.y * 3.0f - Time.time, 50.0f, 0.2f)));
    }
}

