/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world;

import arc.func.Cons;
import arc.func.Intc2;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.util.Nullable;
import java.util.Iterator;
import mindustry.gen.Fire;
import mindustry.gen.Puddle;
import mindustry.world.Tile;

public class Tiles
implements Iterable<Tile> {
    public final int width;
    public final int height;
    final Tile[] array;
    final Puddle[] puddles;
    final Fire[] fires;

    public Tiles(int width, int height) {
        this.array = new Tile[width * height];
        this.width = width;
        this.height = height;
        this.puddles = new Puddle[width * height];
        this.fires = new Fire[width * height];
    }

    public Puddle getPuddle(int pos) {
        return this.puddles[pos];
    }

    public void setPuddle(int pos, Puddle p) {
        this.puddles[pos] = p;
    }

    @Nullable
    public Fire getFire(int pos) {
        return this.fires[pos];
    }

    public void setFire(int pos, Fire f) {
        this.fires[pos] = f;
    }

    public void each(Intc2 cons) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                cons.get(x, y);
            }
        }
    }

    public void fill() {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = new Tile(i % this.width, i / this.width);
        }
    }

    public void set(int x, int y, Tile tile) {
        this.array[y * this.width + x] = tile;
    }

    public void seti(int i, Tile tile) {
        this.array[i] = tile;
    }

    public boolean in(int x, int y) {
        return x >= 0 && x < this.width && y >= 0 && y < this.height;
    }

    @Nullable
    public Tile get(int x, int y) {
        return x < 0 || x >= this.width || y < 0 || y >= this.height ? null : this.array[y * this.width + x];
    }

    public Tile getn(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            throw new IllegalArgumentException(x + ", " + y + " out of bounds: width=" + this.width + ", height=" + this.height);
        }
        return this.array[y * this.width + x];
    }

    public Tile getc(int x, int y) {
        x = Mathf.clamp(x, 0, this.width - 1);
        y = Mathf.clamp(y, 0, this.height - 1);
        return this.array[y * this.width + x];
    }

    public Tile geti(int idx) {
        return this.array[idx];
    }

    @Nullable
    public Tile getp(int pos) {
        return this.get(Point2.x(pos), Point2.y(pos));
    }

    public void eachTile(Cons<Tile> cons) {
        for (Tile tile : this.array) {
            cons.get(tile);
        }
    }

    @Override
    public Iterator<Tile> iterator() {
        return new TileIterator();
    }

    private class TileIterator
    implements Iterator<Tile> {
        int index = 0;

        TileIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < Tiles.this.array.length;
        }

        @Override
        public Tile next() {
            return Tiles.this.array[this.index++];
        }
    }
}

