/*
 * Decompiled with CFR 0.152.
 */
package mindustry.net;

import arc.Core;
import arc.struct.Seq;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.serialization.Base64Coder;
import java.util.zip.CRC32;
import mindustry.core.Version;
import mindustry.io.TypeIO;
import mindustry.net.Packet;
import mindustry.net.Streamable;

public class Packets {

    public static class ConnectPacket
    extends Packet {
        public int version;
        public String versionType;
        public Seq<String> mods;
        public String name;
        public String locale;
        public String uuid;
        public String usid;
        public boolean mobile;
        public int color;

        @Override
        public void write(Writes buffer) {
            buffer.i(Version.build);
            TypeIO.writeString(buffer, this.versionType);
            TypeIO.writeString(buffer, this.name);
            TypeIO.writeString(buffer, this.locale);
            TypeIO.writeString(buffer, this.usid);
            byte[] b = Base64Coder.decode(this.uuid);
            buffer.b(b);
            CRC32 crc = new CRC32();
            crc.update(Base64Coder.decode(this.uuid), 0, b.length);
            buffer.l(crc.getValue());
            buffer.b(this.mobile ? 1 : 0);
            buffer.i(this.color);
            buffer.b((byte)this.mods.size);
            for (int i = 0; i < this.mods.size; ++i) {
                TypeIO.writeString(buffer, this.mods.get(i));
            }
        }

        @Override
        public void read(Reads buffer) {
            this.version = buffer.i();
            this.versionType = TypeIO.readString(buffer);
            this.name = TypeIO.readString(buffer);
            this.locale = TypeIO.readString(buffer);
            this.usid = TypeIO.readString(buffer);
            byte[] idbytes = buffer.b(16);
            this.uuid = new String(Base64Coder.encode(idbytes));
            this.mobile = buffer.b() == 1;
            this.color = buffer.i();
            int totalMods = buffer.b();
            this.mods = new Seq(totalMods);
            for (int i = 0; i < totalMods; ++i) {
                this.mods.add(TypeIO.readString(buffer));
            }
        }

        @Override
        public int getPriority() {
            return 2;
        }
    }

    public static class StreamChunk
    extends Packet {
        public int id;
        public byte[] data;

        @Override
        public void write(Writes buffer) {
            buffer.i(this.id);
            buffer.s((short)this.data.length);
            buffer.b(this.data);
        }

        @Override
        public void read(Reads buffer) {
            this.id = buffer.i();
            this.data = buffer.b(buffer.s());
        }
    }

    public static class StreamBegin
    extends Packet {
        private static int lastid;
        public int id = lastid++;
        public int total;
        public byte type;

        @Override
        public void write(Writes buffer) {
            buffer.i(this.id);
            buffer.i(this.total);
            buffer.b(this.type);
        }

        @Override
        public void read(Reads buffer) {
            this.id = buffer.i();
            this.total = buffer.i();
            this.type = buffer.b();
        }
    }

    public static class WorldStream
    extends Streamable {
    }

    public static class Disconnect
    extends Packet {
        public String reason;

        @Override
        public int getPriority() {
            return 2;
        }
    }

    public static class Connect
    extends Packet {
        public String addressTCP;

        @Override
        public int getPriority() {
            return 2;
        }
    }

    public static enum AdminAction {
        kick,
        ban,
        trace,
        wave,
        switchTeam;

        public static final AdminAction[] all;

        static {
            all = AdminAction.values();
        }
    }

    public static enum KickReason {
        kick,
        clientOutdated,
        serverOutdated,
        banned,
        gameover(true),
        recentKick,
        nameInUse,
        idInUse,
        nameEmpty,
        customClient,
        serverClose,
        vote,
        typeMismatch,
        whitelist,
        playerLimit,
        serverRestarting;

        public static final KickReason[] all;
        public final boolean quiet;

        private KickReason() {
            this(false);
        }

        private KickReason(boolean quiet) {
            this.quiet = quiet;
        }

        public String toString() {
            return Core.bundle.get("server.kicked." + this.name());
        }

        public String extraText() {
            return Core.bundle.getOrNull("server.kicked." + this.name() + ".text");
        }

        static {
            all = KickReason.values();
        }
    }
}

