/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.effect;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import arc.util.Nullable;
import mindustry.entities.Effect;
import mindustry.graphics.Drawf;

public class WaveEffect
extends Effect {
    public Color colorFrom = Color.white.cpy();
    public Color colorTo = Color.white.cpy();
    @Nullable
    public Color lightColor;
    public float sizeFrom = 0.0f;
    public float sizeTo = 100.0f;
    public float lightScl = 3.0f;
    public float lightOpacity = 0.8f;
    public int sides = -1;
    public float rotation = 0.0f;
    public float strokeFrom = 2.0f;
    public float strokeTo = 0.0f;
    public Interp interp = Interp.linear;
    public Interp lightInterp = Interp.reverse;
    public float offsetX;
    public float offsetY;

    @Override
    public void init() {
        this.clip = Math.max(this.clip, Math.max(this.sizeFrom, this.sizeTo) + Math.max(this.strokeFrom, this.strokeTo));
    }

    @Override
    public void render(Effect.EffectContainer e) {
        float fin = e.fin();
        float ifin = e.fin(this.interp);
        float ox = e.x + Angles.trnsx(e.rotation, this.offsetX, this.offsetY);
        float oy = e.y + Angles.trnsy(e.rotation, this.offsetX, this.offsetY);
        Draw.color(this.colorFrom, this.colorTo, ifin);
        Lines.stroke(this.interp.apply(this.strokeFrom, this.strokeTo, fin));
        float rad = this.interp.apply(this.sizeFrom, this.sizeTo, fin);
        Lines.poly(ox, oy, this.sides <= 0 ? Lines.circleVertices(rad) : this.sides, rad, this.rotation + e.rotation);
        Drawf.light(ox, oy, rad * this.lightScl, this.lightColor == null ? Draw.getColor() : this.lightColor, this.lightOpacity * e.fin(this.lightInterp));
    }
}

