/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Unit;
import mindustry.type.UnitType;

public class SpawnDeathAbility
extends Ability {
    public UnitType unit;
    public int amount = 1;
    public int randAmount = 0;
    public float spread = 8.0f;
    public boolean faceOutwards = true;

    public SpawnDeathAbility(UnitType unit, int amount, float spread) {
        this.unit = unit;
        this.amount = amount;
        this.spread = spread;
    }

    public SpawnDeathAbility() {
    }

    @Override
    public void addStats(Table t) {
        super.addStats(t);
        t.add("[stat]" + (this.randAmount > 0 ? this.amount + "x-" + (this.amount + this.randAmount) : Integer.valueOf(this.amount)) + "x[] " + (this.unit.hasEmoji() ? this.unit.emoji() : "") + "[stat]" + this.unit.localizedName);
    }

    @Override
    public void death(Unit unit) {
        if (!Vars.net.client()) {
            int spawned = this.amount + Mathf.random(this.randAmount);
            for (int i = 0; i < spawned; ++i) {
                Tmp.v1.rnd(Mathf.random(this.spread));
                Unit u = this.unit.spawn(unit.team, unit.x + Tmp.v1.x, unit.y + Tmp.v1.y);
                u.rotation = this.faceOutwards ? Tmp.v1.angle() : unit.rotation + Mathf.range(5.0f);
            }
        }
    }
}

