/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.struct.Seq;
import mindustry.editor.DrawOperation;

public class OperationStack {
    private static final int maxSize = 10;
    private Seq<DrawOperation> stack = new Seq();
    private int index = 0;

    public void clear() {
        this.stack.clear();
        this.index = 0;
    }

    public void add(DrawOperation action) {
        this.stack.truncate(this.stack.size + this.index);
        this.index = 0;
        this.stack.add(action);
        if (this.stack.size > 10) {
            this.stack.remove(0);
        }
    }

    public boolean canUndo() {
        return this.stack.size - 1 + this.index >= 0;
    }

    public boolean canRedo() {
        return this.index <= -1 && this.stack.size + this.index >= 0;
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        this.stack.get(this.stack.size - 1 + this.index).undo();
        --this.index;
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        ++this.index;
        this.stack.get(this.stack.size - 1 + this.index).redo();
    }
}

